<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:template name="ELearning_Breadcrumb">
    <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID > 0">
      <div class="N610_exerciseBreadcrumb N610_corner">
        <table style="width:100%;">
          <tr>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isMenu=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/house_32.png" title="Powrót do menu kursu" onclick="loadCourseMenu('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isReload=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/refresh_32.png"  title="Ponowne załadowanie ćwiczenia" onclick="loadExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isCheck=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/ok_32.png"   title="Sprawdzenie odpowiedzi" onclick="checkExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isResolve=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/bulb_32.png"    title="Wyświetlenie poprawnych odpowiedzi" onclick="resolveExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isPrev=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/arrow_left_32.png"    title="Poprzednie ćwiczenie" onclick="loadPreviousExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isNext=1">
              <td style="width:35px;">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/N610/arrow_right_32.png"    title="Następne ćwiczenie" onclick="loadNextExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID});"/>
              </td>
            </xsl:if>
            <xsl:if test="string-length(/Data/EXERCISE/ADDITONAL_INFORMATION)>0">
              <td valign="middle" style="text-align: right;width:100%">
                <h3 class="N610_BreadInfoBox">
                  <xsl:value-of select="/Data/EXERCISE/ADDITONAL_INFORMATION/."/>
                </h3>
              </td>
            </xsl:if>
            <xsl:if test="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE)>0">
              <td>
                <xsl:comment></xsl:comment>
                <xsl:call-template name="numbers"/>
              </td>
            </xsl:if>
          </tr>
        </table>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template name="numbers">
    <xsl:variable name="VISIBLE_COUNT">10</xsl:variable>
    <xsl:if test="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE)>0">
      <div id="exercisePaging" class="N610_fright">
        <table>
          <tr>
            <td>
              <a id="buttonPrev" href="javascript:void(0);">
                <div class="N610_pageNumBlockNav">
                  <div class="positionable">&lt;</div>
                </div>
              </a>
            </td>
            <td>
              <div id="N610_numberSlide">
                <div class="N610_numberCover">
                  <xsl:text disable-output-escaping="yes">&lt;div class="N610_numberStuff"&gt;</xsl:text>
                  <xsl:for-each select="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE">
                    <a title="Ćwiczenie {@index}" href="javascript:loadExercise('{/Data/Config/Domain}','{@contextObjectID}','{@courseID}','{@unitID}','{@exerciseID}')">
                      <div class="N610_pageNumBlock" style="background-color:#cccccc;">
                        <xsl:if test="@isCurrent=1">
                          <xsl:attribute name="class">N610_pageNumBlockCurrent</xsl:attribute>
                          <xsl:attribute name="style">background-color:#ff0000;</xsl:attribute>
                        </xsl:if>
                        <div class="positionable">
                          <xsl:value-of select="@index"/>
                        </div>
                      </div>
                    </a>
                    <xsl:if test="position() mod $VISIBLE_COUNT = 0">
                      <xsl:text disable-output-escaping="yes">&lt;/div&gt;</xsl:text>
                      <xsl:text disable-output-escaping="yes">&lt;div class="N610_numberStuff"&gt;</xsl:text>
                    </xsl:if>
                  </xsl:for-each>
                  <xsl:if test="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE) mod $VISIBLE_COUNT = 0">
                    <xsl:comment></xsl:comment>
                    <xsl:text disable-output-escaping="yes">&lt;/div&gt;</xsl:text>
                  </xsl:if>
                </div>
              </div>
            </td>
            <td>
              <a id="buttonNext" href="javascript:void(0);">
                <div class="N610_pageNumBlockNav">
                  <div class="positionable">&gt;</div>
                </div>
              </a>
            </td>
          </tr>
        </table>
      </div>
    </xsl:if>
    <script type="text/javascript">
      <xsl:variable name="currentIndex">
        <xsl:for-each select="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE">
          <xsl:if test="@isCurrent=1">
            <xsl:value-of select="position()"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>
      <xsl:if test="string-length($currentIndex)>0">
        setupBreadcrumbNavigation(<xsl:value-of select="$VISIBLE_COUNT"/>, <xsl:value-of select="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE)"/>, <xsl:value-of select="$currentIndex"/>);
      </xsl:if>
      <xsl:if test="string-length($currentIndex)=0">
        setupBreadcrumbNavigation(<xsl:value-of select="$VISIBLE_COUNT"/>, <xsl:value-of select="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE)"/>, 1);
      </xsl:if>
    </script>

  </xsl:template>
</xsl:stylesheet>