<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="ELearning_Utils.xsl"/>

  <xsl:variable name="cw">
    <xsl:choose><xsl:when test="string-length(/Data/EXERCISE/AVATAR/@width)=0">0</xsl:when><xsl:otherwise><xsl:value-of select="/Data/EXERCISE/AVATAR/@width"/></xsl:otherwise></xsl:choose>    
  </xsl:variable>
  
  <xsl:template name="ELearning_Exercise_Load_Matching">
    <div id="containment-wrapper" class="N610_Matching">
      <div id="drawing-wrapper">
        <!---->
      </div>
      <table width="100%">
        <tr>
          <td>
            <div id="left_sentences" class="N610_fleft ">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_LEFT/SECTION">
                <div id="SENTENCE_LEFT_{@id}" class="N610_fhw draggable N610_draggableMatching N610_elementNormal {$calculate_width} {$calculate_height}">
                  <xsl:call-template name="set_moovingbox_size_left"/>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable" cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>
                </div>
                <input type="hidden" value="" id="hin_{@id}" />
              </xsl:for-each>
            </div>
          </td>
          <td>
            <div id="right_sentences" class="N610_fright ">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_RIGHT/SECTION">
                <div id="SENTENCE_RIGHT_{@id}" class="N610_fhw droppable N610_droppableMatching N610_elementNormal {$calculate_width} {$calculate_height}">
                  <xsl:call-template name="set_moovingbox_size_right"/>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable" cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>

                </div>
              </xsl:for-each>
            </div>
          </td>
        </tr>
      </table>
    </div>
    <script type="text/javascript">
      function formatCheck(xml) {
        xml.BeginNode("CHECK_EXERCISE");
        $("input[id ^= 'hin_']").each(function() {
          xml.BeginNode("SECTION");
            xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_")+1));
            xml.Attrib("answerID", $(this).val());
          xml.EndNode();
        });
        xml.EndNode();
        return xml;
      }
      jQuery(document).ready(function($) {
        setup_Matching(true,false,<xsl:value-of select="$cw"/>);
      });
    </script>
    <xsl:call-template name="set_object_order" />
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Matching">
    <div id="containment-wrapper" class="N610_Matching">
      <div id="drawing-wrapper">
        <!---->
      </div>
      <table width="100%">
        <tr>
          <td>
            <div id="left_sentences" class="N610_fleft">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_LEFT/SECTION">
                <div id="SENTENCE_LEFT_{@id}">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                  <xsl:choose>
                    <xsl:when test="@isAnswerCorrect=1">
                      <xsl:attribute name="class">N610_fhw draggable N610_draggableMatching N610_elementCorrect</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:attribute name="class" >N610_fhw draggable N610_draggableMatching N610_elementIncorrect</xsl:attribute>
                    </xsl:otherwise>
                  </xsl:choose>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable" cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>
                </div>
                <input type="hidden" value="{@answerID}_{@isAnswerCorrect}" id="hin_{@id}" />
              </xsl:for-each>
            </div>
          </td>
          <td>
            <div id="right_sentences" class="N610_fright">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_RIGHT/SECTION">
                <div id="SENTENCE_RIGHT_{@id}" class="N610_fhw droppable N610_droppableMatching N610_elementNormal">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable " cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>
                </div>
              </xsl:for-each>
            </div>
          </td>
        </tr>
      </table>
    </div>
    <script type="text/javascript">
      jQuery(document).ready(function($) {
         setup_Matching(false,false,<xsl:value-of select="$cw"/>);
      });
    </script>
    <xsl:call-template name="set_object_order" />
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Resolve_Matching">
    <div id="containment-wrapper" class="N610_Matching">
      <div id="drawing-wrapper">
        <!---->
      </div>
      <table width="100%">
        <tr>
          <td>
            <div id="left_sentences" class="N610_fleft">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_LEFT/SECTION">
                <div id="SENTENCE_LEFT_{@id}" class="N610_fhw draggable N610_draggableMatching N610_elementResolved">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable " cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>
                </div>
                <input type="hidden" value="{@answerID}_1" id="hin_{@id}" />
              </xsl:for-each>
            </div>
          </td>
          <td>
            <div id="right_sentences" class="N610_fright ">
              <xsl:for-each select="/Data/EXERCISE/MATCHING/MATCHING_RIGHT/SECTION">
                <div id="SENTENCE_RIGHT_{@id}" class="N610_fhw droppable N610_droppableMatching N610_elementNormal">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
                  <table class="N610_matchingTable" cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                      </td>
                    </tr>
                  </table>
            </xsl:with-param>
          </xsl:call-template>
                </div>
              </xsl:for-each>
            </div>
          </td>
        </tr>
      </table>
    </div>
    <script type="text/javascript">
      jQuery(document).ready(function($) {
        setup_Matching(false,true,<xsl:value-of select="$cw"/>);
      });
    </script>
    <xsl:call-template name="set_object_order" />
  </xsl:template>
</xsl:stylesheet>