<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_MovingBox_Areas">
    <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Areas">
      <xsl:for-each select="/Data/EXERCISE/PARKING_BOX/BOX">
        <div id="divBox_{@id}" class="N610_elementNormal draggable N610_movingBoxDiv ui-draggable">
          <input type="hidden" value="" id="hin_{@id}" />
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <table id="divVal_{@id}" class="N610_movingBoxTable N610_fhw N610_samesize {$calculate_width} {$calculate_height}" cellpadding="0" cellspacing="0">
                <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                <tr><td><xsl:value-of select="."/></td></tr>
              </table>
            </xsl:with-param>
          </xsl:call-template>
        </div>
        <div style="width:5px;float:left;height:30px;"><xsl:comment> </xsl:comment></div>
      </xsl:for-each>
      
      <div class="N610_breaker"><xsl:comment></xsl:comment></div> 
      <div class="N610_breaker"><xsl:comment></xsl:comment></div>
      
      <xsl:for-each select="/Data/EXERCISE/AREAS/AREA">
        <div class="N610_movingbox_area_container">
          <div class="N610_areaName"><xsl:value-of select="./TEXT/." disable-output-escaping="yes" xml:space="preserve"/></div>
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <div id="exerciseArea_{@id}" class="N610_fhw droppable N610_area {$calculate_width_area} {$calculate_height_area}">
                <xsl:call-template name="set_initial_size_area" />
                <xsl:comment></xsl:comment>
              </div>
            </xsl:with-param>
          </xsl:call-template>
        </div>
      </xsl:for-each>
    </div>
    <script type="text/javascript">
      <xsl:comment>
        function formatCheck(xml) {
          xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'hin_']").each(function() {
            xml.BeginNode("BOX");
              xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_")+1));
              xml.Attrib("answerID", $(this).val());
            xml.EndNode();
          });
          xml.EndNode();
          return xml;
        }

        jQuery(document).ready(function($) {
          setup_Questions_MovingBoxArea();
        });
      </xsl:comment>
    </script>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_MovingBox_Areas">
     <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Areas">       
      <xsl:for-each select="/Data/EXERCISE/PARKING_BOX/BOX">
        <div id="divBox_{@id}" class="N610_elementNormal draggable N610_movingBoxDiv ui-draggable">
          <input type="hidden" value="" id="hin_{@id}" />
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <table id="divVal_{@id}" class="N610_movingBoxTable N610_fhw N610_samesize" cellpadding="0" cellspacing="0">
                <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                <tr><td><xsl:value-of select="."/></td></tr>
              </table>
            </xsl:with-param>
          </xsl:call-template>
        </div>
      </xsl:for-each>
      
      <div class="N610_breaker"><xsl:comment></xsl:comment></div> 
      <div class="N610_breaker"><xsl:comment></xsl:comment></div>       
        <xsl:for-each select="/Data/EXERCISE/AREAS/AREA">
          <div class="N610_movingbox_area_container">
            <xsl:for-each select="*">
              <xsl:if test="name(.) = 'TEXT'">
                <div class="N610_areaName N610_mb10"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></div>
              </xsl:if>
            </xsl:for-each>
            
      <xsl:call-template name="common_box">
        <xsl:with-param name="content">
          <div id="exerciseArea_{@id}" class="N610_area N610_fhw">
            <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
            <xsl:for-each select="*">
              <xsl:if test="name(.) = 'BOX'">
                <xsl:choose>
                  <xsl:when test="@isAnswerCorrect=1">
                    <div id="divBox_{@id}" class="N610_movingBoxDiv N610_elementCorrect">
                      <xsl:call-template name="common_box">
                        <xsl:with-param name="content">
                          <table id="divVal_{@id}" class="N610_movingBoxTable N610_elementCorrect N610_fhw" cellpadding="0" cellspacing="0">
                            <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                            <tr><td><xsl:value-of select="."/></td></tr>
                          </table>
                        </xsl:with-param>
                      </xsl:call-template>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div id="divBox_{@id}" class="N610_movingBoxDiv N610_elementIncorrect">
                      <xsl:call-template name="common_box">
                        <xsl:with-param name="content">
                          <table id="divVal_{@id}" class="N610_movingBoxTable N610_elementIncorrect N610_fhw" cellpadding="0" cellspacing="0">
                            <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                            <tr><td><xsl:value-of select="."/></td></tr>
                          </table>
                        </xsl:with-param>
                      </xsl:call-template>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </xsl:for-each>
            <xsl:comment></xsl:comment>
          </div>
        </xsl:with-param>
      </xsl:call-template>
          </div>
          
        </xsl:for-each>
    </div>
    
     <script type="text/javascript">
      <xsl:comment>
        jQuery(document).ready(function($) {
          setup_Questions_MovingBoxArea_Check();
        });
      </xsl:comment>
    </script>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Resolve_MovingBox_Areas">
    <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Areas">       
        <div class="N610_breaker"><xsl:comment></xsl:comment></div>
        <xsl:for-each select="/Data/EXERCISE/AREAS/AREA">
          <div class="N610_movingbox_area_container">
            <xsl:for-each select="*">
              <xsl:if test="name(.) = 'TEXT'">
                <div class="N610_areaName N610_mb10"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></div>
              </xsl:if>
            </xsl:for-each>
            
       <xsl:call-template name="common_box">
        <xsl:with-param name="content">
          <div id="exerciseArea_{@id}" class="N610_area N610_fhw">
            <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
             <xsl:for-each select="*">
              <xsl:if test="name(.) = 'BOX'">
               <div id="divBox_{@id}" class="N610_movingBoxDiv N610_elementResolved N610_fhw">
                <xsl:call-template name="common_box">
                  <xsl:with-param name="content">
                    <table id="divVal_{@id}" class="N610_movingBoxTable N610_elementResolved N610_fhw" cellpadding="0" cellspacing="0">
                      <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                      <tr><td class="N610_elementResolved"><xsl:value-of select="."/></td></tr>
                    </table>
                  </xsl:with-param>
                </xsl:call-template>
               </div>
              </xsl:if>
               </xsl:for-each>
            <xsl:comment></xsl:comment>
          </div>
        </xsl:with-param>
      </xsl:call-template>
          </div>
          
        </xsl:for-each>
    </div>
    
     <script type="text/javascript">
      <xsl:comment>
        jQuery(document).ready(function($) {
          setup_Questions_MovingBoxArea_Check();
        });
      </xsl:comment>
    </script>
    
  </xsl:template>
</xsl:stylesheet>