<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_Questions_ComboBox">
    <div class="N610_Questions_ComboBox">
      <table cellspacing="0" cellpadding="0">
        <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <tr>
          <td class="N610_questionColumn">
            <div class="N610_question" id="question_{@id}">
              <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
            </div>
          </td>
          <td class="N610_answerColumn">
            <table class="N610_answerTable">
              <xsl:for-each select="./BOX"> 
                <tr>
                  <td>
                    <div class="N610_inlineElement N610_elementNormal">
                      <xsl:call-template name="common_box">
                        <xsl:with-param name="content">
                          <select id="cb_{@id}" class="N610_fw N610_samesize msDropdown {$calculate_width}">
                            <xsl:call-template name="set_initial_size" />
                            <option value="0" selected="true">Wybierz</option>
                            <xsl:for-each select="./VALUE"><option value="{@id}"><xsl:value-of select="."/></option></xsl:for-each>
                          </select>
                        </xsl:with-param>
                      </xsl:call-template>
                    </div>
                  </td>
                </tr>
              </xsl:for-each>
            </table>
          </td>
        </tr>
        </xsl:for-each>
      </table>
    </div>
    <xsl:call-template name="set_fhw_size">
      <xsl:with-param name="isbh" select="0" />
    </xsl:call-template>
    <script type="text/javascript">
      function formatCheck(xml) {
        xml.BeginNode("CHECK_EXERCISE");
          $("select[id ^= 'cb_']").each(function() {
            xml.BeginNode("BOX");
              xml.Attrib("id", $(this).attr("id").substr(3));
              xml.Attrib("answerID", $(this).val());
            xml.EndNode();
	        });
        xml.EndNode();
        return xml;
      }
       $(".N610_samesize").setEqualSizes();
    </script>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Questions_ComboBox">
    <div class="N610_Questions_ComboBox">      
      <table cellspacing="0" cellpadding="0">
        <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">      
          <tr>
            <td class="N610_questionColumn">
              <div class="N610_question" id="question_{@id}">
                <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
              </div>
            </td>
            <td class="N610_answerColumn">
              <table class="N610_answerTable">
                <xsl:for-each select="./BOX">
                  <tr>
                    <td>
                      <div>
                        <xsl:choose>
                          <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class">N610_elementCorrect N610_inlineElement N610_dropdown</xsl:attribute></xsl:when>
                          <xsl:otherwise><xsl:attribute name="class">N610_elementIncorrect N610_inlineElement N610_dropdown</xsl:attribute></xsl:otherwise>
                        </xsl:choose>                        
                        <xsl:call-template name="common_box">
                          <xsl:with-param name="content">
                            <div id="cb_{@id}" class="N610_fw">
                              <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                              <xsl:value-of select="."/>
                              <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                            </div>
                          </xsl:with-param>
                        </xsl:call-template>
                      </div>
                    </td>
                  </tr>
                </xsl:for-each>
              </table>
            </td>
          </tr>
        </xsl:for-each>
      </table>      
    </div>
  </xsl:template>  
  
  <xsl:template name="ELearning_Exercise_Resolve_Questions_ComboBox">
    <div class="N610_Questions_ComboBox">
      
      <table cellspacing="0" cellpadding="0">
        <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">      
          <tr>
            <td class="N610_questionColumn">
              <div class="N610_question" id="question_{@id}">
                <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
              </div>
            </td>
            <td class="N610_answerColumn">
              <table class="N610_answerTable">
                <xsl:for-each select="./BOX">
                  <tr><td>
                  <div class="N610_inlineElement N610_elementResolved N610_dropdown">
                    <xsl:call-template name="common_box">
                      <xsl:with-param name="content">
                        <div id="cb_{@id}" class="N610_fw">
                          <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                          <xsl:value-of select="."/>
                          <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                        </div>
                      </xsl:with-param>
                    </xsl:call-template>
                  </div>       
                  </td></tr>
                </xsl:for-each>
              </table>
            </td>
          </tr>
        </xsl:for-each>
      </table>           
    </div>
  </xsl:template>    
</xsl:stylesheet>