<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_Text_MissingSection">
    <div id="containment-wrapper" class="ui-droppable N610_Text_MissingSection">
      <table>
        <tr>
          <td>
            <div class="N610_question" id="question_{@id}">
              <xsl:for-each select="/Data/EXERCISE/EXERCISE_TEXT/*">
                <xsl:choose>
                  <xsl:when test="name(.) = 'TEXT'"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></xsl:when>
                  <xsl:when test="name(.) = 'BOX'">
                    <div class="N610_elementNormal N610_inlineElement droppable ui-droppable" id="divDrop_{@id}">
                      <xsl:call-template name="common_box">
                        <xsl:with-param name="content">
                          <div id="in_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                            <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                            <xsl:comment></xsl:comment>
                          </div>
                          <input type="hidden" value="" id="hin_{@id}" />
                        </xsl:with-param>
                      </xsl:call-template>
                    </div>                
                  </xsl:when>
                </xsl:choose>
              </xsl:for-each>
            </div>
          </td>
          <td>
            <div class="parking">
              <xsl:for-each select="/Data/EXERCISE/PARKING_BOX/BOX">
                <div id="divDrag_{@id}" class="N610_movingBoxDiv N610_inlineElement draggable ui-draggable">
                  <xsl:call-template name="common_box">
                    <xsl:with-param name="content">
                        <div id="divVal_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                          <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                          <xsl:value-of select="."/>
                        </div>
                    </xsl:with-param>
                  </xsl:call-template>
                </div>
              </xsl:for-each>
            </div>
          </td>
        </tr>
      </table>
    </div>
    <script type="text/javascript">
      <xsl:comment>
        function formatCheck(xml) {
          xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'hin_']").each(function() {
            xml.BeginNode("BOX");
              xml.Attrib("id", $(this).attr("id").substr(4));
              xml.Attrib("answerID", $(this).val());
            xml.EndNode();
          });
          xml.EndNode();
          return xml;
        }

        jQuery(document).ready(function($) {
          setup_Questions_MovingBox();
        });
      </xsl:comment>
    </script>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Text_MissingSection">
    <div class="N610_Text_MissingSection">
    <div class="N610_question" id="question_{@id}">
      <xsl:for-each select="/Data/EXERCISE/EXERCISE_TEXT/*">
        <xsl:choose>
          <xsl:when test="name(.) = 'TEXT'"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></xsl:when>
          <xsl:when test="name(.) = 'BOX'">
            <div class="N610_samesize" style="-moz-box-sizing: border-box;" id="in_{@id}">
              <xsl:call-template name="set_object_size"/>
              <xsl:choose>
                  <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class">N610_fhw N610_elementCorrect N610_samesize</xsl:attribute></xsl:when>
                  <xsl:otherwise><xsl:attribute name="class">N610_fhw N610_elementIncorrect N610_samesize</xsl:attribute></xsl:otherwise>
              </xsl:choose>                        
              <xsl:call-template name="common_box">
                <xsl:with-param name="content">
                  <div>
                    <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                  </div>
                </xsl:with-param>
              </xsl:call-template>
            </div>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
    </div>
     </div>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Resolve_Text_MissingSection">
    <div class="N610_Text_MissingSection">
     <div class="N610_question" id="question_{@id}">
      <xsl:for-each select="/Data/EXERCISE/EXERCISE_TEXT/*">
        <xsl:choose>
          <xsl:when test="name(.) = 'TEXT'"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></xsl:when>
          <xsl:when test="name(.) = 'BOX'">
            <div class="N610_samesize droppable ui-droppable N610_elementResolved" style="-moz-box-sizing: border-box;" id="in_{@id}">
              <xsl:call-template name="set_object_size"/>
              <xsl:call-template name="common_box">
                <xsl:with-param name="content">
                  <div>
                    <xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/>
                  </div>
                </xsl:with-param>
              </xsl:call-template>
            </div>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
    </div>      
   </div>
  </xsl:template>
</xsl:stylesheet>