﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:template name="ELearning_Notes_Main">
    <xsl:call-template name="ELearning_Notes">
      <xsl:with-param name="type" select="'Main'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ELearning_Notes_Check">
    <xsl:call-template name="ELearning_Notes">
      <xsl:with-param name="type" select="'Check'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ELearning_Notes_Load">
    <xsl:call-template name="ELearning_Notes">
      <xsl:with-param name="type" select="'Load'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ELearning_Notes_Resolve">
    <xsl:call-template name="ELearning_Notes">
      <xsl:with-param name="type" select="'Resolve'"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="ELearning_Notes">
    <!-- type => {main, load, check, resolve} -->
    <xsl:param name="type" select="'Main'"/>
    
    
    <xsl:if test="count(/Data/EXERCISE/NOTES/NOTE)>0">
      <xsl:for-each select="/Data/EXERCISE/NOTES/NOTE">
        <xsl:if test="($type='Main' and @isMainText=1) or ((($type='Load' and @isOnLoad=1) or ($type='Check' and @isOnCheck=1) or ($type='Resolve' and @isOnResolve=1)) and @isMainText=0)">
          <div id="note_{@id}" class="N610_exerciseNote{$type} N610_corner"><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></div>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>      
  </xsl:template>
  
</xsl:stylesheet>