﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:variable name="bh">
    <xsl:if test="string-length(/Data/EXERCISE/@bh)>0 and /Data/EXERCISE/@bh>0">
      $(".N610_fhw").css("height", <xsl:value-of select="/Data/EXERCISE/@bh"/>);
    </xsl:if>            
  </xsl:variable>
  
  <xsl:variable name="bw">
    <xsl:if test="string-length(/Data/EXERCISE/@bw)>0 and /Data/EXERCISE/@bw>0">
      $(".N610_fhw").css("width", <xsl:value-of select="/Data/EXERCISE/@bw"/>);
    </xsl:if>            
  </xsl:variable>
  
  <xsl:variable name="calculate_width">
    <xsl:if test="string-length(/Data/EXERCISE/@mwl)=0 and string-length(/Data/EXERCISE/@mwr)=0 and string-length(/Data/EXERCISE/@bw)=0">N610_calculate_width</xsl:if>
  </xsl:variable>

  <xsl:variable name="calculate_height">
    <xsl:if test="string-length(/Data/EXERCISE/@mh)=0 and string-length(/Data/EXERCISE/@bh)=0">N610_calculate_height</xsl:if>
  </xsl:variable>
  
  <xsl:variable name="calculate_width_area">
    <xsl:if test="string-length(/Data/EXERCISE/@aw)=0">N610_calculate_width</xsl:if>
  </xsl:variable>

  <xsl:variable name="calculate_height_area">
    <xsl:if test="string-length(/Data/EXERCISE/@ah)=0">N610_calculate_height</xsl:if>
  </xsl:variable>

  <xsl:template name="set_fhw_size">
    <xsl:param name="isbh" select="1"/>
    <xsl:param name="isbw" select="1"/>
    <xsl:if test="(string-length($bw)>0 and $isbw=1) or (string-length($bh)>0 and $isbh=1)">
      <script type="text/javascript">
        jQuery(document).ready(function($) {
          <xsl:if test="$isbw=1"><xsl:value-of select="$bw"/></xsl:if>
          <xsl:if test="$isbh=1"><xsl:value-of select="$bh"/></xsl:if>
        });
      </script>
    </xsl:if>
  </xsl:template>

  <xsl:template name="set_object_order">
    <xsl:if test="string-length(/Data/EXERCISE/@oo)>0">
      <input type="hidden" id="__oo" value="{/Data/EXERCISE/@oo}" />
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="set_object_size">
    <xsl:param name="style" select="''" />
    <xsl:variable name="bwh"><xsl:if test="string-length(@width)>0 and @width>0">width:<xsl:value-of select="@width"/>px;</xsl:if><xsl:if test="string-length(@height)>0 and @height>0">height:<xsl:value-of select="@height"/>px;</xsl:if></xsl:variable>
    <xsl:if test="(string-length($bwh)>0) or (string-length($style)>0)"><xsl:attribute name="style"><xsl:value-of select="$style"/><xsl:value-of select="$bwh"/></xsl:attribute></xsl:if>
  </xsl:template>
  
  <xsl:template name="set_initial_size">
    <xsl:param name="style" select="''" />
    <xsl:variable name="bwh"><xsl:if test="string-length(/Data/EXERCISE/@bw)>0 and /Data/EXERCISE/@bw>0">width:<xsl:value-of select="/Data/EXERCISE/@bw"/>px;</xsl:if><xsl:if test="string-length(/Data/EXERCISE/@bh)>0 and /Data/EXERCISE/@bh>0">height:<xsl:value-of select="/Data/EXERCISE/@bh"/>px;</xsl:if></xsl:variable>
    <xsl:if test="(string-length($bwh)>0) or (string-length($style)>0)"><xsl:attribute name="style"><xsl:value-of select="$style"/><xsl:value-of select="$bwh"/></xsl:attribute></xsl:if>
  </xsl:template>  
  
  <xsl:template name="set_initial_size_area">
    <xsl:param name="style" select="''" />
    <xsl:variable name="bwh"><xsl:if test="string-length(/Data/EXERCISE/@aw)>0 and /Data/EXERCISE/@aw>0">width:<xsl:value-of select="/Data/EXERCISE/@aw"/>px;</xsl:if><xsl:if test="string-length(/Data/EXERCISE/@ah)>0 and /Data/EXERCISE/@ah>0">height:<xsl:value-of select="/Data/EXERCISE/@ah"/>px;</xsl:if></xsl:variable>
    <xsl:if test="(string-length($bwh)>0) or (string-length($style)>0)"><xsl:attribute name="style"><xsl:value-of select="$style"/><xsl:value-of select="$bwh"/></xsl:attribute></xsl:if>
  </xsl:template>   

  <xsl:template name="set_moovingbox_size_left">
    <xsl:param name="style" select="''" />
    <xsl:variable name="bwh"><xsl:if test="string-length(/Data/EXERCISE/@mwl)>0 and /Data/EXERCISE/@mwl>0">width:<xsl:value-of select="/Data/EXERCISE/@mwl"/>px;</xsl:if><xsl:if test="string-length(/Data/EXERCISE/@mh)>0 and /Data/EXERCISE/@mh>0">height:<xsl:value-of select="/Data/EXERCISE/@mh"/>px;</xsl:if></xsl:variable>
    <xsl:if test="(string-length($bwh)>0) or (string-length($style)>0)"><xsl:attribute name="style"><xsl:value-of select="$style"/><xsl:value-of select="$bwh"/></xsl:attribute></xsl:if>
  </xsl:template>
  
  <xsl:template name="set_moovingbox_size_right">
    <xsl:param name="style" select="''" />
    <xsl:variable name="bwh"><xsl:if test="string-length(/Data/EXERCISE/@mwr)>0 and /Data/EXERCISE/@mwr>0">width:<xsl:value-of select="/Data/EXERCISE/@mwr"/>px;</xsl:if><xsl:if test="string-length(/Data/EXERCISE/@mh)>0 and /Data/EXERCISE/@mh>0">height:<xsl:value-of select="/Data/EXERCISE/@mh"/>px;</xsl:if></xsl:variable>
    <xsl:if test="(string-length($bwh)>0) or (string-length($style)>0)"><xsl:attribute name="style"><xsl:value-of select="$style"/><xsl:value-of select="$bwh"/></xsl:attribute></xsl:if>
  </xsl:template>

  <xsl:template name="common_box">
    <xsl:param name="content"/>
      <table class="round_box" cellspacing="0" cellpadding="0" border="0">
        <tr>
          <td class="top_left"><xsl:comment></xsl:comment></td>
          <td class="top"><xsl:comment></xsl:comment></td>
          <td class="top_right"><xsl:comment></xsl:comment></td>
        </tr>
        <tr>
          <td class="left"><div class="left"><xsl:comment></xsl:comment></div></td>
          <td class="center">
            <div class="box_content">
              <xsl:copy-of select="$content"/>
              <xsl:variable name="_v"><xsl:value-of select="$content"/></xsl:variable>
              <xsl:if test="string-length($_v) = 0">&#160;</xsl:if>
              <xsl:comment></xsl:comment>
            </div>
          </td>
          <td class="right"><div class="right"><xsl:comment></xsl:comment></div></td>
        </tr>
        <tr>
          <td class="bottom_left"><xsl:comment></xsl:comment></td>
          <td class="bottom"><xsl:comment></xsl:comment></td>
          <td class="bottom_right"><xsl:comment></xsl:comment></td>
        </tr>
      </table>
  </xsl:template>
  
</xsl:stylesheet>
