﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="../XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  

  <xsl:template name="ZPSB_ELearning_Breadcrumb">
    <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID > 0">
      <div class="e_exercise_menu_container">
        <div class="e_exercise_title fontexercisetitle">
          <xsl:value-of select="/Data/EXERCISE/BREADCRUMBS_MENU/@title"/>
        </div>
        <div class="e_exercise_nav fontexercisetitle">
          <!---Montujemy butony od konca, bo sa float right !-->
          <div class="fright">
            <div>
              <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isPrev=1">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_arrow_left.png"    title="Poprzednie ćwiczenie" onclick="loadPreviousExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
              </xsl:if>
              <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isNext=1">
                <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_arrow_right.png"    title="Następne ćwiczenie" onclick="loadNextExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
              </xsl:if>
              <xsl:comment> </xsl:comment>
            </div>
            
            <xsl:if test="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/@pageCounter > 0">
            <div class="e_exercise_points fontexercisetitle popup_select" id="exercise_numbers_select">           
              <span><xsl:value-of select="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/@pagePosition"/></span><span>/</span><span><xsl:value-of select="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/@pageCounter"/></span>
              <xsl:comment> </xsl:comment>
            </div>
            </xsl:if>
            
          </div>
          <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isResolve=1">
            <div class="fright">
              <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_pokaz_prawidlowe.png" title="Wyświetlenie poprawnych odpowiedzi" onclick="resolveExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
            </div>
          </xsl:if>
          <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isCheck=1">
            <div class="fright">
              <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_sprawdz_cwiczenie.png" title="Sprawdzenie odpowiedzi" onclick="checkExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
            </div>
          </xsl:if>
          <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isMenu=1">
            <div class="fright">
              <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/610/house_32.png" title="Powrót do menu kursu" onclick="loadCourseMenu('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID});"/>
            </div>
          </xsl:if>
          <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isReload=1">
            <div class="fright">
              <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/610/refresh_32.png"  title="Ponowne załadowanie ćwiczenia" onclick="loadExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
            </div>
          </xsl:if>
          <xsl:comment> </xsl:comment>
        </div>
      </div>
      
      <xsl:call-template name="exercise_numbers" />
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="ZPSB_ELearning_Breadcrumb_Bottom">
    <div class="e_exercise_nav_bottom">
      <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isPrev=1">
        <IMG class="e_exercise_nav_bottom_left" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_poprzednia_lekcja.png" title="Poprzednie ćwiczenie" onclick="loadPreviousExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
      </xsl:if>
      <xsl:if test="/Data/EXERCISE/BREADCRUMBS_MENU/@isNext=1">
        <IMG class="e_exercise_nav_bottom_right" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/btn_nastepna_lekcja.png" title="Następne ćwiczenie" onclick="loadNextExercise('{/Data/Config/Domain}',{/Data/EXERCISE/BREADCRUMBS_MENU/@contextObjectID},{/Data/EXERCISE/BREADCRUMBS_MENU/@courseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@unitID},{/Data/EXERCISE/BREADCRUMBS_MENU/@exerciseID},{/Data/EXERCISE/BREADCRUMBS_MENU/@modeID});"/>
      </xsl:if>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>
  
  <xsl:template name="exercise_numbers">
    <xsl:if test="count(/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE) > 0">
    <div id="popup_exercise_numbers_select" class="e_exercise_numbers fontexercisetitle popup_box" style="display:none; background-color:#b0c4de;" >
      <ul>
        <xsl:for-each select="/Data/EXERCISE/BREADCRUMBS_NAVIGATION/EXERCISE">
          <li class="fontexercisetitle" title="Ćwiczenie {@index}" onclick="javascript:loadExercise('{/Data/Config/Domain}','{@contextObjectID}','{@courseID}','{@unitID}','{@exerciseID}',{@modeID})">
            <xsl:if test="@isCurrent=1"><xsl:attribute name="class">fontexercisetitle e_exercise_number_sel</xsl:attribute></xsl:if><xsl:value-of select="@index"/>
          </li>
        </xsl:for-each>        
      </ul>
    </div>
    </xsl:if>
  </xsl:template>
  
  
  <xsl:template name="ZPSB_ELearning_CourseMenu">
    <xsl:if test="count(/Data/EXERCISE/UNITS/UNIT)>0">
      <div class="coursemenu coursemenu_corner">
        <table style="width:100%;">
          <xsl:for-each select="/Data/EXERCISE/UNITS/UNIT">
            
            <xsl:variable name="onclick">loadExercise('<xsl:value-of select="/Data/Config/Domain"/>',<xsl:value-of select="/Data/EXERCISE/UNITS/@contextObjectID"/>,<xsl:value-of select="/Data/EXERCISE/UNITS/@courseId"/>,<xsl:value-of select="@unitId"/>,<xsl:value-of select="@exerciseId"/>,<xsl:value-of select="@modeID"/>);</xsl:variable>
            <tr><td>
            <xsl:call-template name="named_banner">
              <xsl:with-param name="image_url" select="''"/>
              <xsl:with-param name="onclick" select="$onclick" />
              <xsl:with-param name="title" select="@title" />
            </xsl:call-template>
            </td></tr>
          </xsl:for-each>
        </table>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>