﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="../../ResorcesCommon/ELearning_Utils.xsl"/>
  <xsl:import href="./CommonTemplates.xsl"/>

  <xsl:variable name="plec_list">
    <plec ID="0" Name="Mężczyzna"/>
    <plec ID="1" Name="Kobieta"/>
  </xsl:variable>

  <xsl:template name="invaliduser">
    <xsl:call-template name="box">
      <xsl:with-param name="avataronright" select="0"/>
      <xsl:with-param name="content">
        <xsl:call-template name="info"><xsl:with-param name="msg">Nie jesteś zalogowany.</xsl:with-param></xsl:call-template>                          
      </xsl:with-param>
    </xsl:call-template>          
  </xsl:template>
  
  <xsl:template name="invalidgroup">
    <xsl:call-template name="box">
      <xsl:with-param name="avataronright" select="0"/>
      <xsl:with-param name="content">
        <xsl:call-template name="info"><xsl:with-param name="msg">Grupa do której należy użytkownik nie ma panelu administracyjnego. Nazwa grupy: <xsl:value-of select="/Data/Group/@Name"/></xsl:with-param></xsl:call-template>                          
      </xsl:with-param>
    </xsl:call-template>          
  </xsl:template>
    
  <xsl:template name="box">
    <xsl:param name="content" />
    <xsl:param name="avatar" select="1"/>
    <xsl:param name="avataronright" select="1"/>
    
    <div class="userdetailscontainer N610_elementNormal">
      <xsl:call-template name="common_box">
        <xsl:with-param name="content">
          <table style="width:100%;" cellspacing="0" cellpadding="0">
            <tr>
              <xsl:choose>
                <xsl:when test="$avataronright=1">
                  <td class="contentcell">
                    <xsl:copy-of select="$content"/>
                  </td>
                  <xsl:if test="$avatar=1">
                    <td class="avatarcell">
                      <div class="userdetailsavatar">
                        <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/teacheravatar.png" alt="Nauczyciel" title="Nauczyciel" border="0" />
                      </div>
                    </td>
                  </xsl:if>                  
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$avatar=1">
                    <td class="avatarcell">
                      <div class="userdetailsavatar">
                        <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/teacheravatar.png" alt="Nauczyciel" title="Nauczyciel" border="0" />
                      </div>
                    </td>
                  </xsl:if>
                  <td>
                    <xsl:copy-of select="$content"/>
                  </td>
                </xsl:otherwise>
              </xsl:choose>
            </tr>
          </table>
        </xsl:with-param>
      </xsl:call-template>          
    </div>
  </xsl:template>
  
  <xsl:template name="info">
    <xsl:param name="msg" select="''"/>
    <xsl:if test="string-length($msg)>0">
      <table class="loginformtable padding5" cellspacing="0" cellpadding="0" border="0">
        <tr>
          <td>
            <span><xsl:value-of select="$msg"/></span>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="header">
    <xsl:param name="value"/>
    <h1 class="lblhead"><xsl:value-of select="$value"/></h1>
  </xsl:template>
  
  <xsl:template name="label">
    <xsl:param name="value"/>
    <label class="lbl"><xsl:value-of select="$value"/><xsl:if test="string-length($value)>0">:</xsl:if></label>
  </xsl:template>
  
  <xsl:template name="edit">
    <xsl:param name="value"/>
    <xsl:param name="name"/>
    <xsl:param name="type" select="'text'"/>
    <xsl:param name="readonly" select="1"/>
    <input type="{$type}" class="edt" value="{$value}" name="{$name}" id="{$name}">
      <xsl:if test="$readonly=1">
        <xsl:attribute name="readonly">true</xsl:attribute>
        <xsl:attribute name="class">edt ro</xsl:attribute>
      </xsl:if>
    </input>
  </xsl:template>
  
  <xsl:template name="select">
    <xsl:param name="value"/>
    <xsl:param name="list"/>
    <xsl:param name="name"/>
    <xsl:param name="readonly" select="1"/>
    <xsl:choose>
      <xsl:when test="$readonly=1">
        <xsl:variable name="val">
          <xsl:for-each select="$list/*">
            <xsl:if test="$value=@ID">
              <xsl:value-of select="@Name"/>
            </xsl:if>
          </xsl:for-each>
        </xsl:variable>
        <xsl:call-template name="edit"><xsl:with-param name="name" select="$name"/><xsl:with-param name="type" select="'text'"/><xsl:with-param name="readonly" select="1"/><xsl:with-param name="value" select="$val"/></xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <select class="edt" name="{$name}" id="{$name}">
          <xsl:for-each select="$list/*">
            <option value="{@ID}">
              <xsl:if test="$value=@ID">
                <xsl:attribute name="selected">selected</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="@Name"/>
            </option>
          </xsl:for-each>
        </select>
      </xsl:otherwise>
    </xsl:choose>
      
    
  </xsl:template>
  
  <xsl:template name="named_banner">
    <xsl:param name="image_url" />
    <xsl:param name="title" />
    <xsl:param name="link" select="'#'"/>
    <xsl:param name="onclick" />
    <xsl:param name="width" />    
    
    <xsl:choose>
      <xsl:when test="string-length($image_url)>0">
        <div class="competencebox"><a href="{$link}"><xsl:if test="string-length($onclick)>0"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if><img src="{$image_url}" border="0" title="{$title}" /></a></div>
      </xsl:when>
      <xsl:otherwise>
        <div class="N610_inlineElement N610_elementResolved competencebox">
          <xsl:if test="string-length($width)>0">
            <xsl:attribute name="style">width:<xsl:value-of select="$width" />px;margin: auto;</xsl:attribute>
          </xsl:if>
          
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <div class="competencename fontcompetencename"><a href="{$link}"><xsl:if test="string-length($onclick)>0"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if><xsl:value-of select="$title"/></a></div>
            </xsl:with-param>
          </xsl:call-template>
        </div>
      </xsl:otherwise>
    </xsl:choose>
    <div class="cls competenceboxsep"><xsl:comment> </xsl:comment></div>
  </xsl:template>

  <xsl:template name="continue_learn">
      <xsl:param name="node" />    
      <xsl:param name="width" />
    
      <xsl:if test="string-length($node/ValidContext/@contextid)>0">
        
      <xsl:variable name="comment"><xsl:choose><xsl:when test="$node/ValidContext/@start =1">Rozpocznij naukę</xsl:when><xsl:otherwise>Kontynuuj naukę</xsl:otherwise></xsl:choose></xsl:variable>                 
               
      <xsl:variable name="learnging_url"><xsl:choose><xsl:when test="/Data/Config/Debug = 1">Default.aspx?GURL=/learning.html</xsl:when><xsl:otherwise>/learning.html</xsl:otherwise></xsl:choose></xsl:variable>
        
      <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URLReferrer, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>                
                                   
       <xsl:choose>
        
          <xsl:when  test="string-length($node/ValidContext/@partid)>0">
          <xsl:call-template name="named_banner">
            <xsl:with-param name="link"><xsl:value-of select="$learnging_url" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="$node/ValidContext/@competenceid"/>&amp;partid=<xsl:value-of select="$node/ValidContext/@partid"/>&amp;courseid=<xsl:value-of select="$node/ValidContext/@courseid"/>&amp;pt=<xsl:value-of select="$node/ValidContext/@pt"/>&amp;coursetype=<xsl:value-of select="$node/ValidContext/@coursetype"/>&amp;contextid=<xsl:value-of select="$node/ValidContext/@contextid"/></xsl:with-param>
            <xsl:with-param name="title" select="$comment" />
            <xsl:with-param name="width" select="$width" />                  
          </xsl:call-template>
        </xsl:when>
                                                  
        <xsl:otherwise>
          <xsl:call-template name="named_banner">
            <xsl:with-param name="link"><xsl:value-of select="$learnging_url" /><xsl:value-of select="$sign" />courseid=<xsl:value-of select="$node/ValidContext/@courseid"/>&amp;pt=<xsl:value-of select="$node/ValidContext/@pt"/>&amp;coursetype=<xsl:value-of select="$node/ValidContext/@coursetype"/>&amp;contextid=<xsl:value-of select="$node/ValidContext/@contextid"/></xsl:with-param>
            <xsl:with-param name="title" select="$comment" />
            <xsl:with-param name="width" select="$width" />                                    
          </xsl:call-template>                
        </xsl:otherwise>
      </xsl:choose>               
      </xsl:if>    
  </xsl:template>  
  
  <xsl:template name="admin_url">
    <xsl:param name="area" select="'none'"/>
    <xsl:param name="params" select="''"/>
    <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
    <xsl:variable name="rest"><xsl:if test="string-length($params)>0">&amp;<xsl:value-of select="$params"/></xsl:if></xsl:variable>
    <xsl:value-of select="/Data/Config/URL"/><xsl:value-of select="$sign"/>area=<xsl:value-of select="$area"/><xsl:value-of select="$rest"/>
  </xsl:template>

  <xsl:template name="admin_link">
    <xsl:param name="title" select="'Administracja'"/>
    <xsl:param name="area" select="'none'"/>
    <xsl:param name="params" select="''"/>
    <xsl:variable name="url"><xsl:call-template name="admin_url"><xsl:with-param name="area" select="$area"/><xsl:with-param name="params" select="$params"/></xsl:call-template></xsl:variable>
    <a href="{$url}" title="{$title}"><xsl:value-of select="$title"/></a>
  </xsl:template>
  
  <xsl:variable name="main_admin_link">
     <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'none'"/><xsl:with-param name="title" select="'Administracja'"/></xsl:call-template>
  </xsl:variable>
  
  <xsl:variable name="student_list_admin_link">
     <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'studentlist'"/><xsl:with-param name="title" select="'Lista uczniów'"/></xsl:call-template>
  </xsl:variable>

  <xsl:variable name="class_list_admin_link">
     <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classlist'"/><xsl:with-param name="title" select="'Lista klas'"/></xsl:call-template>
  </xsl:variable>
  
  <xsl:variable name="class_add_admin_link">
     <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classedit'"/><xsl:with-param name="title" select="'Dodaj klasę'"/><xsl:with-param name="params" select="'classid=0'"/></xsl:call-template>
  </xsl:variable>

  <xsl:variable name="class_edit_note_admin_link">
    <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classeditnote'"/><xsl:with-param name="title" select="'Edycja oceny'"/><xsl:with-param name="params">classid=<xsl:value-of select="/Data/Class/@ID"/></xsl:with-param></xsl:call-template>
  </xsl:variable>

  <xsl:variable name="class_edit_student_admin_link">
    <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classeditstudent'"/><xsl:with-param name="title" select="'Uczniowie w klasie'"/><xsl:with-param name="params">classid=<xsl:value-of select="/Data/Class/@ID"/></xsl:with-param></xsl:call-template>
  </xsl:variable>

  <xsl:variable name="class_edit_competences_admin_link">
    <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classeditcompetences'"/><xsl:with-param name="title" select="'Plan nauczania'"/><xsl:with-param name="params">classid=<xsl:value-of select="/Data/Class/@ID"/></xsl:with-param></xsl:call-template>
  </xsl:variable>
  
  <xsl:variable name="student_edit_class_admin_link">
    <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'classeditstudent'"/><xsl:with-param name="title" select="'Klasa ucznia'"/><xsl:with-param name="params">classid=<xsl:value-of select="/Data/Class/@ID"/></xsl:with-param></xsl:call-template>
  </xsl:variable>  
  
  <xsl:variable name="student_edit_competences_admin_link">
    <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'studenteditcompetences'"/><xsl:with-param name="title" select="'Plan nauczania'"/><xsl:with-param name="params">studentid=<xsl:value-of select="/Data/Student/@ID"/></xsl:with-param></xsl:call-template>
  </xsl:variable>  
   
  <xsl:variable name="student_add_admin_link">
     <xsl:call-template name="admin_link"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="title" select="'Dodaj ucznia'"/><xsl:with-param name="params" select="'studentid=0'"/></xsl:call-template>
  </xsl:variable>
  
  <xsl:template match="Instructor">
    <xsl:param name="readonly" select="1"/>
    <xsl:param name="isadmin" select="0"/>
    <xsl:param name="isstudent" select="0"/>
    <xsl:param name="ispassword" select="0"/>
    <table class="userdetailstable">
      <tr>
        <td colspan="2"><xsl:call-template name="header"><xsl:with-param name="value" select="'Dane nauczyciela'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Tytuł'"/></xsl:call-template></td>
        <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="readonly" select="$readonly"/><xsl:with-param name="value" select="@Title"/><xsl:with-param name="name" select="'Instructor_Title'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Imię'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="readonly" select="$readonly"/><xsl:with-param name="value" select="@Forename"/><xsl:with-param name="name" select="'Instructor_Forename'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Nazwisko'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="readonly" select="$readonly"/><xsl:with-param name="value" select="@Surename"/><xsl:with-param name="name" select="'Instructor_Surename'"/></xsl:call-template></td>
      </tr>
      <xsl:if test="$isstudent=0">
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Email'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="readonly" select="$readonly"/><xsl:with-param name="value" select="@Email"/><xsl:with-param name="name" select="'Instructor_Email'"/></xsl:call-template></td>
        </tr>
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Telefon'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="readonly" select="$readonly"/><xsl:with-param name="value" select="@Tel"/><xsl:with-param name="name" select="'Instructor_Tel'"/></xsl:call-template></td>
        </tr>
        <xsl:if test="$ispassword=1">
          <tr>
            <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Hasło'"/></xsl:call-template></td>
            <td><xsl:call-template name="edit"><xsl:with-param name="type" select="'password'"/><xsl:with-param name="value" select="''"/><xsl:with-param name="name" select="'Instructor_Password'"/><xsl:with-param name="readonly" select="0"/></xsl:call-template></td>
          </tr>
          <tr>
            <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Powtórz hasło'"/></xsl:call-template></td>
            <td><xsl:call-template name="edit"><xsl:with-param name="type" select="'password'"/><xsl:with-param name="value" select="''"/><xsl:with-param name="name" select="'Instructor_PasswordRe'"/><xsl:with-param name="readonly" select="0"/></xsl:call-template></td>
          </tr>
        </xsl:if>
      </xsl:if>
    </table>
  </xsl:template>
  
  <xsl:template match="School">
    <xsl:param name="readonly" select="1"/>
    <xsl:param name="isadmin" select="0"/>
    <xsl:param name="isstudent" select="0"/>
    <table class="userdetailstable">
      <tr>
        <td colspan="2"><xsl:call-template name="header"><xsl:with-param name="value" select="'Dane szkoły'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Nazwa'"/></xsl:call-template></td>
        <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="value" select="@Name"/><xsl:with-param name="name" select="'School_Name'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Adres'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@AddressLine1"/><xsl:with-param name="name" select="'School_AddressLine1'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="''"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@AddressLine2"/><xsl:with-param name="name" select="'School_AddressLine2'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Kod pocztowy'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@PostCode"/><xsl:with-param name="name" select="'School_PostCode'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Miasto'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@Town"/><xsl:with-param name="name" select="'School_Town'"/></xsl:call-template></td>
      </tr>
      <xsl:if test="$isstudent=0">
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Telefon'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@Tel"/><xsl:with-param name="name" select="'School_Tel'"/></xsl:call-template></td>
        </tr>
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Fax'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@Fax"/><xsl:with-param name="name" select="'School_Fax'"/></xsl:call-template></td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>
  
  <xsl:template match="Class">
    <xsl:param name="readonly" select="1"/>
    <xsl:param name="isadmin" select="0"/>
    <xsl:param name="isstudent" select="0"/>
    <table class="userdetailstable">
      <tr>
        <td colspan="2"><xsl:call-template name="header"><xsl:with-param name="value" select="'Dane klasy'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Nazwa'"/></xsl:call-template></td>
        <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="value" select="@Name"/><xsl:with-param name="name" select="'Class_Name'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
      </tr>
      <xsl:if test ="string-length(@SchoolYear)>0">
        <tr>
          <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Rok szkolny'"/></xsl:call-template></td>
          <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="value" select="@SchoolYear"/><xsl:with-param name="name" select="'Class_SchoolYear'"/><xsl:with-param name="readonly" select="1"/></xsl:call-template></td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>               
  
  <xsl:template match="Student">
    <xsl:param name="readonly" select="1"/>
    <xsl:param name="isadmin" select="0"/>
    <xsl:param name="ispassword" select="0"/>
    <xsl:param name="isstudent" select="0"/>
    <table class="userdetailstable">
      <tr>
        <td colspan="2"><xsl:call-template name="header"><xsl:with-param name="value" select="'Dane ucznia'"/></xsl:call-template></td>
      </tr>
      <tr>
        <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Imię'"/></xsl:call-template></td>
        <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="value" select="@Forename"/><xsl:with-param name="name" select="'Student_Forename'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Nazwisko'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@Surename"/><xsl:with-param name="name" select="'Student_Surename'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Email'"/></xsl:call-template></td>
        <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@Email"/><xsl:with-param name="name" select="'Student_Email'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Płeć'"/></xsl:call-template></td>
        <xsl:choose>
          <xsl:when test="$isstudent=1">
            <td><xsl:call-template name="select"><xsl:with-param name="list" select="msxsl:node-set($plec_list)"/><xsl:with-param name="value" select="@Sex"/><xsl:with-param name="name" select="'Student_Sex'"/><xsl:with-param name="readonly" select="1"/></xsl:call-template></td>
          </xsl:when>
          <xsl:otherwise>
            <td><xsl:call-template name="select"><xsl:with-param name="list" select="msxsl:node-set($plec_list)"/><xsl:with-param name="value" select="@Sex"/><xsl:with-param name="name" select="'Student_Sex'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
      <tr>
        <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Numer indeksu'"/></xsl:call-template></td>
        <xsl:choose>
          <xsl:when test="$isstudent=1">
            <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@IndexNr"/><xsl:with-param name="name" select="'Student_IndexNr'"/><xsl:with-param name="readonly" select="1"/></xsl:call-template></td>
          </xsl:when>
          <xsl:otherwise>
            <td><xsl:call-template name="edit"><xsl:with-param name="value" select="@IndexNr"/><xsl:with-param name="name" select="'Student_IndexNr'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
      <xsl:if test="$readonly=0 and count(/Data/ClassList/Class)>0">
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Klasa'"/></xsl:call-template></td>
          <td><xsl:call-template name="select"><xsl:with-param name="list" select="/Data/ClassList"/><xsl:with-param name="value" select="@ClassID"/><xsl:with-param name="name" select="'Student_ClassID'"/><xsl:with-param name="readonly" select="$readonly"/></xsl:call-template></td>
        </tr>
      </xsl:if>
      <xsl:if test="$ispassword=1">
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Hasło'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="type" select="'password'"/><xsl:with-param name="value" select="''"/><xsl:with-param name="name" select="'Student_Password'"/><xsl:with-param name="readonly" select="0"/></xsl:call-template></td>
        </tr>
        <tr>
          <td><xsl:call-template name="label"><xsl:with-param name="value" select="'Powtórz hasło'"/></xsl:call-template></td>
          <td><xsl:call-template name="edit"><xsl:with-param name="type" select="'password'"/><xsl:with-param name="value" select="''"/><xsl:with-param name="name" select="'Student_PasswordRe'"/><xsl:with-param name="readonly" select="0"/></xsl:call-template></td>
        </tr>
      </xsl:if>
    </table>
    
    <xsl:apply-templates select="/Data/StudentDocList"/>
  </xsl:template>
  
  <xsl:template match="Messages">
    <div class="clc"><xsl:comment> </xsl:comment></div>
    <div class="adminerror">
      <xsl:copy-of select="."/>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>

  <xsl:template match="Informations|Errors|Exceptions">
    <div class="clc"><xsl:comment> </xsl:comment></div>
    <xsl:for-each select="./*">
      <xsl:apply-templates select="." />
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template match="Information">
    <div class="clc"><xsl:comment> </xsl:comment></div>
    <div class="admininformation">
      <xsl:copy-of select="."/>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>  
  
  <xsl:template match="Exception">
    <div class="clc"><xsl:comment> </xsl:comment></div>
    <div class="adminexception">
      <xsl:copy-of select="."/>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>  
  
  <xsl:template match="Error">
    <div class="clc"><xsl:comment> </xsl:comment></div>
    <div class="adminerror">
      <xsl:copy-of select="."/>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>  

  <xsl:template name="row_click">
    <xsl:param name="area" select="''"/>
    <xsl:param name="params" select="''"/>
    <xsl:attribute name="onclick">_goto("<xsl:call-template name="admin_url"><xsl:with-param name="area" select="$area"/><xsl:with-param name="params" select="$params"/></xsl:call-template>");</xsl:attribute>
  </xsl:template>
  
  <xsl:template match="ClassList">
    <div class="table_header_name"><h2>Lista klas</h2></div>
    <div id="tableDiv" class="tableDiv">
      <table class="FixedTables" id="ClassListPanel" cellspacing="0" cellpadding="0">
        <thead>
          <tr>
            <th>Id</th>
            <th>Nazwa</th>
            <th><xsl:comment> </xsl:comment></th>
          </tr>
        </thead>
        <tbody>
          <xsl:variable name="areaname">classeditnote</xsl:variable>
          <xsl:for-each select="./Class">
            <tr>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="$areaname"/><xsl:with-param name="params">classid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@ID"/>
              </td>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="$areaname"/><xsl:with-param name="params">classid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@Name"/>
              </td>
              <td><button type="button" onclick="_certyfikatClass({@ID});return false;">Generuj certyfikaty</button></td>
            </tr>
          </xsl:for-each>
        </tbody>          
      </table>
    </div>
  </xsl:template>
  
  <xsl:template match="StudentDocList">
    <xsl:if test="count(//StudentDoc)>0">
      <table class="userdetailstable">
        <tr>
          <td colspan="2"><xsl:call-template name="header"><xsl:with-param name="value" select="'Certyfikaty'"/></xsl:call-template></td>
        </tr>
        <xsl:for-each select="//StudentDoc">
          <tr>
            <td class="collbl"><xsl:call-template name="label"><xsl:with-param name="value" select="'Nazwa'"/></xsl:call-template></td>
            <td class="coledt"><xsl:call-template name="edit"><xsl:with-param name="value" select="@Name"/><xsl:with-param name="name" select="'Cert_Name'"/><xsl:with-param name="readonly" select="1"/></xsl:call-template><img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/certyfikat.png" onclick="_goto('{@Path}');" alt="{@Name}" title="{@Name}" border="0" padding="0" margin="0" style="float:right;margin-right:20px;"/></td>
          </tr>
        </xsl:for-each>
      </table>
    </xsl:if>
  </xsl:template>
    
</xsl:stylesheet>