<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:template name="tabcontrol">
    <xsl:param name="tabList" select="''" />
    <xsl:param name="showicon" select="0" />
    <xsl:param name="box" select="0" />

    <xsl:if test="$box=1">
      <!-- the tabs -->
      <ul class="tabs">
        <li class="tabspacer">
          <div class="tabspacer">
            <xsl:if test="$showicon=1">
              <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/1boxlogo.png" style="border:0;float:left;margin-right:5px;margin-top:8px;" />
            </xsl:if>
            <xsl:comment>&amp;nbsp;</xsl:comment>
          </div>
        </li>
        <xsl:for-each select="msxsl:node-set($tabList)/tab">
          <li>
            <a class="tbox w0" href="#">
              <xsl:value-of select="@title"/>
            </a>
          </li>
        </xsl:for-each>
      </ul>

      <!-- tab "panes" -->
      <div class="panes">
        <xsl:for-each select="msxsl:node-set($tabList)/tab">
          <div class="tab">
            <div class="tab-top_box">
              <xsl:comment>&amp;nbsp;</xsl:comment>
            </div>
            <div class="tab-middle_box">
              <xsl:copy-of select="."/>
            </div>
            <div class="tab-bottom_box">
              <xsl:comment>&amp;nbsp;</xsl:comment>
            </div>
          </div>
        </xsl:for-each>
      </div>
    </xsl:if>
    <xsl:if test="$box=0">
      <!-- the tabs -->
      <ul class="tabs">
        <li class="tabspacer">
          <div class="tabspacer">
            <xsl:if test="$showicon=1">
              <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/1boxlogo.png" style="border:0;float:left;margin-right:5px;margin-top:8px;" />
            </xsl:if>
            <xsl:comment>&amp;nbsp;</xsl:comment>
          </div>
        </li>
        <xsl:for-each select="msxsl:node-set($tabList)/tab">
          <li>
            <a class="w1" href="#">
              <xsl:value-of select="@title"/>
            </a>
          </li>
        </xsl:for-each>
      </ul>

      <!-- tab "panes" -->
      <div class="panes">
        <xsl:for-each select="msxsl:node-set($tabList)/tab">
          <div class="tab">
            <div class="tab-top">
              <xsl:comment>&amp;nbsp;</xsl:comment>
            </div>
            <div class="tab-middle">
              <xsl:copy-of select="."/>
            </div>
            <div class="tab-bottom">
              <xsl:comment>&amp;nbsp;</xsl:comment>
            </div>
          </div>
        </xsl:for-each>
      </div>
    </xsl:if>

  </xsl:template>

  <xsl:template name="url">
    <xsl:param name="uri" select="/Data/Config/URL" />
    <xsl:param name="params" select="''" />

    <xsl:choose>
      <xsl:when test="string-length($params)>0">
        <xsl:choose>
          <xsl:when test="contains($uri,'?')">
            <xsl:value-of select="$uri"/>&amp;<xsl:value-of select="$params"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$uri"/>?<xsl:value-of select="$params"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$uri"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="headerInstructor">
    <!--table class="adm_table_edit" cellpadding="0" cellspacing="0">
      <tbody>
        <tr style="height: 35px;">
          <td rowspan="2" style="width:85px">graficzka</td>
          <td style="width:95px">Szkoła</td>
          <td><xsl:value-of select="/Data/School/@Name"/></td>
        </tr>
        <tr style="height: 35px;">
          <td class="right">Instruktor</td>
          <td>
            <xsl:value-of select="concat(/Data/Instructor/@Title, ' ', /Data/Instructor/@Forename, ' ', /Data/Instructor/@Surename)"/></td>
        </tr>
      </tbody>
    </table-->
  </xsl:template>

  <xsl:template name="pageTitle">
    <xsl:param name="title" select="''"/>

    <xsl:if test="$title != ''">
      <div style="text-align: center;">
        <h2 class="pageTitle">
          <xsl:value-of select="$title"/>
        </h2>
      </div>
      <hr style="margin: 0px 5px; padding: 0px; border-top: 1px solid #44787C;"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="ELearningStats">
    <table class="adm_table_list" cellpadding="0" cellspacing="0">
      <thead>
        <tr>
          <th class="right">Rodzaj kursu</th>
          <th class="right">Nazwa kursu</th>
          <th class="right">Liczba punktów</th>
          <th colspan="2" class="right">Ocena</th>
          <xsl:if test="/Data/IsInstructorView = 1">
            <th>
              <xsl:text> </xsl:text>
            </th>
          </xsl:if>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
          <xsl:if test="@IsAdvancedLevelTest = 1">
            <tr>
              <td class="right">Test umiejętności</td>
              <td class="right">
                <xsl:value-of select="@Course"/>
              </td>
              <td class="right tac">
                <xsl:if test ="@CousreTypeID!=4">
                  <xsl:if test="string-length(@MaxPoints) > 0">
                    <xsl:value-of select="@Points"/> na <xsl:value-of select="@MaxPoints"/>
                  </xsl:if>
                </xsl:if>
                <xsl:comment></xsl:comment>
              </td>
              <td class="right tac">
                <xsl:value-of select="@Evaluation"/>
                <xsl:comment></xsl:comment>
              </td>
              <td>
                <xsl:if test ="@CousreTypeID!=4">
                  <xsl:if test="string-length(@MaxPoints) > 0">
                    <xsl:call-template name="EvaluationBox">
                      <xsl:with-param name="maxPoints" select="@MaxPoints"/>
                      <xsl:with-param name="points" select="@Points"/>
                      <xsl:with-param name="percentPoints" select="@PointsPercent"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:if>
                <xsl:comment></xsl:comment>
              </td>
              <xsl:if test="/Data/IsInstructorView = 1">
                <td>
                  <xsl:if test="@IsStarted = 1">
                    <a href="#" class="button" onclick="adm_StudentClearStatsForCourse($('#mnu_StudentList'),{@ID},{/Data/Student/@ID});">
                      <span>Zeruj</span>
                    </a>
                  </xsl:if>
                  <xsl:text> </xsl:text>
                </td>
              </xsl:if>
            </tr>
          </xsl:if>
        </xsl:for-each>

        <tr class="nohover">
          <td colspan="5" style="height:20px;">
            <div style="height:20px;">
              <xsl:comment></xsl:comment>
            </div>
          </td>
        </tr>

        <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
          <xsl:if test="@IsStartKnowledgeTest = 1">
            <tr>
              <td class="right">Początkowy test wiedzy</td>
              <td class="right">
                <xsl:value-of select="@Course"/>
              </td>
              <td class="right tac">
                <xsl:if test="@IsComplete = 1">
                  <xsl:if test ="@CousreTypeID!=4">
                    <xsl:if test="string-length(@MaxPoints) > 0">
                      <xsl:value-of select="@Points"/> na <xsl:value-of select="@MaxPoints"/>
                    </xsl:if>
                  </xsl:if>
                </xsl:if>
                <xsl:comment></xsl:comment>
              </td>
              <td class="right tac">
                <xsl:value-of select="@Evaluation"/>
                <xsl:comment></xsl:comment>
              </td>
              <td>
                                <xsl:if test="@IsComplete = 1">
                <xsl:if test ="@CousreTypeID!=4">
                  <xsl:if test="(string-length(@MaxPoints) > 0)">
                    <xsl:call-template name="EvaluationBox">
                      <xsl:with-param name="maxPoints" select="@MaxPoints"/>
                      <xsl:with-param name="points" select="@Points"/>
                      <xsl:with-param name="percentPoints" select="@PointsPercent"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:if>
                </xsl:if>                                  
                <xsl:comment></xsl:comment>
              </td>
              <xsl:if test="/Data/IsInstructorView = 1">
                <td>
                  <xsl:if test="@IsStarted = 1">
                    <a href="#" class="button" onclick="adm_StudentClearStatsForCourse($('#mnu_StudentList'),{@ID},{/Data/Student/@ID});">
                      <span>Zeruj</span>
                    </a>
                  </xsl:if>
                  <xsl:text> </xsl:text>
                </td>
              </xsl:if>
            </tr>
          </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
          <xsl:if test="@IsEndKnowledgeTest = 1">
            <tr>
              <td class="right">Końcowy test wiedzy</td>
              <td class="right">
                <xsl:value-of select="@Course"/>
              </td>
              <td class="right tac">
                <xsl:if test="@IsComplete = 1">
                  <xsl:if test ="@CousreTypeID!=4">
                    <xsl:if test="string-length(@MaxPoints) > 0">
                      <xsl:value-of select="@Points"/> na <xsl:value-of select="@MaxPoints"/>
                    </xsl:if>
                  </xsl:if>
                </xsl:if>
                <xsl:comment></xsl:comment>
              </td>
              <td class="right tac">
                <xsl:value-of select="@Evaluation"/>
                <xsl:comment></xsl:comment>
              </td>
              <td>
                                <xsl:if test="@IsComplete = 1">
                <xsl:if test ="@CousreTypeID!=4">
                  <xsl:if test="string-length(@MaxPoints) > 0">
                    <xsl:call-template name="EvaluationBox">
                      <xsl:with-param name="maxPoints" select="@MaxPoints"/>
                      <xsl:with-param name="points" select="@Points"/>
                      <xsl:with-param name="percentPoints" select="@PointsPercent"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:if>
                </xsl:if>                                  
                <xsl:comment></xsl:comment>
              </td>
              <xsl:if test="/Data/IsInstructorView = 1">
                <td>
                  <xsl:if test="@IsStarted = 1">
                    <a href="#" class="button" onclick="adm_StudentClearStatsForCourse($('#mnu_StudentList'),{@ID},{/Data/Student/@ID});">
                      <span>Zeruj</span>
                    </a>
                  </xsl:if>
                  <xsl:text> </xsl:text>
                </td>
              </xsl:if>
            </tr>
          </xsl:if>
        </xsl:for-each>

        <xsl:for-each select="/Data/CompetenceList/Competence">
          <tr class="nohover">
            <td colspan="5" style="height:20px;">
              <div style="height:20px;">
                <xsl:comment></xsl:comment>
              </div>
            </td>
          </tr>
          <xsl:variable name="_competenceID" select="@ID"/>
          <xsl:variable name="_competenceName" select="@Name"/>
          <tr class="nohover">
            <td colspan="5">
              <h2>
                <xsl:value-of select="@Name"/>
              </h2>
            </td>
          </tr>
          <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
            <xsl:if test="@IsCompetenceCourse = 1 and @CompetenceID=$_competenceID">
              <tr>
                <td colspan="2" class="right">
                  <xsl:value-of select="@Course"/>
                </td>
                <td class="right tac">
                  <xsl:if test ="@CousreTypeID!=4">
                    <xsl:if test="string-length(@MaxPoints) > 0">
                      <xsl:value-of select="@Points"/> na <xsl:value-of select="@MaxPoints"/>
                    </xsl:if>
                  </xsl:if>
                  <xsl:comment></xsl:comment>
                </td>
                <td class="right tac">
                  <xsl:value-of select="@Evaluation"/>
                  <xsl:comment></xsl:comment>
                </td>
                <td>
                  <xsl:if test ="@CousreTypeID!=4">
                    <xsl:if test="string-length(@MaxPoints) > 0">
                      <xsl:call-template name="EvaluationBox">
                        <xsl:with-param name="maxPoints" select="@MaxPoints"/>
                        <xsl:with-param name="points" select="@Points"/>
                        <xsl:with-param name="percentPoints" select="@PointsPercent"/>
                      </xsl:call-template>
                    </xsl:if>
                  </xsl:if>
                  <xsl:comment></xsl:comment>
                </td>
                <xsl:if test="/Data/IsInstructorView = 1">
                  <td>
                    <xsl:if test="@IsStarted = 1">
                      <a href="#" class="button" onclick="adm_StudentClearStatsForCourse($('#mnu_StudentList'),{@ID},{/Data/Student/@ID});">
                        <span>Zeruj</span>
                      </a>
                    </xsl:if>
                    <xsl:text> </xsl:text>
                  </td>
                </xsl:if>
              </tr>
            </xsl:if>
          </xsl:for-each>
        </xsl:for-each>

        <tr class="nohover">
          <td colspan="5">
            <div style="height:20px;">
              <xsl:comment></xsl:comment>
            </div>
          </td>
        </tr>
        <xsl:if test="string-length(/Data/Student/@ExpectedEvaluationValue)>0">
          <tr class="nohover">
            <td class="right">
              <h2>Oczekiwana ocena:</h2>
            </td>
            <td class="right tac" colspan="4" style="color:#000;text-align:left;">
              <h2 style="color:#000;text-align:left;">
                <xsl:choose>
                  <xsl:when test="string-length(/Data/Student/@ExpectedEvaluationValue)>0">
                    <xsl:value-of select="/Data/Student/@ExpectedEvaluationValue"/>
                  </xsl:when>
                  <xsl:otherwise>
                    nie wybrano
                  </xsl:otherwise>
                </xsl:choose>
              </h2>
              <xsl:comment></xsl:comment>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="string-length(/Data/Student/@AverageEvaluation)>0">
          <tr class="nohover">
            <td class="right">
              <h2>Średnia ocena:</h2>
            </td>
            <td class="right tac" colspan="4" style="color:#000;text-align:left;">
              <h2 style="color:#000;text-align:left;">
                <xsl:value-of select="/Data/Student/@AverageEvaluation"/>
              </h2>
              <xsl:comment></xsl:comment>
            </td>
          </tr>
        </xsl:if>
      </tbody>
    </table>
    <table class="evaluation_legend">
      <thead>
        <tr>
          <th colspan="2">Ocena wykonania zadania</th>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="/Data/EvaluationSheet_ClassList/EvaluationSheet_Class">
          <tr>
            <td>
              <xsl:call-template name="EvaluationBox">
                <xsl:with-param name="maxPoints" select="100"/>
                <xsl:with-param name="points" select="@From"/>
                <xsl:with-param name="width" select="20"/>
                <xsl:with-param name="height" select="20"/>
                <xsl:with-param name="constWidth" select="1"/>
                <xsl:with-param name="showText" select="0"/>
                <xsl:with-param name="percentPoints" select="@From"/>
              </xsl:call-template>
            </td>

            <xsl:variable name="FromNormalized">
              <xsl:choose>
                <xsl:when test="@From>0">
                  <xsl:value-of select="@From"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>


            <td>
              <xsl:value-of select="$FromNormalized"/> - <xsl:value-of select="@To"/>%
            </td>
            <td>
              <xsl:value-of select="@Value"/>
            </td>
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name="EvaluationBox">
    <xsl:param name="maxPoints" select="0"/>
    <xsl:param name="points" select="0"/>
    <xsl:param name="percentPoints" select="0"/>
    <xsl:param name="width" select="200"/>
    <xsl:param name="height" select="20"/>
    <xsl:param name="constWidth" select="0"/>
    <xsl:param name="showText" select="1"/>

    <xsl:variable name="maxPointsNormalized">
      <xsl:choose>
        <xsl:when test="$points>$maxPoints">
          <xsl:value-of select="$points"/>
        </xsl:when>
        <xsl:when test="$maxPoints=0">1</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$maxPoints"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="evaluationWidth">
      <xsl:if test="$constWidth=0">
        <xsl:value-of select="round(($percentPoints * $width) div 100)"/>
      </xsl:if>
      <xsl:if test="$constWidth=1">
        <xsl:value-of select="$width"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="colorClass">
      UnitSquer<xsl:for-each select ="/Data/EvaluationSheet_ClassList/EvaluationSheet_Class">
        <xsl:if test="$percentPoints >= @From and @To >= $percentPoints">
          <xsl:value-of select="position()"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>

    <div style="width:{$width}px;height:{$height}px;" class="EvaluationBox EvaluationBoxText">
      <xsl:if test="$showText=1">
        <xsl:if test="30 >= $percentPoints">
          <xsl:value-of select="$percentPoints"/>%
        </xsl:if>
      </xsl:if>
      <div style="width:{$evaluationWidth}px;height:{$height}px;float:left;" class="{$colorClass} EvaluationBoxText">
        <xsl:if test="$showText=1">
          <xsl:if test="$percentPoints > 30">
            <xsl:value-of select="$percentPoints"/>%
          </xsl:if>
        </xsl:if>
        <xsl:comment> </xsl:comment>
      </div>
    </div>
  </xsl:template>

  <xsl:template name="EvaluationText">
    <xsl:param name="maxPoints" select="200"/>
    <xsl:param name="points" select="154"/>
    <xsl:variable name="maxPointsNormalized">
      <xsl:choose>
        <xsl:when test="$points>$maxPoints">
          <xsl:value-of select="$points"/>
        </xsl:when>
        <xsl:when test="$maxPoints=0">1</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$maxPoints"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="percentPoints" select="round(($points div $maxPointsNormalized)*100)" />
    <xsl:for-each select="/Data/EvaluationSheet_ClassList/EvaluationSheet_Class">
      <xsl:if test="$percentPoints >= @From and @To >= $percentPoints">
        <xsl:value-of select="@Value"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="getClassResultPanel">
    <div style="width:800px;overflow:auto;">
      <table class="adm_table_zestawienie" cellpadding="0" cellspacing="0">
        <thead>
          <!--
        <tr>
          <th class="left" rowspan="2">Uczeń</th>
          <th class="center" colspan="{count(/Data/CompetenceList/Competence)+count(/Data/TeachingPlanList/TeachingPlan)}">Kompetencje</th>
        </tr>
        -->
          <tr>
            <th class="small">
              <xsl:text> </xsl:text>
            </th>
            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsStartKnowledgeTest = 1">
                <th class="small" style="background:#fff;vertical-align:middle;">Początkowy test wiedzy</th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsEndKnowledgeTest = 1">
                <th class="small" style="background:#fff;vertical-align:middle;">Końcowy test wiedzy</th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsAdvancedLevelTest = 1">
                <th class="small" style="background:#fff;vertical-align:middle;">Test umiejętności</th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/CompetenceList/Competence">
              <th class="small" style="background:#fff;vertical-align:middle;">
                <xsl:value-of select="@Name"/>
                <br/>
                <b>
                  <xsl:value-of select="@CourseTitle"/>
                </b>
              </th>
            </xsl:for-each>
          </tr>
          <tr>
            <th>
              <img  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/transparent.gif" style="width:170px;height:1px;"/>
            </th>

            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsStartKnowledgeTest = 1">
                <th>
                  <img  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/transparent.gif" style="width:200px;height:1px;"/>
                </th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsEndKnowledgeTest = 1">
                <th>
                  <img  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/transparent.gif" style="width:200px;height:1px;"/>
                </th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
              <xsl:if test="@IsAdvancedLevelTest = 1">
                <th>
                  <img  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/transparent.gif" style="width:200px;height:1px;"/>
                </th>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="/Data/CompetenceList/Competence">
              <th>
                <img  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/transparent.gif" style="width:200px;height:1px;"/>
              </th>
            </xsl:for-each>
          </tr>
        </thead>

        <tbody>
          <xsl:for-each select="/Data/StudentList/Student">
            <tr>
              <td style="background:#fff;height:30px;vertical-align:middle;">
                <xsl:value-of select="@Forename"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="@Surename"/>
              </td>
              <xsl:variable name="studentID" select="@ID"/>

              <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
                <xsl:if test="@IsStartKnowledgeTest = 1">
                  <td class="right tac">
                    <xsl:variable name="teachingPlanID" select="@ID"/>
                    <xsl:for-each select="/Data/ResultList/Result">
                      <xsl:if test="$teachingPlanID = @TeachingPlanID and @StudentID = $studentID">
                        <xsl:call-template name="evaluation" />
                      </xsl:if>
                    </xsl:for-each>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
                <xsl:if test="@IsEndKnowledgeTest = 1">
                  <td class="right tac">
                    <xsl:variable name="teachingPlanID" select="@ID"/>
                    <xsl:for-each select="/Data/ResultList/Result">
                      <xsl:if test="$teachingPlanID = @TeachingPlanID and @StudentID = $studentID">
                        <xsl:call-template name="evaluation" />
                      </xsl:if>
                    </xsl:for-each>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <xsl:for-each select="/Data/TeachingPlanList/TeachingPlan">
                <xsl:if test="@IsAdvancedLevelTest = 1">
                  <td class="right tac">
                    <xsl:variable name="teachingPlanID" select="@ID"/>
                    <xsl:for-each select="/Data/ResultList/Result">
                      <xsl:if test="$teachingPlanID = @TeachingPlanID and @StudentID = $studentID">
                        <xsl:call-template name="evaluationNoPoints" />
                      </xsl:if>
                    </xsl:for-each>
                  </td>
                </xsl:if>
              </xsl:for-each>

              <xsl:for-each select="/Data/CompetenceList/Competence">
                <td class="right tac">
                  <xsl:variable name="isCase" select="@IsCase"/>
                  <xsl:variable name="competenceID" select="@CompetenceID"/>
                  <xsl:variable name="teachingPlanID" select="@TeachingPlanID"/>
                  <xsl:for-each select="/Data/ResultList/Result">
                    <xsl:if test="@CompetenceID = $competenceID and $teachingPlanID = @TeachingPlanID and @StudentID = $studentID">
                      <xsl:if test="$isCase = 1">
                        <xsl:call-template name="evaluationNoPoints" />
                      </xsl:if>
                      <xsl:if test="$isCase = 0">
                        <xsl:call-template name="evaluation" />
                      </xsl:if>
                    </xsl:if>
                  </xsl:for-each>
                  <xsl:comment></xsl:comment>
                </td>
              </xsl:for-each>
            </tr>
          </xsl:for-each>
        </tbody>
      </table>
    </div>
    <xsl:if test="string-length(/Data/Student/@ID)=0">
      <table class="adm_table_edit" cellpadding="0" cellspacing="0">
        <tfoot>
          <tr>
            <td>
              <div class="bottomButtons">
                <a href="#" class="button" onclick="adm_StudentList($('#mnu_ClassAdd'),{/Data/Class/@ID});">
                  <span>Pracownicy</span>
                </a>
                <a href="#" class="button" onclick="adm_ClassStatsPanel($('#mnu_ClassAdd'),{/Data/Class/@ID});">
                  <span>Statystyka</span>
                </a>
                <a href="#" class="button" onclick="adm_ClassEditPanelA($('#mnu_ClassAdd'),{/Data/Class/@ID});">
                  <span>Edycja oceny</span>
                </a>
                <a href="#" class="button" onclick="adm_ClassEditPanelB($('#mnu_ClassAdd'),{/Data/Class/@ID});">
                  <span>Edycja planu nauczania</span>
                </a>
              </div>
            </td>
          </tr>
        </tfoot>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template name="evaluation">
    <xsl:if test="string-length(@Evaluation) > 0">
      <xsl:variable name="pointsPercent">
        <xsl:value-of select="@PointsPercent"/>
      </xsl:variable>
      <xsl:variable name="colorClass">
        UnitSquer<xsl:for-each select ="/Data/EvaluationSheet_ClassList/EvaluationSheet_Class">
          <xsl:if test="$pointsPercent >= @From and @To >= $pointsPercent">
            <xsl:value-of select="position()"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>

      <table style="border:0px;width:100px;" class="{$colorClass}">
        <tr>
          <td style="color:#111;border:0px;">
            <xsl:value-of select="@Evaluation"/>
          </td>
        </tr>
        <tr>
          <td style="border:0px;">
            <b>
              <xsl:value-of select="@PointsPercent"/>
            </b>%
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template name="evaluationNoPoints">
    <xsl:if test="string-length(@Evaluation) > 0">
      <table style="border:0px;width:100px;background-color:#fff;">
        <tr>
          <td style="color:#111;border:0px;">
            <xsl:value-of select="@Evaluation"/>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>




  <!--just for debug purpose-->
  <xsl:template match="*[text() and not(*)]">
    <xsl:apply-templates select="@*"/>
    <tr>
      <th>
        <xsl:value-of select="name()"/>
      </th>
      <td>
        <xsl:apply-templates/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="*[(* or @*) and not(text())]">
    <tr>
      <td colspan="2">
        <fieldset>
          <legend>
            <xsl:value-of select="name()"/>
          </legend>
          <table width="100%">
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates/>
          </table>
        </fieldset>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="@*">
    <tr>
      <th>
        <em>
          <xsl:value-of select="name()"/>
        </em>
      </th>
      <td>
        <xsl:value-of select="."/>
      </td>
    </tr>
  </xsl:template>


</xsl:stylesheet>