<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="./XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
      </ScriptTopList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>
      
      <xsl:if test="/Data/Config/@IUA=1">
        <ScriptInlineBottom>
          jQuery(document).ready(function () {
            initMenu(0);
          });
          function _goto(url) {
            document.location=url;
          }
          function _certyfikatClass(id) {
            if (!confirm("Czy wygenerować certyfikaty dla uczniów w klasie?")) {
              return;
            }
            $("#classid").val(id);
            $("#editmode").val(3);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _certyfikatStudent(id) {
            if (!confirm("Czy wygenerować certyfikat dla ucznia?")) {
              return;
            }
            $("#studentid").val(id);
            $("#editmode").val(3);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _saveClass(id) {
            $("#classid").val(id);
            $("#editmode").val(1);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _removeClass(id){
            if (!confirm('Czy usunąć dane klasy?')){
              return false;
            }
            $("#editmode").val(2);
            $("#classid").val(id);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _saveStudent(id) {
            $("#studentid").val(id);
            $("#editmode").val(1);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _resetSCP(studentid, competencepartid) {
            if (!confirm("Czy wyzerować statystykę dla wybranej kompetencji składowej dla ucznia?")) {
              return;
            }
            $("#studentid").val(studentid);
            $("#competencepartid").val(competencepartid);
            $("#editmode").val(1);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          function _removeStudent(id){
            if (!confirm('Czy usunąć dane ucznia?')){
              return false;
            }
            $("#editmode").val(2);
            $("#studentid").val(id);
            $("#area").val('<xsl:value-of select="/Data/Config/@AdministrationAreaValue"/>');
            document.forms[0].submit();
            return false;
          }
          setSliders("oceny", 0, 100);
          
          $(document).ready(function() {
            $(".tableDiv").each(function() {
                var Id = $(this).get(0).id;
                var maintbheight = 450;
                var maintbwidth = 560;

                $("#" + Id + " .FixedTables").fixedTable({
                    width: maintbwidth,
                    height: maintbheight,
                    fixedColumns: 1,
                    classHeader: "fixedHead",
                    classFooter: "fixedFoot",
                    classColumn: "fixedColumn",
                    fixedColumnWidth: 50,
                    outerId: Id,
                    Contentbackcolor: "#FFFFFF",
                    Contenthovercolor: "#99CCFF", 
                    fixedColumnbackcolor:"#2E4F25", 
                    fixedColumnhovercolor:"#99CCFF"  
                });
            });
            
            fixBorderContainerHeight();
        });
        </ScriptInlineBottom>
      </xsl:if>
      
      <HTMLInline name="{/Data/Config/Name}">
        <input type="hidden" id="editmode" name="editmode" value="0"/>
        <input type="hidden" id="area" name="area" value="''"/>
        <input type="hidden" id="studentid" name="studentid" value="{/Data/Student/@ID}"/>
        <input type="hidden" id="classid" name="classid" value="{/Data/Class/@ID}"/>
        <table width="100%">
          <tr>
            <td>              
      <xsl:call-template name="box">
        <xsl:with-param name="content">       
              <xsl:choose>
                <xsl:when test="/Data/Config/@IUA=1">            
                  <xsl:choose>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='NotLoaded'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='None'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='ClassList'">
                      <xsl:call-template name="ClassListPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='ClassEdit'">
                      <xsl:call-template name="ClassEditPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='ClassEditNote'">
                      <xsl:call-template name="ClassEditNotePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='ClassEditStudent'">
                      <xsl:call-template name="ClassEditStudentPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='ClassEditCompetences'">
                      <xsl:call-template name="ClassEditCompetencesPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='StudentList'">
                      <xsl:call-template name="UserListPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='StudentEdit'">
                      <xsl:call-template name="UserEditPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='StudentEditCompetences'">
                      <xsl:call-template name="UserEditCompetencePanel" />
                    </xsl:when>                    
                    <xsl:when test="/Data/Config/@AdministrationAreaValue='eduFarma'">
                      <xsl:call-template name="eduFarmaPanel" />
                    </xsl:when>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="invaliduser" />
                </xsl:otherwise>
              </xsl:choose>
              <xsl:comment> </xsl:comment>
        </xsl:with-param>
      </xsl:call-template>
            </td>
          </tr>
        </table>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
  
  <xsl:template name="ClassListPanel">
    <xsl:apply-templates select="/Data/ClassList"/>
    <xsl:call-template name="ClassListPanelMenu" />
  </xsl:template>

  <xsl:template name="ClassEditPanel">
    <xsl:param name="withmenu" select="1"/>
    <xsl:apply-templates select="/Data/Class">
      <xsl:with-param name="readonly" select="0"/>
    </xsl:apply-templates>
    <xsl:if test="$withmenu=1">
      <xsl:call-template name="ClassEditPanelMenu" />
    </xsl:if>
  </xsl:template>

  <xsl:template name="ClassEditNotePanel">
    <xsl:call-template name="ClassEditPanel">
      <xsl:with-param name="withmenu" select="0"/>
    </xsl:call-template>
    <xsl:if test="count(/Data/EvaluationSheet_ClassList/EvaluationSheet_Class)>0">
      <table class="admin_list_table" cellpadding="0" cellspacing="0">
        <thead>
          <tr>
            <th colspan="2" class="table_header_name"><h2>Edycja oceny</h2></th>
          </tr>
          <tr>
            <th class="header_col">Ocena</th>
            <th class="header_col">Wartość od</th>
            <th class="header_col">&#160;</th>
            <th class="header_col">Wartość do</th>
          </tr>
        </thead>
        <tbody>
          <xsl:for-each select="/Data/EvaluationSheet_ClassList/EvaluationSheet_Class">
            <tr class="row">
              <xsl:if test="(position() mod 2) = 0">
                <xsl:attribute name="class">row row_odd</xsl:attribute>
              </xsl:if>
              <td class="col col_border_bottom col_border_right" style="padding: 0px 20px"><xsl:value-of select="@Value"/></td>
              <td class="col col_border_bottom col_border_right" style="text-align: center;"><input type="text" class="req es_class adminPanel" name="txt_from_ES_Class_{@ID}" id="txt_from_ES_Class_{@ID}" value="{@From}" readonly="true"/></td>
              <td style="width:330px; padding: 0px 15px" class="col col_id col_border_bottom col_border_right">
                <div id="slider_ES_Class_{@ID}" rel="oceny"></div>
              </td>
              <td class="col col_border_bottom" style="text-align: center;"><input type="text" class="req es_class adminPanel" name="txt_to_ES_Class_{@ID}" id="txt_to_ES_Class_{@ID}" value="{@To}" readonly="true"/></td>
            </tr>
          </xsl:for-each>
        </tbody>
      </table>
    </xsl:if>
    <xsl:call-template name="ClassEditPanelMenu" />
  </xsl:template>
  
  <xsl:template name="ClassEditStudentPanel">
    <xsl:call-template name="ClassEditPanel">
      <xsl:with-param name="withmenu" select="0"/>
    </xsl:call-template>
    <xsl:call-template name="UserListPanel">
      <xsl:with-param name="withmenu" select="0"/>
    </xsl:call-template>
    <xsl:call-template name="ClassEditPanelMenu" />
  </xsl:template>
  
  <xsl:key name="k1" match="CompetencePart_Class" use="@CompetenceName"/>
  
  <xsl:variable name="competenceparts">
    <xsl:for-each select="//CompetencePart_Class">
      <competence ID="{@ID}" CompetencePointsByWeight="{@CompetencePointsByWeight}" Salary="{@Salary}" ResetCount="{@ResetCount}" IsStarted="{@IsStarted}" CompetencePartID="{@CompetencePartID}" competenceID="{@CompetenceID}" IsAvailable="{@IsAvailable}" CompetenceName="{@CompetenceName}"><xsl:value-of select="@CompetencePartName"/></competence>
    </xsl:for-each>
  </xsl:variable>
  
  <xsl:variable name="competences">
    <xsl:for-each select="//CompetencePart_Class[generate-id() = generate-id(key('k1', @CompetenceName)[1])]">
      <competence><xsl:value-of select="@CompetenceName"/></competence>
    </xsl:for-each>
  </xsl:variable>

  <xsl:template name="ClassEditCompetencesPanel">
    <xsl:call-template name="ClassEditPanel">
      <xsl:with-param name="withmenu" select="0"/>
    </xsl:call-template>    
    
    <table class="admin_list_table" cellspacing="0" cellpadding="0">
      <thead>
        <tr>
          <th colspan="2" class="table_header_name"><h2>Plan nauczania</h2></th>
        </tr>
      </thead>
      <xsl:for-each select="msxsl:node-set($competences)/competence">
        <thead>
          <tr>
            <th colspan="2" class="header_col"><xsl:value-of select="."/></th>          
          </tr>
        </thead>
        <tbody>
          <xsl:variable name="n" select="."/>
          <xsl:for-each select="msxsl:node-set($competenceparts)/competence[@CompetenceName=$n]"> 
            <tr class="row">
              <xsl:if test="(position() mod 2) = 0">
                <xsl:attribute name="class">row row_odd</xsl:attribute>
              </xsl:if>
              <td class="col col_id col_border_bottom col_border_right"><xsl:value-of select="."/><xsl:comment> </xsl:comment></td>
              <td class="col col_name col_border_bottom"><input value="true" type="checkbox" name="CompetencePart_Class_IsAvailable_{@ID}" id="CompetencePart_Class_IsAvailable_{@ID}"><xsl:if test="@IsAvailable=1"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if></input><xsl:comment> </xsl:comment></td>
            </tr>
          </xsl:for-each>
        </tbody>     
      </xsl:for-each>
    </table>
    
    <xsl:call-template name="ClassEditPanelMenu" />
  </xsl:template>

  <xsl:template name="UserListPanel">
    <xsl:param name="withmenu" select="1"/>
    <div class="table_header_name"><h2>Lista uczniów</h2></div>
    <div id="tableDiv" class="tableDiv">
      <table class="FixedTables" id="UserListPanel" cellspacing="0" cellpadding="0">
        <thead>
          <tr>
            <th>Id</th>
            <th>Nr. indeksu</th>
            <th>Imię</th>
            <th>Nazwisko</th>
            <th>Klasa</th>
            <th><xsl:comment> </xsl:comment></th>
          </tr>
        </thead>
        <tbody>
          <xsl:for-each select="/Data/StudentList/Student">
            <tr>
              <xsl:variable name="id" select="@ClassID"/>
              <td>              
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@ID"/>
              </td>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@IndexNr"/></td>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@Forename"/></td>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="@Surename"/></td>
              <td>
                <xsl:call-template name="row_click"><xsl:with-param name="area" select="'studentedit'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                <xsl:value-of select="//Class[@ID=$id]/@Name"/></td>
              <td><button type="button" onclick="_certyfikatStudent({@ID});return false;">Generuj certyfikat</button></td>
            </tr>
          </xsl:for-each>
        </tbody>          
      </table>
    </div>
    <xsl:if test="$withmenu=1">
      <xsl:call-template name="UserListPanelMenu" />
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="UserEditPanel">
    <xsl:apply-templates select="/Data/Class"/>
    <xsl:apply-templates select="/Data/Student">
      <xsl:with-param name="readonly" select="0"/>
      <xsl:with-param name="ispassword"><xsl:choose><xsl:when test="/Data/Student/@ID>0">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:with-param>
    </xsl:apply-templates>
    <xsl:call-template name="UserEditPanelMenu" />
  </xsl:template>

  <xsl:template name="UserEditCompetencePanel">
    <xsl:apply-templates select="/Data/Student">
      <xsl:with-param name="readonly" select="1"/>
      <xsl:with-param name="ispassword" select="0"/>
    </xsl:apply-templates>
    <input type="hidden" name="competencepartid" id="competencepartid" value=""/>
    <table class="admin_list_table" cellspacing="0" cellpadding="0">
      <thead>
        <tr>
          <th colspan="3" class="table_header_name"><h2>Plan nauczania</h2></th>
        </tr>
      </thead>
      <xsl:variable name="sid" select="/Data/Student/@ID" />
      <xsl:for-each select="msxsl:node-set($competences)/competence">
        <thead>
          <tr>
            <th colspan="3" class="header_col"><xsl:value-of select="."/></th>          
          </tr>
        </thead>
        <tbody>
          <xsl:variable name="n" select="."/>
          <xsl:for-each select="msxsl:node-set($competenceparts)/competence[@CompetenceName=$n]"> 
            <tr class="row">
              <xsl:if test="(position() mod 2) = 0">
                <xsl:attribute name="class">row row_odd</xsl:attribute>
              </xsl:if>
              <td class="col col_id col_border_bottom col_border_right"><xsl:value-of select="."/><xsl:comment> </xsl:comment></td>
              <td class="col col_name col_border_bottom col_border_right"><input value="true" disabled="disabled" type="checkbox" name="CompetencePart_Class_IsAvailable_{@ID}" id="CompetencePart_Class_IsAvailable_{@ID}"><xsl:if test="@IsAvailable=1"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if></input><xsl:comment> </xsl:comment></td>
              <td class="col col_id col_border_bottom">
                <xsl:if test="@IsStarted=1">
                  <button type="button" onclick="_resetSCP({$sid}, {@CompetencePartID});return false;">Resetuj</button>
                </xsl:if>
                <xsl:comment> </xsl:comment>
              </td>
            </tr>
          </xsl:for-each>
        </tbody>     
      </xsl:for-each>
    </table>    
    <xsl:call-template name="UserEditPanelMenu" />
  </xsl:template>
  
  <xsl:template name="NonePanel">    
    <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
    <div class="learningbox">
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=classlist</xsl:with-param>
        <xsl:with-param name="title" select="'Lista klas'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=studentlist</xsl:with-param>
        <xsl:with-param name="title" select="'Lista uczniów'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=edufarma</xsl:with-param>
        <xsl:with-param name="title" select="'Gra eduFakrma'" />
      </xsl:call-template>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>

  <xsl:template name="ClassListPanelMenu">
    <xsl:apply-templates select="/Data/Messages" />
    <div>
      <ul class="admmenulist">
        <li><xsl:copy-of select="$main_admin_link"/></li>
        <li><xsl:copy-of select="$class_add_admin_link"/></li>
      </ul>
      <div class="cls"><xsl:comment> </xsl:comment></div>
    </div>
  </xsl:template>

  <xsl:template name="ClassEditPanelMenu">
    <xsl:apply-templates select="/Data/Messages" />
    <div>
      <ul class="admmenulist">
        <li><xsl:copy-of select="$main_admin_link"/></li>
        <xsl:if test="/Data/Class/@ID>0">
          <li><xsl:copy-of select="$class_list_admin_link"/></li>
          <li><xsl:copy-of select="$class_edit_note_admin_link"/></li>
          <li><xsl:copy-of select="$class_edit_student_admin_link"/></li>
          <li><xsl:copy-of select="$class_edit_competences_admin_link"/></li>
        </xsl:if>
      </ul>
      <ul class="admactionmenu">
        <li><button type="button" onclick="_saveClass({/Data/Class/@ID});return false;">Zapisz</button></li>
        <xsl:if test="/Data/Class/@ID>0">
          <li><button type="button" onclick="_removeClass({/Data/Class/@ID});return false;">Usuń</button></li>
        </xsl:if>
      </ul>
      <div class="cls"><xsl:comment> </xsl:comment></div>
    </div>
  </xsl:template>

  <xsl:template name="UserListPanelMenu">
    <xsl:apply-templates select="/Data/Messages" />
    <div>
      <ul class="admmenulist">
        <li><xsl:copy-of select="$main_admin_link"/></li>
        <li><xsl:copy-of select="$student_add_admin_link"/></li>
      </ul>
      <div class="cls"><xsl:comment> </xsl:comment></div>
    </div>
  </xsl:template>

  <xsl:template name="UserEditPanelMenu">
    <xsl:apply-templates select="/Data/Messages" />
    <div>
      <ul class="admmenulist">
        <li><xsl:copy-of select="$main_admin_link"/></li>
        <xsl:if test="/Data/Student/@ID>0">
          <li><xsl:copy-of select="$student_list_admin_link"/></li>
          <li><xsl:copy-of select="$student_edit_class_admin_link"/></li>
          <li><xsl:copy-of select="$student_edit_competences_admin_link"/></li>
        </xsl:if>
      </ul>
      <ul class="admactionmenu">
        <li><button type="button" onclick="_saveStudent({/Data/Student/@ID});return false;">Zapisz</button></li>
        <xsl:if test="/Data/Student/@ID>0">
          <li><button type="button" onclick="_removeStudent({/Data/Student/@ID});return false;">Usuń</button></li>
        </xsl:if>
      </ul>
      <div class="cls"><xsl:comment> </xsl:comment></div>
    </div>
  </xsl:template>
   
  <xsl:template name="eduFarmaPanel">
    <div class="fcontainer">
      <div id="EduFarmDiv">
        <a href="http://www.adobe.com/go/getflashplayer">
				  <img src="http://www.adobe.com/images/shared/download_buttons/get_flash_player.gif" alt="Get Adobe Flash player" />
			  </a>
      </div>
      <div>
        <script type="text/javascript">
			    var flashvars = {};
			    var params = {};
			    flashvars.id = "<xsl:value-of select="/Data/Config/@UserID"/>";
			    flashvars.sid = "<xsl:value-of select="/Data/Config/@SessionUID"/>";
			    var attributes = {};
			    swfobject.embedSWF("<xsl:value-of select="/Data/Config/@eduFarmaAdminAddress"/>?nocache=<xsl:value-of select="/Data/Config/Ticks"/>", "EduFarmDiv", "800", "600", "10.0.0", false, flashvars, params, attributes);
		    </script>        
      </div>
    </div>  
  </xsl:template>
  
</xsl:stylesheet>