﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="../ResorcesCommon/ELearning_ChooseExercise.xsl"/>    
  <xsl:import href="./610/Breadcrumb.xsl"/>  
  <xsl:import href="./610/SummaryPage.xsl"/>  
  <xsl:import href="./610/NoAccessPage.xsl"/>
  <xsl:import href="./610/ErrorPage.xsl"/>  
  <xsl:import href="./610/FraudPage.xsl"/>
  <xsl:import href="./610/RedirectPage.xsl"/>   
  <xsl:import href="./610/NoExercisesPage.xsl"/>     
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  <xsl:template match="/">
    <ComponentXML>
      <content>
        <Result>
          <table style="width:100%;">
            <tr>
              <td>
                <xsl:if test="/Data/EXERCISE/@exerciseType > 0">
                  <xsl:call-template name="ZPSB_ELearning_Breadcrumb"/>
                </xsl:if>
              </td>
            </tr>

            <xsl:variable name="v_order">
              <xsl:call-template name="ELearning_Order"/>
            </xsl:variable>
            <xsl:if test="string-length($v_order)>0">
              <tr>
                <td>
                  <xsl:copy-of select="$v_order"/>
                </td>
              </tr>
            </xsl:if>

            <xsl:variable name="v_simle_section">
              <xsl:call-template name="ELearning_SimpleSections"/>
            </xsl:variable>
            <xsl:if test="string-length($v_simle_section)>0">
              <tr>
                <td>
                  <xsl:copy-of select="$v_simle_section"/>
                </td>
              </tr>
            </xsl:if>

            <xsl:variable name="notes_main">
              <xsl:call-template name="ELearning_Notes_Main"/>
            </xsl:variable>
            <xsl:if test="string-length($notes_main)>0">
              <tr>
                <td>
                  <xsl:copy-of select="$notes_main"/>
                </td>
              </tr>
            </xsl:if>

            <tr>
              <td>
                <div>
                  <xsl:if test="string-length(/Data/EXERCISE/@imageURL)>0"><xsl:attribute name="style">background-image:url('<xsl:value-of select="/Data/EXERCISE/@imageURL"/>');background-repeat:no-repeat;width:100%;height:<xsl:value-of select="/Data/EXERCISE/@imageHeight"/>px;</xsl:attribute></xsl:if>
                  <table  style="width:100%;">
                    <tr>
                      <td>
                        <xsl:choose>
                          <xsl:when test="/Data/EXERCISE/@exerciseType =1">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_ComboBox_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_ComboBox_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_ComboBox_Section"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =3">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_MovingBox_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_MovingBox_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_MovingBox_Section"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =2">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_OpenGap_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_OpenGap_Section"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_OpenGap_Section"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =4">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_ComboBox_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_ComboBox_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_ComboBox_Text"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =5">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_OpenGap_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_OpenGap_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_OpenGap_Text"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =6">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_MovingBox_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_MovingBox_Text"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_MovingBox_Text"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =7">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_OpenGap"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_OpenGap"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_OpenGap"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =8">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_MovingBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_MovingBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_MovingBox"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =9">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_ComboBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_ComboBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_ComboBox"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =10">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Text"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =11">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Text_MissingSection"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Text_MissingSection"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Text_MissingSection"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =12">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_ABCD"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_ABCD"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_ABCD"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =13">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_OpenGap"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_OpenGap"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_OpenGap"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =14">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_MovingBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_MovingBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_MovingBox"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =15">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Questions_ComboBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Questions_ComboBox"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Questions_ComboBox"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =17"/>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =18">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_MovingBox_Areas"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_MovingBox_Areas"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_MovingBox_Areas"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =19">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_Matching"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_Matching"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_Matching"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =20">
                            <xsl:choose>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                                <xsl:call-template name="ELearning_Exercise_Load_MovingBox_Points"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                                <xsl:call-template name="ELearning_Exercise_Check_MovingBox_Points"/>
                              </xsl:when>
                              <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                                <xsl:call-template name="ELearning_Exercise_Resolve_MovingBox_Points"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =-1">
                            <xsl:choose>
                              <xsl:when test="/Data/FunctionName = 'loadCourseMenu' or  /Data/FunctionName = 'loadExercise' or /Data/FunctionName = 'loadNextExercise' or /Data/FunctionName = 'loadPreviousExercise'">
                                <xsl:call-template name="ZPSB_ELearning_CourseMenu"/>
                              </xsl:when>
                            </xsl:choose>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =-2">
                            <xsl:call-template name="SummaryPage"/>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =-3">
                            <xsl:call-template name="NoAccessPage"/>
                          </xsl:when>

                          <xsl:when test="/Data/EXERCISE/@exerciseType =-4">
                            <xsl:call-template name="ErrorPage"/>
                          </xsl:when>                               

                          <xsl:when test="/Data/EXERCISE/@exerciseType =-5">
                            <xsl:call-template name="FraudPage"/>
                          </xsl:when>               
                          
                          <xsl:when test="/Data/EXERCISE/@exerciseType =-7">
                            <xsl:call-template name="RedirectPage"/>
                          </xsl:when>        
                          
                          <xsl:when test="/Data/EXERCISE/@exerciseType =-8">
                            <xsl:call-template name="NoExercisesPage"/>
                          </xsl:when>                              

                          <xsl:otherwise>
                            <xsl:call-template name="ErrorPage"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td rowspan="2" valign="top" >
                        <xsl:if test="string-length(/Data/EXERCISE/AVATAR/@width)>0 and string-length(/Data/EXERCISE/AVATAR/@imageURL)>0">
                          <xsl:attribute name="style">width:<xsl:value-of select="/Data/EXERCISE/AVATAR/@width"/>px;</xsl:attribute>                        
                          <xsl:if test="string-length(/Data/EXERCISE/AVATAR/@imageURL)>0">
                            <div class="avatarbox">
                              <xsl:if test="string-length(/Data/EXERCISE/AVATAR/@width)>0">
                                <xsl:attribute name="style">width:<xsl:value-of select="/Data/EXERCISE/AVATAR/@width"/>px;</xsl:attribute>
                              </xsl:if>
                              <xsl:if test="string-length(/Data/EXERCISE/AVATAR/.)>0">
                                <div class="N610_elementNormal">
                                  <xsl:call-template name="common_box">
                                    <xsl:with-param name="content">
                                      <div class="avatartext fontavatartext">
                                        <xsl:value-of select="/Data/EXERCISE/AVATAR/." disable-output-escaping="yes"  />
                                      </div>
                                    </xsl:with-param>
                                  </xsl:call-template>          
                                </div>
                              </xsl:if>
                              <div class="avatarimg">
                                <img src="{/Data/EXERCISE/AVATAR/@imageURL}" border="0" alt="" title="" />
                              </div>
                            </div>
                          </xsl:if>
                        </xsl:if>
                        <xsl:comment> </xsl:comment>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <xsl:variable name="notes_by_function">
                          <xsl:choose>
                            <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'loadExercise'">
                              <xsl:call-template name="ELearning_Notes_Load"/>
                            </xsl:when>
                            <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'checkExercise'">
                              <xsl:call-template name="ELearning_Notes_Check"/>
                            </xsl:when>
                            <xsl:when test="/Data/EXERCISE/@exerciseEvent = 'resolveExercise'">
                              <xsl:call-template name="ELearning_Notes_Resolve"/>
                            </xsl:when>
                          </xsl:choose>
                        </xsl:variable>
                        <xsl:if test="string-length($notes_by_function)>0">
                          <tr>
                            <td>
                              <xsl:copy-of select="$notes_by_function"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </td>
                    </tr>
                  </table>
                </div>
              </td>
            </tr>
            
            <tr>
              <td>
                <xsl:call-template name="ZPSB_ELearning_Breadcrumb_Bottom"/>
              </td>
            </tr>
          </table>
        </Result>
      </content>
    </ComponentXML>
  </xsl:template>
  
</xsl:stylesheet>