<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="./XSLTemplate/CommonTemplates.xsl"/>
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <xsl:for-each select="/Data/Component/ComponentXML/ScriptTopList/ScriptTop">
          <ScriptTop src="{@src}"/>
        </xsl:for-each>        
      </ScriptTopList>

      <ScriptBottomList>
        <!--<ScriptBottom src=""/>-->
        <xsl:for-each select="/Data/Component/ComponentXML/ScriptBottomList/ScriptBottom">
          <ScriptBottom src="{@src}"/>
        </xsl:for-each>
      </ScriptBottomList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}l.css"/>        
        <xsl:for-each select="/Data/Component/ComponentXML/StylesheetList/Stylesheet">
          <Stylesheet href="{@href}"/>
        </xsl:for-each>
      </StylesheetList>

      <StylesheetInline>
        <![CDATA[]]>
        <xsl:value-of select="/Data/Component/ComponentXML/StylesheetInline"/>
      </StylesheetInline>

      <ScriptInlineTop>
        <![CDATA[]]>
        <xsl:value-of select="/Data/Component/ComponentXML/ScriptInlineTop"/>
      </ScriptInlineTop>

      <ScriptInlineBottom>
        <![CDATA[]]>
        <xsl:value-of select="/Data/Component/ComponentXML/ScriptInlineBottom"/>
      </ScriptInlineBottom>

      <ScriptInlineOnLoad>
        <![CDATA[]]>
        <xsl:value-of select="/Data/Component/ComponentXML/ScriptInlineOnLoad"/>
      </ScriptInlineOnLoad>

      <HTMLInline name="{/Data/Config/Name}">
        <xsl:if test="/Data/BID > 0">        
          <div class="innerPage">
            <xsl:if test="string-length(/Data/Title) > 0">
              <xsl:call-template name="pageTitle">
                <xsl:with-param name="title" select="/Data/Title"/>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="string-length(/Data/Image) > 0">
              <img class="banner" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}{/Data/Image}"/>
            </xsl:if>        
            <xsl:if test="string-length(/Data/Content) > 0">
              <div><xsl:copy-of select="/Data/Content/*"/></div>
            </xsl:if>
            <xsl:if test="string-length(/Data/Component/ComponentXML/HTMLInline) > 0">
              <div>
                <xsl:copy-of select="/Data/Component/ComponentXML/HTMLInline/*"/>
              </div>
            </xsl:if>
          </div>
        </xsl:if>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
</xsl:stylesheet>