﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="./XSLTemplate/CommonTemplates.xsl"/>
  
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src=""/>
      </ScriptTopList>

      <ScriptBottomList>
        <!--<ScriptBottom src=""/>-->
      </ScriptBottomList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}sp.css"/>        
      </StylesheetList>

      <StylesheetInline>
        <![CDATA[]]>
      </StylesheetInline>

      <ScriptInlineTop>
        <![CDATA[]]>
      </ScriptInlineTop>

      <ScriptInlineBottom>
        <![CDATA[]]>
      </ScriptInlineBottom>

      <HTMLInline name="{/Data/Config/Name}">
        <xsl:if test="/Data/BID > 0">
          <xsl:if test="string-length(/Data/Title) > 0">
            <h1>
              <xsl:value-of select="/Data/Title"/>
            </h1>
          </xsl:if>
          <xsl:if test="string-length(/Data/Image) > 0">
            <img class="banner" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}{/Data/Image}"/>
          </xsl:if>
          <xsl:if test="string-length(/Data/Content) > 0">
            <div class="content">
              <xsl:copy-of select="/Data/Content/*"/>
            </div>
          </xsl:if>
        </xsl:if>        
        
        <xsl:for-each select="/Data/SubFolders/SubFolder">
          <xsl:if test="string-length(./Title/.) > 0">
            <table style="width:100%;border-top:#ff9968 1px dashed;margin-top:2px;">
              <tr>
                <td colspan="2" style="background-color:#fff;padding:2px;">
                  <h2 style="padding-top:5px;padding-bottom:5px;">
                    <a href="{./URL/.}" title="{./Title/.}">
                      <xsl:value-of select="./Title/." />
                    </a>
                  </h2>
                </td>
              </tr>
              <tr>
                <xsl:if test="string-length(./Image/.) > 0">
                  <td style="background-color:#fff;padding:2px;vertical-align: top;" rowspan="2">
                    <a href="{./URL/.}" title="{./Title/.}">
                      <img alt="{./Title/.}"  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}{./Image/.}" style="border:0;margin-right:5px;margin-bottom:5px;"/>
                    </a>
                  </td>
                </xsl:if>
                <td style="background-color:#fff;padding:2px;vertical-align: top;width:100%;text-align:justify;">
                    <xsl:copy-of select="./Summary/*"/>
                </td>
              </tr>
            </table>
          </xsl:if>
        </xsl:for-each>

        <xsl:call-template name="pager"/>
        
        <xsl:for-each select="/Data/SubPages/SubPage">
          <xsl:if test="string-length(./Title/.) > 0">
            <table style="width:100%;border-top:#ff9968 1px dashed;margin-top:2px;">
              <tr>
                <td colspan="2" style="background-color:#fff;padding:2px;">
                  <h2 style="padding-top:5px;padding-bottom:5px;">
                    <a href="{./URL/.}" title="{./Title/.}">
                      <xsl:value-of select="./Title/." />
                    </a>
                  </h2>
                </td>
              </tr>
              <tr>
                <xsl:if test="string-length(./Image/.) > 0">
                  <td style="background-color:#fff;padding:2px;vertical-align: top;" rowspan="2">
                    <a href="{./URL/.}" title="{./Title/.}">
                      <img alt="{./Title/.}"  src="{/Data/Config/Domain}{/Data/Config/ProjectPath}{./Image/.}" style="border:0;margin-right:5px;margin-bottom:5px;"/>
                    </a>
                  </td>
                </xsl:if>
                <td style="background-color:#fff;padding:2px;vertical-align: top;width:100%;text-align:justify;">
                    <xsl:copy-of select="./Summary/*"/>
                  <span style="padding-left:5px;">
                    <a href="{./URL/.}" title="{./Title/.}">
                      <img alt="{./Title/.}" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/1more_s_on.png" style="border:0;"/>
                    </a>
                  </span>                  
                </td>
              </tr>
            </table>
          </xsl:if>
        </xsl:for-each>      
        
        <xsl:call-template name="pager"/>
        
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
  
  <xsl:template name="pager">
    <xsl:if test="count(/Data/SubPages/Pages/Page) > 0">
      <div style="border:0;width:620px;margin-top:10px;">
      <xsl:for-each select="/Data/SubPages/Pages/*">
        <xsl:variable name="uri">
          <xsl:call-template name="url"><xsl:with-param name="params">pn=<xsl:value-of select="@number"/></xsl:with-param></xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="@state=-2">
            <a href="{$uri}" style="margin-left:5px;margin-right:5px;cursor:pointer;font-weight:normal;color:#9f9b9a;">Poprzednia</a>
          </xsl:when>
          <xsl:when test="@state=0">
            <a href="{$uri}" style="margin-left:5px;margin-right:5px;cursor:pointer;font-weight:normal;color:#9f9b9a;"><xsl:value-of select="@number"/></a>
          </xsl:when>
          <xsl:when test="@state=1">
            <span style="margin-left:5px;margin-right:5px;font-weight:bold;color:#000;"><xsl:value-of select="@number"/></span>
          </xsl:when>
          <xsl:when test="@state=2">
            <a href="{$uri}" style="margin-left:5px;margin-right:5px;cursor:pointer;font-weight:normal;color:#9f9b9a;">Następna</a>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
      </div>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>