﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="../ResorcesCommon/ELearning_Utils.xsl"/>
  <xsl:import href="./XSLTemplate/CommonTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  <xsl:template match="/">
    <ComponentXML>
      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>
      
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}N610.js"/>
      </ScriptTopList>

      <xsl:variable name="learnging_url"><xsl:choose><xsl:when test="/Data/Config/Debug = 1">Default.aspx?GURL=/learning.html</xsl:when><xsl:otherwise>/learning.html</xsl:otherwise></xsl:choose></xsl:variable>
      
      <ScriptInlineBottom>
        <![CDATA[
        function gotoNauka(){
          window.location = ']]><xsl:value-of select="$learnging_url"/><![CDATA[';
        }
        ]]>
        jQuery(document).ready(function () {
          initMenu(0);
        });
      </ScriptInlineBottom>   
      
      <HTMLInline name="{/Data/Config/Name}">
        <div class="loginformcontainer N610_elementNormal">
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <div class="loginformbox">
                <div class="loginformavatar">
                  <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/loginavatar.png" alt="logowanie" title="logowanie" border="0" />
                </div>
                <div class="loginform">                  
                  <xsl:choose>                    
                    <xsl:when test="/Data/LoginOp/@operation = 2">

                      <xsl:choose>                        
                        <xsl:when test="/Data/LoginOp/@success = 1">
                          <!--Poprawnie wylogowano użytkownika z systemu-->
                          <xsl:call-template name="logintable"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:call-template name="info"><xsl:with-param name="msg">Nie udało sie wylogować użytkownika z systemu</xsl:with-param></xsl:call-template>                          
                        </xsl:otherwise>
                      </xsl:choose>
                      
                    </xsl:when>
                    
                    <xsl:when test="/Data/LoginOp/@operation = 3">
                      <xsl:call-template name="remindtable"/>
                    </xsl:when>
                    
                    <xsl:when test="/Data/LoginOp/@operation = 4">

                      <xsl:choose>                        
                        <xsl:when test="/Data/LoginOp/@success = 1">
                          <xsl:call-template name="info"><xsl:with-param name="msg">Poprawnie wyslano przypomnienie hasła</xsl:with-param></xsl:call-template>                          
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:call-template name="info"><xsl:with-param name="msg">Nie udało sie wysłać przypomnienia hasła</xsl:with-param></xsl:call-template>                                                    
                        </xsl:otherwise>
                      </xsl:choose>
                      
                    </xsl:when>
                    <xsl:otherwise>

                      <xsl:choose>                        
                        <xsl:when test="/Data/LoginOp/@success = 1 and /Data/Config/@IUA = 1">
                          <!--Udalo sie zalogowac-->
                          <xsl:call-template name="userinfo_logout" />
                        </xsl:when>
                        <xsl:when test="/Data/Config/@IUA = 1">
                          <!--Użytkownik zalogowany-->
                          <xsl:call-template name="userinfo_logout" />
                        </xsl:when>
                        <xsl:otherwise>
                          <!--Panel logowania-->
                          <xsl:call-template name="logintable"/>
                        </xsl:otherwise>
                      </xsl:choose>
                      
                    </xsl:otherwise>                    
                  </xsl:choose>
                  
                </div>
              </div>
            </xsl:with-param>
          </xsl:call-template>          
        </div>
        
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
 
  <xsl:template name="logintable">
    <table class="loginformtable" cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td><span>Login:</span></td>
        <td>
                        
          <div class="N610_inlineElement N610_elementNormal">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <input type="text" id="login_name" name="login_name" value="" />
              </xsl:with-param>
            </xsl:call-template>
          </div>
                        
        </td>
      </tr>
      <tr>
        <td><span>Hasło:</span></td>
        <td>

          <div class="N610_inlineElement N610_elementNormal">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <input type="password" id="login_password" name="login_password" value="" />
              </xsl:with-param>
            </xsl:call-template>
          </div>
                        
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <button type="image" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/login.png" id="login_op" name="login_op" value="1">Zaloguj</button>
        </td>
      </tr>
      <tr>
        <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
        <td colspan="2"><a href="{/Data/Config/URL}{$sign}login_op=3">Zapomniałeś hasła?</a></td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template name="remindtable">
    <table class="loginformtable" cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td><span>Login:</span></td>
        <td>
                        
          <div class="N610_inlineElement N610_elementNormal">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <input type="text" id="login_name" name="login_name" value="" />
              </xsl:with-param>
            </xsl:call-template>
          </div>
                        
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <button type="image" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/remind.png" id="login_op" name="login_op" value="4">Przypomnij</button>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="userinfo_logout">
    <table class="loginformtable padding5" cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td colspan="2">
          <span>Jesteś zalogowany jako:</span>
        </td>
      </tr>
      <tr>
        <td><span>Imię:</span></td>
        <td><span><xsl:value-of select="/Data/User/@Forename"/></span></td>
      </tr>
      <tr>
        <td><span>Nazwisko:</span></td>
        <td><span><xsl:value-of select="/Data/User/@Surename"/></span></td>
      </tr>
      <tr>
        <td colspan="2">
          <button type="button" onclick="gotoNauka();return false;">Dalej</button>
          <button type="submit" id="login_op" name="login_op" value="2">Wyloguj</button>
        </td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template name="info">
    <xsl:param name="msg" select="''"/>
    <xsl:if test="string-length($msg)>0">
      <table class="loginformtable padding5" cellspacing="0" cellpadding="0" border="0">
        <tr>
          <td>
            <span><xsl:value-of select="$msg"/></span>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>