<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="./XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:import href="./XSLTemplate/StatisticTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
      </ScriptTopList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>
      
      <!-- JSy niezbedne do robienia scrollowanej tabelki -->
      <xsl:call-template name="bottomJS" />
      
      <HTMLInline name="{/Data/Config/Name}">
        <input type="hidden" id="editmode" name="editmode" value="0"/>
        <input type="hidden" id="area" name="area" value="{/Data/Config/@AreaValue}"/>
        <table width="100%">
          <tr>
            <td>              
      <xsl:call-template name="box">
        <xsl:with-param name="content">       
              <xsl:choose>
                <xsl:when test="/Data/Config/@IUA=1">            
                  <xsl:choose>
                    <xsl:when test="/Data/Config/@AreaValue='NotLoaded'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='None'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorClassListPanel'">
                      <xsl:call-template name="InstructorClassListPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePanel'">
                      <xsl:call-template name="InstructorClassCompetencePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePartPanel'">
                      <xsl:call-template name="InstructorClassCompetencePartPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorStudentListPanel'">
                      <xsl:call-template name="InstructorStudentListPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePanel'">
                      <xsl:call-template name="InstructorStudentCompetencePanel" />
                    </xsl:when>                   
                    <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePartPanel'">
                      <xsl:call-template name="InstructorStudentCompetencePartPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorRanking1Panel'">
                      <xsl:call-template name="InstructorRanking1Panel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorRanking2Panel'">
                      <xsl:call-template name="InstructorRanking2Panel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='InstructorRanking3Panel'">
                      <xsl:call-template name="InstructorRanking3Panel" />
                    </xsl:when>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="invaliduser" />
                </xsl:otherwise>
              </xsl:choose>
              <xsl:comment> </xsl:comment>
        </xsl:with-param>
      </xsl:call-template>
            </td>
          </tr>
        </table>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>

  <!-- Panel wyboru rodzaju statystyki przez instruktora - menu poczatkowe statystyki instruktora -->
  <xsl:template name="NonePanel">    
    <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
    <div class="learningbox">
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=instructorclasslistpanel</xsl:with-param>
        <xsl:with-param name="title" select="'Statystyka klas'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=instructorstudentlistpanel</xsl:with-param>
        <xsl:with-param name="title" select="'Statystyka uczniów'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=instructorranking1panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking zgromadzonych środków'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=instructorranking2panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking eduFarma'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=instructorranking3panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking zajmowanych stanowisk'" />
      </xsl:call-template>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>
  
  <!-- Panel statystyki dla listy klas - sumaryczne zestawienie wszystkich klas dla instruktora -->
  <xsl:template name="InstructorClassListPanel">
    <div class="table_header_name"><h2>Statystyka klas</h2></div>
    <xsl:apply-templates select="/Data/StatisticList">
      <xsl:with-param name="isclassview" select="1"/>
    </xsl:apply-templates>
  </xsl:template>
  
  <!-- Panel statystyki dla listy studentow w kontekscie instruktora -->
  <xsl:template name="InstructorStudentListPanel">
    <div class="table_header_name"><h2>Statystyka ucznia</h2></div>
    <xsl:apply-templates select="/Data/StatisticList">
      <xsl:with-param name="isclassview" select="0"/>
    </xsl:apply-templates>
  </xsl:template>

  <!-- Panel statystyki dla klasy - podsumowanie klasy oraz lista kompetencji glownych -->  
  <xsl:template name="InstructorClassCompetencePanel">
    <div class="table_header_name"><h2>Statystyka klasy</h2></div>
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="1"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="1"/></xsl:apply-templates>
  </xsl:template>
   
  <!-- Panel statystyki dla studenta - podsumowanie studenta oraz lista kompetencji glownych -->  
  <xsl:template name="InstructorStudentCompetencePanel">
    <div class="table_header_name"><h2>Statystyka ucznia</h2></div>
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
  </xsl:template>
  
  <!-- Panel statstyki dla listy kompetencji skłądowych w kontekście klasy -->
  <xsl:template name="InstructorClassCompetencePartPanel">
    <div class="table_header_name"><h2>Statystyka klasy</h2></div>
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="1"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="1"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetencePartStatisticList"><xsl:with-param name="isclassview" select="1"/></xsl:apply-templates>
  </xsl:template>

  <!-- Panel statstyki dla listy kompetencji skłądowych w kontekście studenta -->
  <xsl:template name="InstructorStudentCompetencePartPanel">
    <div class="table_header_name"><h2>Statystyka ucznia</h2></div>
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetencePartStatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
  </xsl:template>
  
  <!-- Ranking 1 - ranking zgromadzonych środków (pensja) - sortowanie po $ i nazwisku + imie -->
  <xsl:template name="InstructorRanking1Panel">
    <xsl:call-template name="classcombo"/>    
    <xsl:call-template name="Ranking1"><xsl:with-param name="isstudent" select="1"/></xsl:call-template>
  </xsl:template>
  
  <!-- Ranking 2 - ranking środków z eduFarmu - sortowanie po $ i nazwisku + imie -->
  <xsl:template name="InstructorRanking2Panel">
    <xsl:call-template name="classcombo"/>
    <xsl:call-template name="Ranking2"><xsl:with-param name="isstudent" select="1"/></xsl:call-template>
  </xsl:template>

  <!-- Ranking 3 - zestawienie zajmowanych stanowisk w klasie - grupowanie po stanowisku i sortowanie po nazwisku + imie -->
  <xsl:template name="InstructorRanking3Panel">
    <xsl:call-template name="classcombo"/>
    <xsl:call-template name="Ranking3"><xsl:with-param name="isstudent" select="1"/></xsl:call-template>
  </xsl:template>
  
  <!-- Dropdown do wyboru klasy na statystykach -->
  <xsl:template name="classcombo">
    <xsl:param name="sel" select="/Data/Class/@ID"/>
    <div class="classselect">
      <span>Klasa:</span>
      <select name="classid" id="classid">
        <option value="">Wybierz klase</option>
        <xsl:for-each select="/Data/ClassList/Class">
          <option value="{@ID}">
            <xsl:if test="@ID=$sel">
              <xsl:attribute name="selected">selected</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="@Name"/>
          </option>
        </xsl:for-each>
      </select>
      <button type="submit">Pokaż</button>
    </div>
  </xsl:template>
  
</xsl:stylesheet>