<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="./XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:import href="./XSLTemplate/StatisticTemplates.xsl"/>
  
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
      </ScriptTopList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>

      <!-- JSy niezbedne do robienia scrollowanej tabelki -->
      <xsl:call-template name="bottomJS" />
      
      <HTMLInline name="{/Data/Config/Name}">
        <input type="hidden" id="editmode" name="editmode" value="0"/>
        <table width="100%">
          <tr>
            <td>              
      <xsl:call-template name="box">
        <xsl:with-param name="content">       
              <div class="table_header_name"><h2>Statystyka</h2></div>
              <xsl:choose>
                <xsl:when test="/Data/Config/@IUA=1">            
                  <xsl:choose>
                    <xsl:when test="/Data/Config/@AreaValue='NotLoaded'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='None'">
                      <xsl:call-template name="NonePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePanel'">
                      <xsl:call-template name="StudentCompetencePanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePartPanel'">
                      <xsl:call-template name="StudentCompetencePartPanel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='StudentRanking1Panel'">
                      <xsl:call-template name="StudentRanking1Panel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='StudentRanking2Panel'">
                      <xsl:call-template name="StudentRanking2Panel" />
                    </xsl:when>
                    <xsl:when test="/Data/Config/@AreaValue='StudentRanking3Panel'">
                      <xsl:call-template name="StudentRanking3Panel" />
                    </xsl:when>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="invaliduser" />
                </xsl:otherwise>
              </xsl:choose>
              <xsl:comment> </xsl:comment>
        </xsl:with-param>
      </xsl:call-template>
            </td>
          </tr>
        </table>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
  
  <!-- Panel wyboru rodzaju statystyki przez studenta - menu poczatkowe statystyki studenta -->
  <xsl:template name="NonePanel">    
    <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
    <div class="learningbox">
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=studentcompetencepanel</xsl:with-param>
        <xsl:with-param name="title" select="'Statystyka'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=studentranking1panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking zgromadzonych środków'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=studentranking2panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking eduFarma'" />
      </xsl:call-template>
      <xsl:call-template name="named_banner">
        <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />area=studentranking3panel</xsl:with-param>
        <xsl:with-param name="title" select="'Ranking zajmowanych stanowisk'" />
      </xsl:call-template>
      <xsl:comment> </xsl:comment>
    </div>
  </xsl:template>
  
  <!-- Panel statystyki dla studenta - podsumowanie studenta oraz lista kompetencji glownych -->  
  <xsl:template name="StudentCompetencePanel">
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="0"/><xsl:with-param name="isstudentarea" select="1"/></xsl:apply-templates>
  </xsl:template>

  <!-- Panel statstyki dla listy kompetencji skłądowych w kontekście studenta -->
  <xsl:template name="StudentCompetencePartPanel">
    <xsl:apply-templates select="/Data/StatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetenceStatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
    <xsl:apply-templates select="/Data/CompetencePartStatisticList"><xsl:with-param name="isclassview" select="0"/></xsl:apply-templates>
  </xsl:template>
  
  <!-- Ranking 1 - ranking zgromadzonych środków (pensja) - sortowanie po $ i nazwisku + imie -->
  <xsl:template name="StudentRanking1Panel">
    <xsl:call-template name="Ranking1"><xsl:with-param name="isstudent" select="0"/></xsl:call-template>
  </xsl:template>
  
  <!-- Ranking 2 - ranking środków z eduFarmu - sortowanie po $ i nazwisku + imie -->
  <xsl:template name="StudentRanking2Panel">
    <xsl:call-template name="Ranking2"><xsl:with-param name="isstudent" select="0"/></xsl:call-template>
  </xsl:template>

  <!-- Ranking 3 - zestawienie zajmowanych stanowisk w klasie - grupowanie po stanowisku i sortowanie po nazwisku + imie -->
  <xsl:template name="StudentRanking3Panel">
    <xsl:call-template name="Ranking3"><xsl:with-param name="isstudent" select="0"/></xsl:call-template>
  </xsl:template>

</xsl:stylesheet>