<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="../ResorcesCommon/website.xsl"/>  
  <xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
  <xsl:template match="/">
    <html xmlns= "http://www.w3.org/1999/xhtml">
      <head>
        <title>
          <xsl:value-of select="/Data/WebPageTitle" disable-output-escaping="yes" /> - eduKariera
        </title>

        <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE8" />     

        <xsl:call-template name="MetaData">
          <xsl:with-param name="Copyright" select="'Zachodniopomorska Szkoła Biznesu'"/>
        </xsl:call-template>                
                     
        <link rel="stylesheet" type="text/css" href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}l.css" />
      
         <xsl:call-template name="CSS"/>        

        <xsl:call-template name="JavaScript">        
          <xsl:with-param name="IncludeGeminiCore"    select="1"/>
          <xsl:with-param name="IncludeJQuery"        select="1"/>
          <xsl:with-param name="IncludeJQueryUI"      select="1"/>
          <xsl:with-param name="IncludeJQueryCorner"  select="1"/>   
          <xsl:with-param name="IncludeCufon"         select="0"/>
          <xsl:with-param name="IncludeSwfObject"     select="1"/>         
          <xsl:with-param name="IncludeHTML5"         select="0"/>           
        </xsl:call-template>
        
        <link rel="stylesheet" type="text/css" href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}prettyPhoto.css" />
        <link rel="stylesheet" type="text/css" href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}dd/dd.css" />
        <link rel="stylesheet" type="text/css" href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}dd/skin2.css" />
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}jquery.dd.min.js"><xsl:text> </xsl:text></script>
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}jquery.prettyPhoto.js"><xsl:text> </xsl:text></script>
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}jquery.fixedtable.js"><xsl:text> </xsl:text></script>
        
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}curvycorners.src.js"><xsl:text> </xsl:text></script>
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}main.js"><xsl:text> </xsl:text></script>

        <xsl:call-template name="JavaScriptTop"/>     
      </head>
      <xsl:call-template name="HTMLBody"/>      
    </html>
  </xsl:template>
</xsl:stylesheet>
