<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_MovingBox_Points">
    <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Points">
      <div class="N610_movingBoxCanva">
        <xsl:if test="string-length(/Data/EXERCISE/AREA/@imageURL)>0">
          <xsl:attribute name="style">background-image:url('<xsl:value-of select="/Data/EXERCISE/AREA/@imageURL"/>');background-repeat:no-repeat;width:100%;height:<xsl:value-of select="/Data/EXERCISE/AREA/@imageHeight"/>px;</xsl:attribute>             
        </xsl:if>
        <xsl:for-each select="/Data/EXERCISE/AREA/BOX">
          <div id="divDrop_{@id}" class="N610_elementNormal droppable ui-droppable" style="moz-box-sizing: border-box;position:absolute;left:{@x}px;top:{@y}px;">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <div id="in_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                  <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                  <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                </div>
                <input type="hidden" value="" id="hin_{@id}" />
              </xsl:with-param>
            </xsl:call-template>
          </div>                        
        </xsl:for-each>
      </div>      
      <div class="N610_breaker"><xsl:comment></xsl:comment></div>       
      <xsl:for-each select="/Data/EXERCISE/PARKING_BOX/BOX">  
        <div id="divDrag_{@id}" class="N610_elementNormal N610_movingBoxDiv draggable ui-draggable">
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <div id="divVal_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                <xsl:value-of select="."/>
              </div>
            </xsl:with-param>
          </xsl:call-template>          
        </div>
        <div style="width:5px;float:left;height:30px;"><xsl:comment> </xsl:comment></div>
      </xsl:for-each>        
    </div>
    <xsl:call-template name="set_fhw_size"/>
    <script type="text/javascript">
      <xsl:comment>
        function formatCheck(xml) {
          xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'hin_']").each(function() {
            xml.BeginNode("BOX");
              xml.Attrib("id", $(this).attr("id").substr(4));
              xml.Attrib("answerID", $(this).val());
            xml.EndNode();
          });
          xml.EndNode();
          return xml;
        }
        jQuery(document).ready(function($) {
          setup_Questions_MovingBox();
        });
      </xsl:comment>
    </script>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_MovingBox_Points">
    <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Points">
      <div id="question_{@id}">
        <xsl:if test="string-length(/Data/EXERCISE/AREA/@imageURL)>0">
          <xsl:attribute name="style">background-image:url('<xsl:value-of select="/Data/EXERCISE/AREA/@imageURL"/>');background-repeat:no-repeat;width:100%;height:<xsl:value-of select="/Data/EXERCISE/AREA/@imageHeight"/>px;</xsl:attribute>             
        </xsl:if>
        <xsl:for-each select="/Data/EXERCISE/AREA/BOX">            
          
          <div style="moz-box-sizing: border-box;position:absolute;left:{@x}px;top:{@y}px;">
            <xsl:choose>
                <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class">N610_fhw N610_elementCorrect N610_samesize</xsl:attribute></xsl:when>
                <xsl:otherwise><xsl:attribute name="class">N610_fhw N610_elementIncorrect N610_samesize</xsl:attribute></xsl:otherwise>
            </xsl:choose>                        
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <div id="in_{@id}" class="N610_fhw">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                  <xsl:value-of select="."/>
                  <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                </div>
              </xsl:with-param>
            </xsl:call-template>
          </div>                      
          
        </xsl:for-each>
      </div>
    </div>
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Resolve_MovingBox_Points">
    <div id="containment-wrapper" class="ui-droppable N610_MovingBox_Points">
      <div id="question_{@id}">
        <xsl:if test="string-length(/Data/EXERCISE/AREA/@imageURL)>0">
          <xsl:attribute name="style">background-image:url('<xsl:value-of select="/Data/EXERCISE/AREA/@imageURL"/>');background-repeat:no-repeat;width:100%;height:<xsl:value-of select="/Data/EXERCISE/AREA/@imageHeight"/>px;</xsl:attribute>             
        </xsl:if>
        <xsl:for-each select="/Data/EXERCISE/AREA/BOX">  
          <div class="N610_inlineElement N610_elementResolved N610_movingBoxFont" style="moz-box-sizing: border-box;position:absolute;left:{@x}px;top:{@y}px;">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <div id="in_{@id}">
                  <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                  <xsl:value-of select="."/>
                  <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                </div>
              </xsl:with-param>
            </xsl:call-template>
          </div>                 
        </xsl:for-each>
      </div>
    </div>
  </xsl:template>
</xsl:stylesheet>