<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_Questions_ABCD">
    <div class="N610_Questions_ABCD">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <xsl:variable name="qid" select="@id"/>
          <div><xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/><br/></div>
          <xsl:for-each select="./BOX">
            <div class="N610_ABCDAnswer N610_elementNormal" id="in_{$qid}_{@id}">
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
                <table style="width:100%; height:100%">
                  <tr>
                    <td class="N610_ABCDAnswerMarkCell"><div class="N610_ABCDAnswerMark"><xsl:number value="position()" format="A"/></div><input type="hidden" id="hin_{$qid}_{@id}" value="0" /></td>
                    <td><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></td>
                  </tr>
                </table>
              </xsl:with-param>
            </xsl:call-template>
            </div>
          </xsl:for-each>
        </div>
      </xsl:for-each>
    </div>
    <script type="text/javascript">
      function formatCheck(xml) {
        xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'hin_']").each(function() {
            xml.BeginNode("BOX");
              xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_")+1));
              xml.Attrib("answerID", $(this).val());
            xml.EndNode();
	        });
        xml.EndNode();
        return xml;
      }
     
      jQuery(document).ready(function($) {
         setup_Questions_ABCD(<xsl:value-of select="/Data/EXERCISE/QUESTIONS/@isMultipleChoice " />); 
      });
    </script>    
    <xsl:call-template name="set_object_order" />
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Questions_ABCD">
    <div class="N610_Questions_ABCD">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <xsl:variable name="qid" select="@id"/>
          <div><xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/><br/></div>
          <xsl:for-each select="./BOX">
            <div class="N610_ABCDAnswer" id="in_{$qid}_{@id}">
              <xsl:choose>
                <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class" >N610_ABCDAnswer  N610_elementCorrect</xsl:attribute></xsl:when>
                <xsl:when test="@isAnswerCorrect=0"><xsl:attribute name="class" >N610_ABCDAnswer  N610_elementIncorrect</xsl:attribute></xsl:when>
                <xsl:otherwise><xsl:attribute name="class" >N610_ABCDAnswer</xsl:attribute></xsl:otherwise>
              </xsl:choose>     
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
              <table>
                <tr>
                  <td class="N610_ABCDAnswerMarkCell"><div class="N610_ABCDAnswerMark"><xsl:number value="position()" format="A"/></div></td>
                  <td><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></td>
                </tr>
              </table>
              </xsl:with-param>
            </xsl:call-template>
            </div>
          </xsl:for-each>
        </div>
      </xsl:for-each>
    </div>
    <xsl:call-template name="set_object_order" />
  </xsl:template>  
  
  <xsl:template name="ELearning_Exercise_Resolve_Questions_ABCD">
    <div class="N610_Questions_ABCD">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <xsl:variable name="qid" select="@id"/>
          <div><xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/><br/></div>
          <xsl:for-each select="./BOX">
            <div class="N610_ABCDAnswer" id="in_{$qid}_{@id}">
              <xsl:choose>
                <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class" >N610_ABCDAnswer N610_elementResolved</xsl:attribute></xsl:when>
                <xsl:otherwise><xsl:attribute name="class" >N610_ABCDAnswer</xsl:attribute></xsl:otherwise>
              </xsl:choose>     
            <xsl:call-template name="common_box">
              <xsl:with-param name="content">
              <table>
                <tr>
                  <td class="N610_ABCDAnswerMarkCell"><div class="N610_ABCDAnswerMark"><xsl:number value="position()" format="A"/></div></td>
                  <td><xsl:value-of select="." disable-output-escaping="yes" xml:space="preserve"/></td>
                </tr>
              </table>
              </xsl:with-param>
            </xsl:call-template>
            </div>
          </xsl:for-each>
        </div>
      </xsl:for-each>
    </div>
    <xsl:call-template name="set_object_order" />
  </xsl:template>
  
</xsl:stylesheet>