<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">

  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_Questions_MovingBox">
    <div id="containment-wrapper" class="ui-droppable N610_Questions_MovingBox">  
      <xsl:for-each select="/Data/EXERCISE/PARKING_BOX/BOX">  
        <div id="divDrag_{@id}" class="N610_elementNormal N610_movingBoxDiv N610_movingBoxFont draggable ui-draggable">
          <xsl:call-template name="common_box">
            <xsl:with-param name="content">
              <div id="divVal_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                <xsl:value-of select="."/>
              </div>
            </xsl:with-param>
          </xsl:call-template>          
        </div>
        <div style="width:5px;float:left;height:30px;"><xsl:comment> </xsl:comment></div>
      </xsl:for-each>        
      <div class="N610_breaker"><xsl:comment></xsl:comment><xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text></div>
      
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <table>
            <tr>
              <td class="N610_questionColumn">
                <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
              </td>
              <td class="N610_answerColumn">
                <table class="N610_answerTable">
                  <xsl:for-each select="./BOX"> 
                    <tr>
                      <td>
                        <div id="divDrop_{@id}" class="N610_inlineElement N610_elementNormal N610_movingBoxFont droppable ui-droppable">
                          <xsl:call-template name="common_box">
                            <xsl:with-param name="content">
                              <div id="in_{@id}" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                                <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                                <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                              </div>
                              <input type="hidden" value="" id="hin_{@id}" />
                            </xsl:with-param>
                          </xsl:call-template>
                        </div>                        
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </td>
            </tr>
          </table>              
        </div>
      </xsl:for-each>
    </div>
    
    <xsl:call-template name="set_fhw_size"/>
    
    <script type="text/javascript">
      <xsl:comment>
      function formatCheck(xml) {
        xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'hin_']").each(function() {
            xml.BeginNode("BOX");
                xml.Attrib("id", $(this).attr("id").substr(4));
                xml.Attrib("answerID", $(this).val());
            xml.EndNode();
	        });
        xml.EndNode();
        return xml;
      }
      
      jQuery(document).ready(function($) {
         setup_Questions_MovingBox();
      });
     
      </xsl:comment>
    </script>    
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Questions_MovingBox">
    <div id="containment-wrapper" class="ui-droppable N610_Questions_MovingBox">  
    <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
      <div class="N610_question" id="question_{@id}">
        <table>
          <tr>
            <td class="N610_questionColumn">
              <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
            </td>
            <td class="N610_answerColumn">
              <table class="N610_answerTable">
                <xsl:for-each select="./BOX">
                  <tr>
                    <td>
                      <div>
                        <xsl:choose>
                          <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class">N610_elementCorrect N610_inlineElement N610_movingBoxFont</xsl:attribute></xsl:when>
                          <xsl:otherwise><xsl:attribute name="class">N610_elementIncorrect N610_inlineElement N610_movingBoxFont</xsl:attribute></xsl:otherwise>
                        </xsl:choose>                        
                        <xsl:call-template name="common_box">
                          <xsl:with-param name="content">
                            <div id="in_{@id}" class="N610_fhw">
                              <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                              <xsl:value-of select="."/>
                              <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                            </div>
                          </xsl:with-param>
                        </xsl:call-template>
                      </div>
                    </td>
                  </tr>
                </xsl:for-each>
              </table>
            </td>
          </tr>
        </table>
      </div>
    </xsl:for-each>
    </div>
  </xsl:template>  
  
  <xsl:template name="ELearning_Exercise_Resolve_Questions_MovingBox">
    <div id="containment-wrapper" class="ui-droppable N610_Questions_MovingBox">  
    <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
      <div class="N610_question" id="question_{@id}">
        <table>
          <tr>
            <td class="N610_questionColumn">
              <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
            </td>
            <td class="N610_answerColumn">
              <table class="N610_answerTable">
                <xsl:for-each select="./BOX">
                  <tr><td>
                    <div class="N610_inlineElement N610_elementResolved N610_movingBoxFont">
                      <xsl:call-template name="common_box">
                        <xsl:with-param name="content">
                          <div id="in_{@id}">
                            <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                            <xsl:value-of select="."/>
                            <xsl:text disable-output-escaping="yes" xml:space="preserve">&amp;nbsp;</xsl:text>
                          </div>
                        </xsl:with-param>
                      </xsl:call-template>
                    </div>       
                  </td></tr>
                </xsl:for-each>
              </table>
            </td>
          </tr>
        </table>
      </div>   
    </xsl:for-each>
      </div>
  </xsl:template>
  
</xsl:stylesheet>