<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:import href="ELearning_Utils.xsl"/>
  
  <xsl:template name="ELearning_Exercise_Load_Questions_OpenGap">
    <div class="N610_Questions_OpenGap">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <table>
            <tr>
              <td>
                <div class="N610_Questions_OpenGap_QuestionDiv">
                  <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
                </div>
              </td>
              <td>
                <table class="N610_Questions_OpenGap_AnswerTable">
                  <xsl:for-each select="./BOX"> 
                    <tr>
                      <td>                      
                        <div class="N610_inlineElement N610_elementNormal">
                          <xsl:call-template name="common_box">
                            <xsl:with-param name="content">
                              <input type="text" id="in_{@id}" value="" class="N610_fhw N610_samesize {$calculate_width} {$calculate_height}">
                                <xsl:call-template name="set_initial_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                              </input>
                            </xsl:with-param>
                          </xsl:call-template>
                        </div>                      
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </td>
            </tr>
          </table>
              
        </div>
      </xsl:for-each>
    </div>
    <xsl:call-template name="set_fhw_size"/>
    <script type="text/javascript">
      function formatCheck(xml) {
        xml.BeginNode("CHECK_EXERCISE");
          $("input[id ^= 'in_']").each(function() {
            xml.BeginNode("BOX");
                xml.Attrib("id", $(this).attr("id").substr(3));
                xml.CDATANodeValue($(this).val());
            xml.EndNode();
	        });
        xml.EndNode();
        return xml;
      }
      setup_Questions_OpenGap();
    </script>    
  </xsl:template>

  <xsl:template name="ELearning_Exercise_Check_Questions_OpenGap">
    <div class="N610_Questions_OpenGap">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <table>
            <tr>
              <td>
                <div class="N610_Questions_OpenGap_QuestionDiv">
                  <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
                </div>
              </td>
              <td>
                <table class="N610_Questions_OpenGap_AnswerTable">
                  <xsl:for-each select="./BOX">
                    <tr>
                      <td>
                        <div>
                          <xsl:choose>
                            <xsl:when test="@isAnswerCorrect=1"><xsl:attribute name="class">N610_elementCorrect N610_inlineElement</xsl:attribute></xsl:when>
                            <xsl:otherwise><xsl:attribute name="class">N610_elementIncorrect N610_inlineElement</xsl:attribute></xsl:otherwise>
                          </xsl:choose>                        
                          <xsl:call-template name="common_box">
                            <xsl:with-param name="content">
                              <input type="text" value="{.}" id="in_{@id}" class="N610_fhw" readonly="readonly">
                                <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                              </input>
                            </xsl:with-param>
                          </xsl:call-template>
                        </div>                      
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </td>
            </tr>
          </table>

        </div>
      </xsl:for-each>
    </div>
  </xsl:template>  
  
  <xsl:template name="ELearning_Exercise_Resolve_Questions_OpenGap">
    <div class="N610_Questions_OpenGap">
      <xsl:for-each select="/Data/EXERCISE/QUESTIONS/QUESTION">
        <div class="N610_question" id="question_{@id}">
          <table>
            <tr>
              <td>
                <div class="N610_Questions_OpenGap_QuestionDiv">
                  <xsl:value-of select="TEXT/." disable-output-escaping="yes" xml:space="preserve"/>
                </div>
              </td>
              <td>
                <table class="N610_Questions_OpenGap_AnswerTable">
                  <xsl:for-each select="./BOX">
                    <tr>
                      <td>
                        <div class="N610_inlineElement N610_elementResolved">
                          <xsl:call-template name="common_box">
                            <xsl:with-param name="content">
                              <input type="text" value="{.}" id="in_{@id}" class="N610_fhw" readonly="readonly">
                                <xsl:call-template name="set_object_size"><xsl:with-param name="style" select="'-moz-box-sizing: border-box;'"/></xsl:call-template>
                              </input>
                            </xsl:with-param>
                          </xsl:call-template>
                        </div>       
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </td>
            </tr>
          </table>
        </div>
      </xsl:for-each>
    </div>
  </xsl:template>    
</xsl:stylesheet>