<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:output method="html" indent="no" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
  
  
  <xsl:template name="GoogleAnalytics">
    <xsl:if test="string-length(/Data/Config/GoogleAnalyticsID)>0">
      <script type="text/javascript">
          var _gaq = _gaq || [];
          _gaq.push(['_setAccount', '<xsl:value-of select="/Data/Config/GoogleAnalyticsID"/>']);
          _gaq.push(['_trackPageview']);

          (function() {
            var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
            ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
          })();
        </script>
    </xsl:if>
  </xsl:template>

  <xsl:template name="HTMLBody">
    <body onload="onloadHandler();">
      <form name="formMain" id="formMain" method="post" action="{/Data/Config/URL}">
        <input type="hidden" name="IPB" id="IPB" value="1" />
        <input type="hidden" name="BID" id="BID" value="{/Data/Config/BID}" />
        <input type="hidden" name="UID" id="UID" value="{/Data/Config/UID}" />
        <input type="hidden" name="IUA" id="IUA" value="{/Data/Config/IUA}" />
        <xsl:value-of select="/Data/HTMLInline" disable-output-escaping="yes"/>
      </form>
      <div id='processing' style="display: none;background-color:transparent;">Wczytywanie danych...</div>
      <div id="dialog6" class="disable_masking">
        <xsl:text> </xsl:text>
      </div>
      <xsl:for-each select="/Data/ScriptBottomList/ScriptBottom">
        <script type="text/javascript" src="{.}">
          <xsl:text> </xsl:text>
        </script>
      </xsl:for-each>
      <script type="text/javascript">
        <xsl:comment>
            function onloadHandler()
            {
            <xsl:if test="string-length(/Data/ScriptInlineOnLoad)>0">
              <xsl:value-of select="/Data/ScriptInlineOnLoad" disable-output-escaping="yes"/>
            </xsl:if>
            };
            <xsl:if test="string-length(/Data/ScriptInlineBottom)>0">
              <xsl:value-of select="/Data/ScriptInlineBottom" disable-output-escaping="yes"/>
            </xsl:if>
          </xsl:comment>
      </script>
    </body>
  </xsl:template>

  <xsl:template name="JavaScript">
      <xsl:param name="IncludeGeminiCore"    select="0"/>    
      <xsl:param name="IncludeJQuery"        select="0"/>
      <xsl:param name="IncludeJQueryUI"      select="0"/>
      <xsl:param name="IncludeJQueryCorner"  select="0"/>   
      <xsl:param name="IncludeCufon"         select="0"/>
      <xsl:param name="IncludeSwfObject"     select="0"/>      
      <xsl:param name="IncludeHTML5"         select="0"/>      
    
        <xsl:if test="$IncludeHTML5=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}html5.js"><xsl:text> </xsl:text></script>    
        </xsl:if>       
    
        <xsl:if test="$IncludeJQueryUI=1 and ($IncludeJQuery=1 or $IncludeGeminiCore=1  or $IncludeJQueryCorner=1)">  
        <link rel="stylesheet" type="text/css" href="{/Data/Config/Domain}{/Data/Config/CommonPath}css/jq/black-tie/{/Data/Config/ResoursesVersion}jquery-ui-1.8.17.custom.css" />    
        </xsl:if>     
      
        <xsl:if test="$IncludeJQuery=1  or $IncludeGeminiCore=1 or $IncludeJQueryCorner=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/jq/{/Data/Config/ResoursesVersion}jquery-1.5.2.min.js"><xsl:text> </xsl:text></script>  
        </xsl:if>         
             
        <xsl:if test="$IncludeJQueryUI=1 and ($IncludeJQuery=1 or $IncludeGeminiCore=1  or $IncludeJQueryCorner=1)">  
          <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/jq/{/Data/Config/ResoursesVersion}jquery-ui-1.8.17.custom.min.js"><xsl:text> </xsl:text></script>        
        </xsl:if>  
                
        <xsl:if test="$IncludeJQueryCorner=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/jq/{/Data/Config/ResoursesVersion}jquery.corner.js"><xsl:text> </xsl:text></script>    
        </xsl:if>    
    
        <xsl:if test="$IncludeCufon=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}cufon-yui.js"><xsl:text> </xsl:text></script>   
        </xsl:if>     
    
        <xsl:if test="$IncludeGeminiCore=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}gajax.js"><xsl:text> </xsl:text></script>       
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}gemini.js"><xsl:text> </xsl:text></script>
        </xsl:if>  
    
        <xsl:if test="$IncludeSwfObject=1">  
        <script type="text/javascript" src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}swfobject.js"><xsl:text> </xsl:text></script>    
        </xsl:if>      
  </xsl:template>  
  
  <xsl:template name="JavaScriptTop">
        <xsl:for-each select="/Data/ScriptTopList/ScriptTop">
          <script type="text/javascript" src="{.}">
            <xsl:text> </xsl:text>
          </script>
        </xsl:for-each>

        <xsl:if test="string-length(/Data/ScriptInlineTop)>0">
          <script type="text/javascript"> 
            <xsl:comment>
              <xsl:value-of select="/Data/ScriptInlineTop" disable-output-escaping="yes"/>
            </xsl:comment>
          </script>
        </xsl:if> 
  </xsl:template>    
  
  <xsl:template name="CSS">
          <xsl:for-each select="/Data/StylesheetList/Stylesheet">
          <link  rel="stylesheet"  type="text/css" href="{.}" />
        </xsl:for-each>
        <xsl:if test="string-length(/Data/StylesheetInline)>0">
          <style type="text/css">
            <xsl:value-of select="/Data/StylesheetInline" disable-output-escaping="yes"/>
          </style>
        </xsl:if>
  </xsl:template>  
    
  <xsl:template name="MetaData">
      <xsl:param name="Copyright"/>     
        <meta http-equiv="Pragma" content="NoCache" />
        <meta http-equiv="Expires" content="0" />
        <meta name="robots" content="index,follow" />
        <meta name="Googlebot" content="index,follow"/>
        <meta name="rating" content="general" />
        <meta name="author" content="Inisoft.pl" />
        <meta name="generator" content="Gemini CMS" />
        <meta name="Distribution" content="Global"/>
        <xsl:if test="string-length($Copyright)>0"><meta name="copyright" content="{$Copyright}" /></xsl:if>     
        <xsl:for-each select="/Data/MetaDataList/MetaData"><meta name="{@LabelValue}" content="{@Data}"/></xsl:for-each>     
        <xsl:if test="string-length(/Data/Config/GoogleSiteVerification)>0"><meta name="google-site-verification" content="{/Data/Config/GoogleSiteVerification}" /></xsl:if>
  </xsl:template>     
</xsl:stylesheet>