<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
<xsl:import href="../XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:template name="SummaryPage">
    <div class="N610_notyfication message_corner">
      <TABLE border="0" class="N610_notyfication">
        <TR>
          <TD>
            <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/610/summary.png"/>
          </TD>              
          <TD style="vertical-align:middle">
            <xsl:choose>
              <xsl:when test="/Data/EXERCISE/@courseType =1">
                <xsl:call-template name="KnowledgeTest"/>
              </xsl:when>
              
              <xsl:when test="/Data/EXERCISE/@courseType =2">
                <xsl:call-template name="AdvancedTest"/>
              </xsl:when>      
              
              <xsl:when test="/Data/EXERCISE/@courseType =3">
                <xsl:call-template name="CompetenceCourse"/>
              </xsl:when>       
                            
              <xsl:when test="/Data/EXERCISE/@courseType =5">
                <xsl:call-template name="Case"/>
              </xsl:when>                
            </xsl:choose>
          </TD> 
        </TR>
        <TR>
          <TD colspan="2"  align="center">
                <xsl:call-template name="continue_learn">
                  <xsl:with-param name="node" select="/Data/EXERCISE" />
                  <xsl:with-param name="width" select="200" />                  
                </xsl:call-template>               
          </TD>
        </TR>
      </TABLE>
    </div>
  </xsl:template>
  
  <xsl:template name="Case">
       <TABLE border="0" class="N610_notyfication">
      <TR>
        <TD>
<b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoj wyniki uzyskany z rozwiązania zadania praktycznego to <b><xsl:value-of select="/Data/EXERCISE/@pointsPercent"/></b> %.          
        </TD>
      </TR>
      <TR>
        <TD>
               <xsl:choose>
                 <xsl:when test="/Data/EXERCISE/@sex =1">
                  Zaliczyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zaliczyłeś
               </xsl:otherwise>
               </xsl:choose>
               <b><xsl:value-of select="/Data/EXERCISE/@points"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@maxPoints"/></b> możliwych zestawów ćwiczeń praktycznych.
        </TD>
      </TR>
    </TABLE>  
  </xsl:template>
  <xsl:template name="CompetenceCourse">
     <TABLE border="0" class="N610_notyfication">
       <TR>
         <TD>
          <b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoje wyniki z wykonania ćwiczeń to <b><xsl:value-of select="/Data/EXERCISE/@pointsPercent"/></b> %.         
        </TD>
       </TR>
       
       <TR>
         <TD>
               <xsl:choose>
                 <xsl:when test="/Data/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
               <b><xsl:value-of select="/Data/EXERCISE/@points"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@maxPoints"/></b> punktów możliwych.               
        </TD>
       </TR>
       <TR>
         <TD>
           <xsl:choose>
             <xsl:when test="/Data/EXERCISE/@evaluationSheetProgress =1">
                   Gratuluje, 
                     <xsl:choose>
                       <xsl:when test="/Data/EXERCISE/@sex =1">
                        zostałaś awansowana
                     </xsl:when>
                       <xsl:otherwise>
                        zostałeś awansowany
                     </xsl:otherwise>
                     </xsl:choose>
                   ze stanowiska <b><xsl:value-of select="/Data/EXERCISE/@evaluationSheetStart"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@evaluationSheetEnd"/></b>.
                </xsl:when>
             <xsl:when test="/Data/EXERCISE/@evaluationSheetProgress =-1">
                   Bardzo mi przykro ale 
                     <xsl:choose>
                       <xsl:when test="/Data/EXERCISE/@sex =1">
                        zostałaś zdegradowana
                     </xsl:when>
                       <xsl:otherwise>
                        zostałeś zdegradowany
                     </xsl:otherwise>
                     </xsl:choose>
                   ze stanowiska <b><xsl:value-of select="/Data/EXERCISE/@evaluationSheetStart"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@evaluationSheetEnd"/></b>.
                </xsl:when>
             <xsl:otherwise>
                  Twoje zaszeregowanie w firmie nie uległo zmianie i nadal piastujesz stanowisko <b><xsl:value-of select="/Data/EXERCISE/@evaluationSheetEnd"/></b>.
                </xsl:otherwise>
           </xsl:choose>
         </TD>
       </TR>
       <TR>
         <TD>Za wykonanie tego zadania  
               <xsl:choose>
                 <xsl:when test="/Data/EXERCISE/@sex =1">
                  zarobiłaś
               </xsl:when>
                 <xsl:otherwise>
                  zarobiłeś
               </xsl:otherwise>
               </xsl:choose>          
          
          <b><xsl:value-of select="/Data/EXERCISE/@salary"/></b>.</TD>
       </TR>
       <TR>
         <TD>Twój bieżący stan konta to  <b><xsl:value-of select="/Data/EXERCISE/@salaryTotal"/></b>.</TD>
       </TR>
       <TR>
         <TD>
           <xsl:choose>
             <xsl:when test="/Data/EXERCISE/@advancedLevelProgress =1">
                   Twój stopień trudności został podwyższony z <b><xsl:value-of select="/Data/EXERCISE/@advancedLevelStart"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@advancedLevelEnd"/></b>.
                </xsl:when>
             <xsl:when test="/Data/EXERCISE/@evaluationSheetProgress =-1">
                   Twój stopień trudności został obniżony z <b><xsl:value-of select="/Data/EXERCISE/@advancedLevelStart"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@advancedLevelEnd"/></b>.
                 </xsl:when>
             <xsl:otherwise>
                  Twój stopień trudności nie zmienił się i zostajesz na poziomie  <b><xsl:value-of select="/Data/EXERCISE/@advancedLevelEnd"/></b>.
                </xsl:otherwise>
           </xsl:choose>
         </TD>
       </TR>
     </TABLE>     
  </xsl:template>
  <xsl:template name="AdvancedTest">
    <TABLE border="0" class="N610_notyfication">
      <TR>
        <TD>
          <xsl:choose>
            <xsl:when test="/Data/EXERCISE/@start =1">
<b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoje wyniki wykonania początkowego testu umiejętności
               </xsl:when>
            <xsl:otherwise>
<b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoje wyniki wykonania końcowego testu umiejętności
               </xsl:otherwise>
          </xsl:choose>
          to <b><xsl:value-of select="/Data/EXERCISE/@pointsPercent"/></b> %.
        </TD>
      </TR>
      <TR>
        <TD>
               <xsl:choose>
                 <xsl:when test="/Data/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
               <b><xsl:value-of select="/Data/EXERCISE/@points"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@maxPoints"/></b> punktów możliwych.
        </TD>
      </TR>
    </TABLE>    
  </xsl:template>
  <xsl:template name="KnowledgeTest">
    <TABLE border="0" class="N610_notyfication">
      <TR>
        <TD>
          <xsl:choose>
            <xsl:when test="/Data/EXERCISE/@start =1">
<b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoje wyniki wykonania początkowego testu wiedzy
               </xsl:when>
            <xsl:otherwise>
<b><xsl:value-of select="/Data/EXERCISE/@name"/></b>, Twoje wyniki wykonania końcowego testu wiedzy
               </xsl:otherwise>
          </xsl:choose>
          to <b><xsl:value-of select="/Data/EXERCISE/@pointsPercent"/></b> %.
        </TD>
      </TR>
      <TR>
        <TD>
               <xsl:choose>
                 <xsl:when test="/Data/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
               <b><xsl:value-of select="/Data/EXERCISE/@points"/></b> na <b><xsl:value-of select="/Data/EXERCISE/@maxPoints"/></b> puntów możliwych.
        </TD>
      </TR>
         <TR>
        <TD>
          <xsl:choose>
            <xsl:when test="/Data/EXERCISE/@start =1">
Twój początkowy stopień trudności został ustalony na <b><xsl:value-of select="/Data/EXERCISE/@advancedLevel"/></b>.
               </xsl:when>
            <xsl:otherwise>
Twój końcowy stpień trudności to <b><xsl:value-of select="/Data/EXERCISE/@advancedLevel"/></b>.
               </xsl:otherwise>
          </xsl:choose>
        </TD>
      </TR>   
    </TABLE>
  </xsl:template>
  
  
  <xsl:template name="SummaryPageAPIMobile">
            <xsl:choose>
              <xsl:when test="/EXERCISE/@courseType =1">
                <xsl:call-template name="KnowledgeTestAPIMobile"/>
              </xsl:when>
              
              <xsl:when test="/EXERCISE/@courseType =2">
                <xsl:call-template name="AdvancedTestAPIMobile"/>
              </xsl:when>      
              
              <xsl:when test="/EXERCISE/@courseType =3">
                <xsl:call-template name="CompetenceCourseAPIMobile"/>
              </xsl:when>       
                            
              <xsl:when test="/EXERCISE/@courseType =5">
                <xsl:call-template name="CaseAPIMobile"/>
              </xsl:when>
            </xsl:choose>
  </xsl:template>
  
  <xsl:template name="CaseAPIMobile">
    <xsl:value-of select="/EXERCISE/@name"/>, Twoj wyniki uzyskany z rozwiązania zadania praktycznego to <xsl:value-of select="/EXERCISE/@pointsPercent"/> %.          
    <xsl:choose>
    <xsl:when test="/EXERCISE/@sex =1">
      Zaliczyłaś 
    </xsl:when>
    <xsl:otherwise>
      Zaliczyłeś
    </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="/EXERCISE/@points"/> na <xsl:value-of select="/EXERCISE/@maxPoints"/> możliwych zestawów ćwiczeń praktycznych.
  </xsl:template>
  <xsl:template name="CompetenceCourseAPIMobile">
          <xsl:value-of select="/EXERCISE/@name"/>, Twoje wyniki z wykonania ćwiczeń to <xsl:value-of select="/EXERCISE/@pointsPercent"/> %.         
               <xsl:choose>
                 <xsl:when test="/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
               <xsl:value-of select="/EXERCISE/@points"/> na <xsl:value-of select="/EXERCISE/@maxPoints"/> punktów możliwych.               
           <xsl:choose>
             <xsl:when test="/EXERCISE/@evaluationSheetProgress =1">
                   Gratuluje, 
                     <xsl:choose>
                       <xsl:when test="/EXERCISE/@sex =1">
                        zostałaś awansowana
                     </xsl:when>
                       <xsl:otherwise>
                        zostałeś awansowany
                     </xsl:otherwise>
                     </xsl:choose>
                   ze stanowiska <xsl:value-of select="/EXERCISE/@evaluationSheetStart"/> na <xsl:value-of select="/EXERCISE/@evaluationSheetEnd"/>.
                </xsl:when>
             <xsl:when test="/EXERCISE/@evaluationSheetProgress =-1">
                   Bardzo mi przykro ale 
                     <xsl:choose>
                       <xsl:when test="/EXERCISE/@sex =1">
                        zostałaś zdegradowana
                     </xsl:when>
                       <xsl:otherwise>
                        zostałeś zdegradowany
                     </xsl:otherwise>
                     </xsl:choose>
                   ze stanowiska <xsl:value-of select="/EXERCISE/@evaluationSheetStart"/> na <xsl:value-of select="/EXERCISE/@evaluationSheetEnd"/>.
                </xsl:when>
             <xsl:otherwise>
                  Twoje zaszeregowanie w firmie nie uległo zmianie i nadal piastujesz stanowisko <xsl:value-of select="/EXERCISE/@evaluationSheetEnd"/>.
                </xsl:otherwise>
           </xsl:choose>
         Za wykonanie tego zadania  
               <xsl:choose>
                 <xsl:when test="/EXERCISE/@sex =1">
                  zarobiłaś
               </xsl:when>
                 <xsl:otherwise>
                  zarobiłeś
               </xsl:otherwise>
               </xsl:choose>          
          
          <xsl:value-of select="/EXERCISE/@salary"/>.
         Twój bieżący stan konta to <xsl:value-of select="/EXERCISE/@salaryTotal"/>.
           <xsl:choose>
             <xsl:when test="/EXERCISE/@advancedLevelProgress =1">
                   Twój stopień trudności został podwyższony z <xsl:value-of select="/EXERCISE/@advancedLevelStart"/> na <xsl:value-of select="/EXERCISE/@advancedLevelEnd"/>.
                </xsl:when>
             <xsl:when test="/EXERCISE/@evaluationSheetProgress =-1">
                   Twój stopień trudności został obniżony z <xsl:value-of select="/EXERCISE/@advancedLevelStart"/> na <xsl:value-of select="/EXERCISE/@advancedLevelEnd"/>.
                 </xsl:when>
             <xsl:otherwise>
                  Twój stopień trudności nie zmienił się i zostajesz na poziomie <xsl:value-of select="/EXERCISE/@advancedLevelEnd"/>.
                </xsl:otherwise>
           </xsl:choose>    
  </xsl:template>
  <xsl:template name="AdvancedTestAPIMobile">
          <xsl:choose>
            <xsl:when test="/EXERCISE/@start =1">
                <xsl:value-of select="/EXERCISE/@name"/>, Twoje wyniki wykonania początkowego testu umiejętności
            </xsl:when>
            <xsl:otherwise>
            <xsl:value-of select="/EXERCISE/@name"/>, Twoje wyniki wykonania końcowego testu umiejętności
               </xsl:otherwise>
          </xsl:choose>
          to <xsl:value-of select="/EXERCISE/@pointsPercent"/> %.
               <xsl:choose>
                 <xsl:when test="/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
          <xsl:value-of select="/EXERCISE/@points"/> na <xsl:value-of select="/EXERCISE/@maxPoints"/> punktów możliwych.
  </xsl:template>
  <xsl:template name="KnowledgeTestAPIMobile">
          <xsl:choose>
            <xsl:when test="/EXERCISE/@start =1">
<xsl:value-of select="/EXERCISE/@name"/>, Twoje wyniki wykonania początkowego testu wiedzy
               </xsl:when>
            <xsl:otherwise>
<xsl:value-of select="/EXERCISE/@name"/>, Twoje wyniki wykonania końcowego testu wiedzy
               </xsl:otherwise>
          </xsl:choose>
          to <xsl:value-of select="/EXERCISE/@pointsPercent"/> %.
               <xsl:choose>
                 <xsl:when test="/EXERCISE/@sex =1">
                  Zdobyłaś 
               </xsl:when>
                 <xsl:otherwise>
                  Zdobyłeś
               </xsl:otherwise>
               </xsl:choose>
               <xsl:value-of select="/EXERCISE/@points"/> na <xsl:value-of select="/EXERCISE/@maxPoints"/> puntów możliwych.
          <xsl:choose>
            <xsl:when test="/EXERCISE/@start =1">
Twój początkowy stopień trudności został ustalony na <xsl:value-of select="/EXERCISE/@advancedLevel"/>.
               </xsl:when>
            <xsl:otherwise>
Twój końcowy stpień trudności to <xsl:value-of select="/EXERCISE/@advancedLevel"/>.
               </xsl:otherwise>
          </xsl:choose>
  </xsl:template>  
</xsl:stylesheet>