﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  
  <xsl:import href="AdministrationTemplates.xsl"/>

  <!-- Szerokosc kolumny FIXED --> 
  <xsl:variable name="fixedColumnWidth">
    <xsl:choose>
      <xsl:when test="/Data/Config/@IUA=1">            
        <xsl:choose>              
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassListPanel'">80</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePartPanel'">120</xsl:when>
              
          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentListPanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePartPanel'">120</xsl:when>
          
          <xsl:when test="/Data/Config/@AreaValue='NotLoaded'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='None'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePartPanel'">120</xsl:when>

          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>        
  </xsl:variable>
      
  <!-- Szerokosc kolumn w tabeli --> 
  <xsl:variable name="columnWidth">
    <xsl:choose>
      <xsl:when test="/Data/Config/@IUA=1">            
        <xsl:choose>              
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassListPanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorClassCompetencePartPanel'">120</xsl:when>

          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentListPanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='InstructorStudentCompetencePartPanel'">120</xsl:when>
          
          <xsl:when test="/Data/Config/@AreaValue='NotLoaded'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='None'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePanel'">120</xsl:when>
          <xsl:when test="/Data/Config/@AreaValue='StudentCompetencePartPanel'">120</xsl:when>
          
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>        
  </xsl:variable>
      
  <!-- JSy niezbedne do robienia scrollowanej tabelki -->
  <xsl:template name="bottomJS">
    <xsl:if test="/Data/Config/@IUA=1">
      <ScriptInlineBottom>
        jQuery(document).ready(function () {
          initMenu(0);
          $(".tableDiv").each(function() {
              var Id = $(this).get(0).id;
              var maintbheight = 450;
              var maintbwidth = 600;

              $("#" + Id + " .FixedTables").fixedTable({
                  width: maintbwidth,
                  height: maintbheight,
                  fixedColumns: 1,
                  classHeader: "fixedHead",
                  classFooter: "fixedFoot",
                  classColumn: "fixedColumn",
                  fixedColumnWidth: <xsl:value-of select="$fixedColumnWidth"/>,
                  columnWidth: <xsl:value-of select="$columnWidth"/>,
                  outerId: Id,
                  Contentbackcolor: "#FFFFFF",
                  Contenthovercolor: "#99CCFF", 
                  fixedColumnbackcolor:"#2E4F25", 
                  fixedColumnhovercolor:"#99CCFF"  
              });
          });
            
          fixBorderContainerHeight();
        });
        function _goto(url) {
          document.location=url;
        }
      </ScriptInlineBottom>
    </xsl:if>
  </xsl:template>
  
  <!-- Pojedynczy wiersz statystyki LABEL - VALUE -->
  <xsl:template name="sr">
    <xsl:param name="label" select="''"/>
    <xsl:param name="value" select="''"/>
    <tr>
      <td class="label"><xsl:value-of select="$label"/></td>
      <td class="value"><xsl:value-of select="$value"/></td>
    </tr>  
  </xsl:template>
  
  <!-- Pojedynczy wiersz statystyki z wartoscia procentowa LABEL - VALUE % -->
  <xsl:template name="srp">
    <xsl:param name="label" select="''"/>
    <xsl:param name="value" select="''"/>
    <tr>
      <td class="label"><xsl:value-of select="$label"/></td>
      <td class="value"><xsl:value-of select="$value"/> %</td>
    </tr>  
  </xsl:template>  
  
  <!-- Zdarzenie onclick z funkcja _goto(URL) -->
  <xsl:template name="onclick">
    <xsl:param name="area" select="''"/>
    <xsl:param name="params" select="''"/>
    <xsl:attribute name="onclick">_goto("<xsl:call-template name="admin_url"><xsl:with-param name="area" select="$area"/><xsl:with-param name="params" select="$params"/></xsl:call-template>");</xsl:attribute>
  </xsl:template>
    
  <!-- Template dla poziomów trudnosci -->
  <xsl:template match="AdvancedLevelList">
    <xsl:param name="isheader" select="0"/>
    <xsl:param name="isrow" select="0"/>
    <xsl:param name="issinglevalue" select="0"/>
    
    
    <xsl:choose>
      <xsl:when test="$issinglevalue=1">
        <xsl:choose>
          <xsl:when test="$isrow=1">
            <xsl:for-each select="./AdvancedLevel"><xsl:if test="@CountPercent>0"><tr><td class="label">Poziom trudności</td><td class="value"><xsl:value-of select="@Name"/></td></tr></xsl:if></xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="$isheader=0">
                <xsl:variable name="pt">
                  <xsl:for-each select="./AdvancedLevel"><xsl:if test="@CountPercent>0"><xsl:value-of select="@Name"/></xsl:if></xsl:for-each>
                </xsl:variable>
                <td><xsl:value-of select="$pt"/><xsl:comment> </xsl:comment></td>
              </xsl:when>
              <xsl:otherwise>
                <th>Poziom trudności</th>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$isrow=1">
            <xsl:for-each select="./AdvancedLevel"><tr><td class="label"><xsl:value-of select="@Name"/></td><td class="value"><xsl:value-of select="@CountPercent"/> %</td></tr></xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="$isheader=0">
                <xsl:for-each select="./AdvancedLevel"><td><xsl:value-of select="@CountPercent"/> %</td></xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:for-each select="./AdvancedLevel"><th><xsl:value-of select="@Name"/></th></xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
    
  </xsl:template>

  <!-- Panel prezentujacy liste statystyki dla klas albo studentow albo widok szczegolowy dla klasy/studenta -->
  <xsl:template match="StatisticList">
    <xsl:param name="isclassview" select="1"/>
    <xsl:choose>
      <xsl:when test="count(./Statistic) = 1">
        <xsl:choose>
          <xsl:when test="$isclassview=0">
            <xsl:for-each select="./Statistic">
              <xsl:variable name="aid" select="@CurrentAdvancedLevelID"/>
              <xsl:variable name="eid" select="@CurrentEvaluationSheetID"/>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Uczeń'"/><xsl:with-param name="value"><xsl:value-of select="@Forename"/><xsl:text> </xsl:text><xsl:value-of select="@Surename"/></xsl:with-param></xsl:call-template>
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Klasa'"/><xsl:with-param name="value" select="@ClassName"/></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Aktualne stanowisko'"/><xsl:with-param name="value"><xsl:value-of select="/Data/EvaluationSheetList/EvaluationSheet[@ID=$eid]/@Name"/></xsl:with-param></xsl:call-template>                
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Pensja'"/><xsl:with-param name="value" select="@SalaryAvg" /></xsl:call-template>
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Wynik z inwestycji w eduFarma'"/><xsl:with-param name="value" select="@GameCashAvg" /></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z ćwiczeń'"/><xsl:with-param name="value" select="@CompetencePointsPercent" /></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z praktyki'"/><xsl:with-param name="value" select="@CaseStudyPointsPercent"/></xsl:call-template>
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Średnia ilość powtórzeń'"/><xsl:with-param name="value" select="@CompetencePartDoneAvg"/></xsl:call-template>                                
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy początkowy'"/><xsl:with-param name="value" select="@KnowledgeTestStartPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy końcowy'"/><xsl:with-param name="value" select="@KnowledgeTestEndPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności początkowy'"/><xsl:with-param name="value" select="@AdvancedTestStartPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności końcowy'"/><xsl:with-param name="value" select="@AdvancedTestEndPointsPercent" /></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Aktualny poziom zaawansowania'"/><xsl:with-param name="value"><xsl:value-of select="/Data/AdvancedLevelList/AdvancedLevel[@ID=$aid]/@Name"/></xsl:with-param></xsl:call-template>                
                <xsl:apply-templates select="./AdvancedLevelList"><xsl:with-param name="isrow" select="1"/></xsl:apply-templates>
              </table>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="./Statistic">
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Klasa'"/><xsl:with-param name="value" select="@ClassName"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z ćwiczeń'"/><xsl:with-param name="value" select="@CompetencePointsPercent" /></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z praktyki'"/><xsl:with-param name="value" select="@CaseStudyPointsPercent"/></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy początkowy %'"/><xsl:with-param name="value" select="@KnowledgeTestStartPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy końcowy %'"/><xsl:with-param name="value" select="@KnowledgeTestEndPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności początkowy %'"/><xsl:with-param name="value" select="@AdvancedTestStartPointsPercent"/></xsl:call-template>
                <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności końcowy %'"/><xsl:with-param name="value" select="@AdvancedTestEndPointsPercent" /></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Średnia ilość powtórzeń'"/><xsl:with-param name="value" select="@CompetencePartDoneAvg"/></xsl:call-template>
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Średnia pensja'"/><xsl:with-param name="value" select="@SalaryAvg" /></xsl:call-template>
                <xsl:call-template name="sr"><xsl:with-param name="label" select="'Średni wynik z inwestycji w eduFarma'"/><xsl:with-param name="value" select="@GameCashAvg" /></xsl:call-template>
              </table>
              <table class="simplestatstable" cellspacing="0" cellpadding="0">
                <xsl:apply-templates select="./AdvancedLevelList"><xsl:with-param name="isrow" select="1"/></xsl:apply-templates>
              </table>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
        
        
      </xsl:when>
      <xsl:otherwise>
        <div id="tableDiv" class="tableDiv">
          <table class="FixedTables" id="statstable" cellspacing="0" cellpadding="0">
            <thead>
              <tr>
                <xsl:choose>
                  <xsl:when test="$isclassview=0">
                    <th>Uczeń</th>
                    <th>Klasa</th>
                    <th>Aktualny poziom zaawansowania</th>
                    <th>Aktualne stanowisko</th>
                    <th>Średni wynik z ćwiczeń</th>
                    <th>Średni wynik z praktyki</th>
                    <th>Średnia ilość powtórzeń</th>
                    <th>Test wiedzy początkowy %</th>
                    <th>Test wiedzy końcowy %</th>
                    <th>Test umiejętności początkowy %</th>
                    <th>Test umiejętności końcowy %</th>
                    <th>Pensja</th>
                    <th>Wynik z inwestycji w eduFarma</th>
                    <xsl:apply-templates select="./Statistic[position()=1]/AdvancedLevelList"><xsl:with-param name="isheader" select="1"/></xsl:apply-templates>
                  </xsl:when>
                  <xsl:otherwise>
                    <th>Klasa</th>
                    <th>Średni wynik z ćwiczeń</th>
                    <th>Średni wynik z praktyki</th>
                    <th>Średnia ilość powtórzeń</th>
                    <th>Test wiedzy początkowy %</th>
                    <th>Test wiedzy końcowy %</th>
                    <th>Test umiejętności początkowy %</th>
                    <th>Test umiejętności końcowy %</th>
                    <th>Średnia pensja</th>
                    <th>Średni wynik z inwestycji w eduFarma</th>
                    <xsl:apply-templates select="./Statistic[position()=1]/AdvancedLevelList"><xsl:with-param name="isheader" select="1"/></xsl:apply-templates>
                  </xsl:otherwise>
                </xsl:choose>                
              </tr>
            </thead>
            <tbody>
              <xsl:choose>
                <xsl:when test="$isclassview=0">
                  <xsl:for-each select="./Statistic">
                    <tr>
                      <td>
                        <xsl:call-template name="onclick"><xsl:with-param name="area" select="'instructorstudentcompetencepanel'"/><xsl:with-param name="params">studentid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                        <xsl:value-of select="@Forename"/><xsl:text> </xsl:text><xsl:value-of select="@Surename"/>
                      </td>
                      <td><xsl:value-of select="@ClassName"/></td>
                      <xsl:variable name="aid" select="@CurrentAdvancedLevelID"/>
                      <xsl:variable name="eid" select="@CurrentEvaluationSheetID"/>
                      <td><xsl:value-of select="/Data/AdvancedLevelList/AdvancedLevel[@ID=$aid]/@Name"/></td>
                      <td><xsl:value-of select="/Data/EvaluationSheetList/EvaluationSheet[@ID=$eid]/@Name"/></td>
                      <td><xsl:value-of select="@CompetencePointsPercent"/> %</td>
                      <td><xsl:value-of select="@CaseStudyPointsPercent"/> %</td>
                      <td><xsl:value-of select="@CompetencePartDoneAvg"/></td>
                      <td><xsl:value-of select="@KnowledgeTestStartPointsPercent"/> %</td>
                      <td><xsl:value-of select="@KnowledgeTestEndPointsPercent"/> %</td>
                      <td><xsl:value-of select="@AdvancedTestStartPointsPercent"/> %</td>
                      <td><xsl:value-of select="@AdvancedTestEndPointsPercent"/> %</td>
                      <td><xsl:value-of select="@SalaryAvg"/></td>
                      <td><xsl:value-of select="@GameCashAvg"/></td>
                      <xsl:apply-templates select="./AdvancedLevelList"/>
                    </tr>
                  </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:for-each select="./Statistic">
                    <tr>
                      <td>
                        <xsl:call-template name="onclick"><xsl:with-param name="area" select="'instructorclasscompetencepanel'"/><xsl:with-param name="params">classid=<xsl:value-of select="@ClassID"/></xsl:with-param></xsl:call-template>
                        <xsl:value-of select="@ClassName"/>
                      </td>
                      <td><xsl:value-of select="@CompetencePointsPercent"/> %</td>
                      <td><xsl:value-of select="@CaseStudyPointsPercent"/> %</td>
                      <td><xsl:value-of select="@CompetencePartDoneAvg"/></td>
                      <td><xsl:value-of select="@KnowledgeTestStartPointsPercent"/> %</td>
                      <td><xsl:value-of select="@KnowledgeTestEndPointsPercent"/> %</td>
                      <td><xsl:value-of select="@AdvancedTestStartPointsPercent"/> %</td>
                      <td><xsl:value-of select="@AdvancedTestEndPointsPercent"/> %</td>
                      <td><xsl:value-of select="@SalaryAvg"/></td>
                      <td><xsl:value-of select="@GameCashAvg"/></td>
                      <xsl:apply-templates select="./AdvancedLevelList"/>
                    </tr>
                  </xsl:for-each>
                </xsl:otherwise>
              </xsl:choose>              
            </tbody>          
          </table>
        </div>
        
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  <!-- Panel prezentujacy liste statystyki dla kompetencji glownych albo wybrana kompetencje glowna w kontekscie klasy/studenta -->
  <xsl:template match="CompetenceStatisticList">
    <xsl:param name="isclassview" select="1"/>
    <xsl:param name="isstudentarea" select="0"/>
    
    <xsl:choose>
      <xsl:when test="count(./CompetenceStatistic) = 1">
        
        <xsl:for-each select="./CompetenceStatistic">
          <table class="simplestatstable" cellspacing="0" cellpadding="0">
            <xsl:call-template name="sr"><xsl:with-param name="label" select="'Nazwa kompetencji'"/><xsl:with-param name="value" select="@Name"/></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z ćwiczeń'"/><xsl:with-param name="value" select="@CompetencePointsPercent"/></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z praktyki'"/><xsl:with-param name="value" select="@CaseStudyPointsPercent" /></xsl:call-template>
            <xsl:call-template name="sr"><xsl:with-param name="label" select="'Średnia ilość powtórzeń'"/><xsl:with-param name="value" select="@CompetencePartDoneAvg" /></xsl:call-template>
            <xsl:apply-templates select="./AdvancedLevelList"><xsl:with-param name="isrow" select="1"/></xsl:apply-templates>
          </table>
        </xsl:for-each>
        
      </xsl:when>
      <xsl:otherwise>
        <div id="tableDiv" class="tableDiv">
          <table class="FixedTables" id="statstable" cellspacing="0" cellpadding="0">
            <thead>
              <tr>
                <th>Nazwa kompetencji</th>
                <th>Średni wynik z ćwiczeń</th>
                <th>Średni wynik z praktyki</th>                
                <th>Średnia ilość powtórzeń</th>
                <xsl:apply-templates select="./CompetenceStatistic[position()=1]/AdvancedLevelList"><xsl:with-param name="isheader" select="1"/></xsl:apply-templates>
              </tr>
            </thead>
            <tbody>
              <xsl:for-each select="./CompetenceStatistic">
                <tr>
                  <td>
                    <xsl:if test="$isclassview=1">
                      <xsl:call-template name="onclick"><xsl:with-param name="area" select="'instructorclasscompetencepartpanel'"/><xsl:with-param name="params">classid=<xsl:value-of select="@ClassID"/>&amp;competenceid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                    </xsl:if>
                    <xsl:if test="$isclassview=0">
                      <xsl:variable name="area">
                        <xsl:choose>
                          <xsl:when test="$isstudentarea=1">studentcompetencepartpanel</xsl:when>
                          <xsl:otherwise>instructorstudentcompetencepartpanel</xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <xsl:call-template name="onclick"><xsl:with-param name="area" select="$area"/><xsl:with-param name="params">studentid=<xsl:value-of select="@StudentID"/>&amp;competenceid=<xsl:value-of select="@ID"/></xsl:with-param></xsl:call-template>
                    </xsl:if>
                    <xsl:value-of select="@DisplayValue"/>                  
                  </td>
                  <td><xsl:value-of select="@CompetencePointsPercent"/> %</td>
                  <td><xsl:value-of select="@CaseStudyPointsPercent"/> %</td>
                  <td><xsl:value-of select="@CompetencePartDoneAvg"/></td>
                  <xsl:apply-templates select="./AdvancedLevelList"/>
                </tr>
              </xsl:for-each>
            </tbody>          
          </table>
        </div>
        
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Panel prezentujacy liste statystyki dla kompetencji skladowych albo wybrana kompetencje skladowa w kontekscie klasy/studenta -->
  <xsl:template match="CompetencePartStatisticList">
    <xsl:param name="isclassview" select="1"/>
    
    <xsl:choose>
      <xsl:when test="count(./CompetencePartStatistic) = 1">
        
        <xsl:for-each select="./CompetencePartStatistic">
          <table class="simplestatstable" cellspacing="0" cellpadding="0">
            <xsl:call-template name="sr"><xsl:with-param name="label" select="'Nazwa kompetencji'"/><xsl:with-param name="value" select="@Name"/></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z ćwiczeń'"/><xsl:with-param name="value" select="@CompetencePointsPercent" /></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Średni wynik z praktyki'"/><xsl:with-param name="value" select="@CaseStudyPointsPercent" /></xsl:call-template>
          </table>
          <table class="simplestatstable" cellspacing="0" cellpadding="0">
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy początkowy %'"/><xsl:with-param name="value" select="@KnowledgeTestStartMaxPointsPercent" /></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test wiedzy końcowy %'"/><xsl:with-param name="value" select="@KnowledgeTestEndPointsPercent" /></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności początkowy %'"/><xsl:with-param name="value" select="@AdvancedTestStartPointsPercent" /></xsl:call-template>
            <xsl:call-template name="srp"><xsl:with-param name="label" select="'Test umiejętności końcowy %'"/><xsl:with-param name="value" select="@AdvancedTestEndMaxPointsPercent" /></xsl:call-template>
          </table>
          <table class="simplestatstable" cellspacing="0" cellpadding="0">
            <xsl:call-template name="sr"><xsl:with-param name="label" select="'Ilość powtórzeń'"/><xsl:with-param name="value" select="@ResetCount" /></xsl:call-template>
            <xsl:call-template name="sr"><xsl:with-param name="label" select="'Pensja'"/><xsl:with-param name="value" select="@Salary" /></xsl:call-template>
          </table>
          <table class="simplestatstable" cellspacing="0" cellpadding="0">
            <xsl:apply-templates select="./AdvancedLevelList"><xsl:with-param name="isrow" select="1"/><xsl:with-param name="issinglevalue"><xsl:choose><xsl:when test="$isclassview=0">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:with-param></xsl:apply-templates>
          </table>
        </xsl:for-each>
        
      </xsl:when>
      <xsl:otherwise>
        <div id="tableDiv" class="tableDiv">
          <table class="FixedTables" id="statstable" cellspacing="0" cellpadding="0">
            <thead>
              <tr>
                <th>Nazwa kompetencji</th>
                <th>Wynik z ćwiczeń</th>
                <th>Wynik z praktyki</th>                
                <th>Ilość powtórzeń</th>
                <th>Pensja</th>
                <xsl:apply-templates select="./CompetencePartStatistic[position()=1]/AdvancedLevelList"><xsl:with-param name="isheader" select="1"/><xsl:with-param name="issinglevalue"><xsl:choose><xsl:when test="$isclassview=0">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:with-param></xsl:apply-templates>
              </tr>
            </thead>
            <tbody>
              <xsl:for-each select="./CompetencePartStatistic">
                <tr>
                  <td>
                    <xsl:value-of select="@DisplayValue"/>
                  </td>
              
                  <td><xsl:value-of select="@CompetencePointsPercent"/> %</td>
                  <td><xsl:value-of select="@CaseStudyPointsPercent"/> %</td>
                  
                  <td><xsl:value-of select="@ResetCount"/></td>
                  <td><xsl:value-of select="@Salary"/></td>
                  <xsl:apply-templates select="./AdvancedLevelList"><xsl:with-param name="issinglevalue"><xsl:choose><xsl:when test="$isclassview=0">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:with-param></xsl:apply-templates>
                </tr>
              </xsl:for-each>
            </tbody>          
          </table>
        </div>
        
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Panel prezentujacy ranking 1 studentow w widoku albo studenta albo instruktora -->
  <xsl:template name="Ranking1">
    <xsl:param name="isstudent" select="1"/>

    <xsl:variable name="maxsalary">
      <xsl:for-each select="//RankingStudent/@Salary">
        <xsl:sort data-type="number" order="descending"/>
        <xsl:if test="position()=1"><xsl:value-of select="."/></xsl:if>
      </xsl:for-each>      
    </xsl:variable>

    <xsl:variable name="max"><xsl:choose><xsl:when test="$maxsalary=0 or string-length($maxsalary)=0">1</xsl:when><xsl:otherwise><xsl:value-of select="$maxsalary"/></xsl:otherwise></xsl:choose></xsl:variable>
    
    <table class="rankingtable" cellspacing="0" cellpadding="0" width="90%">
      <thead>
        <tr>
          <th colspan="4" class="rankingtitle">Ranking klasy według pensji</th>
        </tr>
        <tr>
          <th>Uczeń</th>
          <th>Stanowisko</th>
          <th>Pensja</th>                
          <th class="rankingheader"><xsl:comment> </xsl:comment></th>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="//RankingStudent">
          <xsl:sort data-type="number" order="descending" select="@Salary"/>
          <tr>
            <td><xsl:value-of select="@DisplayValue"/></td>
            <td><xsl:value-of select="@CurrentEvaluationSheetName"/></td>
            <td><xsl:value-of select="@Salary"/></td>
            <xsl:variable name="width" select="(@Salary div $max) * 100"/>
            <td class="rankingcell"><div class="rankingbar" style="width:{$width}%;"><xsl:comment> </xsl:comment></div></td>
          </tr>
        </xsl:for-each>
      </tbody>          
    </table>
    
  </xsl:template>

  <!-- Panel prezentujacy ranking 2 studentow w widoku albo studenta albo instruktora -->
  <xsl:template name="Ranking2">
    <xsl:param name="isstudent" select="1"/>

    <xsl:variable name="maxsalary">
      <xsl:for-each select="//RankingStudent/@GameCash">
        <xsl:sort data-type="number" order="descending"/>
        <xsl:if test="position()=1"><xsl:value-of select="."/></xsl:if>
      </xsl:for-each>      
    </xsl:variable>

    <xsl:variable name="max"><xsl:choose><xsl:when test="$maxsalary=0 or string-length($maxsalary)=0">1</xsl:when><xsl:otherwise><xsl:value-of select="$maxsalary"/></xsl:otherwise></xsl:choose></xsl:variable>
    
    <table class="rankingtable" cellspacing="0" cellpadding="0" width="90%">
      <thead>
        <tr>
          <th colspan="4" class="rankingtitle">Ranking klasy według środków eduFarma</th>
        </tr>
        <tr>
          <th>Uczeń</th>
          <th>Stanowisko</th>
          <th>Środki z eduFarma</th>
          <th class="rankingheader"><xsl:comment> </xsl:comment></th>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="//RankingStudent">
          <xsl:sort data-type="number" order="descending" select="@GameCash"/>
          <tr>
            <td><xsl:value-of select="@DisplayValue"/></td>
            <td><xsl:value-of select="@CurrentEvaluationSheetName"/></td>
            <td><xsl:value-of select="@GameCash"/></td>
            <xsl:variable name="width" select="(@GameCash div $max) * 100"/>
            <td class="rankingcell"><div class="rankingbar" style="width:{$width}%;"><xsl:comment> </xsl:comment></div></td>
          </tr>
        </xsl:for-each>
      </tbody>          
    </table>
    
  </xsl:template>
  
  <!-- Panel prezentujacy ranking 3 studentow w widoku albo studenta albo instruktora -->
  <xsl:template name="Ranking3">
    <xsl:param name="isstudent" select="1"/>

    <xsl:variable name="maxsalary">
      <xsl:for-each select="//RankingStudent/@Salary">
        <xsl:sort data-type="number" order="descending"/>
        <xsl:if test="position()=1"><xsl:value-of select="."/></xsl:if>
      </xsl:for-each>      
    </xsl:variable>

    <xsl:variable name="max"><xsl:choose><xsl:when test="$maxsalary=0 or string-length($maxsalary)=0">1</xsl:when><xsl:otherwise><xsl:value-of select="$maxsalary"/></xsl:otherwise></xsl:choose></xsl:variable>
    
    <table class="rankingtable" cellspacing="0" cellpadding="0">
      <thead>
        <tr>
          <th colspan="3" class="rankingtitle">Ranking klasy według stanowisk</th>
        </tr>
        <tr>
          <th>Uczeń</th>
          <th>Pensja</th>                
          <th>Środki z eduFarma</th>
        </tr>
      </thead>
      
      <xsl:for-each select="//EvaluationSheet">
        <xsl:sort data-type="number" order="descending" select="@Weight"/>
        <xsl:variable name="id" select="@ID"/>
        <xsl:if test="count(//RankingStudent[@CurrentEvaluationSheetID=$id])>0">
          <thead>
            <tr><td colspan="3"><xsl:comment> </xsl:comment></td></tr>
            <tr>
              <th colspan="3" class="rankingsubtitle"><xsl:value-of select="@Name"/></th>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="//RankingStudent[@CurrentEvaluationSheetID=$id]">
              <xsl:sort data-type="text" order="ascending" select="@DisplayValue"/>
              <tr>
                <td><xsl:value-of select="@DisplayValue"/></td>
                <td><xsl:value-of select="@Salary"/></td>
                <td><xsl:value-of select="@GameCash"/></td>
              </tr>
            </xsl:for-each>
          </tbody>          
        </xsl:if>
      </xsl:for-each>
      
    </table>
    
  </xsl:template>

</xsl:stylesheet>