<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="../ResorcesCommon/ELearning_Utils.xsl"/>
  <xsl:import href="./XSLTemplate/CommonTemplates.xsl"/>
  <xsl:import href="./XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}N610_config.js"/>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}N610.js"/>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/CommonPath}js/{/Data/Config/ResoursesVersion}raphael.min.js"/>
      </ScriptTopList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>

      <ScriptInlineBottom>
        jQuery(document).ready(function () {
          initMenu(<xsl:value-of select="/Data/PageType"/>);
          <xsl:if test="/Data/Course/@ID != '' and /Data/Course/@firstUnitID != '' and /Data/Course/@firstExerciseID != '' and /Data/ContextID != ''">
            <![CDATA[loadExercise(']]><xsl:value-of select="/Data/Config/Domain"/><![CDATA[',']]><xsl:value-of select="/Data/ContextID"/><![CDATA[',']]><xsl:value-of select="/Data/Course/@ID"/><![CDATA[',']]><xsl:value-of select="/Data/Course/@firstUnitID"/><![CDATA[',']]><xsl:value-of select="/Data/Course/@firstExerciseID"/><![CDATA[',']]><xsl:value-of select="/Data/Course/@ModeID"/><![CDATA[');]]>
          </xsl:if>
        
        });
      </ScriptInlineBottom>

      <HTMLInline name="{/Data/Config/Name}">
        <div class="learning_content">
          <xsl:choose>
            <xsl:when test="$isStudent=1 or $isInstructor=1">
              <xsl:if test="/Data/PageType!=0">
                <xsl:call-template name="tabBreadcrumb"/>
              </xsl:if>
              <xsl:choose>
                <xsl:when test="/Data/PageType=0">
                  <!-- Panel nauki - glowny -->
                  <xsl:call-template name="Render_Panel_Main"/>
                </xsl:when>
                <xsl:when test="/Data/PageType=1">
                  <!-- Panel kompetencji - lita kursow dla danej kompetencji -->
                  <xsl:call-template name="Render_Panel_Competence"/>
                </xsl:when>
                <xsl:when test="/Data/PageType=2">
                  <!-- Panel kompetencji skłądowej - wyświetla opis kompetencji składowej oraz Case, COurse, Theory -->
                  <xsl:call-template name="Render_Panel_CompetencePart"/>
                </xsl:when>
                <xsl:when test="/Data/PageType=3">
                  <!-- Panel kursu - wyswietla juz jakis konkretny kurs -->
                  <xsl:call-template name="Render_Panel_Course"/>
                </xsl:when>
                <xsl:when test="/Data/PageType=4">
                  <!-- Panel eduFarma -->
                  <xsl:call-template name="Render_Panel_eduFarma"/>
                </xsl:when>
                <xsl:otherwise>
                  <TABLE border="0" class="table_summary">
                    <TR>
                      <TD rowspan="4">
                        <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/lock_128.png"/>
                      </TD>
                      <TD>
                        <SPAN class="course_summary">Przepraszamy ale nie masz dostępu do tego materiału.</SPAN>
                      </TD>
                    </TR>
                  </TABLE>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <TABLE border="0" class="table_summary">
                <TR>
                  <TD rowspan="4">
                    <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/log_128.png"/>
                  </TD>
                  <TD>
                    <SPAN class="course_summary">Musisz się zalogować jako Pracownik lub Kadrowiec.</SPAN>
                  </TD>
                </TR>
              </TABLE>              
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>

  <xsl:template name="Render_Panel_Main">
    <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
    <div class="learningbox">

      <table cellspacing="0" cellpadding="0" class="panelnauczania">
        <tr>
          <td class="col1">
                <xsl:call-template name="continue_learn">
                  <xsl:with-param name="node" select="/Data" />                  
                </xsl:call-template>              
            
            <xsl:if test="string-length(/Data/StartKnowledgeTestCourse/@ID)>0">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="/Data/StartKnowledgeTestCourse/@ImageURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />courseid=<xsl:value-of select="/Data/StartKnowledgeTestCourse/@ID"/>&amp;pt=3&amp;coursetype=10&amp;contextid=<xsl:value-of select="/Data/StartKnowledgeTestCourse/@ContextID"/></xsl:with-param>
                <xsl:with-param name="title" select="/Data/StartKnowledgeTestCourse/@Title" />
              </xsl:call-template>
            </xsl:if>

            <xsl:if test="string-length(/Data/StartAdvancedTestCourse/@ID)>0">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="/Data/StartAdvancedTestCourse/@ImageURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />courseid=<xsl:value-of select="/Data/StartAdvancedTestCourse/@ID"/>&amp;pt=3&amp;coursetype=11&amp;contextid=<xsl:value-of select="/Data/StartAdvancedTestCourse/@ContextID"/></xsl:with-param>
                <xsl:with-param name="title" select="/Data/StartAdvancedTestCourse/@Title" />
              </xsl:call-template>
            </xsl:if>
            <div class="cls avatar">
              <img src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/mainavatar.png" title="" alt="" border="0" />
            </div>
          </td>
          <td class="col2">
            <xsl:for-each select="/Data/CompetenceList/Competence">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="@ImageFileURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="@ID"/>&amp;pt=1</xsl:with-param>
                <xsl:with-param name="title" select="@Name" />
              </xsl:call-template>
            </xsl:for-each>
            
            <xsl:if test="string-length(/Data/eduFarma/@eduFarmaAddress)>0">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="/Data/eduFarma/@eduFarmaImageURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />pt=4</xsl:with-param>
                <xsl:with-param name="title" select="'eduFarma'" />
              </xsl:call-template>
            </xsl:if>
          </td>
          <td class="col3">
            <xsl:if test="string-length(/Data/EndKnowledgeTestCourse/@ID)>0">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="/Data/EndKnowledgeTestCourse/@ImageURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />courseid=<xsl:value-of select="/Data/EndKnowledgeTestCourse/@ID"/>&amp;pt=3&amp;coursetype=12&amp;contextid=<xsl:value-of select="/Data/EndKnowledgeTestCourse/@ContextID"/></xsl:with-param>
                <xsl:with-param name="title" select="/Data/EndKnowledgeTestCourse/@Title" />
              </xsl:call-template>
            </xsl:if>

            <xsl:if test="string-length(/Data/EndAdvancedTestCourse/@ID)>0">
              <xsl:call-template name="named_banner">
                <xsl:with-param name="image_url" select="/Data/EndAdvancedTestCourse/@ImageURL"/>
                <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />courseid=<xsl:value-of select="/Data/EndAdvancedTestCourse/@ID"/>&amp;pt=3&amp;coursetype=13&amp;contextid=<xsl:value-of select="/Data/EndAdvancedTestCourse/@ContextID"/></xsl:with-param>
                <xsl:with-param name="title" select="/Data/EndAdvancedTestCourse/@Title" />
              </xsl:call-template>
            </xsl:if>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>
  
  <xsl:template name="Render_Panel_Competence">
    <div class="learningbox">
      <h1><xsl:value-of select="/Data/Competence/@Name"/></h1>
      <xsl:if test="string-length(/Data/Competence/@ImageFileURL)>0">
        <div><img src="{/Data/Competence/@ImageFileURL}" border="0" title="{/Data/Competence/@Name}" /></div>
      </xsl:if>
      
      <xsl:if test="string-length(/Data/CompetenceDescriptionID) > 0">
        <div class="description fontdescription"><HTMLCode name="{/Data/CompetenceDescriptionID}"/></div>
      </xsl:if>

      <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
      <xsl:for-each select="/Data/CompetencePartList/CompetencePart">
        <xsl:call-template name="named_banner">
          <xsl:with-param name="image_url" select="@ImageFileURL"/>
          <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="/Data/Competence/@ID"/>&amp;partid=<xsl:value-of select="@ID"/>&amp;pt=2</xsl:with-param>
          <xsl:with-param name="title" select="@Name" />
        </xsl:call-template>
      </xsl:for-each>
    </div>
  </xsl:template>
  
  <xsl:template name="Render_Panel_CompetencePart">
    <div class="learningbox">
      <h1><xsl:value-of select="/Data/CompetencePart/@Name"/></h1>
      <xsl:if test="string-length(/Data/CompetencePart/@ImageFileURL)>0">
        <div><img src="{/Data/CompetencePart/@ImageFileURL}" border="0" title="{/Data/CompetencePart/@Name}" /></div>
      </xsl:if>
      
      <xsl:if test="string-length(/Data/CompetencePartDescriptionID) > 0">
        <div class="description fontdescription"><HTMLCode name="{/Data/CompetencePartDescriptionID}"/></div>
      </xsl:if>

      <div class="cls" style="width: 100%; height: 20px;"><xsl:comment> </xsl:comment></div>
      
      <xsl:if test="/Data/CourseTheory/@ID > 0">
        <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
        <xsl:call-template name="named_banner">
          <xsl:with-param name="image_url" select="/Data/CompetencePart/@CompetenceTheoryImageFileURL"/>
          <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="/Data/Competence/@ID"/>&amp;partid=<xsl:value-of select="/Data/CompetencePart/@ID"/>&amp;courseid=<xsl:value-of select="/Data/CourseTheory/@ID"/>&amp;pt=3&amp;coursetype=3&amp;contextid=<xsl:value-of select="/Data/CompetencePart/@ID"/></xsl:with-param>
          <xsl:with-param name="title" select="/Data/CourseTheory/@Title" />
        </xsl:call-template>
      </xsl:if>

      <xsl:if test="/Data/CourseCourse/@ID > 0">
        <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
        <xsl:call-template name="named_banner">
          <xsl:with-param name="image_url" select="/Data/CompetencePart/@CompetenceCourseImageFileURL"/>
          <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="/Data/Competence/@ID"/>&amp;partid=<xsl:value-of select="/Data/CompetencePart/@ID"/>&amp;courseid=<xsl:value-of select="/Data/CourseCourse/@ID"/>&amp;pt=3&amp;coursetype=2&amp;contextid=<xsl:value-of select="/Data/CompetencePart/@ID"/></xsl:with-param>
          <xsl:with-param name="title" select="/Data/CourseCourse/@Title" />
        </xsl:call-template>
      </xsl:if>

      <xsl:if test="/Data/CourseCase/@ID > 0">
        <xsl:variable name="sign"><xsl:choose><xsl:when test="contains(/Data/Config/URL, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable>
        <xsl:call-template name="named_banner">
          <xsl:with-param name="image_url" select="/Data/CourseCase/@CaseImageFileURL"/>
          <xsl:with-param name="link"><xsl:value-of select="/Data/Config/URL" /><xsl:value-of select="$sign" />competenceid=<xsl:value-of select="/Data/Competence/@ID"/>&amp;partid=<xsl:value-of select="/Data/CompetencePart/@ID"/>&amp;courseid=<xsl:value-of select="/Data/CourseCase/@ID"/>&amp;pt=3&amp;coursetype=1&amp;contextid=<xsl:value-of select="/Data/CompetencePart/@ID"/></xsl:with-param>
          <xsl:with-param name="title" select="/Data/CourseCase/@Title" />
        </xsl:call-template>
      </xsl:if>
      
    </div>
  </xsl:template>
  
  <xsl:template name="Render_Panel_Course">
    <xsl:call-template name="ELearning" />
  </xsl:template>
  
  <xsl:template name="Render_Panel_eduFarma">
    <div class="fcontainer">
      <xsl:choose>
      <xsl:when test="/Data/eduFarma/@accessGranted = 1">
      <div id="EduFarmDiv">
        <a href="http://www.adobe.com/go/getflashplayer">
				  <img src="http://www.adobe.com/images/shared/download_buttons/get_flash_player.gif" alt="Get Adobe Flash player" />
			  </a>
      </div>
      <div>
        <script type="text/javascript">
			    var flashvars = {};
			    var params = {};
			    flashvars.id = "<xsl:value-of select="/Data/Config/@UserID"/>";
			    flashvars.sid = "<xsl:value-of select="/Data/Config/@SessionUID"/>";
			    var attributes = {};
			    swfobject.embedSWF("<xsl:value-of select="/Data/eduFarma/@eduFarmaAddress"/>?nocache=<xsl:value-of select="/Data/Config/Ticks"/>", "EduFarmDiv", "800", "600", "10.0.0", false, flashvars, params, attributes);
		    </script>        
      </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="N610_notyfication message_corner">
      <TABLE border="0" class="N610_notyfication">
        <TR>
          <TD>
            <IMG src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/610/redirect.png"/>
          </TD>
          <TD style="vertical-align:middle">
            Gra zostanie odblokowana gdy przerobisz całość materiału.<br/>
            <b>Proszę kontynuuj naukę zgodnie z harmonogramem.</b>
          </TD>          
        </TR>
        <TR>
          <TD colspan="2"  align="center">
                <xsl:call-template name="continue_learn">
                  <xsl:with-param name="node" select="/Data/eduFarma" />
                  <xsl:with-param name="width" select="200" />                  
                </xsl:call-template>               
          </TD>
        </TR>        
      </TABLE>
        </div>        
      </xsl:otherwise>
    </xsl:choose> 

    </div>  
  </xsl:template>
  
  <xsl:variable name="isStudent">
    <xsl:choose>
      <xsl:when test="/Data/Student/@ID>0 and /Data/UserStudent=1">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="isInstructor">
    <xsl:choose>
      <xsl:when test="/Data/Instructor/@ID>0 and /Data/UserInstructor=1">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Display Name - czyli albo name albo abbreviation -->
  <xsl:template name="dn">
    <xsl:param name="name" select="''"/>
    <xsl:param name="ab" select="''"/>
    <xsl:choose><xsl:when test="string-length($ab)=0"><xsl:value-of select="$name"/></xsl:when><xsl:otherwise><xsl:value-of select="$ab"/></xsl:otherwise></xsl:choose>
  </xsl:template>
  
  <xsl:template name="tabBreadcrumb">
      <div class="learning_menu_container rounded_border_top15">
          <xsl:choose>
            <xsl:when test="/Data/PageType=0">
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                Plan nauczania
              </div>
              <div class="learning_menu_bread1_arrow_t"><xsl:comment> </xsl:comment></div>
            </xsl:when>

            <xsl:when test="/Data/PageType=1">
              <xsl:variable name="panelUrl">
                <xsl:call-template name="extendUrl">
                  <xsl:with-param name="url">
                    <xsl:value-of select="/Data/Config/URL"/>
                  </xsl:with-param>
                  <xsl:with-param name="paramValue">
                    rv=<xsl:value-of select="/Data/RandomValue/."/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                <a href="{$panelUrl}">Plan nauczania</a>
              </div>
              <div class="learning_menu_bread1_arrow"><xsl:comment> </xsl:comment></div>

              <div class="learning_menu_bread2 fontlearningmenu">
                <xsl:value-of select="/Data/Competence/@Name"/><xsl:value-of select="$CourseType"/>
                <!--<xsl:call-template name="dn"><xsl:with-param name="name" select="/Data/Competence/@Name"/><xsl:with-param name="ab" select="/Data/Competence/@Abbreviation"/></xsl:call-template>-->
                <xsl:comment> </xsl:comment>
              </div>
              <div class="learning_menu_bread2_arrow_t"><xsl:comment> </xsl:comment></div>
            </xsl:when>

            <xsl:when test="/Data/PageType=2">
              <xsl:variable name="panelUrl">
                <xsl:call-template name="extendUrl">
                  <xsl:with-param name="url"><xsl:value-of select="/Data/Config/URL"/></xsl:with-param>
                  <xsl:with-param name="paramValue">rv=<xsl:value-of select="/Data/RandomValue/."/></xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                <a href="{$panelUrl}">Plan nauczania</a>
              </div>
              <xsl:if test="/Data/Competence/@ID>0">
                <xsl:variable name="competenceUrl">
                  <xsl:call-template name="extendUrl">
                    <xsl:with-param name="url">
                      <xsl:value-of select="/Data/Config/URL"/>
                    </xsl:with-param>
                    <xsl:with-param name="paramValue">rv=<xsl:value-of select="/Data/RandomValue/."/>&amp;pt=1&amp;competenceid=<xsl:value-of select="/Data/Competence/@ID"/></xsl:with-param>
                  </xsl:call-template>
                </xsl:variable>
                <div class="learning_menu_bread1_arrow"><xsl:comment> </xsl:comment></div>
                <div class="learning_menu_bread2 fontlearningmenu">
                  <a href="{$competenceUrl}"><xsl:value-of select="/Data/Competence/@Name"/><!--<xsl:call-template name="dn"><xsl:with-param name="name" select="/Data/Competence/@Name"/><xsl:with-param name="ab" select="/Data/Competence/@Abbreviation"/></xsl:call-template>--></a>
                </div>
                <div class="learning_menu_bread2_arrow_t"><xsl:comment> </xsl:comment></div>
              </xsl:if>
              <xsl:if test="string-length(/Data/Competence/@ID)=0">
                <div class="learning_menu_bread1_arrow_t"><xsl:comment> </xsl:comment></div>
              </xsl:if>
              <div class="learning_menu_bread3 fontlearningmenu">
                <xsl:value-of select="/Data/CompetencePart/@Name"/><xsl:value-of select="$CourseType"/>
                <!--<xsl:call-template name="dn"><xsl:with-param name="name" select="/Data/CompetencePart/@Name"/><xsl:with-param name="ab" select="/Data/CompetencePart/@Abbreviation"/></xsl:call-template>-->
                <xsl:comment> </xsl:comment>
              </div>
            </xsl:when>
            
            <xsl:when test="(/Data/PageType=3) and (/Data/CourseType=10 or /Data/CourseType=11 or /Data/CourseType=12 or /Data/CourseType=13)">
              <xsl:variable name="panelUrl">
                <xsl:call-template name="extendUrl">
                  <xsl:with-param name="url">
                    <xsl:value-of select="/Data/Config/URL"/>
                  </xsl:with-param>
                  <xsl:with-param name="paramValue">
                    rv=<xsl:value-of select="/Data/RandomValue/."/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                <a href="{$panelUrl}">Plan nauczania</a>
              </div>
              <div class="learning_menu_bread1_arrow"><xsl:comment> </xsl:comment></div>

              <div class="learning_menu_bread2 fontlearningmenu">
                <xsl:value-of select="/Data/Course/@Title"/><xsl:value-of select="$CourseType"/>
                <xsl:comment> </xsl:comment>
              </div>
              <div class="learning_menu_bread2_arrow_t"><xsl:comment> </xsl:comment></div>
            </xsl:when>

            <xsl:when test="/Data/PageType=3">
              <xsl:variable name="panelUrl">
                <xsl:call-template name="extendUrl">
                  <xsl:with-param name="url"><xsl:value-of select="/Data/Config/URL"/></xsl:with-param>
                  <xsl:with-param name="paramValue">rv=<xsl:value-of select="/Data/RandomValue/."/></xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                <a href="{$panelUrl}">Plan nauczania</a>
              </div>
              <xsl:if test="/Data/Competence/@ID>0">
                <xsl:variable name="competenceUrl">
                  <xsl:call-template name="extendUrl">
                    <xsl:with-param name="url">
                      <xsl:value-of select="/Data/Config/URL"/>
                    </xsl:with-param>
                    <xsl:with-param name="paramValue">rv=<xsl:value-of select="/Data/RandomValue/."/>&amp;pt=1&amp;competenceid=<xsl:value-of select="/Data/Competence/@ID"/></xsl:with-param>
                  </xsl:call-template>
                </xsl:variable>
                <div class="learning_menu_bread1_arrow"><xsl:comment> </xsl:comment></div>
                <div class="learning_menu_bread2 fontlearningmenu">
                  <a href="{$competenceUrl}"><xsl:value-of select="/Data/Competence/@Name"/><!--<xsl:call-template name="dn"><xsl:with-param name="name" select="/Data/Competence/@Name"/><xsl:with-param name="ab" select="/Data/Competence/@Abbreviation"/></xsl:call-template>--></a>
                </div>
                <div class="learning_menu_bread2_arrow_t"><xsl:comment> </xsl:comment></div>
              </xsl:if>
              <xsl:if test="string-length(/Data/CompetencePart/@ID)>0">
                <xsl:variable name="competencePartUrl">
                  <xsl:call-template name="extendUrl">
                    <xsl:with-param name="url">
                      <xsl:value-of select="/Data/Config/URL"/>
                    </xsl:with-param>
                    <xsl:with-param name="paramValue">rv=<xsl:value-of select="/Data/RandomValue/."/>&amp;pt=2&amp;competenceid=<xsl:value-of select="/Data/Competence/@ID"/>&amp;partid=<xsl:value-of select="/Data/CompetencePart/@ID"/></xsl:with-param>
                  </xsl:call-template>
                </xsl:variable>              
                <div class="learning_menu_bread3 fontlearningmenu">
                  <a href="{$competencePartUrl}"><xsl:value-of select="/Data/CompetencePart/@Name"/><xsl:value-of select="$CourseType"/><!--<xsl:call-template name="dn"><xsl:with-param name="name" select="/Data/CompetencePart/@Name"/><xsl:with-param name="ab" select="/Data/CompetencePart/@Abbreviation"/></xsl:call-template><xsl:value-of select="$CourseType"/>--></a>
                  <xsl:comment> </xsl:comment>
                </div>
              </xsl:if>
            </xsl:when>
            
            <xsl:when test="/Data/PageType=4">
              <xsl:variable name="panelUrl">
                <xsl:call-template name="extendUrl">
                  <xsl:with-param name="url">
                    <xsl:value-of select="/Data/Config/URL"/>
                  </xsl:with-param>
                  <xsl:with-param name="paramValue">
                    rv=<xsl:value-of select="/Data/RandomValue/."/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <div class="learning_menu_bread1 fontlearningmenu rounded_border_topleft15">
                <a href="{$panelUrl}">Plan nauczania</a>
              </div>
              <div class="learning_menu_bread1_arrow"><xsl:comment> </xsl:comment></div>

              <div class="learning_menu_bread2 fontlearningmenu">eduFarma</div>
              <div class="learning_menu_bread2_arrow_t"><xsl:comment> </xsl:comment></div>
            </xsl:when>
            
          </xsl:choose>
        <xsl:comment> </xsl:comment>
      </div>
  </xsl:template>

  <xsl:template name="CourseStat">
    <xsl:param name="CourseNode"/>
    <xsl:param name="IsActive" select="0"/>
    <xsl:if test="string-length($CourseNode/Stats/@IsStarted)>0">
      <div class="course_legend">
        <div class="course_status_img">
          <xsl:if test="$IsActive=0">
            <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/lock_24.png" alt="Kurs zablokowany" title="Kurs zablokowany"/>
          </xsl:if>
          <xsl:if test="$IsActive=1">
            <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/unlock_24.png" alt="Kurs aktywny" title="Kurs aktywny"/>
          </xsl:if>
        </div>
        <xsl:if test="$CourseNode/@CousreTypeID!=6">
          <xsl:if test="$CourseNode/Stats/@IsRefresh=1">
            <div class="course_status">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/rerefresh_24.png" alt="Kurs powtórkowy" title="Kurs powtórkowy"/>
              <span class="course_label">Powtórka</span>
            </div>
            <div class="course_ocena">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/diplom_two_24.png" alt="Ocena kursu" title="Ocena kursu"/>
              <span class="course_label">
                Ocena:<xsl:value-of select="$CourseNode/Stats/@Evaluation"/><xsl:comment></xsl:comment>
              </span>
            </div>
            <xsl:if test="($CourseNode/@CousreTypeID!=4)">
              <div class="course_punkty">
                <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/stats.png" alt="Liczba punktów" title="Liczba punktów"/>
                <span class="course_label">
                  Punkty <xsl:value-of select="$CourseNode/Stats/@Points"/> na <xsl:value-of select="$CourseNode/Stats/@MaxPoints"/>
                </span>
              </div>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$CourseNode/Stats/@IsRefresh=0 and $CourseNode/Stats/@IsComplete=1">
            <div class="course_status">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/ok_24.png" alt="Kurs ukończony" title="Kurs ukończony"/>
              <span class="course_label">Ukończony</span>
            </div>
            <div class="course_ocena">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/diplom_two_24.png" alt="Ocena kursu" title="Ocena kursu"/>
              <span class="course_label">
                Ocena:<xsl:value-of select="$CourseNode/Stats/@Evaluation"/><xsl:comment></xsl:comment>
              </span>
            </div>
            <xsl:if test="$CourseNode/@CousreTypeID!=4">
              <div class="course_punkty">
                <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/stats.png" alt="Liczba punktów" title="Liczba punktów"/>
                <span class="course_label">
                  Punkty <xsl:value-of select="$CourseNode/Stats/@Points"/> na <xsl:value-of select="$CourseNode/Stats/@MaxPoints"/>
                </span>
              </div>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$CourseNode/Stats/@IsRefresh=0 and $CourseNode/Stats/@IsComplete=0 and $CourseNode/Stats/@IsStarted=1">
            <div class="course_status">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/arrow_right_24.png" alt="Kurs w toku" title="Kurs w toku"/>
              <span class="course_label">W toku</span>
            </div>
            <xsl:if test="$CourseNode/@CousreTypeID!=4">
              <div class="course_ocena">
                <xsl:text>&#160;</xsl:text>
                <xsl:comment></xsl:comment>
              </div>
                          <xsl:if test="$CourseNode/@CousreTypeID!=1">
              <div class="course_punkty">
                <img class="course_img course_punkty" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/stats.png" alt="Liczba punktów" title="Liczba punktów"/>
                <span class="course_label course_punkty">
                  Punkty <xsl:value-of select="$CourseNode/Stats/@Points"/> na <xsl:value-of select="$CourseNode/Stats/@MaxPoints"/>
                </span>
              </div>
                              </xsl:if>          
            </xsl:if>
          </xsl:if>
          <xsl:if test="$CourseNode/Stats/@IsRefresh=0 and $CourseNode/Stats/@IsComplete=0 and $CourseNode/Stats/@IsStarted=0">
            <div class="course_status">
              <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/clock_24.png" alt="Kurs do wykonania" title="Kurs do wykonania"/>
              <span class="course_label">Do wykonania</span>
            </div>
          </xsl:if>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template name="CompetenceStat">
    <xsl:param name="IsActive" select="0"/>
    <div class="course_legend">
      <div class="course_status_img">
        <xsl:if test="$IsActive=0">
          <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/lock_24.png" alt="Kurs zablokowany" title="Kurs zablokowany"/>
        </xsl:if>
        <xsl:if test="$IsActive=1">
          <img class="course_img" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/unlock_24.png" alt="Kurs aktywny" title="Kurs aktywny"/>
        </xsl:if>
      </div>
    </div>
  </xsl:template>

  <xsl:template name="extendUrl">
    <xsl:param name="url"/>
    <xsl:param name="paramValue"/>

    <xsl:choose>
      <xsl:when test="contains($url,'?')">
        <xsl:value-of select="$url"/>&amp;<xsl:value-of select="$paramValue"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$url"/>?<xsl:value-of select="$paramValue"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="ELearning">

    <div>
    <div id="spacerDiv" style="width: 100%; height: 20px;">
      <xsl:comment> </xsl:comment>
    </div>
      <div class="cls"><xsl:comment></xsl:comment></div>
    <div id="exercise">
      <xsl:comment> </xsl:comment>
    </div>
      <div class="cls"><xsl:comment></xsl:comment></div>
    </div>
  </xsl:template>
  
  <xsl:variable name="CourseType">
    <xsl:choose>
      <xsl:when test="/Data/CourseType=1"> - Praktyka</xsl:when>
      <xsl:when test="/Data/CourseType=2"> - Cwiczenia</xsl:when>
      <xsl:when test="/Data/CourseType=3"> - Teoria</xsl:when>
      <!--
      <xsl:when test="/Data/CourseType=10"> - Początkowy test wiedzy</xsl:when>
      <xsl:when test="/Data/CourseType=11"> - Początkowy test umiejętności</xsl:when>
      <xsl:when test="/Data/CourseType=12"> - Końcowy test wiedzy</xsl:when>
      <xsl:when test="/Data/CourseType=13"> - Końcowy test umiejętności</xsl:when>-->
    </xsl:choose>
  </xsl:variable>
</xsl:stylesheet>