<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="./XSLTemplate/CommonTemplates.xsl"/>
  
  <xsl:template match="/">
    <ComponentXML>
      <HTMLInline name="{/Data/Config/Name}">
        <!--<div>
          <a href="{/Data/Config/Domain}" class="menuhome fontmenu"><img style="border:0;" border="0" src="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/img/home.png"/></a>
        </div>-->
        <div id="floatingmenu" style="display:none;">
          <ul>
          <xsl:for-each select="/Data/Menus/Menu">
            <li>
            <xsl:choose>
              <xsl:when test="@isActive='1'">
                <xsl:call-template name="mnu_btn_1"><xsl:with-param name="title" select="./Title/."/><xsl:with-param  name="url" select="./URL/." /></xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="mnu_btn_0"><xsl:with-param name="title" select="./Title/."/><xsl:with-param  name="url" select="./URL/." /></xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
            </li>
          </xsl:for-each> 
          </ul>
        </div>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
  
  <xsl:template name="mnu_btn_1">
    <xsl:param name="title"/>
    <xsl:param name="url"/>
    <a href="{$url}" class="menulink fontmenu"><xsl:value-of select="$title"/></a>
  </xsl:template>

  <xsl:template name="mnu_btn_0">
    <xsl:param name="title"/>
    <xsl:param name="url"/>
    <a href="{$url}" class="menulink fontmenu"><xsl:value-of select="$title"/></a>
  </xsl:template>

</xsl:stylesheet>