<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                version="1.0"
                exclude-result-prefixes="msxsl">
  <xsl:import href="./XSLTemplate/AdministrationTemplates.xsl"/>
  <xsl:output method="html" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" encoding="utf-8" />
  <xsl:template match="/">
    <ComponentXML>
      <ScriptTopList>
        <ScriptTop src="{/Data/Config/Domain}{/Data/Config/ProjectPath}js/{/Data/Config/ResoursesVersion}zsb.js"/>
      </ScriptTopList>

      <StylesheetList>
        <Stylesheet href="{/Data/Config/Domain}{/Data/Config/ProjectPath}css/{/Data/Config/ResoursesVersion}N610.css"/>
      </StylesheetList>
      
      <ScriptInlineBottom>
        jQuery(document).ready(function () {
          initMenu(0);
        });
        function _saveInstructor(id) {
            $("#instructorid").val(id);
            $("#editmode").val(1);
            document.forms[0].submit();
            return false;
        }
        function _saveStudent(id) {
            $("#studentid").val(id);
            $("#editmode").val(1);
            document.forms[0].submit();
            return false;
        }
        function _goto(url) {
            document.location=url;
        }
      </ScriptInlineBottom>
      
      <HTMLInline name="{/Data/Config/Name}">
        <table width="100%">
          <tr>
            <td>              
              <xsl:choose>
                <xsl:when test="/Data/Config/@IUA=1">
            
                  <xsl:choose>
                    <xsl:when test="/Data/Group/@IsTeacher=1">
                      <xsl:call-template name="teacher" />
                    </xsl:when>
                    <xsl:when test="/Data/Group/@IsStudent=1">
                      <xsl:call-template name="student" />
                    </xsl:when>
                    <xsl:when test="/Data/Group/@IsInstruktor=1">
                      <xsl:call-template name="invalidgroup" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:call-template name="invalidgroup" />
                    </xsl:otherwise>
                  </xsl:choose>
            
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="invaliduser" />
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>
      </HTMLInline>
    </ComponentXML>
  </xsl:template>
  
  <xsl:template name="student">
    
    <xsl:call-template name="box">
      <xsl:with-param name="content">        
        <xsl:apply-templates select="/Data/Student">
          <xsl:with-param name="isstudent" select="1"/>
          <xsl:with-param name="readonly" select="0"/>
          <xsl:with-param name="ispassword" select="1"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="/Data/Class">
          <xsl:with-param name="isstudent" select="1"/>
        </xsl:apply-templates>
              
        <xsl:apply-templates select="/Data/Instructor">
          <xsl:with-param name="isstudent" select="1"/>
        </xsl:apply-templates>
              
        <xsl:apply-templates select="/Data/School">
          <xsl:with-param name="isstudent" select="1"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="/Data/Messages" />
        <div>
          <input type="hidden" id="editmode" name="editmode" value="0"/>
          <input type="hidden" id="studentid" name="studentid" value="{/Data/Student/@ID}"/>
          <ul class="admactionmenu">
            <li><button type="button" onclick="_saveStudent({/Data/Student/@ID});return false;">Zapisz</button></li>
          </ul>
          <div class="cls"><xsl:comment> </xsl:comment></div>
        </div>          
      </xsl:with-param>
    </xsl:call-template>
    
  </xsl:template>

  <xsl:template name="teacher">
    <xsl:call-template name="box">
      <xsl:with-param name="content">    
        <xsl:apply-templates select="/Data/Instructor">
          <xsl:with-param name="readonly" select="0"/>
          <xsl:with-param name="ispassword" select="1"/>
        </xsl:apply-templates>        
        <xsl:apply-templates select="/Data/School"/>

        <xsl:apply-templates select="/Data/Messages" />
        <div>
          <input type="hidden" id="editmode" name="editmode" value="0"/>
          <input type="hidden" id="instructorid" name="instructorid" value="{/Data/Instructor/@ID}"/>
          <ul class="admactionmenu">
            <li><button type="button" onclick="_saveInstructor({/Data/Instructor/@ID});return false;">Zapisz</button></li>
          </ul>
          <div class="cls"><xsl:comment> </xsl:comment></div>
        </div>          
      </xsl:with-param>      
    </xsl:call-template>
  </xsl:template>
  
</xsl:stylesheet>