﻿package pl.fabrykagier.edufarma 
{
	
	import com.gskinner.utils.Rnd;
	
	public class AI 
	{

		public function AI(shops:Vector.<Shop>,players:Vector.<Player>,logger:Function) 
		{
			
			logger("clear");
			
			this.shops = shops;
			this.players = players;
			this.logger = logger;
			
			shuffleVector(shops as Vector.<*>);
			
			showInfo();
			//var currentShop:Shop = shops[0];
			
			logger("========== Symulacja ==========");
			
			for each(var currentShop:Shop in shops)
			{
				logger("========== Symulacja sklepu: "+currentShop.name+" ==========");
				buyAllProducts(currentShop);
				logger("========== Koniec zakupów sklepu: "+currentShop.name+" ==========");
				logger("");
			}
			
			showSummary();
		}
		
		private function showSummary():void
		{
			logger("");

			for each(var currentShop:Shop in shops)
			{
				logger("========== Podsumowanie dla sklepu: "+currentShop.name+" ==========");
				for each(var purchase:Purchase in currentShop.purchaseList)
				{
					logger(purchase.log());
				}
				logger("");
			}
		}
		
		public static function shuffleVector(vec:Vector.<*>):void
		{
			if (vec.length > 1)
			{
				var i:int = vec.length - 1;
				while (i > 0)
				{
					var s:Number = Rnd.integer(0, vec.length);
					var temp:* = vec[s];
					vec[s] = vec[i];
					vec[i] = temp;
					i--;
				}
			}			
		}
		
		private function buyProduct(currentShop:Shop,shopProduct:ShopProduct):void
		{
			var profitArray:Array = [];
				
			//each players in game
			for each(var currentPlayer:Player in players)
			{
				//info about profit in player
				var info:ProductProfitInfo = calculateProductProfit(currentShop,shopProduct,currentPlayer,currentPlayer.getProduct(shopProduct.name));
				
				//save result to array
				if(info.transactionStatus == ProductProfitInfo.TRANSACTION_STATUS_OK)
					profitArray.push(info);
			}
			
			//losowe wybieranie jak jest taka sama cena sprzedaży dla kilku graczy
			
			var shopDemand:int = shopProduct.demand;
			
			if(profitArray.length > 0)
			{
				//sort by profits
				profitArray.sortOn("profit", Array.NUMERIC | Array.DESCENDING);
				
				var profit:ProductProfitInfo = ProductProfitInfo(profitArray.shift());
				shopDemand -= profit.amount;
					
				currentShop.buy(profit.player,profit.player.getProduct(shopProduct.name),profit.amount,profit.price,profit.transportCost,profit.transportLeft);
				profit.player.sell(shopProduct.name,profit.amount);
				
				logger("!!!!!!!! Sklep dokonuje zakupu od gracza: "+profit.player.name+" produktu o nazwie: "+shopProduct.name+" w ilość: "+profit.amount+" za łączną kwotę (+transport): "+(profit.price*profit.amount+profit.transportCost));
			}
			else
			{
				logger("!!!!!!!! Sklep nie znalazł produktu: "+shopProduct.name+" u żadnego gracza");
			}
			
			//shop need more products
			if(shopDemand > 0 && profitArray.length > 0)
				buyProduct(currentShop,shopProduct);
		}
		
		private function buyAllProducts(currentShop:Shop):void
		{
			//each products in shop
			for each(var shopProduct:ShopProduct in currentShop.productsList)
			{
				buyProduct(currentShop,shopProduct);
			}
		}
				
		private function calculateProductProfit(shop:Shop,shopProduct:ShopProduct,player:Player,playerProduct:PlayerProduct):ProductProfitInfo
		{
			logger("Obliczam zysk dla produktu: "+shopProduct.name+" od gracza: "+player.name);
			logger("Ilość potrzebna: "+shopProduct.demand);
			logger("Max Cena: "+shopProduct.maxPrice);
			logger("Ilość gracza: "+playerProduct.amount);
			logger("Cena gracza: "+playerProduct.price);
			
			var info:ProductProfitInfo = new ProductProfitInfo();
			
			if(playerProduct.amount == 0)
			{
				logger("Gracz nie posiada tego produktu");
				logger(" ");
				
				info.transactionStatus = ProductProfitInfo.TRANSACTION_STATUS_NO_IN_STORE;
				return info;
			}
			
			info.transactionStatus = ProductProfitInfo.TRANSACTION_STATUS_OK;
			
			var amount:int;
			
			if(shopProduct.demand > playerProduct.amount)
			{
				amount = playerProduct.amount;
			}
			else
			{
				amount = shopProduct.demand;
			}
			
			var transportLeft:int = shop.getTransportLeftFromPlayer(player);
			
			logger("Pozostałe miejsce z poprzedniego: "+transportLeft);
			
			var transportTotalCost:int = Math.ceil((amount-transportLeft)/transportAmount)*transportCost;
			
			if(transportTotalCost < 0)
				transportTotalCost = 0;
			
			logger("Zakupiona ilość: "+amount);
			logger("Wartość zakupu: "+playerProduct.price*amount);
			logger("Koszt transportu: "+transportTotalCost);
			
			
			info.profit = shopProduct.maxPrice*amount - (playerProduct.price*amount + transportTotalCost);
			info.transportLeft = Math.ceil((amount)/transportAmount)*transportAmount - amount;
			info.player = player;
			info.amount = amount;
			info.price = playerProduct.price;
			info.transportCost = transportTotalCost;
			
			logger("OGÓLNY ZYSK: "+info.profit);
			logger(" ");
			
			return info;
		}
		
		private function showInfo():void
		{
			logger("========== Dane wejściowe ==========");
			logger("");
			logger("-= SKLEPY -=");
			logger("");
			
			for each(var shop:Shop in shops)
			{
				logger("Nazwa sklepu: "+shop.name);
				logger("Zapotrzebowanie:");
				
				var i:int = 1;
				
				for each(var product:ShopProduct in shop.productsList)
				{
					logger(i+". "+product.name+" potrzeba: "+product.demand+", max cena: "+product.maxPrice);
					i++;
				}
			}
			logger("");
			
			logger("-= GRACZE -=");
			logger("");
			
			for each(var player:Player in players)
			{
				logger("Nazwa gracza: "+player.name);
				logger("Dostępne towary:");
				
				var j:int = 1;
				
				for each(var product2:PlayerProduct in player.productsList)
				{
					logger(j+". "+product2.name+" w magazynie: "+product2.amount+", cena: "+product2.price);
					j++;
				}
			}
			
			logger("");
			
		}
		
		private var profitArray:Array = [];
		private var playersTable:Array = [];
		private var transportAmount:int = 100;
		private var transportCost:int = 200;
		private var shops:Vector.<Shop>;
		private var players:Vector.<Player>;
		private var logger:Function;

	}
	
}
