﻿package pl.fabrykagier.edufarma {
	
	public class Shop {

		public function Shop(name:String) 
		{
			// constructor code
			_name = name;
		}

		public function addProduct(productName:String, productGroup:String, demand:int, maxPrice:Number):void
		{
			_productsList.push(new ShopProduct(productName,productGroup,demand,maxPrice));
		}
		
		public function get productsList():Vector.<ShopProduct>
		{
			return _productsList;
		}
		
		private function getProductByName(name:String):ShopProduct
		{
			for each(var product:ShopProduct in _productsList)
			{
				if(product.name == name)
					return product;
			}
			
			return new ShopProduct("none","none",-1,-1);
		}
		
		public function get name():String
		{
			return _name;
		}
		
		public function set name(value:String):void
		{
			_name = value;
		}
		
		public function buy(player:Player,product:PlayerProduct,amount:int,price:Number,transportCost:int,transportLeft:int):void
		{
			clearTransportLeftInAllPurchaseInOnePlayer(player);
			
			_purchaseList.push(new Purchase(player,product,amount,price,transportCost,transportLeft));
			
			getProductByName(product.name).demand -= amount;
		}
		
		private function clearTransportLeftInAllPurchaseInOnePlayer(player:Player):void
		{
			for each(var purchase:Purchase in _purchaseList)
			{
				if(purchase.player == player)
				{
					purchase.transportLeft = 0;
				}
			}
		}
		
		public function getTransportLeftFromPlayer(player:Player):int
		{
			for each(var purchase:Purchase in _purchaseList)
			{
				if(purchase.player == player && purchase.transportLeft != 0)
				{
					return purchase.transportLeft;
				}
			}
			
			return 0;
		}
		
		public function get purchaseList():Vector.<Purchase>
		{
			return _purchaseList;
		}
		
		private var _purchaseList:Vector.<Purchase> = new Vector.<Purchase>();
		private var contractor:Vector.<ShopProduct> = new Vector.<ShopProduct>();
		private var _name:String;
		private var _productsList:Vector.<ShopProduct> = new Vector.<ShopProduct>();
		
		
	}
	
}
