package pl.fabrykagier.eduFarma.adminPanel
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import pl.fabrykagier.eduFarma.adminPanel.AdminPanel;
	import pl.fabrykagier.eduFarma.communication.Communicator;
	import pl.fabrykagier.eduFarma.communication.ExtensionCommands;
	import pl.fabrykagier.eduFarma.communication.GameMessage;
	import pl.fabrykagier.framework.display.GameObject;
	import pl.fabrykagier.framework.events.FrameworkEvent;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * Main application class
	 * @author Andrzej Kaczor
	 */
	public class AdminPanel extends GameObject
	{				
		private var adminPanel:MovieClip;
		private var _communicator:Communicator;
		private static var _instance:AdminPanel;
		private var _roomID:int = -1;
		private var sessionId:String;
		private var userId:int;
		private var _databaseRoomId:int = -1;
		
		/**
		 * Creates a SmartFox communicator instance, registers global call functions
		 */
		public function AdminPanel(sessionId:String, userId:String) 
		{
			this.userId = parseInt(userId);
			this.sessionId = sessionId;
			
			_instance = this;
			
			// Create the communicator and connect to the server
			communicator = new Communicator(true);
			communicator.addEventListener(Communicator.USER_LIST_CHANGE, handleUserListChange);
			communicator.addEventListener(Communicator.JOINED_WAITING_ROOM, joinedWaitingRoomHandler);
			communicator.connect(this.userId, "teacher");
			
			trace("SESSION ID:", sessionId);
			trace("USER ID:", userId);
			
			// Register global call functions
			Framework.instance.registerFunction(startGameplay, "startGameplay");
			Framework.instance.registerFunction(stopGameplay, "stopGameplay");
			
			// Create the graphical interface
			adminPanel = new adminPanelContainer();
			this.addChild(adminPanel);
		}
		
		private function joinedWaitingRoomHandler(e:Event):void 
		{
			communicator.removeEventListener(Communicator.JOINED_WAITING_ROOM, joinedWaitingRoomHandler);
			
			communicator.addEventListener(Communicator.AUTHENTICATION_REPONSE, authenticationResponseHandler);
			communicator.authenticateTeacher(sessionId, userId);
		}
		
		private function authenticationResponseHandler(event:FrameworkEvent):void 
		{
			var status:String = event.getParameter("status");
			
			if (status == "1")
			{
				//logInToClass(parseInt(event.getParameter("roomId")), event.getParameter("roomName"));
				getClassList(parseInt(event.getParameter("schoolId")));
			}
			else
			{
				
			}
		}
		
		private function getClassList(schoolId:int = -1):void 
		{
			if (schoolId < 0)
				return;
			
			communicator.setExtensionCallback(onClassListReceivedHandler, ExtensionCommands.GET_CLASS_LIST);
			communicator.callExtension(Communicator.EXTENSION_USERS, ExtensionCommands.GET_CLASS_LIST, { selectedSchool:schoolId, id:userId } );
		}
		
		private function onClassListReceivedHandler(params:Object):void 
		{
			var classSelectionBox:AdminLoginBox = new interface_loginBox();
			classSelectionBox.populateClassList(params.rooms);
			
			this.addChild(classSelectionBox);
			classSelectionBox.x = (this.width / 2) - (classSelectionBox.width / 2);
			classSelectionBox.y = (this.height / 2) - (classSelectionBox.height / 2);
		}
		
		/**
		 * Places the user in a previously selected room on server
		 */
		public function logInToClass(roomId:int, databaseRoomId:int):void 
		{
			this.databaseRoomId = databaseRoomId;			
			
			if (this._roomID == roomId)
			{
				trace("already in room!");
				goToAdminSection(null);
			}
			else
			{
				communicator.addEventListener("RESTORE_DATA", goToAdminSection);
				
				this._roomID = roomId;
				communicator.changeRoom(roomId);		
			}
		}
		
		/**
		 * Display the teacher-administrator user list view
		 * @param	e
		 */
		private function goToAdminSection(e:Event):void 
		{
			communicator.removeEventListener("RESTORE_DATA", goToAdminSection);
			
			// Get the user list from server and display it
			initUserList();
		}
		
		/**
		 * Calls the server extension to stop the gameplay for all users
		 */
		private function stopGameplay():void 
		{
			communicator.callExtension("usersExt", "endGame", { userId:-1} );
		}
		
		/**
		 * Calls the server extension to start the gameplay for all users or users who joined the game later
		 */
		private function startGameplay():void 
		{
			// Copy the user list
			var users:Vector.<Object> = UserList(adminPanel.getChildByName("listOfUsers")).userVector.slice();
			
			// Iterate through all the users
			for each (var object:Object in users)
			{				
				// If a user has been accepted to play
				if (int(object.accepted) == 1)
				{
					// Send a server message to this user's application, informing it that it can start the gameplay
					communicator.sendMessage(GameMessage.GAME_START, "private", -1, int(object.serverId));
				}
			}
			
			// After enabling all the users for gameplay - launch the shop simulation countdown on server
			communicator.callExtension("usersExt", "countdownSimulation", { } );
		}
		
		/**
		 * Called when a user joins or leaves the room
		 * @param	e
		 */
		private function handleUserListChange(e:Event):void 
		{
			// Refresh the user list
			Framework.instance.callRegisteredFunction("refreshList");
		}
		
		/**
		 * Jumps to the user list screen
		 */
		public function initUserList():void
		{
			adminPanel.gotoAndPlay("toUserList");
		}
		
		static public function get getInstance():AdminPanel { return _instance; }
		
		public function get communicator():Communicator { return _communicator; }
		
		public function set communicator(value:Communicator):void 
		{
			_communicator = value;
		}
		
		public function get roomID():int { return _roomID; }
		
		public function set roomID(value:int):void 
		{
			_roomID = value;
		}
		
		public function get databaseRoomId():int 
		{
			return _databaseRoomId;
		}
		
		public function set databaseRoomId(value:int):void 
		{
			_databaseRoomId = value;
		}
	}

}