package pl.fabrykagier.eduFarma.adminPanel
{
	import com.greensock.TweenLite;
	import flash.display.Bitmap;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	
	/**
	 * Scrollable items list.
	 * @author Andrzej Kaczor
	 */
	public class ScrollableUserWindow extends MovieClip
	{
		private static const singleItemWidth:Number = 717;
		private static const singleItemHeight:Number = 29;
		private static const horizontalMargin:Number = 0;
		private static const verticalMargin:Number = 0;
		
		private var sHead:MovieClip;
		private var maxTop:Number;
		private var maxBottom:Number;
		private var itemContainer:MovieClip;
		private var sLine:MovieClip;
		private var scrollState:int = 0;
		private var itemContainerOrigin:Number;
		private var windowHeight:Number;
		private var windowWidth:Number;
		private var sArrowUp:MovieClip;
		private var sArrowDown:MovieClip;
		private var columns:int;
		private var rows:int;
				
		/**
		 * class constructor, gathers instances of objects
		 */
		public function ScrollableUserWindow() 
		{
			sHead = MovieClip(this.getChildByName("scrollHead"));			
			sLine = MovieClip(this.getChildByName("scrollLine"));
			sArrowUp = MovieClip(this.getChildByName("scrollUp"));
			sArrowDown = MovieClip(this.getChildByName("scrollDown"));
			itemContainer = MovieClip(this.getChildByName("iContainer"));
			itemContainerOrigin = itemContainer.y;
			
			windowHeight = this.getChildByName("itemMask").height;
			windowWidth = this.getChildByName("itemMask").width;
			
			maxTop = sLine.y + sHead.height/2;
			maxBottom = maxTop + sLine.height - sHead.height;		
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
		}
		
		/**
		 * clears listeners, vars, instances when the container is removed
		 * @param	e
		 */
		private function cleanUp(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
			clearItemList();
			deactivate();
		}
		
		/**
		 * activates the container by adding listeners, enabling interaction
		 */
		public function activate():void
		{
			if (itemContainer.numChildren > 15)
			{
				sHead.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sHead.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sHead.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
				this.parent.parent.addEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
				sLine.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				this.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
				
				sArrowUp.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sArrowUp.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sArrowUp.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
				sArrowDown.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sArrowDown.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sArrowDown.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);		
			
				sHead.buttonMode = true;
				sLine.buttonMode = true;
				sArrowUp.buttonMode = true;
				sArrowDown.buttonMode = true;
				
				sHead.gotoAndStop("active");
				sArrowUp.gotoAndStop("active");
				sArrowDown.gotoAndStop("active");
			}
			else
			{
				sHead.gotoAndStop("inactive");
				sArrowUp.gotoAndStop("inactive");
				sArrowDown.gotoAndStop("inactive");
			}
		}
		
		/**
		 * deactivates the container by removing listeners, disabling interaction
		 */
		public function deactivate():void
		{
			sHead.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
			sLine.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			this.removeEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			
			sArrowUp.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			sArrowUp.removeEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
			sArrowUp.removeEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
			sArrowDown.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			sArrowDown.removeEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
			sArrowDown.removeEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
			
			this.parent.parent.addEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.parent.parent.addEventListener(Event.ENTER_FRAME, handleScrollDown);
			
			sHead.buttonMode = false;
			sLine.buttonMode = false;
			sArrowUp.buttonMode = false;
			sArrowDown.buttonMode = false;
		}
		
		private function handleMouseOut(e:MouseEvent):void 
		{
			e.target.gotoAndStop("off");
			
			this.removeEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollDown);
		}
		
		private function handleMouseOver(e:MouseEvent):void 
		{
			e.target.gotoAndStop("on");
		}
		
		/**
		 * called when the mouse wheel has moved, scrolls the item list
		 * @param	e
		 */
		private function mouseWheelHandler(e:MouseEvent):void 
		{
			var movement:Number = e.delta;
			
			if (sHead.y - movement < maxTop) sHead.y = maxTop;
			else if (sHead.y - movement > maxBottom) sHead.y = maxBottom;
			else sHead.y -= movement;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * removes objects from item list
		 */
		public function clearItemList():void
		{
			var items:int = itemContainer.numChildren;
			
			for (var i:int = 0; i < items; i++)
			{
				itemContainer.removeChild(itemContainer.getChildAt(0));
			}
			
			moveItemContainer(0);
			sHead.y = maxTop;
		}
		
		/**
		 * populates the item list with new objects
		 * @param	items - a vector containing arrays which consist of two elements - object instance and it's class reference
		 * @param	itemGroup - the group od items to which the new item belongs
		 */
		public function populateItemList(items:Vector.<Object> = null, itemGroup:String = ""):void
		{			
			var itemAmount:int;
			
			if (items && items.length > 0)
			{
				itemAmount = items.length;			
			
				columns = Math.floor(windowWidth / (singleItemWidth + horizontalMargin));
				if (columns <= 0) columns = 1;
				columns = (itemAmount < columns ? itemAmount : columns);
				rows = Math.ceil(itemAmount / columns);
				var singleItem:MovieClip;
				
				var counter:int = 0;
				
				for (var i:int = 0; i < rows; i++)
				{
					for (var j:int = 0; j < columns; j++)
					{
						if (items.length - 1 < counter) break;
						
						singleItem = new SingleItemContainer();
						singleItem.itemClass = itemGroup;
						singleItem.x = j * singleItem.width + j * horizontalMargin;
						singleItem.y = i * singleItem.height + i * verticalMargin;
											
						singleItem.id = counter;
						singleItem.username = items[counter].username;
						singleItem.userId = items[counter].id;
						singleItem.serverId = items[counter].serverId;
						
						TextField(singleItem["fieldId"]).text = items[counter].id;
						TextField(singleItem["fieldUsername"]).text = items[counter].username;					
						TextField(singleItem["fieldSchool"]).text = items[counter].school;					
						TextField(singleItem["fieldClass"]).text = items[counter].schoolClass;
															
						if (int(items[counter].accepted)) singleItem.gotoAndStop("confirmed");
						
						itemContainer.addChild(singleItem);
						counter++;
					}
				}
			}
		}
		
		/**
		 * called when the mouse button is released, disables scrolling
		 * @param	e
		 */
		private function handleMouseUp(e:MouseEvent):void 
		{
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollDown);
		}
		
		/**
		 * called when the mouse button is pressed, enables scrolling
		 * @param	e
		 */
		private function handleMouseDown(e:MouseEvent):void 
		{
			e.target.gotoAndStop("click");
						
			if (e.target.name == "scrollHead")
			{
				if (this.mouseY < maxTop) sHead.y = maxTop;
				else if (this.mouseY > maxBottom) sHead.y = maxBottom;
				else sHead.y = this.mouseY;
				
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.parent.parent.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			}
			else if (e.target.name == "scrollUp")
			{
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.addEventListener(Event.ENTER_FRAME, handleScrollUp);
			}
			else if (e.target.name == "scrollDown")
			{
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.addEventListener(Event.ENTER_FRAME, handleScrollDown);
			}			
		}
		
		private function handleScrollDown(e:Event):void 
		{
			sHead.y += 2;
			
			if (sHead.y < maxTop) sHead.y = maxTop;
			else if (sHead.y > maxBottom) sHead.y = maxBottom;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		private function handleScrollUp(e:Event):void 
		{
			sHead.y -= 2;
			
			if (sHead.y < maxTop) sHead.y = maxTop;
			else if (sHead.y > maxBottom) sHead.y = maxBottom;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * called when the mouse has moved, updates the scrollbar and item list position
		 * @param	e
		 */
		private function handleMouseMove(e:MouseEvent):void
		{
			if (this.mouseY < maxTop) sHead.y = maxTop;
			else if (this.mouseY > maxBottom) sHead.y = maxBottom;
			else sHead.y = this.mouseY;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * moves the item container to a new position
		 * @param	position - in percent, 0 - original position, 100 - fully scrolled down
		 */
		private function moveItemContainer(position:int):void
		{
			var translation:Number = itemContainerOrigin - ((itemContainer.height + rows*verticalMargin) - windowHeight) * position / 100;
			
			TweenLite.killTweensOf(itemContainer);
			TweenLite.to(itemContainer, 0.3, { y:translation });
		}
		
		
		
	}

}