package pl.fabrykagier.eduFarma.adminPanel 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * The user list object with a scrollable area of elements representing users.
	 * @author Andrzej Kaczor
	 */
	public class UserList extends MovieClip
	{		
		private var itemList:ScrollableUserWindow;
		private var _userVector:Vector.<Object>;
		
		public function UserList() 
		{
			userVector = new Vector.<Object>();
			
			// Register a global call function for refreshing the list
			Framework.instance.registerFunction(updateUserList, "refreshList");
			
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		/**
		 * Called when this object is added to the stage
		 * @param	e
		 */
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			// get the scrollable area instance
			itemList = ScrollableUserWindow(this["scrollableList"]);
						
			// refresh the list and activate the scrollable area
			refreshList();
			itemList.activate();
		}
		
		/**
		 * Request the user list from server and set a function to receive it
		 */		
		public function updateUserList():void
		{
			if (AdminPanel.getInstance.roomID < 0) return;
			
			AdminPanel.getInstance.communicator.setExtensionCallback(userListResponse,"getWaitingUsers");
			AdminPanel.getInstance.communicator.callExtension("usersExt", "getWaitingUsers", { roomId:AdminPanel.getInstance.databaseRoomId } );
		}
		
		/**
		 * Called when a response from server has been received
		 * @param	response - the server response
		 */
		private function userListResponse(response:Object):void 
		{
			var users:Array = response.users as Array;
			var limiter:int = users.length;
			var oldLength:int =  userVector.length;
			userVector = new Vector.<Object>();
						
			for (var i:int = 0; i < limiter; i++)
			{
				userVector.push( { id:users[i].id, username:users[i].username, school:users[i].schoolName, schoolClass:users[i].className, accepted:users[i].accepted, serverId:users[i].serverId} );
			}
			
			if (oldLength != userVector.length) refreshList();
		}
		
		private function refreshList():void
		{
			itemList.clearItemList();
			itemList.populateItemList(userVector);
		}
		
		public function get userVector():Vector.<Object> { return _userVector; }
		
		public function set userVector(value:Vector.<Object>):void 
		{
			_userVector = value;
		}
		
	}

}