package pl.fabrykagier.eduFarma.gameData 
{
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	/**
	 * Handles management of the marketplace. Allows the user to put on and remove products off market.
	 * @author Andrzej Kaczor
	 */
	public class Marketplace 
	{
		/**
		 * Vector of products currently put on market
		 */
		private var _storedProducts:Vector.<Product> = new Vector.<Product>();
		
		/**
		 * Constructor
		 */
		public function Marketplace() 
		{
			
		}
		
		/**
		 * Put a product on market
		 * @param	product - @see Product
		 */
		public function addProduct(product:Product):void
		{			
			// search for the same product among products already put on market
			for each (var object:Product in storedProducts)
			{
				// if this product is on market already
				if (object.product == product.product && object.price == product.price)
				{
					// increase the amount of that product
					object.amount += product.amount;
					return;
				}
			}
			
			// Set the status of the product so it is clear it has been put on market
			product.onMarket = true;
			
			// Add the product to the list of products currently on market
			storedProducts.push( product );
			
			if (MainGameClass.FLAG_dataRestored)
			{
				MainGameClass.getInstance.communicator.setExtensionCallback(setProductId,"toMarketplace");
				MainGameClass.getInstance.communicator.callExtension("warehouseExt", "toMarketplace", {userDbId:UserData.getInstance.userDbID, productId:product.productId, amount:product.amount, price:product.price, storeId:storedProducts.indexOf(product)});
			}
		}
		
		/**
		 * Sets the unique database id of the product when it is received from server
		 * @param	params
		 */
		private function setProductId(params:Object):void 
		{
			storedProducts[params.id].dbId = params.db;
		}
		
		/**
		 * Take a product off market
		 * @param	product - the name of the product to be taken off
		 */
		public function removeProduct(product:Product):void
		{
			var index:int
			
			for each (var object:Product in storedProducts)
			{
				trace("PRODUCT ID'S: ", object.dbId, product.dbId);
				if (object.dbId == product.dbId)
				{
					index = storedProducts.indexOf(object);
					break;
				}
			}
			
			// search for the prodct among those on market
			if (index >= 0)
			{									
				MainGameClass.getInstance.communicator.callExtension("warehouseExt", "removeFromMarketplace", {userDbId:UserData.getInstance.userDbID, productId:product.productId, productDbId:product.dbId, type:product.type});
				
				UserData.getInstance.storeInWarehouse(product);
				
				// remove it from the list of products put on market
				storedProducts.splice(index, 1);
				return;						
			}
		}
		
		/**
		 * Take a product off market
		 * @param	product - the name of the product to be taken off
		 */
		public function sellProduct(product:Product):void
		{
			var index:int
			
			for each (var object:Product in storedProducts)
			{
				trace("PRODCUT ID's : ", object.dbId, product.dbId);
				if (object.dbId == product.dbId)
				{
					index = storedProducts.indexOf(object);
					break;
				}
			}
			
			// search for the prodct among those on market
			if (index >= 0)
			{				
				MainGameClass.getInstance.communicator.callExtension("warehouseExt", "removeFromMarketplace", {userDbId:UserData.getInstance.userDbID, productId:storedProducts[index].dbId, type:storedProducts[index].type});
									
				// remove it from the list of products put on market
				storedProducts.splice(index, 1);
				return;				
			}
		}
		
		/**
		 * Returns the amount of product of a specified type
		 * @param	type - the type of proudct
		 * @return the amount of the product on market
		 */		
		public function getProductTypeAmount(type:String):int
		{
			var totalAmount:int = 0;
			
			for each (var product:Product in storedProducts)
			{
				if (product.type == type)
				{
					totalAmount += product.amount;
				}
			}
			
			return totalAmount;
		}
		
		/**
		 * Get the list of products currently on market
		 */
		public function get storedProducts():Vector.<Product> { return _storedProducts; }
		
		/**
		 * Set the list of products currently on market
		 */
		public function set storedProducts(value:Vector.<Product>):void 
		{
			_storedProducts = value;
		}
		
	}

}