package pl.fabrykagier.eduFarma.gameData 
{
	/**
	 * A product object containing all the necessary information about a product being used in the game.
	 * @author Andrzej Kaczor
	 */
	public class Product 
	{
		private var _product:String;
		private var _productName:String;
		private var _amount:int;
		private var _price:Number;
		private var FLAG_onMarket:Boolean = false;
		private var _type:String;
		private var _buildingId:int;
		private var _productId:int;
		private var _removeAmount:int = 0;
		private var _soldHeader:Boolean;
		private var _notSoldHeader:Boolean;
		private var _sold:Boolean;
		private var _notSold:Boolean;
		private var _transactionNumber:int;
		private var _totalProfit:int;
		private var _dbId:int;
		private var _roundNumber:int;
		
		/**
		 * Constructor. Creates a Product object carrying information about the product's name, type, amount and price.
		 * @param	name - the name of the product.
		 * @param	type - the type of the producy.
		 * @param	amount - the amount of the product.
		 * @param	price - the price of the product (used only when adding or removing products from marketplace).
		 */
		public function Product(name:String,
								productName:String,
								productId:int,
								type:String,
								amount:int = 1,
								price:Number = 0,
								buildingId:int = 0,
								soldHeader:Boolean = false,
								notSoldHeader:Boolean = false,
								sold:Boolean = false,
								notSold:Boolean = false,
								transactionNumber:int = 0,
								totalProfit:int = 0,
								roundNumber:int = -1) 
		{
			this._roundNumber = roundNumber;
			this._totalProfit = totalProfit;
			this._transactionNumber = transactionNumber;
			this._notSold = notSold;
			this._sold = sold;
			this._notSoldHeader = notSoldHeader;
			this._soldHeader = soldHeader;
			this._productName = productName;
			this._productId = productId;
			_buildingId = buildingId;
			_type = type;
			_product = name;
			_amount = amount;
			_price = price;
		}
		
		/**
		 * Get the price of the product.
		 */
		public function get price():Number { return _price; }
		
		/**
		 * Set the price of the product.
		 */
		public function set price(value:Number):void 
		{
			_price = value;
		}
		
		/**
		 * Get the amount of the product.
		 */
		public function get amount():int { return _amount; }
		
		/**
		 * Set the amount of the product.
		 */
		public function set amount(value:int):void 
		{
			_amount = value;
		}
		
		/**
		 * Get the product's name.
		 */
		public function get product():String { return _product; }
		
		/**
		 * Set the product's name.
		 */
		public function set product(value:String):void 
		{
			_product = value;
		}
		
		/**
		 * Get the product's type.
		 */
		public function get type():String { return _type; }
		
		/**
		 * Set the products type.
		 */
		public function set type(value:String):void 
		{
			_type = value;
		}
		
		/**
		 * Get the product's market status.
		 * If true - the product is currently on market.
		 * If false - it is not available for sale and can be put on market or removed.
		 */
		public function get onMarket():Boolean { return FLAG_onMarket; }
		
		/**
		 * Set the product's market status.
		 */
		public function set onMarket(value:Boolean):void 
		{
			FLAG_onMarket = value;
		}
		
		public function get buildingId():int { return _buildingId; }
		
		public function set buildingId(value:int):void 
		{
			_buildingId = value;
		}
		
		public function get productId():int { return _productId; }
		
		public function set productId(value:int):void 
		{
			_productId = value;
		}
		
		public function get productName():String { return _productName; }
		
		public function set productName(value:String):void 
		{
			_productName = value;
		}
		
		public function get removeAmount():int { return _removeAmount; }
		
		public function set removeAmount(value:int):void 
		{
			_removeAmount = value;
		}
		
		public function get totalProfit():int { return _totalProfit; }
		
		public function get transactionNumber():int { return _transactionNumber; }
		
		public function get notSold():Boolean { return _notSold; }
		
		public function get sold():Boolean { return _sold; }
		
		public function get notSoldHeader():Boolean { return _notSoldHeader; }
		
		public function get soldHeader():Boolean { return _soldHeader; }
		
		public function get dbId():int { return _dbId; }
		
		public function set dbId(value:int):void 
		{
			_dbId = value;
		}
		
		public function get roundNumber():int { return _roundNumber; }
		
		public function set roundNumber(value:int):void 
		{
			_roundNumber = value;
		}
		
	}

}