package pl.fabrykagier.eduFarma.gameData 
{
	import flash.events.EventDispatcher;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.StructureGraphics;
	import pl.fabrykagier.eduFarma.popups.BuildingDescriptionPopup;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	
	/**
	 * Holds information about a building in the game.
	 * @author Andrzej Kaczor
	 */
	public class StructureData extends EventDispatcher
	{				
		protected var _structureReference:PlaceableObject;
		protected var _structureLevel:int;
		protected var _storedAmount:int=0;
		protected var _capacity:int=0;
		protected var _unitProductionTime:Number;
		protected var _unitProductionCost:Number;
		protected var _upgradeCost:int;
		protected var _outputProduct:String;
		protected var _inputProduct:String;
		protected var _inputProductAmount:Number;
		protected var _inputType:String;
		protected var _outputType:String;
		protected var _storageTime:int;
		protected var _typeId:int;
		protected var _storageTimeLeft:int;
		protected var _dbID:int = -1;
		
		public var FLAG_rotten:Boolean = false;
		public var FLAG_producing:Boolean = false;
		public var FLAG_ready:Boolean = false;
		public var FLAG_upgrading:Boolean = false;
		public var FLAG_productionComplete:Boolean = false;
		
		/**
		 * Constructor.
		 */
		public function StructureData() 
		{
			
		}
		
		/**
		 * Store a product produced in this building.
		 * @param	product
		 */
		public function storeProduct(product:Product):void
		{
			// if the current available space allows to store the product
			if (capacity - storedAmount > 0)
			{
				// if there is available storage space but the amount of the product exceeds it, reduce the amount to available space.
				if (storedAmount + product.amount > capacity) storedAmount = capacity;
				// store the product
				else storedAmount += product.amount;
			}
			
			FLAG_productionComplete = true;
		}
		
		/**
		 * Remove any stored products from the building.
		 */
		public function emptyStorage():void
		{
			storedAmount = 0;
			storageTimeLeft = storageTime;
			
			FLAG_productionComplete = false;
			FLAG_rotten = false;
		}
		
		/**
		 * Remove products which have rottend over time due to not being transported to a warehouse.
		 */
		public function removeRotten():void
		{
			emptyStorage();
			FLAG_rotten = false;
			storageTimeLeft = storageTime;
		}
		
		/**
		 * Updates the stored products status if there are any.
		 */
		public function update():void
		{
			// if there is anything to update
			if (storedAmount > 0 && storageTimeLeft > 0)
			{
				// reduce the left storage time
				storageTimeLeft--;
				
				var prc:int = 100 - Math.round((storageTimeLeft / storageTime) * 100);
				
				// update the building status icon to indicate that the products inside has started to rot
				StructureGraphics(structureReference.objectFace).statusIcon.update(prc);
				
				//if (MainGameClass.getInstance.popup && MainGameClass.getInstance.popup.popupID == _structureReference.ID)
				//{
					//BuildingDescriptionPopup(MainGameClass.getInstance.popup).updateRottingStatus(prc, storageTimeLeft, _storedAmount);
				//}
				
				// if the storage time has run out
				if (storageTimeLeft == 0)
				{
					// update the building status icon to indicate that the products have rotten
					StructureGraphics(structureReference.objectFace).statusIcon.setStatus("rotten");
					StructureGraphics(structureReference.objectFace).setStatus("rotten");
					
					if (MainGameClass.getInstance.tooltip && MainGameClass.getInstance.tooltipID == structureReference.ID)
					{
						MainGameClass.getInstance.tooltip.updateText("", "Kliknij, aby wyrzucić zepsute produkty");
					}
					
					FLAG_ready = false;
					FLAG_rotten = true;
				}
			}
		}
		
		/**
		 * Get the available storage space.
		 */
		public function get capacity():int { return _capacity; }
		
		/**
		 * Set the available storage space.
		 */
		public function set capacity(value:int):void 
		{
			_capacity = value;
		}
		
		/**
		 * Get the production time per product.
		 */
		public function get unitProductionTime():Number { return _unitProductionTime; }
		
		/**
		 * Set the production time per product.
		 */
		public function set unitProductionTime(value:Number):void 
		{
			_unitProductionTime = value;
		}
		
		/**
		 * Get the production cost per product.
		 */
		public function get unitProductionCost():Number { return _unitProductionCost; }
		
		/**
		 * Get the production cost per product.
		 */
		public function set unitProductionCost(value:Number):void 
		{
			_unitProductionCost = value;
		}
		
		/**
		 * Get the output product's name.
		 */
		public function get outputProduct():String { return _outputProduct; }
		
		/**
		 * Set the output product's name.
		 */
		public function set outputProduct(value:String):void 
		{
			_outputProduct = value;
		}
		
		/**
		 * Get the input product's name (if there is an input product specified)
		 */
		public function get inputProduct():String { return _inputProduct; }
		
		/**
		 * Set the input product's name.
		 */
		public function set inputProduct(value:String):void 
		{
			_inputProduct = value;
		}
		
		/**
		 * Get the type of the output product.
		 */
		public function get outputType():String { return _outputType; }
		
		/**
		 * Set the type of the output product.
		 */
		public function set outputType(value:String):void 
		{
			_outputType = value;
		}
		
		/**
		 * Get the amount of products currently stored in building.
		 */
		public function get storedAmount():int { return _storedAmount; }
		
		/**
		 * Set the amount of products currently stored in building.
		 */
		public function set storedAmount(value:int):void 
		{
			_storedAmount = value;
		}
		
		/**
		 * Get the time of product storage.
		 */
		public function get storageTime():int { return _storageTime; }
		
		/**
		 * Set the time of product storage.
		 */
		public function set storageTime(value:int):void 
		{
			_storageTime = value;
		}
		
		/**
		 * Get the storage time left.
		 */
		public function get storageTimeLeft():int { return _storageTimeLeft; }
		
		/**
		 * Set the storage time left.
		 */
		public function set storageTimeLeft(value:int):void 
		{
			_storageTimeLeft = value;
		}
		
		/**
		 * Get the reference to the building object on game grid.
		 */
		public function get structureReference():PlaceableObject { return _structureReference; }
		
		/**
		 * Set the reference to the building object on game grid.
		 */
		public function set structureReference(value:PlaceableObject):void 
		{
			_structureReference = value;
		}
		
		/**
		 * Get the current level of the building.
		 */
		public function get structureLevel():int { return _structureLevel; }
		
		/**
		 * Set the current level of the building.
		 */
		public function set structureLevel(value:int):void 
		{
			_structureLevel = value;
		}
		
		public function get dbID():int { return _dbID; }
		
		public function set dbID(value:int):void 
		{
			_dbID = value;
		}
		
		public function get typeId():int { return _typeId; }
		
		public function set typeId(value:int):void 
		{
			_typeId = value;
		}
		
		public function get upgradeCost():int { return _upgradeCost; }
		
		public function set upgradeCost(value:int):void 
		{
			_upgradeCost = value;
		}
		
		public function get inputProductAmount():Number { return _inputProductAmount; }
		
		public function set inputProductAmount(value:Number):void 
		{
			_inputProductAmount = value;
		}
		
		public function get inputType():String { return _inputType; }
		
		public function set inputType(value:String):void 
		{
			_inputType = value;
		}
		
	}

}