package pl.fabrykagier.eduFarma.gameInterface 
{
	import com.greensock.TweenLite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.engines.tEngine.EngineSettings;
	import pl.fabrykagier.framework.main.Framework;
	import com.greensock.easing.Quad;
	import pl.fabrykagier.framework.media.sounds.SoundManager;
	import pl.fabrykagier.framework.states.FrameworkState;
	
	/**
	 * Manages the slide-in build structures list.
	 * @author Andrzej Kaczor
	 */
	public class BuildingList extends MovieClip
	{		
		private static var _BUILDINGS_TYPE:String = "type 1";
		private static var _STATE:String = "hidden";
		
		private var scrollList:Vector.<MovieClip> = new Vector.<MovieClip>();
		private var scrollItemsContainer:MovieClip;
		private var scrollItemsContainerOrigin:Number;
		private var visibleAreaWidth:Number;
		private var FLAG_stopScrolling:Boolean = false;
		private var listMargin:Number = 2;
		public var container:MovieClip;
		
		/**
		 * Class constructor
		 */
		public function BuildingList() 
		{
			// Register functions used to scroll the list
			Framework.instance.registerFunction(scrollLeft, "scrollLeft");
			Framework.instance.registerFunction(scrollRight, "scrollRight");
			Framework.instance.registerFunction(scrollLeftEnd, "scrollLeftEnd");
			Framework.instance.registerFunction(scrollRightEnd, "scrollRightEnd");
					
			// Listen for the event informing when this list should slide onto the screen
			GameEvent.dispatcher.addEventListener(GameEvent.SHOW_BUILDING_LIST, showBuildingList);	
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			
			// Get the masked item container
			container = MovieClip(this.getChildByName("content"));
			scrollItemsContainer = MovieClip(container.getChildByName("buildingContainer"));
			scrollItemsContainerOrigin = scrollItemsContainer.x;
						
			// Get mask width
			visibleAreaWidth = MovieClip(MovieClip(this.getChildByName("content")).getChildByName("scrollMask")).width;
			
			this.addEventListener(MouseEvent.ROLL_OVER, mouseOverHandler);
			this.addEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = false;
		}
		
		private function mouseOverHandler(e:MouseEvent):void 
		{
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
		
		/**
		 * Scrolls the masked container immediately to the left end through TweenLite tween
		 */
		private function scrollRightEnd():void 
		{
			//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 0.5;
			//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 0.5;
			
			//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 1;
			//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 1;
			
			TweenLite.killTweensOf(scrollItemsContainer);
			TweenLite.to(scrollItemsContainer, 0.3, { x:scrollItemsContainerOrigin - (scrollItemsContainer.width - visibleAreaWidth), ease:Quad.easeInOut } );
		}
		
		/**
		 * Scrolls the masked container immediately to the right end through TweenLite tween
		 */
		private function scrollLeftEnd():void 
		{
			//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 1;
			//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 1;
			
			//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 0.5;
			//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 0.5;
			
			TweenLite.killTweensOf(scrollItemsContainer);
			TweenLite.to(scrollItemsContainer, 0.3, { x:scrollItemsContainerOrigin, ease:Quad.easeInOut } );
		}
		
		/**
		 * Scrolls the masked container to the left through TweenLite tween
		 */
		private function scrollRight():void 
		{
			if (FLAG_stopScrolling || scrollItemsContainer.x <= scrollItemsContainerOrigin - (scrollItemsContainer.width - visibleAreaWidth))
			{
				//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 0.5;
				//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 0.5;
				
				//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 1;
				//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 1;
				
				FLAG_stopScrolling = false;
				GameEvent.dispatcher.removeEventListener(GameEvent.STOP_SCROLLING, stopScrolling);
				return;
			}
			
			TweenLite.killTweensOf(scrollItemsContainer);
			//TweenLite.to(scrollItemsContainer, (scrollItemsContainer.width / BuildingListItem.WIDTH) * 0.2, { x:scrollItemsContainerOrigin - (scrollItemsContainer.width - visibleAreaWidth), ease:Quad.easeInOut } );
			TweenLite.to(scrollItemsContainer, 0.2, { x:scrollItemsContainer.x - BuildingListItem.WIDTH - listMargin, ease:Quad.easeInOut, onComplete:scrollRight } );
			
			//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 1;
			//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 1;
			
			// Listen to an event telling when to srop scrolling
			if(!GameEvent.dispatcher.hasEventListener(GameEvent.STOP_SCROLLING)) GameEvent.dispatcher.addEventListener(GameEvent.STOP_SCROLLING, stopScrolling);
		}
		
		/**
		 * Scrolls the masked container to the right through TweenLite tween
		 */
		private function scrollLeft():void
		{
			if (FLAG_stopScrolling || scrollItemsContainer.x >= scrollItemsContainerOrigin)
			{
				//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 1;
				//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 1;
				
				//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 0.5;
				//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 0.5;
				
				FLAG_stopScrolling = false;
				GameEvent.dispatcher.removeEventListener(GameEvent.STOP_SCROLLING, stopScrolling);
				return;
			}
			
			TweenLite.killTweensOf(scrollItemsContainer);
			//TweenLite.to(scrollItemsContainer, (scrollItemsContainer.width / BuildingListItem.WIDTH) * 0.2, { x:scrollItemsContainerOrigin, ease:Quad.easeInOut } );
			TweenLite.to(scrollItemsContainer, 0.2, { x:scrollItemsContainer.x + BuildingListItem.WIDTH + listMargin, ease:Quad.easeInOut, onComplete:scrollLeft } );
			
			//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 1;
			//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 1;
			
			// Listen to an event telling when to srop scrolling
			if(!GameEvent.dispatcher.hasEventListener(GameEvent.STOP_SCROLLING)) GameEvent.dispatcher.addEventListener(GameEvent.STOP_SCROLLING, stopScrolling);
		}
		
		/**
		 * Stops scrolling of the item list
		 * @param	e
		 */
		private function stopScrolling(e:GameEvent):void
		{
			//TweenLite.killTweensOf(scrollItemsContainer);
			FLAG_stopScrolling = true;
			GameEvent.dispatcher.removeEventListener(GameEvent.STOP_SCROLLING, stopScrolling);
		}
		
		/**
		 * Called upon removal of this object from display list, removes listeners, clears vars and references
		 * @param	e
		 */
		private function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			GameEvent.dispatcher.removeEventListener(GameEvent.SHOW_BUILDING_LIST, showBuildingList);		
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hideBuildingList);
			
			this.removeEventListener(MouseEvent.ROLL_OVER, mouseOverHandler);
			this.removeEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
		}
		
		/**
		 * Makes this list appear on screen. If it alredy is visible - just reload the list.
		 * @param	e
		 */
		private function showBuildingList(e:GameEvent):void 
		{		
			if (this.currentLabel != "slideIn") 
			{
				MainGameClass.getInstance.switchMode(GameSettings.BUILDMODE);
				if (MainGameClass.getInstance.tooltip)
				{
					MainGameClass.getInstance.tooltip.parent.removeChild(MainGameClass.getInstance.tooltip);
					MainGameClass.getInstance.tooltip = null;
				}
				
				this.gotoAndPlay("slideIn");
				
				SoundManager.instance.playSound( { name:"buildingListWhoosh", group:"sound", duplicate:true } );
				
				MovieClip(container.getChildByName("closeButton")).gotoAndPlay("close_in");
				
				if(_BUILDINGS_TYPE == "type 1") MovieClip(container.getChildByName("tab_1")).gotoAndStop("on_on")
				
				reloadBuildingList();			
			}
			else
			{
				reloadBuildingList();
			}
			
			MainGameClass.getInstance.removePlaceableObject(true);
		}
		
		/**
		 * Populates item list with objects of type specified by the BUILDINGS_TYPE var. 
		 * If the list was previously populated and types mismatch, the list is cleared first, then populated again.
		 */
		public function reloadBuildingList():void 
		{
			scrollItemsContainer.x = scrollItemsContainerOrigin;
			
			// Clear the list if it's not empty
			if (scrollList.length > 0)
			{
				var limiter:int = scrollList.length;
				var element:*;
				
				for (var i:int = 0; i < limiter; i++)
				{
					element = scrollList.pop();
					element.parent.removeChild(element);
				}
			}
			
			var item:BuildingListItem;
			var nextX:Number = 0;
			
			if (BUILDINGS_TYPE != "type expand")
			{
				// Cycle through the available objects
				for each (var object:Object in EngineSettings.PLACEABLE_SETTINGS)
				{
					// If the current object is of the correct type - create it and add to list
					if (object.type == BUILDINGS_TYPE)
					{
						item = new BuildingListItem(object.objectSettings);
						item.itemGraphics.gotoAndStop(int(object.colorGroup));
						scrollList.push(item);
						
						if (int(object.objectSettings["costLevel1"]) > UserData.getInstance.money)
						{
							item.itemGraphics.alpha = 0.3;
							item.FLAG_inactive = true;
						}
						else
						{						
							item.itemGraphics.alpha = 1;
							item.FLAG_inactive = false;
						}
						
						item.y = 0;
						item.x = nextX;
						scrollItemsContainer.addChild(item);
						
						// Next item will be added at this point
						nextX = item.x + item.width + listMargin;
					}
					else continue;
				}
			}
			else
			{
				var expandItem:MovieClip = new expandButton1();
				if (MainGameClass.getInstance.expandLevel >= 1 || UserData.getInstance.money < 10000) 
				{
					expandItem.gotoAndStop("inactive");
					expandItem.mouseEnabled = false;
					expandItem.mouseChildren = false;					
				}
				scrollList.push(expandItem);
				
				expandItem.y = 0;
				expandItem.x = 0;
				scrollItemsContainer.addChild(expandItem);
				TextField(expandItem["itemPrice"]).text = "10000";
				
				expandItem = new expandButton2();
				if (MainGameClass.getInstance.expandLevel == 0 || MainGameClass.getInstance.expandLevel >= 2 || UserData.getInstance.money < 20000) 
				{
					expandItem.gotoAndStop("inactive");
					expandItem.mouseEnabled = false;
					expandItem.mouseChildren = false;					
				}
				scrollList.push(expandItem);
				
				expandItem.y = 0;
				expandItem.x = expandItem.width + listMargin;
				scrollItemsContainer.addChild(expandItem);
				TextField(expandItem["itemPrice"]).text = "20000";
			}
			
			if (scrollItemsContainer.width > visibleAreaWidth)
			{
				//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 1;
				//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 1;
				
				//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 0.5;
				//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 0.5;
			}
			else
			{
				//MovieClip(container.getChildByName("call_scrollRight$lockEnabled_false$")).alpha = 0.5;
				//MovieClip(container.getChildByName("call_scrollRightEnd$lockEnabled_false$")).alpha = 0.5;
				
				//MovieClip(container.getChildByName("call_scrollLeft$lockEnabled_false$")).alpha = 0.5;
				//MovieClip(container.getChildByName("call_scrollLeftEnd$lockEnabled_false$")).alpha = 0.5;
			}
		}
		
		/**
		 * Called on frame - the list is on screen, unlock buttons, listen for an event to hide the list
		 */
		public function listInPlace():void
		{
			Framework.unlockButtons();
			
			GameEvent.dispatcher.addEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hideBuildingList);
			
			STATE = "shown";
		}
		
		/**
		 * Triggered by a GameEvent.CLOSE_OPEN_WINDOWS event, hides the building list
		 * @param	e
		 */
		private function hideBuildingList(e:GameEvent):void 
		{
			if (e && this.parent.getChildIndex(this) < this.parent.numChildren - 3) return;
			
			// hide
			this.gotoAndPlay("slideOut");
			
			MovieClip(container.getChildByName("closeButton")).gotoAndPlay("close_out");
			
			STATE = "hidden";
			
			// Change game mode back to normal
			MainGameClass.getInstance.switchMode(GameSettings.GAMEMODE);			
			
			Framework.unlockButtons();
			
			MainGameClass.getInstance.removePlaceableObject(true);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hideBuildingList);
		}
		
		public function disable():void
		{
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hideBuildingList);
		}
		
		public function enable():void
		{
			if(STATE == "shown") GameEvent.dispatcher.addEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hideBuildingList);
		}
		
		static public function get BUILDINGS_TYPE():String { return _BUILDINGS_TYPE; }
		
		static public function set BUILDINGS_TYPE(value:String):void 
		{
			_BUILDINGS_TYPE = value;
		}
		
		static public function get STATE():String { return _STATE; }
		
		static public function set STATE(value:String):void 
		{
			_STATE = value;
		}		
		
	}

}