package pl.fabrykagier.eduFarma.gameInterface 
{
	import flash.events.MouseEvent;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	import pl.fabrykagier.framework.main.Framework;
	import pl.fabrykagier.framework.utils.objects.ParametersObject;
	
	/**
	 * Arrow button used to scroll the building list
	 * @author Andrzej Kaczor
	 */
	public class BuildingListScrollArrow extends GotoButton
	{
		
		/**
		 * Constructor
		 */
		public function BuildingListScrollArrow() 
		{
			
		}
		
		override protected function onButtonOverHandler(event:MouseEvent):void 
		{
			if (this.alpha == 1)
			{
				super.onButtonOverHandler(event);
			}
		}
		
		
		/**
		 * Calls the scrolling function when the mouse button is pressed
		 * @param	event
		 */
		override protected function onButtonDownHandler(event:MouseEvent):void 
		{
			if (this.alpha == 1)
			{
				super.onButtonDownHandler(event);
			
				Framework.instance.callRegisteredFunction((new ParametersObject(this.name)).getValue("call"));
			}
		}
		
		/**
		 * This is overriden only to prevent the parent method from being called
		 * @param	event
		 */
		override protected function onClickHandler(event:MouseEvent):void 
		{
			
		}
		
		/**
		 * When mouse button is released, dispatch an event informing the building list to stop scrolling
		 * @param	event
		 */
		override protected function onButtonUpHandler(event:MouseEvent):void 
		{
			if (this.alpha == 1)
			{
				super.onButtonUpHandler(event);
			
				if (!this.name.match("End")) GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.STOP_SCROLLING));
			}
		}	
		
	}

}