package pl.fabrykagier.eduFarma.gameInterface 
{
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.framework.display.buttons.BaseButton;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * A tab on top of the building list, used to switch the type of buildings currently displayed on list.
	 * @author Andrzej Kaczor
	 */
	public class BuildingListTab extends GotoButton
	{
		//private var buttonLabel:TextField;
		
		/**
		 * Class constructor
		 */
		public function BuildingListTab() 
		{
			super();
			
			this.mouseChildren = false;
			gotoAndStop(1);
			
			// Get the text field with the tab name
			//buttonLabel = TextField(this.getChildByName("tabLabel"));
			
			//buttonLabel.mouseEnabled = false;
			
			// Listen to an event infroming this tab to deactivate itself if another tab has been clicked
			GameEvent.dispatcher.addEventListener(GameEvent.BUILDING_TAB_CHANGE, deactivateTab);
			GameEvent.dispatcher.addEventListener(GameEvent.CLOSE_OPEN_WINDOWS, deactivateTab);
		}
		
		/**
		 * Called upon removal, clears listeners
		 */
		override protected function onRemoved():void 
		{
			super.onRemoved();
			
			GameEvent.dispatcher.removeEventListener(GameEvent.BUILDING_TAB_CHANGE, deactivateTab);
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, deactivateTab);
		}
		
		/**
		 * Deactivates this tab
		 * @param	e
		 */
		private function deactivateTab(e:GameEvent):void 
		{
			this.gotoAndStop("off_off");
		}
		
		/**
		 * Makes this tab active, informs the building list that it should appear on screen, informs other tabs that they should be deactivated
		 * @param	event
		 */
		override protected function onClickHandler(event:MouseEvent):void 
		{
			if (MainGameClass.getInstance.gameMap.FLAG_moving) return;
			
			// Set the buildings type in the buildings list
			if (this.name != "buildMode") BuildingList.BUILDINGS_TYPE = "type " + this.name.split("_")[1];
			else 
			{
				BuildingList.BUILDINGS_TYPE = "type 1";
				
				if (BuildingList.STATE == "shown")
				{
					Framework.instance.callRegisteredFunction("closeCommand");
					return;
				}
			}
			
			// Dispatch an event to show the building list
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.SHOW_BUILDING_LIST));
			
			// Dispatch an event to deactivate other tabs
			if (this.name != "buildMode") GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.BUILDING_TAB_CHANGE));
			
			this.gotoAndStop("on_on");			
		}
		
		/**
		 * Mouse is over the tab
		 * @param	event
		 */
		override protected function onButtonOverHandler(event:MouseEvent):void
		{
			this.gotoAndStop("on_" + this.currentLabel.split("_")[1]);
		}
		
		/**
		 * Mouse went off the tab
		 * @param	event
		 */
		override protected function onButtonOutHandler(event:MouseEvent):void 
		{
			this.gotoAndStop("off_" + this.currentLabel.split("_")[1]);			
		}
	}

}