package pl.fabrykagier.eduFarma.main
{
	import com.greensock.easing.Quad;
	import com.greensock.plugins.AutoAlphaPlugin;
	import com.greensock.plugins.TweenPlugin;
	import com.greensock.TweenLite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.LoaderInfo;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import flash.utils.Timer;
	import pl.fabrykagier.eduFarma.communication.Communicator;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.gameData.StructureData;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.eduFarma.gameInterface.BuildingList;
	import pl.fabrykagier.eduFarma.gameInterface.BuildingListItem;
	import pl.fabrykagier.eduFarma.gameInterface.Hud;
	import pl.fabrykagier.eduFarma.popups.BalloonTooltip;
	import pl.fabrykagier.eduFarma.popups.BuildingDescriptionPopup;
	import pl.fabrykagier.eduFarma.popups.BuyingRoundPopup;
	import pl.fabrykagier.eduFarma.popups.ChartsPopup;
	import pl.fabrykagier.eduFarma.popups.EndGamePopup;
	import pl.fabrykagier.eduFarma.popups.FinancesPopup;
	import pl.fabrykagier.eduFarma.popups.GameInfoPopup;
	import pl.fabrykagier.eduFarma.popups.InfoPopup;
	import pl.fabrykagier.eduFarma.popups.MarketplacePopup;
	import pl.fabrykagier.eduFarma.popups.PopupBase;
	import pl.fabrykagier.eduFarma.popups.RemoveFromWarehousePopup;
	import pl.fabrykagier.eduFarma.popups.SendToMarketplacePopup;
	import pl.fabrykagier.eduFarma.popups.ServerMessage;
	import pl.fabrykagier.eduFarma.popups.StatisticsPopup;
	import pl.fabrykagier.eduFarma.popups.UpgradePopup;
	import pl.fabrykagier.eduFarma.popups.WarehousePopup;
	import pl.fabrykagier.eduFarma.popups.WarningPopup;
	import pl.fabrykagier.eduFarma.popups.YesNoPopup;
	import pl.fabrykagier.eduFarma.processess.ProcessBase;
	import pl.fabrykagier.eduFarma.processess.ProcessProduction;
	import pl.fabrykagier.eduFarma.processess.ProcessUpgrade;
	import pl.fabrykagier.engines.tEngine.EngineSettings;
	import pl.fabrykagier.engines.tEngine.ObjectParser;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	import pl.fabrykagier.framework.display.GameObject;
	import pl.fabrykagier.framework.events.FrameworkEvent;
	import pl.fabrykagier.framework.main.Framework;
	import pl.fabrykagier.framework.media.sounds.SoundManager;
	import pl.fabrykagier.framework.states.FrameworkState;
	
	/**
	 * Manages main game flow and logic.
	 * @author Andrzej Kaczor
	 */
	public class MainGameClass extends GameObject
	{			
		private static var _instance:MainGameClass;
		
		private var _communicator:Communicator;
		private var pregameClip:MovieClip;
		private var _gameClip:MovieClip;
		private var _gameMap:GameMap;
		private var hud:Hud;
		private var _buildingList:BuildingList;
		private var _tooltip:BalloonTooltip;
		private var _buildTooltip:BalloonTooltip;
		private var optionsTooltip:BalloonTooltip;
		private var _tooltipID:int;
		private var _currentProductionAmount:int = 0;
		private var _processQueue:Vector.<ProcessBase> = new Vector.<ProcessBase>();
		private var _popup:PopupBase;
		public var expandLevel:int = 0;
		private var roundTime:int = 600;
		private var roundTimeLeft:int = roundTime;
		private var roundTimer:Timer;		
		private var blocker:Sprite;
		private var _cloudsClip:MovieClip;
		private var cloudsNumber:int=0;
		private var _currentRoundId:int = 0;
		private var totalProfit:int;
		private var _currentRound:int = 1;
		private var tutorialClip:MovieClip;
		private var tutorialFrames:int;
		private var konamiSequence:String = "";
		private var testSequence:String = "";
		private var startTutorial:Boolean = false;
		private var wiesiekTalk:MovieClip;
		private var fakeLoader:MovieClip;
		private var sessionId:String;
		private var userId:int;	
		
		// FLAGS
		public static var FLAG_dataRestored:Boolean = false;
		public static var FLAG_firstRun:Boolean = false;
		public var FLAG_endGame:Boolean = false;
			
	
		/**
		 * Class constructor, adds game graphics.
		 */
		public function MainGameClass(sessionId:String, userId:String)
		{				
			this.userId = parseInt(userId);
			UserData.getInstance.userDbID = parseInt(userId);
			this.sessionId = sessionId;
			this.tabEnabled = true;
			this.tabChildren = true;
			
			trace("SESSION ID:", sessionId);
			trace("USER ID:", userId);
			
			_instance = this;
												
			// Create the communication object used to communicate with the game server.
			communicator = new Communicator(true);
			communicator.addEventListener(Communicator.CONNECTION_ERROR, connectionErrorHandler);
			communicator.addEventListener(Communicator.JOINED_WAITING_ROOM, joinedWaitingRoomHandler);
			communicator.connect(this.userId, "player");
			
			GameEvent.dispatcher.addEventListener(GameEvent.TIME_SYNC, synchronizeTime);
			
			//communicator.addEventListener("RESTORE_DATA", restoreData);
			
			getSettings();
			
			// get the list of in-game buildings stored in an xml configuration file
			getObjectList();			
			getProductList();			
			getWarningTexts();			
			initLoginScreen();			
			
			//initGameplay();
			SoundManager.instance.playSound( { name:"bgmMenu", group:"music", loops:9999 } );
			
			this.addEventListener(Event.ADDED_TO_STAGE, onAddedHandler);
			
			GameEvent.dispatcher.addEventListener(GameEvent.END_GAME, endGameHandler);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
		}	
		
		private function joinedWaitingRoomHandler(e:Event):void 
		{
			communicator.removeEventListener(Communicator.JOINED_WAITING_ROOM, joinedWaitingRoomHandler);
			
			communicator.addEventListener(Communicator.AUTHENTICATION_REPONSE, authenticationResponseHandler);
			communicator.authenticate(sessionId, userId);
		}
		
		private function authenticationResponseHandler(event:FrameworkEvent):void 
		{
			var status:String = event.getParameter("status");
			
			if (status == "1")
			{
				logInToClass(parseInt(event.getParameter("roomId")), event.getParameter("roomName"));
			}
			else
			{
				
			}
		}
		
		private function logInToClass(roomId:int, className:String):void 
		{
			communicator.addEventListener("RESTORE_DATA", goToWaitMode);
			communicator.changeRoom(className);
				
			communicator.dbRoomId = roomId;							
			communicator.callExtension("usersExt", "updateRoomId", { roomId:roomId, id:userId } );
							
			addBlocker();
				
			fakeLoader = new miniPreloader();
			fakeLoader.x = this.parent.width / 2;
			fakeLoader.y = this.parent.height / 2;
				
			var glow:GlowFilter = new GlowFilter(0xFFFFFF, 1, 17, 17, 2);
				
			fakeLoader.filters = [glow];
				
			this.addChild(fakeLoader);				
		}
		
		private function goToWaitMode(e:Event):void 
		{
			communicator.removeEventListener("RESTORE_DATA", goToWaitMode);
			
			communicator.setExtensionCallback(getRoundsData,"getRoundHistory");			
			communicator.callExtension("historyExt", "getRoundHistory", {roomId:MainGameClass.getInstance.communicator.dbRoomId});
						
			waitForStartSignal();
		}
		
		
		private function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			communicator.removeEventListener(Communicator.CONNECTION_ERROR, connectionErrorHandler);
		}
		
		private function connectionErrorHandler(event:FrameworkEvent):void 
		{
			showServerError(event.getParameter("errorType"));
		}
		
		private function onAddedHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, onAddedHandler);
			//stage.tabChildren = true;
			//this.stage.focus = this.stage;
			//stage.tabChildren = true;
			//stage.tabEnabled = true;
		}
		
		public function emergencyStopTimer():void
		{
			if (roundTimer)
			{
				roundTimer.removeEventListener(TimerEvent.TIMER, timerUpdateHandler);
				roundTimer.stop();
			}
		}
		
		public function showServerError(type:String="generic"):void
		{
			if (FLAG_endGame) return;
			
			var errorPopup:ServerMessage = new serverMessage();
			
			errorPopup.setMessage(type);
			
			this.addChild(errorPopup);
		}
		
		private function endGameHandler(e:GameEvent):void 
		{
			FLAG_endGame = true;
			
			GameEvent.dispatcher.removeEventListener(GameEvent.END_GAME, endGameHandler);
			
			if (roundTimer)
			{
				roundTimer.removeEventListener(TimerEvent.TIMER, timerUpdateHandler);
				roundTimer.stop();
			}
			
			hideOptionsTooltip();
			hideTooltip();
			
			if (popup) popup.hide();
			
			popup = new finishPopup();
			
			EndGamePopup(popup).populate(e.parameters.scoreResults);
			
			this.addChild(popup);			
		}
		
		private function getWarningTexts():void
		{					
			XML.ignoreWhitespace = true;
			
			var xmlPath:URLRequest = new URLRequest(GameSettings.xmlPath + "XML/popupMessages.xml");
			var xmlData:XML;				
			
			if (xmlPath)
			{
				var xmlLoader:URLLoader = new URLLoader(xmlPath);
				xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
				
				function xmlLoaderCompleteHandler(e:Event):void
				{
					xmlLoader.removeEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
					xmlData = new XML(String(e.target.data).replace(/\\n/g,"\n"));
											
					for each (var node:XML in xmlData.children())
					{
						GameSettings.POPUP_TEXT[node.child("popupName").toString()] = ( {header:node.child("popupHeader").toString(), content:node.child("popupMessage").toString() } );						
					}					
				}
			}	
		}
		
		public function waitForStartSignal():void
		{
			GameEvent.dispatcher.addEventListener(GameEvent.GAME_START, restoreData);
		}
		
		public function restoreData(e:Event=null):void
		{			
			GameEvent.dispatcher.removeEventListener(GameEvent.GAME_START, restoreData);
			
			communicator.setExtensionCallback(getRestorationResponse,"restoreData");
			communicator.callExtension("databaseExt", "restoreData", { userId:UserData.getInstance.userDbID } );
		}
		
		private function getRestorationResponse(response:Object):void
		{
			if (response == null || response._cmd != "restoreData")
			{
				FLAG_dataRestored = true;
				return;
			}
			
			UserData.getInstance.money = response.cash;
			UserData.getInstance.loan = response.loan;
			
			UserData.getInstance.currentLoanLimit -= UserData.getInstance.loan;
			UserData.getInstance.loanLimit -= UserData.getInstance.loan;
			
			UserData.getInstance.loanRate = response.loanRate;
			UserData.getInstance.loanLength = response.loanLength;
			
			EngineSettings.GRID_HEIGHT = response.fieldSizeY;
			EngineSettings.GRID_WIDTH = response.fieldSizeX;
							
			if (EngineSettings.GRID_WIDTH - EngineSettings.IINITIAL_MAP_WIDTH == 3) expandLevel = 1; 
			else if (EngineSettings.GRID_WIDTH - EngineSettings.IINITIAL_MAP_WIDTH == 6) expandLevel = 2;
			
			
			initGameplay();
			
			// RESTORE BUILDINGS!!!!!
			for each (var buildingRestore:Object in response.buildings)
			{
				trace("BUILDING: ", buildingRestore.typeId, buildingRestore.level, buildingRestore.progress);
				restorePlaceableObject(buildingRestore.dbId, buildingRestore.typeId, buildingRestore.x, buildingRestore.y, buildingRestore.level, buildingRestore.progress);
			}
			
			gameMap.setDisplayOrder();
			
			// restore products in warehouses
			for each (var warehouseProduct:Object in response.warehouseProducts)
			{
				var productInfo:Object;
				
				for each (var object:Object in GameSettings.PRODUCTS)
				{
					if (int(object.productId) == int(warehouseProduct.id))
					{
						productInfo = object;
						break;
					}
				}
				
				if (productInfo)
				{
					var product:Product = new Product(productInfo.internalName,
													  productInfo.productName,
													  warehouseProduct.id,
													  warehouseProduct.type,
													  warehouseProduct.amount,
													  0,
													  0);
				
					UserData.getInstance.storeInWarehouse(product);
				}
			}
			
			// restore products on marketplace
			for each (var marketplaceProduct:Object in response.marketplaceProducts)
			{				
				for each (object in GameSettings.PRODUCTS)
				{
					if (int(object.productId) == int(marketplaceProduct.id))
					{
						productInfo = object;
						break;
					}
				}
				
				if (productInfo)
				{
					product = new Product(productInfo.internalName,
										  productInfo.productName,
										  int(marketplaceProduct.id),										  
										  productInfo.productType,
										  int(marketplaceProduct.amount),
										  int(marketplaceProduct.price),
										  0);
										  
					product.dbId = int(marketplaceProduct.dbId);
				
					UserData.getInstance.removeFromMarketplace(product);
				}
			}						
						
			// restore products in buildings
			for each (var buildingProduct:Object in response.buildingProducts)
			{
				for each (var placeable:PlaceableObject in gameMap.placeableVector)
				{
					if (placeable.objectSpecificContent.dbID == buildingProduct.buildingId)
					{						
						trace("PROGRESS: ", int(buildingProduct.progress), buildingProduct.amount);
						if (int(buildingProduct.progress) > 0 && int(buildingProduct.progress) < 100)
						{
							gameMap.selectedPlaceable = placeable;
							currentProductionAmount = int(buildingProduct.amount);
							startProcess("production", int(buildingProduct.progress));
						}
						else if(int(buildingProduct.amount) > 0)
						{
							placeable.objectSpecificContent.storedAmount = buildingProduct.amount;
							
							placeable.objectSpecificContent.FLAG_ready = true;
							placeable.objectSpecificContent.FLAG_producing = false;
							
							placeable.objectFace.setStatus("ready");
							placeable.objectFace.statusIcon.setStatus("ready");
							
							break;
						}
					}
				}
			}						
			
			FLAG_dataRestored = true;
			
			gameMap.selectedPlaceable = null;
			
			addClouds(null);
		}
		
		/**
		 * Shows the startup and login screen.
		 */
		private function initLoginScreen():void 
		{
			pregameClip = new pregameContainer();
			this.addChild(pregameClip);
			pregameClip.x = 0;
			pregameClip.y = 0;
		}
		
		/**
		 * Starts gameplay. Removes the login screen if it was on stage.
		 */
		public function initGameplay(e:Event=null):void
		{			
			SoundManager.instance.stopSound( { name:"bgmMenu" } );
			SoundManager.instance.playSound( { name:"bgmGame", group:"music", loops:9999} );
			
			//GameEvent.dispatcher.removeEventListener(GameEvent.GAME_START, initGameplay);
			
			if (pregameClip) this.removeChild(pregameClip);			
			
			removeBlocker();
			
			if (fakeLoader)
			{
				fakeLoader.filters = [];
				fakeLoader.parent.removeChild(fakeLoader);
			}
			
			// add the graphics container to the display list
			gameClip = new interfaceContainer();
			this.addChild(gameClip);
						
			Framework.instance.registerInterface(gameClip);
			
			// get hud reference
			hud = Hud(gameClip.getChildByName("gameHud"));
			hud.updateRoundTimer(roundTimeLeft, roundTime);
			
			buildingList = BuildingList(gameClip.getChildByName("gameBuildings"))
			
			ObjectParser.parseObjects(new ObjectsToParse());
			
			// add the tile engine to the graphics container
			gameMap = new GameMap();			
			MovieClip(gameClip["gridContainer"]).addChild(gameMap);
			
			gameMap.addStaticTileGroup("objects", true);
			gameMap.fenceVisibleArea();
			
			gameMap.setDisplayOrder();
			
			gameMap.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			gameMap.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
			
			hud.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHudHandler)
			buildingList.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHudHandler)
			hud.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHudHandler)
			buildingList.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHudHandler)
			buildingList.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownOnHudHandler)
			
			this.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			
			// register functions called by in-game buttons
			Framework.instance.registerFunction(expandGrid, "expandGrid");
			Framework.instance.registerFunction(removeBuildingRequest, "removePlaceableObject");
			Framework.instance.registerFunction(movePlaceableObject, "movePlaceableObject");
			Framework.instance.registerFunction(sendCloseCommand, "closeCommand");
			Framework.instance.registerFunction(showMarketplace, "showMarketplace");
			Framework.instance.registerFunction(showWarehouse, "showWarehouse");
			Framework.instance.registerFunction(showFinances, "showFinances");
			Framework.instance.registerFunction(changeQuality, "changeQuality");
			Framework.instance.registerFunction(soundOptions, "soundOptions");
			Framework.instance.registerFunction(qualityOptions, "qualityOptions");
			Framework.instance.registerFunction(startProcess, "startProcess");
			Framework.instance.registerFunction(removeWarehouseItem, "removeWarehouseItem");
			Framework.instance.registerFunction(removeMarketplaceItem, "removeMarketplaceItem");
			Framework.instance.registerFunction(sendToMarketplacePopup, "sendToMarketplacePopup");
			Framework.instance.registerFunction(sendToWarehouse, "sendToWarehouse");
			Framework.instance.registerFunction(removeRottenProducts, "removeRottenProducts");
			Framework.instance.registerFunction(upgradeDialog, "upgradeDialog");
			Framework.instance.registerFunction(removeItemFromWarehouse, "doRemoveItem");
			Framework.instance.registerFunction(sendGameInfoPopup, "infoPopup");
			Framework.instance.registerFunction(showStatisticsPopup, "showStatistics");
			Framework.instance.registerFunction(showClickableTutorial, "showTutorial");
			
			GameEvent.dispatcher.addEventListener(GameEvent.SIMULATION_START, roundEnd);			
			
			//roundTimer.addEventListener(TimerEvent.TIMER, timerUpdateHandler);
			//roundTimer.start();		
			
			//addClouds(null);		
			
			if (startTutorial)
			{
				tutorialClip = new tutorial();
				tutorialFrames = tutorialClip.totalFrames;
			
				gameClip.addChild(tutorialClip);
				tutorialClip.addEventListener(Event.ENTER_FRAME, checkTutorialEnd);
				
				stage.addEventListener(KeyboardEvent.KEY_DOWN, konamiCodeHandler);
				
				roundTimer.stop();
			}
			else
			{
				wiesiekTalk = new wiesiekTalking();
				wiesiekTalk.x = 0;
				wiesiekTalk.y = 0;			
				
				gameClip.addChild(wiesiekTalk);
				
				wiesiekTalk.addEventListener(MouseEvent.MOUSE_DOWN, hideWiesiek);
			}
		}
		
		private function showClickableTutorial():void
		{
			tutorialClip = new tutorial();
			tutorialFrames = tutorialClip.totalFrames;
			
			tutorialClip.addChild(new clickMessage());
		
			this.addChild(tutorialClip);
			tutorialClip.addEventListener(Event.ENTER_FRAME, checkTutorialEnd);
			tutorialClip.addEventListener(MouseEvent.CLICK, removeTutorial);
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, konamiCodeHandler);
		}
		
		private function removeTutorial(e:MouseEvent):void 
		{
			tutorialClip.removeEventListener(Event.ENTER_FRAME, checkTutorialEnd);
			tutorialClip.removeEventListener(MouseEvent.CLICK, removeTutorial);
			
			stage.removeEventListener(KeyboardEvent.KEY_DOWN, konamiCodeHandler);
			
			tutorialClip.parent.removeChild(tutorialClip);
		}
		
		private function mouseDownOnHudHandler(e:MouseEvent):void 
		{
			if (GameSettings.GAME_MODE == GameSettings.BUILDMODE)
			{				
				gameMap.unselectObject();
				hideTooltip();
			}
		}
		
		private function konamiCodeHandler(e:KeyboardEvent):void 
		{
			if (testSequence.length >= 4) testSequence = "";
			
			testSequence += e.keyCode.toString();
			
			if (testSequence.slice(testSequence.length - 4, testSequence.length) == "3838")
			{
				testSequence = "";
				
				konamiSequence = "38";
			}
			
			if (konamiSequence.slice(0, 2) == "38")
			{
				konamiSequence += e.keyCode.toString();
				
				if (konamiSequence == "38384040373937396665")
				{
					trace("K-K-K-KONAMI C-C-C-CODE!!!!");
					
					Wiesiek.wiesiekFrame = 2;
					
					if (tutorialClip && tutorialClip["wiesiek"])
					{
						Wiesiek(tutorialClip["wiesiek"]).gotoAndStop(2);
					}
					
					stage.removeEventListener(KeyboardEvent.KEY_DOWN, konamiCodeHandler);
				}
			}
		}
		
		private function checkTutorialEnd(e:Event):void 
		{
			if (tutorialFrames == tutorialClip.currentFrame)
			{
				tutorialClip.removeEventListener(Event.ENTER_FRAME, checkTutorialEnd);
				tutorialClip.parent.removeChild(tutorialClip);
				
				stage.removeEventListener(KeyboardEvent.KEY_DOWN, konamiCodeHandler);
				
				if (startTutorial)
				{
					roundTimer.start();
				
					communicator.callExtension("usersExt", "countdownSimulation", { } );
					
					wiesiekTalk = new wiesiekTalking();
					wiesiekTalk.x = 0;
					wiesiekTalk.y = 0				
					
					this.addChild(wiesiekTalk);
					
					wiesiekTalk.addEventListener(MouseEvent.MOUSE_DOWN, hideWiesiek);
				}
			}
		}
		
		private function hideWiesiek(e:MouseEvent):void 
		{
			wiesiekTalk.removeEventListener(MouseEvent.MOUSE_DOWN, hideWiesiek);
			
			if (wiesiekTalk.currentLabel != "hide") wiesiekTalk.gotoAndPlay("hide");
			
			wiesiekTalk = null;
		}
		
		public function showStatisticsPopup(productId:int = -1):void 
		{
			popup = new statisticsPopup();
			popup.popupID = -17;
			
			if (productId < 0) 
			{
				StatisticsPopup(popup).activeTab = "balance";
				StatisticsPopup(popup).populate("balance");
			}
			
			if (productId > 0)
			{
				StatisticsPopup(popup).activeTab = "statistics";
				StatisticsPopup(popup).populate("productStats", productId);			
				//StatisticsPopup(popup).showProductGraph(productId);			
			}
			
			gameClip.addChild(popup);
		}
		
		private function addClouds(e:Event):void
		{
			cloudsNumber = Math.round(Math.random() * 3) + 1;
			
			cloudsClip = new cloudsAll();
			cloudsClip.gotoAndPlay("clouds"+cloudsNumber.toString());
			
			cloudsClip.x = 0;
			cloudsClip.y = 0;
			
			cloudsClip.mouseEnabled = false;
			cloudsClip.mouseChildren = false;
			
			gameMap.foregroundLayer.addChild(cloudsClip);
			
			if(!cloudsClip.hasEventListener(Event.REMOVED_FROM_STAGE)) cloudsClip.addEventListener(Event.REMOVED_FROM_STAGE, addClouds);
		}
		
		public function showChartsPopup(product:String):void 
		{			
			popup = new chartsPopup();
			popup.popupID = -17;
			
			var params:Array = [];
			
			params.push(new Bitmap(BitmapData(new (getDefinitionByName(GameSettings.PRODUCTS[product].productIcon) as Class )())));
			
			params.push(GameSettings.PRODUCTS[product].productName);
			
			params.push("1") // TODO: set round number
			
			params.push(new Vector.<Product>);
			
			ChartsPopup(popup).populate(params);
			
			gameClip.addChild(popup);
		}
		
		private function sendGameInfoPopup(infoType:String):void 
		{
			var tempPopup:GameInfoPopup = new gameInfoPopup();
			
			tempPopup.populate(infoType);
			
			if (popup) tempPopup.popupBeneath = popup;
			
			gameClip.addChild(tempPopup);
		}
		
		private function upgradeDialog():void 
		{
			var tempPopup:UpgradePopup = new upgradePopup();
			
			var paramsVector:Array = [];				
			
			paramsVector.push(gameMap.selectedPlaceable.objectSettings["name"]);
			
			if (gameMap.selectedPlaceable.objectSettings["type"] == "storage")
			{
				tempPopup.setWarehouseOverlay();
				
				Warehouse(gameMap.selectedPlaceable.objectSpecificContent).currentID = gameMap.selectedPlaceable.ID;
				
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["costLevel" + (Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel+1).toString()]);
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["capacityLevel" + (Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel).toString() ]);
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["capacityLevel" + (Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel+1).toString()]);
			}
			else
			{
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["costLevel" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel+1).toString()]);
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["productionTime" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel).toString() ]);
				paramsVector.push(gameMap.selectedPlaceable.objectSettings["productionTime" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel+1).toString()]);
			}		
			
			var icon:MovieClip = MovieClip(new (getDefinitionByName(gameMap.selectedPlaceable.objectSettings["graphicAssetName"] + "_icon") as Class)());
			
			if (gameMap.selectedPlaceable.objectSettings["type"] == "storage")
			{
				icon.gotoAndStop(Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel);
			}
			else
			{
				icon.gotoAndStop(gameMap.selectedPlaceable.objectSpecificContent.structureLevel);
			}
			
			paramsVector.push(icon);
			
			icon = null;
			icon = MovieClip(new (getDefinitionByName(gameMap.selectedPlaceable.objectSettings["graphicAssetName"] + "_icon") as Class)());
			
			if (gameMap.selectedPlaceable.objectSettings["type"] == "storage")
			{
				icon.gotoAndStop(Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel+1);
			}
			else
			{
				icon.gotoAndStop(gameMap.selectedPlaceable.objectSpecificContent.structureLevel+1);
			}
			
			paramsVector.push(icon);
			
			paramsVector.push(gameMap.selectedPlaceable);
			
			UpgradePopup(tempPopup).populate(paramsVector);
			
			gameClip.addChild(tempPopup);
		}
		
		private function synchronizeTime(e:GameEvent):void 
		{
			if (roundTimer)
			{
				roundTimer.removeEventListener(TimerEvent.TIMER, timerUpdateHandler);
				roundTimer.stop();
			}
			
			roundTime = int(e.parameters.targetTime);
			roundTimeLeft = int(e.parameters.time);
						
			roundTimer = null;
			roundTimer = new Timer(1000, roundTime);
			roundTimer.addEventListener(TimerEvent.TIMER, timerUpdateHandler);
			
			trace("TUTORIAL: ", e.parameters.isTutorial);
			if (int(e.parameters.isTutorial) != 1)
			{
				roundTimer.start();			
			}
			else startTutorial = true;
			
			if (e.parameters.firstRoundId != undefined && e.parameters.firstRoundId > -1)
			{
				currentRoundId = int(e.parameters.firstRoundId);
			}
		}
		
		private function qualityOptions():void 
		{		
			if (optionsTooltip)
			{
				optionsTooltip.hide();
				var flag:Array = getQualifiedClassName(optionsTooltip).match("quality");
				optionsTooltip = null;
				
				if (flag) return;
			}
			
			hideTooltip();
			
			optionsTooltip = new qualityTooltip();
			optionsTooltip.fixedPosition(684.2, buildingList.container.getChildByName("call_qualityOptions$lockEnabled_false$").y);
			
			MovieClip(buildingList.getChildByName("content")).addChild(optionsTooltip);		
			optionsTooltip.clickEnabled();
		}
		
		private function soundOptions():void 
		{		
			if (optionsTooltip)
			{
				optionsTooltip.hide();
				var flag:Array = getQualifiedClassName(optionsTooltip).match("sound");
				optionsTooltip = null;
				
				if (flag) return;
			}
			
			hideTooltip();
			
			optionsTooltip = new soundTooltip();			
			optionsTooltip.fixedPosition(725.35, buildingList.container.getChildByName("call_soundOptions$lockEnabled_false$").y);
			
			MovieClip(buildingList.getChildByName("content")).addChild(optionsTooltip);
			optionsTooltip.clickEnabled();
		}
		
		private function mouseMoveHandler(e:MouseEvent):void 
		{
			if (gameMap.FLAG_unfixedPlaceableOnGrid)
			{				
				if (hud.hitTestPoint(stage.mouseX, stage.mouseY) || buildingList.hitTestPoint(stage.mouseX, stage.mouseY) || blocker)
				{
					gameMap.disablePlaceableMouse();
				}
				else
				{
					gameMap.enablePlaceableMouse();
				}
			}
		}
		
		private function mouseOutHudHandler(e:MouseEvent):void 
		{
			// If the tooltip exists and is visible
			if (tooltip && tooltip.parent)
			{
				// If it's not a click enabled tooltip - hide it
				if(!tooltip.FLAG_clickEnabled) tooltip.hide();
			}
			// Tooltip doesn't exist or isn't visible anymore so clear it's reference for safety
			else
			{
				tooltip = null;
			}
		}
		
		private function mouseOverHudHandler(e:MouseEvent):void 
		{							
			if (e.target.name == "timeCounter")
			{
				// If the tooltip is visible and belongs to the current object - show it
				if (tooltip && tooltip.parent && tooltipID == -1)
				{
					tooltip.show((roundTimeLeft / 60 < 10 ? "0": "") + Math.floor(roundTimeLeft / 60).toString() + ":" + (roundTimeLeft % 60 < 10 ? "0": "") + Math.floor(roundTimeLeft % 60).toString());
				}
				// Tooltip does not exist or doesn't belong to the current object, so create a new one
				else
				{
					// Hide the old tooltip if it still exists
					if (tooltip && tooltip.parent)
					{
						tooltip.hide();
					}
					
					tooltip = new clockTooltip();		
					tooltipID = -1;
					this.addChild(tooltip);
					tooltip.show((roundTimeLeft / 60 < 10 ? "0": "") + Math.floor(roundTimeLeft / 60).toString() + ":" + (roundTimeLeft % 60 < 10 ? "0": "") + Math.floor(roundTimeLeft % 60).toString());
				}
			}
			else if (getQualifiedClassName(e.target.parent).match("buildingListItem"))
			{
				// If the tooltip is visible and belongs to the current object - show it
				if (tooltip && tooltip.parent && tooltipID == -2)
				{
					var rect:Rectangle = BuildingListItem(e.target.parent.parent).getBounds(BuildingListItem(e.target.parent.parent).parent);
					var coords:Point = new Point(rect.left + rect.width / 2, rect.topLeft.y);
					coords = BuildingListItem(e.target.parent.parent).parent.localToGlobal(coords);
					
					tooltip.fixedPosition(coords.x, coords.y);
					
					tooltip.show(BuildingListItem(e.target.parent.parent).objectSettings["name"]);
				}
				// Tooltip does not exist or doesn't belong to the current object, so create a new one
				else
				{
					// Hide the old tooltip if it still exists
					if (tooltip && tooltip.parent)
					{
						tooltip.hide();
					}
					
					tooltip = new balloonTooltip();
					
					rect = BuildingListItem(e.target.parent.parent).getBounds(BuildingListItem(e.target.parent.parent).parent);
					coords = new Point(rect.left + rect.width / 2, rect.topLeft.y);
					coords = BuildingListItem(e.target.parent.parent).parent.localToGlobal(coords);
					
					tooltip.fixedPosition(coords.x, coords.y);					
					tooltipID = -2;
					this.addChild(tooltip);
					tooltip.show(BuildingListItem(e.target.parent.parent).objectSettings["name"]);
				}
			}
			else if (e.target.parent && e.target.parent.parent && getQualifiedClassName(e.target.parent.parent).match("interface_buildingList") && !e.target.name.match("closeCommand"))
			{
				// If the tooltip is visible and belongs to the current object - show it
				if (tooltip && tooltip.parent && tooltipID == -2)
				{			
					var tooltipText:String;
					
					if (e.target.name.match("expand")) tooltipText = "Powiększ teren";
					else if (e.target.name.match("tab_1")) tooltipText = "Przemysł owocowy";
					else if (e.target.name.match("tab_2")) tooltipText = "Przemysł warzywny";
					else if (e.target.name.match("tab_3")) tooltipText = "Przemysł zbożowy";
					else if (e.target.name.match("tab_4")) tooltipText = "Przemysł nabiałowy";
					else if (e.target.name.match("tab_5")) tooltipText = "Przemysł mięsny";
					else if (e.target.name.match("tab_6")) tooltipText = "Magazyny";
					else if (e.target.name.match("buildMode")) tooltipText = "Tryb budowania";
					else if (e.target.name.match("quality")) tooltipText = "Opcje jakości grafiki";
					else if (e.target.name.match("soundOptions")) tooltipText = "Opcje dźwięku";
					else return;
					
					rect = e.target.getBounds(e.target.parent);
					coords = new Point(rect.left + rect.width / 2, rect.top);
					coords = e.target.parent.localToGlobal(coords);					
					
					tooltip.fixedPosition(coords.x, coords.y);
					
					tooltip.show(tooltipText);
				}
				// Tooltip does not exist or doesn't belong to the current object, so create a new one
				else
				{
					// Hide the old tooltip if it still exists
					if (tooltip && tooltip.parent)
					{
						if(!tooltip.FLAG_clickEnabled) tooltip.hide();
					}
					
					if (e.target.name.match("expand")) tooltipText = "Powiększ teren";
					else if (e.target.name.match("tab_1")) tooltipText = "Przemysł owocowy";
					else if (e.target.name.match("tab_2")) tooltipText = "Przemysł warzywny";
					else if (e.target.name.match("tab_3")) tooltipText = "Przemysł zbożowy";
					else if (e.target.name.match("tab_4")) tooltipText = "Przemysł nabiałowy";
					else if (e.target.name.match("tab_5")) tooltipText = "Przemysł mięsny";
					else if (e.target.name.match("tab_6")) tooltipText = "Magazyny";
					else if (e.target.name.match("buildMode")) tooltipText = "Tryb budowania";
					else if (e.target.name.match("quality")) tooltipText = "Opcje jakości grafiki";
					else if (e.target.name.match("soundOptions")) tooltipText = "Opcje dźwięku";
					else 
					{
						tooltip = null;
						return;
					}
					
					tooltip = new balloonTooltip();
					
					rect = e.target.getBounds(e.target.parent);
					coords = new Point(rect.left + rect.width / 2, rect.top);
					coords = e.target.parent.localToGlobal(coords);					
										
					tooltip.fixedPosition(coords.x, coords.y);
					
					tooltipID = -2;
					this.addChild(tooltip);
					tooltip.show(tooltipText);
				}
			}
			else if (e.target.parent && getQualifiedClassName(e.target.parent).match("interface_hud_hudBar"))
			{
				// If the tooltip is visible and belongs to the current object - show it
				if (tooltip && tooltip.parent && tooltipID == -2)
				{
					if (e.target.name.match("call_showWarehouse")) tooltipText = "Magazyny";
					else if (e.target.name.match("call_showMarketplace")) tooltipText = "Rynek";
					else if (e.target.name.match("call_showFinances")) tooltipText = "Bank";
					else if (e.target.name.match("call_showStatistics")) tooltipText = "Statystyki";					
					else if (e.target.name.match("call_showTutorial")) tooltipText = "Samouczek";
					else if (e.target.name.match("call_infoPopup")) tooltipText = "Info";
					else return;
					
					tooltip.tooltipType("down");
					
					rect = e.target.getBounds(e.target.parent);
					coords = new Point(rect.left + rect.width / 2, rect.bottom);					
					coords = e.target.parent.localToGlobal(coords);							
					
					tooltip.fixedPosition(coords.x, coords.y);
					
					tooltip.show(tooltipText);
				}
				// Tooltip does not exist or doesn't belong to the current object, so create a new one
				else
				{
					// Hide the old tooltip if it still exists
					if (tooltip && tooltip.parent)
					{
						tooltip.hide();
					}					
										
					if (e.target.name.match("call_showWarehouse")) tooltipText = "Magazyny";
					else if (e.target.name.match("call_showMarketplace")) tooltipText = "Rynek";
					else if (e.target.name.match("call_showFinances")) tooltipText = "Bank";
					else if (e.target.name.match("call_showStatistics")) tooltipText = "Statystyki";
					else if (e.target.name.match("call_showTutorial")) tooltipText = "Samouczek";
					else if (e.target.name.match("call_infoPopup")) tooltipText = "Info";
					else
					{
						tooltip = null;
						return;
					}
					
					tooltip = new balloonTooltip();
					
					tooltip.tooltipType("down");
					
					rect = e.target.getBounds(e.target.parent);
					coords = new Point(rect.left + rect.width / 2, rect.bottom);					
					coords = e.target.parent.localToGlobal(coords);	
					
					tooltip.fixedPosition(coords.x, coords.y);
					
					tooltipID = -2;
					this.addChild(tooltip);
					tooltip.show(tooltipText);
				}
			}
						
		}
		
		/**
		 * Removes rotten products from a selected building on game grid.
		 */
		public function removeRottenProducts():void 
		{
			gameMap.selectedPlaceable.objectSpecificContent.removeRotten();
			
			if (popup && popup.popupID == gameMap.selectedPlaceable.ID)
			{
				//if (gameMap.selectedPlaceable.objectSettings["type"] != "production") BuildingDescriptionPopup(popup).setNormalOverlay();
				//else BuildingDescriptionPopup(popup).setNormal2Overlay();
			}
			
			gameMap.selectedPlaceable.objectFace.isRotten = true;
			gameMap.selectedPlaceable.objectFace.statusIcon.setStatus("idle");
			gameMap.selectedPlaceable.objectFace.setStatus("idle");
			
			sendCloseCommand();
		}
		
		/**
		 * Moves the products from a selected building to a warehouse.
		 */
		public function sendToWarehouse():void
		{
			// If the warehouse exists and has the available space to store the product
			if (UserData.getInstance.storeInWarehouse(new Product(gameMap.selectedPlaceable.objectSpecificContent.outputProduct,
																  gameMap.selectedPlaceable.objectSettings["outputProductName"],
																  GameSettings.PRODUCTS[gameMap.selectedPlaceable.objectSpecificContent.outputProduct].productId,
															      gameMap.selectedPlaceable.objectSpecificContent.outputType,
															      gameMap.selectedPlaceable.objectSpecificContent.storedAmount,
															      0,
															      gameMap.selectedPlaceable.objectSpecificContent.dbID
																  )))
			{
				var amount:int = gameMap.selectedPlaceable.objectSpecificContent.storedAmount;
				
				// Empty the building's storage space
				gameMap.selectedPlaceable.objectSpecificContent.emptyStorage();
				// and update it's status icon
			    StructureGraphics(gameMap.selectedPlaceable.objectFace).statusIcon.setStatus("idle");
			    StructureGraphics(gameMap.selectedPlaceable.objectFace).setStatus("idle");
				
				gameMap.selectedPlaceable.objectSpecificContent.FLAG_ready = false;
				
				//if(gameMap.selectedPlaceable.objectSettings["type"] == "production") BuildingDescriptionPopup(popup).setNormal2Overlay();
				//else BuildingDescriptionPopup(popup).setNormalOverlay();
				
				addToWarehouseAnim(gameMap.selectedPlaceable, amount);
				
				//sendCloseCommand();
			}
			// If there is no such warehouse or there isn't enough space to store the products
			else
			{
				// create and display a popup informing the user that the warehouse doesn't exist or there isn't enough space
				popup = new warningPopup();
				popup.popupID = -13;
					
				if (!UserData.getInstance.getWarehouse(gameMap.selectedPlaceable.objectSpecificContent.outputType))
				{
					WarningPopup(popup).setWarning("noWarehouse" + gameMap.selectedPlaceable.objectSpecificContent.outputType);
				}				
				else if (UserData.getInstance.warehouseFreeSpace(gameMap.selectedPlaceable.objectSpecificContent.outputType) < gameMap.selectedPlaceable.objectSpecificContent.storedAmount)
				{
					WarningPopup(popup).setWarning("noCapacity" + gameMap.selectedPlaceable.objectSpecificContent.outputType);
				}								
			
				popup.x = 0;
				popup.y = 0;
				
				gameClip.addChild(popup);
			}
		}
		
		private function addToWarehouseAnim(placeable:PlaceableObject, amount:int):void 
		{
			var product:Bitmap = new Bitmap(new (getDefinitionByName(GameSettings.PRODUCTS[placeable.objectSpecificContent.outputProduct].productIcon) as Class)());
			
			var coords:Point = placeable.parent.localToGlobal(new Point(placeable.getBounds(placeable.parent).left + placeable.width / 2, placeable.getBounds(placeable.parent).top + placeable.height/2));
			product.x = coords.x;
			product.y = coords.y;
					
			this.addChild(product);
			
			var warehouseButton:MovieClip = MovieClip(hud.getChildByName("call_showWarehouse$lockEnabled_false$"));
			
			var target:Point = new Point(warehouseButton.x, warehouseButton.y);
			target = hud.localToGlobal(target);
			
			TweenLite.to(product, 0.7, {x:target.x-warehouseButton.width/2, y:target.y-warehouseButton.height/2, alpha:0.5, ease:Quad.easeInOut, onComplete:addAnimEnd, onCompleteParams:[product, amount] } );			
		}
		
		private function addAnimEnd(product:Bitmap, amount:int):void
		{
			product.parent.removeChild(product);
			
			var anim:MovieClip = new addItemsAnim();
			anim.x = 457.9;
			anim.y = -3.25;
			TextField(MovieClip(anim["amountClip"])["amountText"]).text = amount.toString();
			
			hud.addChild(anim);		
			
			SoundManager.instance.playSound( { name:"productAdded", group:"sound", duplicate:true } );
		}
		
		/**
		 * Displays a small popup in which the user can input the amount an price of products which he wants to put on market.
		 */
		private function sendToMarketplacePopup():void 
		{
			// If the item already is on market - terminate the action
			if (!GameSettings.selectedItem || GameSettings.selectedItem.onMarket) return;
			
			var tempPopup:SendToMarketplacePopup = new popupSendToMarketplace();
			
			tempPopup.x = 0;
			tempPopup.y = 0;
			
			tempPopup.populate(GameSettings.selectedItem.type, GameSettings.selectedItem.product);
			
			if (popup) tempPopup.popupBeneath = popup;
			
			gameClip.addChild(tempPopup);
		}
		
		/**
		 * Removes a product from warehouse. Used in the warehouse popup.
		 */
		private function removeWarehouseItem():void 
		{
			var tempPopup:RemoveFromWarehousePopup = new removeFromWarehousePopup();
			
			var paramsVector:Array = [];
			
			paramsVector.push(new Bitmap(BitmapData(new (getDefinitionByName(GameSettings.PRODUCTS[GameSettings.selectedItem.product].productIcon) as Class)())));
			paramsVector.push(GameSettings.selectedItem.amount);
			
			tempPopup.populate(paramsVector);
			
			gameClip.addChild(tempPopup);
		}
		
		private function removeItemFromWarehouse():void
		{
			if (!GameSettings.selectedItem) return;
			
			UserData.getInstance.removeFromWarehouse(GameSettings.selectedItem.type, GameSettings.selectedItem.product, GameSettings.selectedItem.removeAmount);
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UPDATE_POPUP, { itemList:UserData.getInstance.getWarehouseProducts(GameSettings.selectedItem.type) } ));
			
			sendCloseCommand();
		}
		
		/**
		 * Remove a product from marketplace. Used in the marketplace popup or the marketplace tab in warehouse popup.
		 */
		private function removeMarketplaceItem():void 
		{
			if (!GameSettings.selectedItem) return;
			
			if (!GameSettings.selectedItem.onMarket) return;
			
			UserData.getInstance.removeFromMarketplace(GameSettings.selectedItem);
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UPDATE_POPUP, {itemList:UserData.getInstance.getProductsOnMarketplace()}));
		}	
		
		/**
		 * Starts an in-game process.
		 * @param	processType - the type of the process to launch.
		 */
		public function startProcess(processType:String,startPoint:int=0):void 
		{
			switch (processType)
			{
				// Create a new production process and add it to the process queue
				case "production":
				{
					if (StructureData(gameMap.selectedPlaceable.objectSpecificContent).storedAmount == 0 && !StructureData(gameMap.selectedPlaceable.objectSpecificContent).FLAG_producing && currentProductionAmount > 0)
					{	
						if (FLAG_dataRestored)
						{
							if (gameMap.selectedPlaceable.objectSettings["type"] == "process")
							{
								if (!UserData.getInstance.getWarehouse(gameMap.selectedPlaceable.objectSpecificContent.inputType) || (UserData.getInstance.getWarehouse(gameMap.selectedPlaceable.objectSpecificContent.inputType) && 
									StructureData(gameMap.selectedPlaceable.objectSpecificContent).inputProduct != "undefined" && !UserData.getInstance.getWarehouse(gameMap.selectedPlaceable.objectSpecificContent.inputType).isProductAvailable(gameMap.selectedPlaceable.objectSpecificContent.inputProduct,
									Math.round(gameMap.selectedPlaceable.objectSettings["inputProductAmount"] * currentProductionAmount))))
								{
									// create and display a popup informing the user that the warehouse doesn't exist or there isn't enough space
									var warning:WarningPopup = new warningPopup();
									WarningPopup(warning).setWarning("noInputProduct");
									warning.popupBeneath = popup;
									warning.popupID = -13;
									
									warning.x = 0;
									warning.y = 0;
									
									gameClip.addChild(warning);
									
									return;
								}
							}
						}
						
						StructureGraphics(gameMap.selectedPlaceable.objectFace).statusIcon.setStatus("progress");					
						StructureGraphics(gameMap.selectedPlaceable.objectFace).setStatus("progress");					
										
						processQueue.push(new ProcessProduction(gameMap.selectedPlaceable.ID,
																gameMap.selectedPlaceable,
																gameMap.selectedPlaceable.objectSpecificContent.outputProduct,
																gameMap.selectedPlaceable.objectSpecificContent.inputProduct,
																gameMap.selectedPlaceable.objectSettings["inputProductAmount"],
																gameMap.selectedPlaceable.objectSpecificContent.inputType,
																currentProductionAmount,
																gameMap.selectedPlaceable.objectSpecificContent.unitProductionTime,
																gameMap.selectedPlaceable.objectSpecificContent.unitProductionCost,
																startPoint));
																
						StructureData(gameMap.selectedPlaceable.objectSpecificContent).FLAG_producing = true;
						
						//BuildingDescriptionPopup(popup).setProductionOverlay();
						
						_currentProductionAmount = 0;
						
						sendCloseCommand();
					}
					break;
				}
				// Create a new upgrade process and add it to the process queue
				case "upgrade":
				{
					if ((gameMap.selectedPlaceable.objectSettings["costLevel" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1).toString()] != undefined &&
						gameMap.selectedPlaceable.objectSettings["costLevel" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1).toString()] <= UserData.getInstance.money && 
						!StructureData(gameMap.selectedPlaceable.objectSpecificContent).FLAG_producing) || !FLAG_dataRestored)
					{
						StructureGraphics(gameMap.selectedPlaceable.objectFace).statusIcon.setStatus("building");
						StructureGraphics(gameMap.selectedPlaceable.objectFace).setStatus("construction");
										
						processQueue.push(new ProcessUpgrade(gameMap.selectedPlaceable.ID,
															 gameMap.selectedPlaceable,
															 gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1,
															 gameMap.selectedPlaceable.objectSettings["constructionTime" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1).toString()],
															 gameMap.selectedPlaceable.objectSettings["costLevel" + (gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1).toString()],
															 startPoint));
																
						StructureData(gameMap.selectedPlaceable.objectSpecificContent).FLAG_upgrading = true;
						
						if(gameMap.selectedPlaceable.objectSpecificContent.structureLevel > 0) sendCloseCommand();
					}
					break;
				}
			}
			
			// Listen to an event indicating an end of a process. Only one listener should exist so it ther is one - don't add another.
			//if (!GameEvent.dispatcher.hasEventListener(GameEvent.PROCESS_END)) GameEvent.dispatcher.addEventListener(GameEvent.PROCESS_END, endProcess);
			_processQueue[_processQueue.length - 1].addEventListener(GameEvent.PROCESS_END, endProcess);
		}
		
		/**
		 * Called when a process has ended and it's results need to be applied to the object, which launched the process.
		 * @param	e
		 */
		private function endProcess(e:GameEvent):void 
		{			
			var process:ProcessBase = e.parameters.process;
			
			process.removeEventListener(GameEvent.PROCESS_END, endProcess);
			
			// Remove the process object from the process queue
			var index:int = processQueue.indexOf(process);
			processQueue.splice(index, 1);			
			
			// if this was a production process
			if (StructureData(PlaceableObject(process.structure).objectSpecificContent).FLAG_producing)
			{								
				// set the corresponding building's status icon to "ready"
				StructureGraphics(PlaceableObject(process.structure).objectFace).statusIcon.setStatus("ready");
				StructureGraphics(PlaceableObject(process.structure).objectFace).setStatus("ready");
				
				// change the building's status
				StructureData(PlaceableObject(process.structure).objectSpecificContent).FLAG_producing = false;
				StructureData(PlaceableObject(process.structure).objectSpecificContent).FLAG_ready = true;
				
				// update necessary building data and store the produced product
				var data:StructureData = StructureData(PlaceableObject(process.structure).objectSpecificContent);
				data.storeProduct(new Product(data.outputProduct, PlaceableObject(process.structure).objectSettings["outputProductName"], GameSettings.PRODUCTS[data.outputProduct].productId, data.outputType, int(e.parameters.process["amount"])));
			}
			// if this was an upgrade process
			else if (StructureData(PlaceableObject(process.structure).objectSpecificContent).FLAG_upgrading)
			{
				// set the corresponding building's status icon to "idle"
				StructureGraphics(PlaceableObject(process.structure).objectFace).statusIcon.setStatus("idle");
				StructureGraphics(PlaceableObject(process.structure).objectFace).setStatus("idle");
				
				// change the building's status
				var stopUpgrade:Boolean = true;
				
				for each (var pr:ProcessBase in _processQueue)
				{
					if (PlaceableObject(process.structure).objectSpecificContent is Warehouse)
					{
						stopUpgrade = false;
						break;
					}
				}
				
				if(stopUpgrade) StructureData(PlaceableObject(process.structure).objectSpecificContent).FLAG_upgrading = false;
											
				// If the building is a warehouse
				if (PlaceableObject(process.structure).objectSettings["type"] != "storage")
				{			
					// Increase the building's level
					var level:int = ++StructureData(PlaceableObject(process.structure).objectSpecificContent).structureLevel;
					
					StructureData(PlaceableObject(process.structure).objectSpecificContent).upgradeCost = PlaceableObject(process.structure).objectSettings["costLevel" + String(level + 1)];
					
					// Update the warehouse information so it represents it's new level
					data = StructureData(PlaceableObject(process.structure).objectSpecificContent);
					
					data.unitProductionTime = Number(PlaceableObject(process.structure).objectSettings["productionTime" + level.toString() ]);
					data.unitProductionCost = int(PlaceableObject(process.structure).objectSettings["productionCost" + level.toString() ]);
				}
				// and if it's a regular building
				else
				{
					// Increase the building's level
					Warehouse(PlaceableObject(process.structure).objectSpecificContent).currentID = PlaceableObject(process.structure).ID;
					level = ++Warehouse(PlaceableObject(process.structure).objectSpecificContent).structureLevel;
					
					Warehouse(PlaceableObject(process.structure).objectSpecificContent).upgradeCost = PlaceableObject(process.structure).objectSettings["costLevel" + String(level + 1)];
					
					// Update the warehouse information so it represents it's new level
					var wData:Warehouse = Warehouse(PlaceableObject(process.structure).objectSpecificContent);
					
					//if (level > 1)
					{
						wData.capacity += int(PlaceableObject(process.structure).objectSettings["capacityLevel" + level.toString()]) - int(PlaceableObject(process.structure).objectSettings["capacityLevel" + (level-1).toString()]);		
						wData.expandFreeSpace(int(PlaceableObject(process.structure).objectSettings["capacityLevel" + level.toString()]) - int(PlaceableObject(process.structure).objectSettings["capacityLevel" + (level-1).toString()]));
					}
					
					if(level == 1 && !UserData.getInstance.getWarehouse(PlaceableObject(process.structure).objectSettings["inputType"])) UserData.getInstance.addWarehouse(PlaceableObject(process.structure).objectSettings["inputType"], wData);
				}				
			}
		}
		
		/**
		 * The round has ended
		 * @param	e
		 */
		private function roundEnd(e:Event):void 
		{			
			//roundTimer.stop();
			
			trace("ROUND END");
			
			SoundManager.instance.stopSound( { name:"timerTick" } );
			SoundManager.instance.playSound( { name:"timeUpSound", group:"sound" } );
			
			removeScreenBlock();
			
			if (popup && popup.popupID == -15)
			{
				BuyingRoundPopup(popup).FLAG_tooLong = true;
				BuyingRoundPopup(popup).hide();
			}
			
			gameMap.FLAG_blockMouseActions = true;
			
			gameMap.mouseEnabled = false;
			gameMap.mouseEnabled = false;
			gameMap.mouseChildren = false;
			
			buildingList.disable();
			buildingList.mouseEnabled = false;
			buildingList.mouseChildren = false;
			
			hud.mouseEnabled = false;
			hud.mouseChildren = false;
			
			sendCloseCommand(true);
			
			blocker = new Sprite();
			
			blocker.graphics.beginFill(0x000000, 0.5);
			blocker.graphics.drawRect(0, 0, GameSettings.SCREEN_WIDTH, GameSettings.SCREEN_HEIGHT);
			blocker.graphics.endFill();
			blocker.mouseChildren = false;
			blocker.mouseEnabled = true;	
			
			gameClip.addChild(blocker);		
			
			fakeLoader = new miniPreloader();
			fakeLoader.x = blocker.width / 2;
			fakeLoader.y = blocker.height / 2;
			
			var glow:GlowFilter = new GlowFilter(0xFFFFFF, 1, 17, 17, 2);
			
			fakeLoader.filters = [glow];
			
			blocker.addChild(fakeLoader);		
			
			communicator.setExtensionCallback(roundStart, "endSimulation");
		}
		
		private function roundStart(params:Object):void
		{
			fakeLoader.filters = [];
			fakeLoader.parent.removeChild(fakeLoader);
			
			var players:Array = params.players;
			
			var soldProducts:Vector.<Product> = new Vector.<Product>();
			var unsoldProducts:Vector.<Product> = new Vector.<Product>();
			
			var toSell:Vector.<Product> = new Vector.<Product>();
			var toRemove:Vector.<Product> = new Vector.<Product>();
									
			totalProfit = 0;
			
			currentRoundId = int(params.roundId);
			currentRound = int(params.roundNumber)
						
			for each (var player:Object in players)
			{				
				if (int(player.id) == int(UserData.getInstance.userDbID))
				{								
					for each (var product:Product in UserData.getInstance.getProductsOnMarketplace())
					{
						var request:Object = {};
			
						request.roundNumber = currentRound;
						request.roomId = communicator.dbRoomId;
						request.userId = UserData.getInstance.userDbID;
						request.productId = product.productId;
						request.amount = product.amount;
						request.price = product.price;
						request.boughtAmount = 0;
											
						for each (var playerProduct:Object in player.productsList)
						{
							if (int(playerProduct.amount) < int(product.amount) && int(playerProduct.price) == int(product.price) && int(playerProduct.id) == int(product.dbId))
							{
								//UserData.getInstance.marketplace.sellProduct(product);
								toSell.push(product);
								
								UserData.getInstance.money += ((product.amount - int(playerProduct.amount)) * product.price);
								
								totalProfit += ((product.amount - int(playerProduct.amount)) * product.price);
								
								soldProducts.push(new Product(product.product, product.productName, product.productId, product.type, product.amount-int(playerProduct.amount), playerProduct.price, 0, false, false, true));
								
								request.boughtAmount = int(product.amount - int(playerProduct.amount));
								
								if (int(playerProduct.amount) > 0)
								{
									product.amount = int(playerProduct.amount);
																		
									UserData.getInstance.storeInWarehouse(product);
									
									unsoldProducts.push(new Product(product.product, product.productName, product.productId, product.type, product.amount, playerProduct.price, 0, false, false, false, true));
								}
							}
							else if (int(playerProduct.amount) == int(product.amount) && int(playerProduct.price) == int(product.price) && int(playerProduct.id) == int(product.dbId))
							{			
								toRemove.push(product);
								
								request.boughtAmount = 0;
								
								unsoldProducts.push(new Product(product.product, product.productName, product.productId, product.type, product.amount, playerProduct.price, 0, false, false, false, true));
							}
						}
												
						communicator.callExtension("historyExt", "setOfferHistory", request); //TODO: zoptymalizować!!
					}
				}
			}
			
			for each (product in toSell)
			{
				UserData.getInstance.marketplace.sellProduct(product);
			}
			
			for each (product in toRemove)
			{
				UserData.getInstance.removeFromMarketplace(product);
			}
			
			soldProducts.push(new Product("", "", -1, "", 0, 0, 0, true, false, false, false, soldProducts.length, totalProfit));
			unsoldProducts.push(new Product("", "", -1, "", 0, 0, 0, false, true, false, false, unsoldProducts.length, 0));
			
			soldProducts.reverse();
			unsoldProducts.reverse();
			
			var summary:Vector.<Product> = soldProducts.concat(unsoldProducts);
						
			// Update players finances history		
			
			request = { };
			
			request.userId = UserData.getInstance.userDbID;
			request.roundNumber = currentRound;
			request.money = UserData.getInstance.money;
			request.income = totalProfit;
			request.loan = UserData.getInstance.loanThisRound;
			request.buildingsCost = UserData.getInstance.buildingsCost;
			request.upgradesCost = UserData.getInstance.upgradesCost;
			request.expandCost = UserData.getInstance.expandCost;
			request.productionCost = UserData.getInstance.productionCost;
			request.paidLoanRate = UserData.getInstance.loanRate;
			
			communicator.callExtension("historyExt", "setFinancesHistory", request);
			
			UserData.getInstance.payLoanRate();
			
			sendCloseCommand();
									
			//if (this.getChildAt(numChildren - 1)) this.removeChild(this.getChildAt(numChildren - 1));
					
			popup = new buyingRoundPopup();
			popup.popupID = -15;
			
			if (totalProfit > 0) BuyingRoundPopup(popup).FLAG_moneyAnim = true;
			
			var paramsVector:Vector.<Vector.<Product>> = new Vector.<Vector.<Product>>();
			paramsVector.push(summary);
						
			BuyingRoundPopup(popup).populate(paramsVector);
			
			gameClip.addChild(popup);
			
			if (cloudsClip) gameMap.foregroundLayer.addChild(cloudsClip);
			
			UserData.getInstance.buildingsCost = 0;
			UserData.getInstance.productionCost = 0;
			UserData.getInstance.upgradesCost = 0;
			UserData.getInstance.expandCost = 0;
			UserData.getInstance.loanThisRound = 0;
			
			sendRoundRequest();			
		}		
		
		private function sendRoundRequest():void 
		{
			communicator.setExtensionCallback(getRoundsData, "getRoundHistory");					
			communicator.callExtension("historyExt", "getRoundHistory", {roomId:communicator.dbRoomId});
		}
		
		public function getRoundsData(params:Object):void
		{
			trace("############## RUNDA: ", params.rounds);
			
			if (params.rounds != undefined) currentRound = int(params.rounds.roundNumber);		
			else currentRound = 1;
		}
		
		public function showMoneyAnim(customValue:int = 0):void
		{
			TextField(MovieClip(hud.getChildByName("coinsAnim"))["amountClip"]["amountText"]).text = (customValue == 0 ? totalProfit.toString() : customValue.toString());
			
			MovieClip(hud.getChildByName("coinsAnim")).play();
			
			SoundManager.instance.playSound( { name:"moneyAdded", group:"sound", duplicate:true } );
		
		}
		public function removeScreenBlock():void
		{
			if (blocker)
			{
				blocker.parent.removeChild(blocker);
				blocker = null;
			}
			
			gameMap.mouseEnabled = true;
			gameMap.mouseChildren = true;
				
			buildingList.enable();
			buildingList.mouseEnabled = true;
			buildingList.mouseChildren = true;
			
			hud.mouseEnabled = true;
			hud.mouseChildren = true;
		}
		
		/**
		 * Called every second
		 * @param	e
		 */
		private function timerUpdateHandler(e:TimerEvent):void
		{
			roundTimeLeft--;
			
			if (FLAG_dataRestored)
			{
				hud.updateRoundTimer(roundTimeLeft, roundTime);
				
				if (tooltip && tooltipID == -1) tooltip.updateText((roundTimeLeft / 60 < 10 ? "0": "") + Math.floor(roundTimeLeft / 60).toString() + ":" + (roundTimeLeft % 60 < 10 ? "0": "") + Math.floor(roundTimeLeft % 60).toString());
				
				for each (var structure:PlaceableObject in gameMap.placeableVector)
				{
					if(structure && structure.objectSpecificContent) structure.objectSpecificContent.update();
				}
				
				for each (var process:ProcessBase in processQueue)
				{
					process.update();
				}
				
				if (popup && popup.popupID == -12)
				{
					MarketplacePopup(popup).updateTimer(roundTimeLeft);
				}
			}
			
			if (roundTimeLeft == 27)
			{
				SoundManager.instance.playSound( { name:"timerTick", group:"sound", loops:99 } );
			}
		}
		
		/**
		 * Changes graphics quality
		 */
		private function changeQuality(quality:String):void 
		{
			switch(quality)
			{
				case "low":
				{
					stage.quality = StageQuality.LOW;
					break;
				}
				case "medium":
				{
					stage.quality = StageQuality.MEDIUM;
					break;
				}
				case "high":
				{
					stage.quality = StageQuality.HIGH;
					break;
				}
			}
			
			hideTooltip();
		}
		
		/**
		 * Displays finances popup screen
		 */
		private function showFinances():void 
		{
			popup = new financesPopup();
			popup.popupID = -11;
						
			popup.x = 0;
			popup.y = 0;
			
			FinancesPopup(popup).populate();
			
			gameClip.addChild(popup);
		}
		
		/**
		 * Displays warehouse popup screen
		 */
		private function showWarehouse(type:String = "all"):void 
		{
			if (gameMap.selectedPlaceable) type = Warehouse(gameMap.selectedPlaceable.objectSpecificContent).storageType;
			
			var paramsVector:Vector.<Object> = new Vector.<Object>();
			
			// Icon
			if (gameMap.selectedPlaceable) paramsVector.push( { value:gameMap.selectedPlaceable.objectSettings["graphicAssetName"] + "_icon" } );
			else paramsVector.push(null);
			
			// Type
			paramsVector.push( { value:type } );
			
			WarehousePopup.shownType = type;
			
			// Level
			if (gameMap.selectedPlaceable) 
			{
				Warehouse(gameMap.selectedPlaceable.objectSpecificContent).currentID = gameMap.selectedPlaceable.ID;
				
				paramsVector.push( { value:Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel } );
			}
			else paramsVector.push(null);
			
			//Products
			paramsVector.push( { value:UserData.getInstance.getWarehouseProducts(type) } );
			
			if (gameMap.selectedPlaceable) paramsVector.push( { value:Warehouse(gameMap.selectedPlaceable.objectSpecificContent).upgradeCost } );
			else paramsVector.push(null);
			
			if (gameMap.selectedPlaceable) paramsVector.push( { value:gameMap.selectedPlaceable.objectSettings["name"] } );
			else paramsVector.push(null);
			
			showWarehousePopup(paramsVector);
		}
		
		/**
		 * Displays marketplace popup screen
		 */
		private function showMarketplace():void 
		{		
			gameMap.FLAG_blockMouseActions = true;
			popup = new marketplacePopup();
			popup.popupID = -12;
			MarketplacePopup(popup).populate(UserData.getInstance.getProductsOnMarketplace());
			
			popup.x = 0;
			popup.y = 0;
			
			gameClip.addChild(popup);
		}
		
		/**
		 * Add a popup containing building description, status and available actions
		 * @param	object - the building which the popup corresponds to
		 */
		public function showBuildingDescriptionPopup(object:PlaceableObject):void
		{
			if (object.objectSettings["type"] != "storage")
			{
				var paramsVector:Array = []
				
				// Building image
				paramsVector.push(object.objectSettings["graphicAssetName"] + "_icon");
				if (object.objectSpecificContent.inputProduct != "undefined") paramsVector.push(GameSettings.PRODUCTS[object.objectSpecificContent.inputProduct].productIcon + "_small");
				else paramsVector.push(null);
				paramsVector.push(GameSettings.PRODUCTS[object.objectSpecificContent.outputProduct].productIcon + "_small");
				if (object.objectSpecificContent.inputProduct != "undefined") paramsVector.push(GameSettings.PRODUCTS[object.objectSpecificContent.inputProduct].productIcon);
				else paramsVector.push(null);
				paramsVector.push(GameSettings.PRODUCTS[object.objectSpecificContent.outputProduct].productIcon);
				
				// Building name
				paramsVector.push(object.objectSettings["name"]);
				
				paramsVector.push(object.objectSettings["inputProductAmount"]);
				
				paramsVector.push(1);
				
				paramsVector.push(object.objectSpecificContent.unitProductionCost);
				
				paramsVector.push(object.objectSpecificContent.unitProductionTime);
				
				paramsVector.push(object.objectSettings["inputProductName"]);
				
				paramsVector.push(UserData.getInstance.getProductAmountInWarehouse(object.objectSpecificContent.inputType, object.objectSpecificContent.inputProduct));
				
				paramsVector.push(0);
				
				if (object.objectSettings["type"] == "process") paramsVector.push(0);
				else 
				{
					paramsVector.push(int(object.objectSettings["productionAmount" + object.objectSpecificContent.structureLevel.toString()]));
				}
				
				paramsVector.push(UserData.getInstance.getProductAmountInWarehouse(object.objectSpecificContent.outputType, object.objectSpecificContent.outputProduct));
				
				// Building output product
				paramsVector.push(object.objectSettings["outputProductName"]);
				
				if (object.objectSettings["type"] == "process") paramsVector.push(0);
				else 
				{
					paramsVector.push(int(object.objectSettings["productionCost"+object.objectSpecificContent.structureLevel.toString()]));
				}
				
				if (object.objectSettings["type"] == "process") paramsVector.push(0);
				else 
				{
					paramsVector.push(object.objectSettings["productionTime"+object.objectSpecificContent.structureLevel.toString()]);
				}
				
				paramsVector.push(object.objectSpecificContent.structureLevel);
								
				popup = new buildingDescriptionPopup();				
				
				if (object.objectSettings["type"] == "production") BuildingDescriptionPopup(popup).setNormal2Overlay();
				if (object.objectSpecificContent.FLAG_producing) BuildingDescriptionPopup(popup).setProductionOverlay();
				
				BuildingDescriptionPopup(popup).populate(paramsVector);
				
				popup.popupID = object.ID;
				
				popup.x = 0;
				popup.y = 0;							
				
				gameClip.addChild(popup);
			}
			else
			{
				showWarehouse(Warehouse(object.objectSpecificContent).storageType);
			}
		}
		
		/**
		 * Add a popup containing warehouse information, status and actions
		 * @param	object - the building which the popup corresponds to
		 */
		public function showWarehousePopup(paramsVector:Vector.<Object>):void
		{			
			gameMap.FLAG_blockMouseActions = true;
			if (!gameMap.selectedPlaceable) popup = new warehousePopup();
			else popup = new singleWarehousePopup();
			popup.popupID = -10;			
			WarehousePopup(popup).populate(paramsVector);
			
			popup.x = 0;
			popup.y = 0;
			
			gameClip.addChild(popup);
		}
		
		/**
		 * Reads from an xml file and stores in-game object list, their settings, types and asset class names
		 */
		private function getObjectList():void 
		{		
			var xmlPath:URLRequest = new URLRequest(GameSettings.xmlPath + "XML/objects/placeableObjects/objectList.xml");
			var xmlData:XML;
				
			if (xmlPath)
			{
				try
				{
					var xmlLoader:URLLoader = new URLLoader(xmlPath);
					xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
				}
				catch (error:Error)
				{
					return;
				}
				
				function xmlLoaderCompleteHandler(e:Event):void 
				{
					xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
					xmlData = new XML(e.target.data);
					
					for each (var node:XML in xmlData.children())
					{
						EngineSettings.PLACEABLE_SETTINGS.push({placeableName:node.child("name").toString(), settingsFile:node.child("settings").toString(), type:node.child("typeName").toString(), asset:node.child("asset").toString(), colorGroup:node.child("colorgroup").toString()});
					}					
					
					RetrieveBuildingsSettings();
				}
			}	
		}
		
		private function RetrieveBuildingsSettings():void 
		{
			var xmlPath:URLRequest = null;
			var xmlData:XML;
			var xmlLoader:URLLoader;
			var iterator:int = 0;
			var limiter:int = EngineSettings.PLACEABLE_SETTINGS.length;
					
			getSettingsObject(iterator);
			
			function getSettingsObject(index:int):void
			{			
				var settingsObject:Object = EngineSettings.PLACEABLE_SETTINGS[index];
				xmlPath = new URLRequest(GameSettings.xmlPath + settingsObject.settingsFile);
								
				if (xmlPath)
				{
					try
					{
						xmlLoader = new URLLoader(xmlPath);
						if(!xmlLoader.hasEventListener(Event.COMPLETE)) xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);					
					}
					catch (error:Error)
					{
						return;
					}
				}	
			}
			
			function xmlLoaderCompleteHandler(e:Event):void 
			{
				xmlData = new XML(e.target.data);
								
				EngineSettings.PLACEABLE_SETTINGS[iterator].objectSettings = [];
				
				for each (var node:XML in xmlData.children())
				{
					EngineSettings.PLACEABLE_SETTINGS[iterator].objectSettings[node.name().toString()] = node.toString();					
				}
								
				iterator++;
				if (iterator < limiter) getSettingsObject(iterator);
				else xmlLoader.removeEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
			}
		}
		
		private function getProductList():void 
		{		
			var xmlPath:URLRequest = new URLRequest(GameSettings.xmlPath + "XML/products/productList.xml");
			var xmlData:XML;
									
			if (xmlPath)
			{
				var xmlLoader:URLLoader = new URLLoader(xmlPath);
				xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
				
				function xmlLoaderCompleteHandler(e:Event):void
				{
					xmlLoader.removeEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
					xmlData = new XML(e.target.data);
					
					for each (var node:XML in xmlData.children())
					{
						GameSettings.PRODUCTS[node.child("internalName").toString()] = ( {productIcon:node.child("assetName").toString(), productName:node.child("name").toString(), productId:node.child("id").toString(), productType:node.child("type").toString(), internalName:node.child("internalName").toString() } );						
						GameSettings.PRODUCTS_BY_ID[node.child("id").toString()] = ( {productIcon:node.child("assetName").toString(), productName:node.child("name").toString(), productId:node.child("id").toString(), productType:node.child("type").toString(), internalName:node.child("internalName").toString() } );						
					}					
				}
			}	
		}
				
		/**
		 * Reads game settings from an xml file
		 */
		private function getSettings():void 
		{		
			var xmlPath:URLRequest = new URLRequest(GameSettings.xmlPath + "XML/settings.xml");
			var xmlData:XML;
									
			if (xmlPath)
			{
				var xmlLoader:URLLoader = new URLLoader(xmlPath);
				xmlLoader.addEventListener(Event.COMPLETE, xmlLoaderCompleteHandler);
				
				function xmlLoaderCompleteHandler(e:Event):void 
				{
					xmlData = new XML(e.target.data);
					
					GameSettings.MONEY = int(xmlData.child("money"));
					GameSettings.SELL_RATE = int(xmlData.child("sellRate"));
					
					UserData.getInstance.money = GameSettings.MONEY;					
				}
			}	
		}
		
		/**
		 * Sends and event which closes any open in-game tabs or windows with a corresponding event listener
		 */
		public function sendCloseCommand(allPopups:Boolean = false):void 
		{			
			if(!allPopups) GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.CLOSE_OPEN_WINDOWS, {allWindows:false}));
			else GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.CLOSE_OPEN_WINDOWS, {allWindows:true}));
			
			hideOptionsTooltip();
			hideTooltip();
		}
		
		/**
		 * Switches game mode to one specified by "mode" or switches between modes if "mode" is empty
		 * @param	mode - mode name which the game should switch to
		 */
		public function switchMode(mode:String=""):void 
		{
			// no mode was specified so just switch between two modes depending on the current mode
			if (mode == "")
			{
				if (GameSettings.GAME_MODE == GameSettings.GAMEMODE)
				{
					GameSettings.GAME_MODE = GameSettings.BUILDMODE;
				}
				else if (GameSettings.GAME_MODE == GameSettings.BUILDMODE)
				{
					GameSettings.GAME_MODE = GameSettings.GAMEMODE;
				}
			}
			// mode was specified - switch to it
			else
			{
				GameSettings.GAME_MODE = mode;
			}
			
			if (GameSettings.GAME_MODE == GameSettings.BUILDMODE) gameMap.addGrid();
			else gameMap.removeGrid();
			
			gameMap.unselectObject();
			
			// Update the text field indicating which game mode is currently on
			//TextField(gameClip.getChildByName("gameModeIndicator")).text = GameSettings.GAME_MODE;
			
			// Inform other game components that the mode has changed
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.GAME_MODE_CHANGE));
			
			if (cloudsClip) gameMap.foregroundLayer.addChild(cloudsClip);
		}
		
		/**
		 * Checks which object has the mouse pointer left
		 * @param	e
		 */
		private function mouseOutHandler(e:MouseEvent):void 
		{
			// If the current object is a PlaceableObject and it has a fixed position
			if (e.target.parent && getQualifiedClassName(e.target.parent).match("PlaceableObject") && PlaceableObject(e.target.parent).FLAG_placeableInPlace)
			{			
				// If the tooltip exists and is visible
				if (tooltip && tooltip.parent)
				{
					// If it's not a click enabled tooltip - hide it
					if(!tooltip.FLAG_clickEnabled) tooltip.hide();
				}
				// Tooltip doesn't exist or isn't visible anymore so clear it's reference for safety
				else
				{
					tooltip = null;
				}
			}
		}
		
		/**
		 * Checks object currently lying under mouse pointer and applies object-specific actions
		 * @param	e
		 */
		private function mouseOverHandler(e:MouseEvent):void 
		{			
			// If the current object is a PlaceableObject and it has a fixed position
			if (e.target.parent && getQualifiedClassName(e.target.parent).match("PlaceableObject") && PlaceableObject(e.target.parent).FLAG_placeableInPlace)
			{
				// If the game is in game mode
				if (GameSettings.GAME_MODE == GameSettings.GAMEMODE)
				{
					// If the tooltip is visible and belongs to the current object - show it
					if (tooltip && tooltip.parent && tooltipID == PlaceableObject(e.target.parent).ID)
					{
						var rect:Rectangle = PlaceableObject(e.target.parent).getBounds(PlaceableObject(e.target.parent).parent);
						
						var coords:Point = new Point(rect.left + rect.width / 2, rect.topLeft.y);
						//coords = PlaceableObject(e.target.parent).parent.localToGlobal(coords);
						
						tooltip.fixedPosition(coords.x, coords.y);						
						
						var buildingStatus:String;
						
						if (PlaceableObject(e.target.parent).objectSettings["type"] != "storage")
						{
							if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_producing)
							{
								buildingStatus = "Produkcja\n"
							}
							else if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_upgrading)
							{
								buildingStatus = "W budowie\n"
							}
							else if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_rotten)
							{
								buildingStatus = "Kliknij aby wyrzucić zepsute produkty\n"
							}
							else
							{
								buildingStatus = "Kliknij, aby rozpocząć produkcję\n"
							}
						}
						else
						{
							var capacity:int = Warehouse(PlaceableObject(e.target.parent).objectSpecificContent).capacity;
							var free:int = Warehouse(PlaceableObject(e.target.parent).objectSpecificContent).freeSpace;
							
							buildingStatus = (capacity - free).toString() + "/" + capacity.toString();
						}
											
						if (!PlaceableObject(e.target.parent).objectSpecificContent.FLAG_ready)
						{
							tooltip.show(PlaceableObject(e.target.parent).objectSettings["name"], buildingStatus);
						}
						else
						{
							tooltip.show(PlaceableObject(e.target.parent).objectSettings["name"], "Kliknij, aby przenieść produkty do magazynu");
						}
					}
					// Tooltip does not exist or doesn't belong to the current object, so create a new one
					else
					{
						// Hide the old tooltip if it still exists
						if (tooltip && tooltip.parent) 
						{
							tooltip.hide();
						}
						
						tooltip = new buildingDescriptionTooltip();
						
						rect = PlaceableObject(e.target.parent).getBounds(PlaceableObject(e.target.parent).parent);
						
						coords = new Point(rect.left + rect.width / 2, rect.topLeft.y);
						//coords = PlaceableObject(e.target.parent).parent.localToGlobal(coords);
						
						tooltip.fixedPosition(coords.x, coords.y);
						tooltipID = PlaceableObject(e.target.parent).ID;
						gameMap.foregroundLayer.addChild(tooltip);
												
						if (PlaceableObject(e.target.parent).objectSettings["type"] != "storage")
						{
							if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_producing)
							{
								buildingStatus = "Produkcja\n"
							}
							else if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_upgrading)
							{
								buildingStatus = "W budowie\n"
							}
							else if (PlaceableObject(e.target.parent).objectSpecificContent.FLAG_rotten)
							{
								buildingStatus = "Kliknij aby wyrzucić zepsute produkty\n"
							}
							else
							{
								buildingStatus = "Kliknij, aby rozpocząć produkcję\n"
							}
						}
						else
						{
							capacity = Warehouse(PlaceableObject(e.target.parent).objectSpecificContent).capacity;
							free = Warehouse(PlaceableObject(e.target.parent).objectSpecificContent).freeSpace;
							
							buildingStatus = (capacity - free).toString() + "/" + capacity.toString();
						}
						
						if (!PlaceableObject(e.target.parent).objectSpecificContent.FLAG_ready)
						{
							tooltip.show(PlaceableObject(e.target.parent).objectSettings["name"], buildingStatus);
						}
						else
						{
							tooltip.show(PlaceableObject(e.target.parent).objectSettings["name"], "Kliknij, aby przenieść produkty do magazynu");
						}
						
					}
				}
			}
		}
		
		/**
		 * Hides visible tooltip
		 */
		public function hideTooltip():void
		{
			if (tooltip)
			{
				tooltip.hide();
				tooltip = null;
			}
			
			if (buildTooltip)
			{
				buildTooltip.hide();
				buildTooltip = null;
			}
		}
		
		/**
		 * Hides visible options tooltip
		 */
		public function hideOptionsTooltip():void
		{
			if (optionsTooltip)
			{
				optionsTooltip.hide();
				optionsTooltip = null;
			}
		}
		
		/**
		 * Adds a build mode building tooltip containing "Move" and "Sell" buttons
		 * @param	object
		 */
		public function addBuildTooltip(object:PlaceableObject):void
		{
			// It there already was a tooltip on screen - hide it
			hideTooltip();
			
			// Create a new tooltip and add it to the display list
			buildTooltip = new buildBalloonTooltip();			
			tooltipID = object.ID;
						
			// Calculate coordinates of the tooltip according to the building's bounding box
			var tooltipX:Number = object.getBounds(object.parent).topLeft.x + object.getBounds(this.parent).width;
			var tooltipY:Number = object.getBounds(object.parent).topLeft.y;
			
			var globalCoords:Point = new Point(tooltipX, tooltipY);
			globalCoords = object.parent.localToGlobal(globalCoords);
			
			// Correct position if the tooltip would be placed outside the visible area
			if(globalCoords.x + buildTooltip.width > GameSettings.SCREEN_WIDTH) tooltipX = object.getBounds(this.parent).topLeft.x - buildTooltip.width;
			if(globalCoords.y + buildTooltip.height > GameSettings.SCREEN_HEIGHT) tooltipY = object.getBounds(this.parent).topLeft.y - buildTooltip.height;
			
			var localCoords:Point = gameMap.foregroundLayer.globalToLocal(globalCoords);
			buildTooltip.fixedPosition(localCoords.x, localCoords.y);
			
			gameMap.foregroundLayer.addChild(buildTooltip);
			
			// Make it click enabled so it won't follow mouse cursor and won't disappear after mouse leaves the building area
			buildTooltip.clickEnabled();
			
			//buildTooltip.x = tooltipX;
			//buildTooltip.y = tooltipY;
		}
		
		/**
		 * Allows moving of the selected building, hides the tooltip if it was visible.
		 */
		public function movePlaceableObject():void
		{
			buildingList.mouseEnabled = false;
			buildingList.mouseChildren = false;
			
			gameMap.movePlaceableObject();
			hideTooltip();
		}
		
		/**
		 * Adds a new building to the game grid
		 * @param	objectName - name of the object to add (must match the names provided in the building list xml)
		 */
		public function addPlaceableObject(typeId:int):void
		{			
			StructureGraphics.FLAG_statusVisible = false;
			var object:PlaceableObject = gameMap.addPlaceableObject(typeId);
		}
		
		public function restorePlaceableObject(dbId:int, typeId:int, gridX:int, gridY:int, level:int, progress:int=0):void
		{
			StructureGraphics.FLAG_statusVisible = true;
			var object:PlaceableObject = gameMap.addPlaceableObject(typeId);
			object.setInPlace(gridX, gridY);
			gameMap.FLAG_unfixedPlaceableOnGrid = false;
			gameMap.updateGrid(object);
			
			for each (var pObj:PlaceableObject in gameMap.placeableVector)
			{
				if (pObj)
				{
					pObj.mouseEnabled = true;
					pObj.mouseChildren = true;
				}
			}
			
			if (object.objectSettings["type"] != "storage")
			{
				// Create a regular building information object
				object.objectSpecificContent = new StructureData();
			}
			// and if it is a warehouse
			else
			{
				// Check if an information object for this type of warehouse already exists
				var warehouse:Warehouse = UserData.getInstance.getWarehouse(object.objectSettings["inputType"]);
				
				// If it does
				if (warehouse)
				{
					// Set the information object of this particular warehouse to the one existing
					object.objectSpecificContent = warehouse;
					warehouse.currentID = object.ID;
					//warehouse.expandFreeSpace(int(selectedPlaceable.objectSettings["capacityLevel1"]));
				}
				// and if not
				else
				{
					// Create a new warehouse information object
					warehouse = new Warehouse(object.objectSettings["inputType"]);
					object.objectSpecificContent = warehouse;
					warehouse.currentID = object.ID;
					UserData.getInstance.addWarehouse(object.objectSettings["inputType"], warehouse);
				}
			}
					
			StructureData(object.objectSpecificContent).structureReference = object;								
			StructureData(object.objectSpecificContent).typeId = typeId;
			
			if (object.objectSettings["type"] != "storage")
			{					
				StructureData(object.objectSpecificContent).dbID = dbId;
				if (progress == 0) StructureData(object.objectSpecificContent).structureLevel = level;
				else StructureData(object.objectSpecificContent).structureLevel = level-1;
				StructureData(object.objectSpecificContent).upgradeCost = object.objectSettings["costLevel" + String(level)];
				StructureData(object.objectSpecificContent).capacity = int(object.objectSettings["capacity"]);
				StructureData(object.objectSpecificContent).unitProductionTime = Number(object.objectSettings["productionTime" + String(level)]);
				StructureData(object.objectSpecificContent).unitProductionCost = int(object.objectSettings["productionCost" + String(level)]);
				StructureData(object.objectSpecificContent).inputProduct = String(object.objectSettings["inputProduct"]);
				StructureData(object.objectSpecificContent).outputProduct = String(object.objectSettings["outputProduct"]);
				StructureData(object.objectSpecificContent).outputType = String(object.objectSettings["outputType"]);
				StructureData(object.objectSpecificContent).inputType = String(object.objectSettings["inputType"]);
				StructureData(object.objectSpecificContent).storageTime = int(object.objectSettings["storageTime"]);
				StructureData(object.objectSpecificContent).storageTimeLeft = int(object.objectSettings["storageTime"]);										
			}
			else
			{
				Warehouse(object.objectSpecificContent).dbID = dbId;
				if (progress == 0) Warehouse(object.objectSpecificContent).structureLevel = level;
				else Warehouse(object.objectSpecificContent).structureLevel = level-1;
				Warehouse(object.objectSpecificContent).upgradeCost = object.objectSettings["costLevel" + String(level)];
				Warehouse(object.objectSpecificContent).capacity += int(object.objectSettings["capacityLevel" + String(level)]);
				Warehouse(object.objectSpecificContent).freeSpace += int(object.objectSettings["capacityLevel" + String(level)]);
				Warehouse(object.objectSpecificContent).storageType = String(object.objectSettings["inputType"]);
			}		
			
			if (progress == 0)
			{
				object.objectFace.gotoAndStop("lvl" +  String(level));
				object.objectFace.setStatus("idle");
			}
			else
			{
				gameMap.selectedPlaceable = object;
				startProcess("upgrade", progress);
			}
			
		}
		
		public function removeBuildingRequest(unfixed:Boolean = false):void
		{
			if (!gameMap.selectedPlaceable) return;
			
			if (gameMap.selectedPlaceable.objectSettings["type"] == "storage")
			{
				if (Warehouse(gameMap.selectedPlaceable.objectSpecificContent).freeSpace < int(gameMap.selectedPlaceable.objectSettings["capacityLevel" + Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel.toString()]))
				{
					var warning:WarningPopup = new warningPopup();
					warning.setWarning("removeWarehouse");
					
					gameClip.addChild(warning);
					
					hideTooltip();
					return;
				}
			}
			
			var requestPopup:YesNoPopup = new yesNoPopup();
			requestPopup.populate("Usuń budynek", "Czy na pewno chcesz usunąć ten budynek?");
			
			this.addChild(requestPopup);
			
			GameEvent.dispatcher.addEventListener(GameEvent.YES_NO_RESPONSE, handleBuildingRemoveResponse);
		}
		
		private function handleBuildingRemoveResponse(e:GameEvent):void 
		{
			if (e.parameters.response == "yes")
			{
				removePlaceableObject();
			}
			
			GameEvent.dispatcher.removeEventListener(GameEvent.YES_NO_RESPONSE, handleBuildingRemoveResponse);
		}
		
		private function removeBlocker():void 
		{
			if (blocker)
			{
				blocker.parent.removeChild(blocker);
				blocker = null;
			}
		}
		
		private function addBlocker():void 
		{
			blocker = new Sprite();
		
			blocker.graphics.beginFill(0x000000, 0.3);
			blocker.graphics.drawRect( 0, 0, 800, 600);
			blocker.graphics.endFill();
			
			blocker.x = 0;
			blocker.y = 0;
				
			this.addChild(blocker);
		}
		
		/**
		 * Removes a selected building from game grid and hides the tooltip if it's visible
		 */
		public function removePlaceableObject(unfixed:Boolean=false):void
		{
			if (!unfixed)
			{			
				if (gameMap.selectedPlaceable.objectSettings["type"] == "storage")
				{
					UserData.getInstance.removeWarehouse(Warehouse(gameMap.selectedPlaceable.objectSpecificContent).storageType);
					
					Warehouse(gameMap.selectedPlaceable.objectSpecificContent).currentID = gameMap.selectedPlaceable.ID;
					communicator.callExtension("buildingsExt", "deleteWarehouseData", { dbId:Warehouse(gameMap.selectedPlaceable.objectSpecificContent).dbID, userId:UserData.getInstance.userDbID } );
					
					var level:int = Warehouse(gameMap.selectedPlaceable.objectSpecificContent).structureLevel;
					
					Warehouse(gameMap.selectedPlaceable.objectSpecificContent).capacity -= int(gameMap.selectedPlaceable.objectSettings["capacityLevel" + String(level)]);
					Warehouse(gameMap.selectedPlaceable.objectSpecificContent).freeSpace -= int(gameMap.selectedPlaceable.objectSettings["capacityLevel" + String(level)]);
				}
				else
				{
					communicator.callExtension("buildingsExt", "deleteBuildingData", { dbId:gameMap.selectedPlaceable.objectSpecificContent.dbID, userId:UserData.getInstance.userDbID } );
				}
				
				var costReturn:int = Math.round(int(gameMap.selectedPlaceable.objectSettings["costLevel1"]) * 0.25);
				
				UserData.getInstance.money += costReturn;			
				
				showMoneyAnim(costReturn);
				
				gameMap.removePlaceableObject();				
			
				hideTooltip();
			}
			else
			{
				for each (var placeable:PlaceableObject in gameMap.placeableVector)
				{
					if (placeable && !placeable.FLAG_placeableInPlace)
					{
						gameMap.clearHighlight();
						gameMap.selectedPlaceable = placeable;					
						
						gameMap.removePlaceableObject();
						
						gameMap.FLAG_unfixedPlaceableOnGrid = false;
						Framework.unlockButtons();
						
						break;
					}
				}				
			}
		}
		
		/**
		 * Expands the game grid by a specified amount of rows and columns
		 * @param	rows - number of rows
		 * @param	cols - number of columns
		 */
		public function expandGrid(rows:int=3, cols:int=3):void 
		{
			expandLevel++;
			
			gameMap.expandGrid(rows, cols);
			
			if (expandLevel == 1)
			{
				UserData.getInstance.money -= 10000;
				UserData.getInstance.expandCost += 10000;
			}
			else if (expandLevel == 2)
			{
				UserData.getInstance.money -= 20000;
				UserData.getInstance.expandCost += 20000;
			}
			
			gameMap.removeGrid();
			gameMap.addGrid();
			gameMap.setDisplayOrder();
			
			buildingList.reloadBuildingList();
			
			communicator.callExtension("usersExt", "expandGrid", {userId:UserData.getInstance.userDbID, fieldX:EngineSettings.GRID_WIDTH, fieldY:EngineSettings.GRID_HEIGHT});
		}
		
		public function saveGameplayData():void
		{
			
		}
		
		public function get tooltip():BalloonTooltip { return _tooltip; }
		
		public function set tooltip(value:BalloonTooltip):void 
		{
			_tooltip = value;
		}
		
		static public function get getInstance():MainGameClass { return _instance; }
		
		public function get currentProductionAmount():int { return _currentProductionAmount; }
		
		public function set currentProductionAmount(value:int):void 
		{
			_currentProductionAmount = value;
		}
		
		public function get gameMap():GameMap { return _gameMap; }
		
		public function set gameMap(value:GameMap):void 
		{
			_gameMap = value;
		}
		
		public function get communicator():Communicator { return _communicator; }
		
		public function set communicator(value:Communicator):void 
		{
			_communicator = value;
		}
		
		public function get gameClip():MovieClip { return _gameClip; }
		
		public function set gameClip(value:MovieClip):void 
		{
			_gameClip = value;
		}
		
		public function get popup():PopupBase { return _popup; }
		
		public function set popup(value:PopupBase):void 
		{
			_popup = value;
		}
		
		public function get tooltipID():int { return _tooltipID; }
		
		public function set tooltipID(value:int):void 
		{
			_tooltipID = value;
		}
		
		public function get buildTooltip():BalloonTooltip { return _buildTooltip; }
		
		public function set buildTooltip(value:BalloonTooltip):void 
		{
			_buildTooltip = value;
		}
		
		public function get buildingList():BuildingList { return _buildingList; }
		
		public function set buildingList(value:BuildingList):void 
		{
			_buildingList = value;
		}
		
		public function get processQueue():Vector.<ProcessBase> { return _processQueue; }
		
		public function set processQueue(value:Vector.<ProcessBase>):void 
		{
			_processQueue = value;
		}
		
		public function get cloudsClip():MovieClip { return _cloudsClip; }
		
		public function set cloudsClip(value:MovieClip):void 
		{
			_cloudsClip = value;
		}
		
		public function get currentRoundId():int { return _currentRoundId; }
		
		public function set currentRoundId(value:int):void 
		{
			_currentRoundId = value;
		}
		
		public function get currentRound():int { return _currentRound; }
		
		public function set currentRound(value:int):void 
		{
			_currentRound = value;
		}
	}

}