package pl.fabrykagier.eduFarma.main 
{
	import flash.events.EventDispatcher;
	import flash.geom.Point;
	import pl.fabrykagier.eduFarma.gameData.Marketplace;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	
	/**
	 * Holds and updates user data
	 * @author Andrzej Kaczor
	 */
	public final class UserData extends EventDispatcher
	{
		private static var _instance:UserData;
		
		private var _login:String;
		private var _money:int = 10000;		
		private var _loan:int = 0;
		private var _loanRate:int = 0;
		private var _loanLength:int = 0;
		private var _loanPeriod:int = 0;
		private var _loanLimit:int = 100000;
		private var _currentLoanLimit:int = 10000;
		private var _userID:int;
		private var _userDbID:int;
		private var _username:String;
		private var structureList:Vector.<Object> = new Vector.<Object>();
		private var warehouseVector:Vector.<Warehouse> = new Vector.<Warehouse>();
		private var _marketplace:Marketplace;
		private var _productsList:Array = [];
		private var fieldSize:Point;
		private var _buildingsCost:int = 0;
		private var _upgradesCost:int = 0;
		private var _expandCost:int = 0;
		private var _productionCost:int = 0;
		private var _loanThisRound:int = 0;
				
		/**
		 * Constructor. Fills the warehouse vector and creates the marketplace object.
		 * @param	lock - prevents instantiation. Class can be accessed only through UserData.getInstance
		 */
		public function UserData(lock:InstantiationLock) 
		{
			warehouseVector.push(null);
			warehouseVector.push(null);
			warehouseVector.push(null);
			warehouseVector.push(null);
			
			marketplace = new Marketplace();
		}
		
		/**
		 * Get the warehouse object according to the provided warehouse type.
		 * If the warehouse does not exist null is returned.
		 * @param	type - the type of warehouse.
		 * @return
		 */
		public function getWarehouse(type:String):Warehouse
		{
			var warehouse:Warehouse = null;
			
			switch(type)
			{
				case "dry":
				{			
					warehouse = warehouseVector[1];
					break;
				}
				case "fresh":
				{
					warehouse = warehouseVector[2];
					break;
				}
				case "normal":
				{
					warehouse = warehouseVector[0];
					break;
				}
				case "frozen":
				{
					warehouse = warehouseVector[3];
					break;
				}
			}
			
			return warehouse;
		}
		
		public function getProductAmountInWarehouse(type:String, product:String):int
		{
			var warehouse:Warehouse = getWarehouse(type);
			var amount:int = 0;
			
			if (warehouse)
			{
				amount = warehouse.getProductAmount(product);
			}			
			
			return amount;
		}
		
		/**
		 * Add a new type of warehouse to the warehouse vector if there wasn't one of the same type.
		 * @param	type - type of warehouse.
		 * @param	warehouse - the warehouse object.
		 */
		public function addWarehouse(type:String, warehouse:Warehouse):void
		{
			switch(type)
			{
				case "dry":
				{			
					warehouseVector[1] = warehouse;					
					break;
				}
				case "fresh":
				{
					warehouseVector[2] = warehouse;	
					break;
				}
				case "normal":
				{
					warehouseVector[0] = warehouse;	
					break;
				}
				case "frozen":
				{
					warehouseVector[3] = warehouse;	
					break;
				}
			}
		}
		
		/**
		 * Remove existing warehouse from warehouse vector.
		 * @param	type - type of warehouse.
		 */
		public function removeWarehouse(type:String):void
		{
			var warehouseCounter:int = 0;
			
			for each (var object:PlaceableObject in MainGameClass.getInstance.gameMap.placeableVector)
			{
				if (object.objectSettings["type"] == "storage" && object.objectSettings["inputType"] == type)
				{
					warehouseCounter++;
				}
			}
			
			if (warehouseCounter != 1) return;
			
			switch(type)
			{
				case "dry":
				{			
					warehouseVector[1] = null;					
					break;
				}
				case "fresh":
				{
					warehouseVector[2] = null;	
					break;
				}
				case "normal":
				{
					warehouseVector[0] = null;	
					break;
				}
				case "frozen":
				{
					warehouseVector[3] = null;
					break;
				}
			}
		}
		
		/**
		 * Allows the player to take a loan. Adds the amount of the loan to the current player's money amount.
		 * Calculates the loan rate.
		 * @param	amount - the amount of money taken for loan.
		 * @param	length - the duration of a loan.
		 */
		public function takeLoan(amount:int, length:int):void
		{
			loan = amount;
			loanThisRound = amount;
			money += amount;
			currentLoanLimit -= loan;
			loanLimit -= loan;
			
			loanLength = length;
			loanRate = Math.ceil(loan / loanLength);
			
			var loanInterest:int = Math.round((loan * 0.1) / loanLength);
			
			loanRate += loanInterest;
			
			if (MainGameClass.FLAG_dataRestored) MainGameClass.getInstance.communicator.callExtension("financesExt", "updateLoan", { loan:loan, loanRate:loanRate, loanLength:loanLength, userId:UserData.getInstance.userDbID } );
		}
		
		/**
		 * Reduces money amount by a previously calculated loan rate.
		 */
		public function payLoanRate():void
		{
			if (loan == 0) return;
			
			if (loan - loanRate < 0) loanRate = loan;
			
			money -= loanRate;
			loan -= loanRate;
			currentLoanLimit += loanRate;
			loanLimit += loanRate;
			
			loanLength--;
			
			if (loan == 0)
			{
				loanRate = 0;
				loanLength = 0;
			}
			
			if (MainGameClass.FLAG_dataRestored) MainGameClass.getInstance.communicator.callExtension("financesExt", "updateLoan", { loan:loan, loanRate:loanRate, loanLength:loanLength, userId:UserData.getInstance.userDbID } );
		}
		
		/**
		 * Sends a given product to marketplace.
		 * @param	product
		 */
		public function productToMarketplace(product:Product):void
		{
			marketplace.addProduct(product);
		}
		
		/**
		 * Returns a vector of products currently on marketplace.
		 * @return
		 */
		public function getProductsOnMarketplace():Vector.<Product>
		{
			return marketplace.storedProducts;
		}
		
		/**
		 * Returns free space available in a given warehouse type.
		 * @param	type - the type of warehouse.
		 * @return
		 */
		public function warehouseFreeSpace(type:String):int
		{
			var freeSpace:int = 0;
			
			freeSpace += (getWarehouse(type) ? getWarehouse(type).getFreeSpace() : 0);			
			
			return freeSpace;
		}
		
		/**
		 * Remove a product from marketplace.
		 * @param product
		 */
		public function removeFromMarketplace(product:Product):void
		{
			marketplace.removeProduct(product);
		}
		
		/**
		 * Send a product to warehouse
		 * @param	product - @see pl.fabrykagier.eduFarma.gameData.Product
		 * @return
		 */
		public function storeInWarehouse(product:Product):Boolean
		{
			trace(warehouseVector);
			
			trace("## PRODUCT AMOUNT: ", product.amount);
			if (product.amount == 0) return false;		
			
			trace("## PRODUCT TYPE: ", product.type);
			switch(product.type)
			{
				case "dry":
				{					
					trace("## WAREHOUSE: ", warehouseVector[1]);
					if (!warehouseVector[1]) return false;
					
					trace("## NO SPACE: ", product.amount > warehouseVector[1].getFreeSpace());
					if (product.amount > warehouseVector[1].getFreeSpace() && !product.onMarket) return false;
					warehouseVector[1].storeProduct(product);
					break;
				}
				case "fresh":
				{
					trace("## WAREHOUSE: ", warehouseVector[2]);
					if (!warehouseVector[2]) return false;
					
					trace("## NO SPACE: ", product.amount > warehouseVector[2].getFreeSpace());
					if (product.amount > warehouseVector[2].getFreeSpace() && !product.onMarket) return false;
					warehouseVector[2].storeProduct(product);
					break;
				}
				case "normal":
				{
					trace("## WAREHOUSE: ", warehouseVector[0]);
					if (!warehouseVector[0]) return false;
					
					trace("## NO SPACE: ", product.amount > warehouseVector[0].getFreeSpace());
					if (product.amount > warehouseVector[0].getFreeSpace() && !product.onMarket) return false;
					warehouseVector[0].storeProduct(product);
					break;
				}
				case "frozen":
				{
					trace("## WAREHOUSE: ", warehouseVector[3]);
					if (!warehouseVector[3]) return false;
					
					trace("## NO SPACE: ", product.amount > warehouseVector[3].getFreeSpace());
					if (product.amount > warehouseVector[3].getFreeSpace() && !product.onMarket) return false;
					warehouseVector[3].storeProduct(product);
					break;
				}
			}
			
			return true;
		}
		
		/**
		 * Remove a product from warehouse.
		 * @param	type - the type of product/warehouse.
		 * @param	product - product name.
		 * @param	amount - amount to remove.
		 */
		public function removeFromWarehouse(type:String, product:String, amount:int, buyingRound:Boolean=false):void
		{
			switch(type)
			{
				case "dry":
				{			
					warehouseVector[1].removeProduct(product, amount, buyingRound);					
					break;
				}
				case "fresh":
				{
					warehouseVector[2].removeProduct(product, amount, buyingRound);	
					break;
				}
				case "normal":
				{
					warehouseVector[0].removeProduct(product, amount, buyingRound);	
					break;
				}
				case "frozen":
				{
					warehouseVector[3].removeProduct(product, amount, buyingRound);	
					break;
				}
			}
		}
		
		/**
		 * Returns a vector of products stored in a warehouse of a given type.
		 * @param	type - the type of warehouse.
		 * @return
		 */
		public function getWarehouseProducts(type:String):Vector.<Product>
		{
			var productVector:Vector.<Product> = new Vector.<Product>();
			
			switch(type)
			{
				case "dry":
				{		
					if (!warehouseVector[1]) return null;
					productVector = warehouseVector[1].storedProducts;
					
					productVector = productVector.concat(getMarketplaceProductsByType(type));
					break;
				}
				case "fresh":
				{
					if (!warehouseVector[2]) return null;
					productVector = warehouseVector[2].storedProducts;
					
					productVector = productVector.concat(getMarketplaceProductsByType(type));
					break;
				}
				case "normal":
				{
					if (!warehouseVector[0]) return null;
					productVector = warehouseVector[0].storedProducts;
					
					productVector = productVector.concat(getMarketplaceProductsByType(type));
					break;
				}
				case "frozen":
				{
					if (!warehouseVector[3]) return null;
					productVector = warehouseVector[3].storedProducts;
					
					productVector = productVector.concat(getMarketplaceProductsByType(type));
					break;
				}
				case "all":
				{
					if (warehouseVector[0])
					{
						productVector = productVector.concat(warehouseVector[0].storedProducts);
					}
					
					if (warehouseVector[1])
					{
						productVector = productVector.concat(warehouseVector[1].storedProducts);
					}
					
					if (warehouseVector[2])
					{
						productVector = productVector.concat(warehouseVector[2].storedProducts);
					}
					
					if (warehouseVector[3])
					{
						productVector = productVector.concat(warehouseVector[3].storedProducts);
					}
										
					productVector = productVector.concat(getMarketplaceProductsByType(type));
					
					break;
				}
			}
			
			//for each (var object:Object in productVector)
			//{
				//object.type = type;
			//}
			
			return productVector;
		}
		
		private function getMarketplaceProductsByType(type:String):Vector.<Product>
		{
			var selectedProducts:Vector.<Product> = new Vector.<Product>();
			
			if (type != "all")
			{
				for each (var product:Product in marketplace.storedProducts)
				{
					if (product.type == type)
					{
						selectedProducts.push(product);
					}
				}
			}
			else selectedProducts = marketplace.storedProducts;
			
			return selectedProducts;
		}
		
		/**
		 * Called from the productions process, decreases the amount of product needed to produce another.
		 * @param	product - which product amount to decrease
		 * @param	amount - by how much should the product amount be decreased
		 */
		public function decreaseProduct(product:String, type:String, decreaseAmount:int):void
		{
			getWarehouse(type).removeProduct(product, decreaseAmount);
		}
		
		/**
		 * Nullfies the loan amount and decreases the money amount by the loan amount.
		 */
		public function payLoan():void 
		{
			money -= loan;
			currentLoanLimit += loan;
			loanLimit += loan;
			
			loan = 0;
			loanLength = 0;
			loanPeriod = 0;
			loanRate = 0;
			
			if (MainGameClass.FLAG_dataRestored) MainGameClass.getInstance.communicator.callExtension("financesExt", "updateLoan", { loan:loan, loanRate:loanRate, loanLength:loanLength, userId:UserData.getInstance.userDbID } );
		}
		
		/**
		 * Singleton pattern.
		 */
		static public function get getInstance():UserData
		{
			if (!_instance)
			{
				_instance = new UserData(new InstantiationLock());
			}
			
			return _instance;
		}
		
		/**
		 * Get the username
		 */
		public function get login():String { return _login; }
		
		/**
		 * Set the username
		 */
		public function set login(value:String):void 
		{
			_login = value;
		}
		
		/**
		 * Get the current money amount
		 */
		public function get money():int { return _money; }
		
		/**
		 * Set the current money amount and dispatch an event informing the listening objects to update used money amount.
		 */
		public function set money(value:int):void 
		{
			_money = value;
			getInstance.dispatchEvent(new GameEvent(GameEvent.MONEY_UPDATE));
			
			if (MainGameClass.FLAG_dataRestored) MainGameClass.getInstance.communicator.callExtension("financesExt", "updateCash", { cash:_money, userId:UserData.getInstance.userDbID } );
		}
		
		/**
		 * Get the loan amount
		 */
		public function get loan():int { return _loan; }
		
		/**
		 * Set the loan amount
		 */
		public function set loan(value:int):void 
		{
			_loan = value;
		}
		
		/**
		 * Get the loan rate.
		 */
		public function get loanRate():int { return _loanRate; }
		
		/**
		 * Set the loan rate
		 */
		public function set loanRate(value:int):void 
		{
			_loanRate = value;
		}
		
		/**
		 * Get the loan length
		 */
		public function get loanLength():int { return _loanLength; }
		
		/**
		 * Set the loan length
		 */
		public function set loanLength(value:int):void 
		{
			_loanLength = value;
		}
		
		/**
		 * Get the loan period
		 */
		public function get loanPeriod():int { return _loanPeriod; }
		
		/**
		 * Set the loand period
		 */
		public function set loanPeriod(value:int):void 
		{
			_loanPeriod = value;
		}
		
		/**
		 * Get the products list
		 */
		public function get productsList():Array { return _productsList; }
		
		/**
		 * Set the products list
		 */
		public function set productsList(value:Array):void 
		{
			_productsList = value;
		}
		
		/**
		 * Get the loan limit
		 */
		public function get loanLimit():int { return _loanLimit; }
		
		/**
		 * Set the loan limit
		 */
		public function set loanLimit(value:int):void 
		{
			_loanLimit = value;
		}
		
		/**
		 * Get the current loan limit
		 */
		public function get currentLoanLimit():int { return _currentLoanLimit; }
		
		/**
		 * Set the current loan limit
		 */
		public function set currentLoanLimit(value:int):void 
		{
			_currentLoanLimit = value;
		}
		
		public function get userID():int { return _userID; }
		
		public function set userID(value:int):void 
		{
			_userID = value;
		}
		
		public function get username():String { return _username; }
		
		public function set username(value:String):void 
		{
			_username = value;
		}
		
		public function get userDbID():int { return _userDbID; }
		
		public function set userDbID(value:int):void 
		{
			_userDbID = value;
		}
		
		public function get marketplace():Marketplace { return _marketplace; }
		
		public function set marketplace(value:Marketplace):void 
		{
			_marketplace = value;
		}
		
		public function get buildingsCost():int { return _buildingsCost; }
		
		public function set buildingsCost(value:int):void 
		{
			_buildingsCost = value;
		}
		
		public function get upgradesCost():int { return _upgradesCost; }
		
		public function set upgradesCost(value:int):void 
		{
			_upgradesCost = value;
		}
		
		public function get expandCost():int { return _expandCost; }
		
		public function set expandCost(value:int):void 
		{
			_expandCost = value;
		}
		
		public function get productionCost():int { return _productionCost; }
		
		public function set productionCost(value:int):void 
		{
			_productionCost = value;
		}
		
		public function get loanThisRound():int { return _loanThisRound; }
		
		public function set loanThisRound(value:int):void 
		{
			_loanThisRound = value;
		}
		
	}

}

class InstantiationLock
{
	public function InstantiationLock()
	{
		
	}
}