package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	
	/**
	 * A balloon tooltip base class.
	 * @author Andrzej Kaczor
	 */
	public class BalloonTooltip extends MovieClip
	{
		public var FLAG_clickEnabled:Boolean = false;
		private var FLAG_fixed:Boolean = false;
		private var container:MovieClip;
		
		/**
		 * Class constructor
		 */
		public function BalloonTooltip(txt:String="") 
		{		
			// Mouse events are disabled on default			
			this.mouseEnabled = false;
			this.mouseChildren = false;
			
			container = MovieClip(this.getChildByName("content"));
			
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
		}
		
		/**
		 * Makes this balloon tooltip click enabled which means it can disapper only after calling hide() method externally.
		 * Also, this tooltip won't follow mouse cursor.
		 */
		public function clickEnabled():void
		{
			this.parent.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			FLAG_clickEnabled = true;
			
			this.mouseEnabled = true;
			this.mouseChildren = true;
		}
		
		public function tooltipType(type:String):void
		{
			var labelPart:String = container.currentLabel.split("_")[0];
				
			if (type == "up") container.gotoAndStop(labelPart + "_arrowDown");
			else container.gotoAndStop(labelPart + "_arrowUp");
		}
		
		public function fixedPosition(_x:Number, _y:Number):void
		{
			FLAG_fixed = true;
			
			this.x = _x;
			this.y = _y;
		}
		
		/**
		 * Tooltip has been added to the display list, this shows it and places it near the mouse cursor
		 * @param	e
		 */
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);			
			
			this.play();
			
			if (FLAG_fixed) return;
			
			this.x = this.parent.mouseX + 10;
			this.y = this.parent.mouseY + 10;
			
			// Correct position to prevent the tooltip from falling outside the screen area
			if(this.x + this.width > GameSettings.SCREEN_WIDTH) this.x = this.parent.mouseX - this.width - 10;
			if (this.y + this.height > GameSettings.SCREEN_HEIGHT) this.y = this.parent.mouseY - this.height - 10;
			
			this.parent.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		
		/**
		 * Called upon removal, removes listeners
		 * @param	e
		 */
		private function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			this.parent.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		
		/**
		 * Updates position after the mouse has moved, makes the tooltip follow the mouse cursor
		 * @param	e
		 */
		private function mouseMoveHandler(e:MouseEvent):void 
		{			
			this.x = this.parent.mouseX + 10;
			this.y = this.parent.mouseY + 10;
			
			// Correct position to prevent the tooltip from falling outside the screen area
			if(this.x + this.width > GameSettings.SCREEN_WIDTH) this.x = this.parent.mouseX - this.width - 10;
			if(this.y + this.height > GameSettings.SCREEN_HEIGHT) this.y = this.parent.mouseY - this.height - 10;
		}
		
		/**
		 * Show this tooltip with a nice animation
		 */
		public function show(txt:String="", txt2:String = ""):void
		{
			if (txt)
			{
				trace("TEXT LENGTH: ", txt.length);
				
				if (container.currentLabel)
				{
					var labelPart:String = container.currentLabel.split("_")[1];
				
					if (txt.length >= 16) container.gotoAndStop("big_" + labelPart);
					else container.gotoAndStop("small_" + labelPart);
				}
				
				TextField(container.getChildByName("tooltipText")).text = txt;
			}
			
			if (txt2)
			{
				TextField(container.getChildByName("tooltipText2")).text = txt2;
			}
			
			this.gotoAndPlay(this.totalFrames - this.currentFrame < Math.ceil(this.totalFrames / 2) ? this.totalFrames - this.currentFrame - 1 : this.currentFrame - 1);
		}
		
		public function updateText(txt:String = "", txt2:String = ""):void
		{
			if (txt) TextField(container.getChildByName("tooltipText")).text = txt;
			
			if (txt2) TextField(container.getChildByName("tooltipText2")).text = txt2;
		}
		
		public function updateTimer(time:int):void
		{
			var txt:String = TextField(container.getChildByName("tooltipText2")).text.split("\r")[0];
			
			var timerText:String = (time / 60 < 10 ? "0": "") + Math.floor(time / 60).toString() + " min " + (time % 60 < 10 ? "0": "") + Math.floor(time % 60).toString() + " s";
			
			TextField(container.getChildByName("tooltipText2")).text = txt + "\n" + timerText;
		}
		
		/**
		 * Hide this tooltip with an equally nice animation
		 */
		public function hide():void
		{					
			this.gotoAndPlay(this.totalFrames - this.currentFrame > Math.ceil(this.totalFrames/2) ? this.totalFrames - this.currentFrame : this.currentFrame);
		}
		
		/**
		 * Called on last frame of the tooltip graphics, removes it from the display list
		 */
		public function hidden():void
		{
			this.parent.removeChild(this);
		}
		
	}

}