package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class EndGamePopup extends PopupBase
	{
		private var results1:MovieClip;
		private var results2:MovieClip;
		private var results3:MovieClip;
		
		
		public function EndGamePopup() 
		{
			results1 = MovieClip(container.getChildByName("resultsContainer_1"));
			results2 = MovieClip(container.getChildByName("resultsContainer_2"));
			results3 = MovieClip(container.getChildByName("resultsContainer_3"));
		}
		
		public function populate(scoreList:Array):void
		{
			scoreList.sortOn("score", Array.NUMERIC | Array.DESCENDING);
			
			var scoreCount:int = scoreList.length;
			var minInterval:int = 5000;		
			
			var scoreThreshold1:int = Math.ceil(scoreCount/3);
			var scoreThreshold2:int = Math.ceil((scoreCount/3)*2);
			var scoreThreshold3:int = scoreCount;
			
			for (var i:int = 0; i < scoreCount; i++ )
			{
				var scoreClip:MovieClip = new singleResult();
				TextField(scoreClip["playerScore"]).text = scoreList[i].score.toString();
				
				if (scoreList[i].name.toString() == UserData.getInstance.username)
				{
					scoreClip.gotoAndStop(2);
				}
			
				if (i < scoreThreshold1)
				{
					TextField(scoreClip["playerName"]).text = int(results1.numChildren + 1).toString() + ". " + scoreList[i].name.toString();
					scoreClip.x = 0;
					scoreClip.y = results1.numChildren * scoreClip.height;
					
					results1.addChild(scoreClip);					
				}
				else if (i < scoreThreshold2)
				{
					TextField(scoreClip["playerName"]).text = int(results2.numChildren + 1).toString() + ". " + scoreList[i].name.toString();
					scoreClip.x = 0;
					scoreClip.y = results2.numChildren * scoreClip.height;
					
					results2.addChild(scoreClip);
				}
				else if (i <= scoreThreshold3)
				{
					TextField(scoreClip["playerName"]).text = int(results3.numChildren + 1).toString() + ". " + scoreList[i].name.toString();
					scoreClip.x = 0;
					scoreClip.y = results3.numChildren * scoreClip.height;
					
					results3.addChild(scoreClip);
				}
			}			
		}
		
	}

}