package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * Popup which allows the player to take a loan and pay the one existing.
	 * @author Andrzej Kaczor
	 */
	public class FinancesPopup extends PopupBase
	{
		private var verifyPattern:RegExp = /([0-9])/
		private var amountField:TextField;
		private var lengthField:TextField;
		private var increaseLoanButton:MovieClip;
		private var decreaseLoanButton:MovieClip;
		private var increaseRateButton:MovieClip;
		private var decreaseRateButton:MovieClip;
		private var loan:int = 0;
		private var rate:int = 5;
		private var rateField:TextField;
		private var frameCount:int = 0;
		private var divider:int = 10;
		
		/**
		 * Constructor. Gathers references to the input fields on the popup and registers functions used by contained buttons.
		 */
		public function FinancesPopup() 
		{
			super(false);
						
			Framework.instance.registerFunction(takeLoan, "takeLoan");
			Framework.instance.registerFunction(payLoan, "payLoan");
			
			if (UserData.getInstance.loan > 0)
			{
				container.gotoAndStop("PayOff");
			}
		}
		
		public function populate():void
		{
			if (UserData.getInstance.loan == 0)
			{			
				amountField = TextField(container.getChildByName("loanAmount"));	
				
				lengthField = TextField(container.getChildByName("loanLength"));
				
				rateField = TextField(container.getChildByName("rate"));
				
				amountField.text = "10000";
				loan = 10000;
				lengthField.text = "5";
				
				var loanInterest:int = Math.round((loan * 0.1) / rate);
							
				rateField.text = (Math.round(loan / rate) + loanInterest).toString();
				
				increaseLoanButton = MovieClip(container.getChildByName("increaseLoan"));
				decreaseLoanButton = MovieClip(container.getChildByName("decreaseLoan"));
				increaseRateButton = MovieClip(container.getChildByName("increaseRate"));
				decreaseRateButton = MovieClip(container.getChildByName("decreaseRate"));
				
				decreaseRateButton.alpha = 0.3;
				decreaseRateButton.mouseChildren = false;
				decreaseRateButton.mouseEnabled = false;				
				
				increaseLoanButton.alpha = 0.3;
				increaseLoanButton.mouseChildren = false;
				increaseLoanButton.mouseEnabled = false;
				
				increaseLoanButton.buttonMode = true;
				decreaseLoanButton.buttonMode = true;
				increaseRateButton.buttonMode = true;
				decreaseRateButton.buttonMode = true;
							
				increaseLoanButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				decreaseLoanButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
				increaseLoanButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				decreaseLoanButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				increaseLoanButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				decreaseLoanButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				
				increaseRateButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				decreaseRateButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				increaseRateButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				decreaseRateButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				increaseRateButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				decreaseRateButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			}
			else
			{			
				TextField(container["loanLength"]).text = UserData.getInstance.loanLength.toString();
				TextField(container["rate"]).text = UserData.getInstance.loanRate.toString();
			}
		}
		
		private function startValueChange(e:MouseEvent):void 
		{
			if (e.currentTarget.name == "increaseLoan") this.addEventListener(Event.ENTER_FRAME, increaseLoanHandler);
			else if (e.currentTarget.name == "decreaseLoan") this.addEventListener(Event.ENTER_FRAME, decreaseLoanHandler);
			else if (e.currentTarget.name == "increaseRate") this.addEventListener(Event.ENTER_FRAME, increaseRateHandler);
			else if (e.currentTarget.name == "decreaseRate") this.addEventListener(Event.ENTER_FRAME, decreaseRateHandler);
		}
		
		private function stopValueChange(e:MouseEvent):void
		{
			frameCount = 0;
			divider = 10;
			
			this.removeEventListener(Event.ENTER_FRAME, increaseLoanHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseLoanHandler);
			this.removeEventListener(Event.ENTER_FRAME, increaseRateHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseRateHandler);
		}
		
		private function decreaseRateHandler(e:Event):void 
		{
			if (rate > 5)
			{
				if (increaseRateButton.alpha < 1)
				{
					increaseRateButton.alpha = 1;
					increaseRateButton.mouseEnabled = true;
					increaseRateButton.mouseChildren = true;
				}
				
				if (frameCount % divider == 0) 
				{
					rate--;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					lengthField.text = rate.toString();
					
					var loanInterest:int = Math.round((loan * 0.1) / rate);
							
					rateField.text = (Math.round(loan / rate) + loanInterest).toString();
				}
			}
			else
			{
				decreaseRateButton.alpha = 0.3;
				decreaseRateButton.mouseEnabled = false;
				decreaseRateButton.mouseChildren = false;
			}
			
			frameCount++;
		}
		
		private function increaseRateHandler(e:Event):void 
		{
			if (rate < 10)
			{
				if (decreaseRateButton.alpha < 1)
				{
					decreaseRateButton.alpha = 1;
					decreaseRateButton.mouseEnabled = true;
					decreaseRateButton.mouseChildren = true;
				}
				
				if (frameCount % divider == 0) 
				{
					rate++
					divider -= 1;
					if (divider < 2) divider = 2;
					
					lengthField.text = rate.toString();
					
					var loanInterest:int = Math.round((loan * 0.1) / rate);
							
					rateField.text = (Math.round(loan / rate) + loanInterest).toString();
				}
			}
			else
			{
				increaseRateButton.alpha = 0.3;
				increaseRateButton.mouseEnabled = false;
				increaseRateButton.mouseChildren = false;
			}
			
			frameCount++;
		}
		
		private function decreaseLoanHandler(e:Event):void 
		{
			if (loan > 5000)
			{
				if (increaseLoanButton.alpha < 1)
				{
					increaseLoanButton.alpha = 1;
					increaseLoanButton.mouseEnabled = true;
					increaseLoanButton.mouseChildren = true;
				}
				
				if (frameCount % divider == 0) 
				{
					loan -= 1000;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					amountField.text = loan.toString();
					
					var loanInterest:int = Math.round((loan * 0.1) / rate);
							
					rateField.text = (Math.round(loan / rate) + loanInterest).toString();
				}
			}
			else
			{
				decreaseLoanButton.alpha = 0.3;
				decreaseLoanButton.mouseEnabled = false;
				decreaseLoanButton.mouseChildren = false;
			}
			
			frameCount++;
		}
		
		private function increaseLoanHandler(e:Event):void 
		{
			if (loan < 10000)
			{
				if (decreaseLoanButton.alpha < 1)
				{
					decreaseLoanButton.alpha = 1;
					decreaseLoanButton.mouseEnabled = true;
					decreaseLoanButton.mouseChildren = true;
				}
				
				if (frameCount % divider == 0)
				{
					loan += 1000;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					amountField.text = loan.toString();
					
					var loanInterest:int = Math.round((loan * 0.1) / rate);
							
					rateField.text = (Math.round(loan / rate) + loanInterest).toString();
				}
			}
			else
			{
				increaseLoanButton.alpha = 0.3;
				increaseLoanButton.mouseEnabled = false;
				increaseLoanButton.mouseChildren = false;
			}
			
			frameCount++;
		}
		
		/**
		 * Nullify the existing loan.
		 */
		private function payLoan():void 
		{
			UserData.getInstance.payLoan();
			
			hide();
			
			//container.gotoAndStop("bank");
			
			//populate();
		}
		
		/**
		 * Take a loan.
		 */
		private function takeLoan():void
		{
			if (loan > UserData.getInstance.loanLimit || loan > UserData.getInstance.currentLoanLimit || rate <= 0  || loan <= 0) return;
			
			UserData.getInstance.takeLoan(loan, rate);
			
			hide();
			
			//container.gotoAndStop("PayOff");
			
			//TextField(container["loanLength"]).text = UserData.getInstance.loanLength.toString();
			//TextField(container["rate"]).text = UserData.getInstance.loanRate.toString();
		}
		
		/**
		 * Called upon removal from display list. Removes listeners.
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);	
			
			if (container.currentLabel == "bank")
			{
				increaseLoanButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				decreaseLoanButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
				increaseLoanButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				decreaseLoanButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				increaseLoanButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				decreaseLoanButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				
				increaseRateButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				decreaseRateButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
				increaseRateButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				decreaseRateButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
				increaseRateButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
				decreaseRateButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			}
		}					
	}

}