package pl.fabrykagier.eduFarma.popups 
{
	import flash.events.Event;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.UserData;
	
	/**
	 * Popup representing the marketplace. Contains a scrollable list of items currently on market.
	 * @author Andrzej Kaczor
	 */
	public class MarketplacePopup extends PopupBase
	{
		private var scrollableWindow:ScrollableWindow;
		
		/**
		 * Constructor. Gets the reference to the scorllable item list.
		 */
		public function MarketplacePopup() 
		{
			super();
			
			scrollableWindow = ScrollableWindow(container.getChildByName("scrollablesContainer"));		
			
			GameEvent.dispatcher.addEventListener(GameEvent.UPDATE_POPUP, reloadItemList);
		}
		
		/**
		 * Called upon removal from display list. Removes listeners.
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.UPDATE_POPUP, reloadItemList);
		}
		
		/**
		 * Clears the scrollable item list and populates it again with items provided in the event parameter.
		 * @param	e
		 */
		private function reloadItemList(e:GameEvent):void 
		{
			scrollableWindow.clearItemList();
			scrollableWindow.populateItemList(UserData.getInstance.getProductsOnMarketplace(), "marketplace");
		}
		
		public function updateTimer(time:int):void
		{
			var clock:TextField = TextField(container.getChildByName("timerText"));
			
			if(clock) clock.text = (time / 60 < 10 ? "0": "") + Math.floor(time / 60).toString() + ":" + (time % 60 < 10 ? "0": "") + Math.floor(time % 60).toString()
		}
		
		/**
		 * Initially populates the item list and activates it's elements to process mouse events.
		 * @param	paramsVector
		 */
		public function populate(paramsVector:Vector.<Product>):void
		{			
			//Products			
			scrollableWindow.clearItemList();
			scrollableWindow.populateItemList(paramsVector, "marketplace");
			scrollableWindow.activate();
		}
	}

}