package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * A popup for server connection events
	 * @author Andrzej Kaczor
	 */
	public class ServerMessage extends MovieClip 
	{
		private var header:TextField;
		private var content:TextField;
		
		public function ServerMessage() 
		{
			this.mouseEnabled = true;
			this.mouseChildren = true;
			
			// get the header and content fields instances
			header = TextField(this.getChildByName("messageHeader"));
			content = TextField(this.getChildByName("message"));
			
			Framework.instance.registerFunction(removeServerMessage, "removeServerMessage");
			Framework.instance.registerFunction(retryConnection, "retryConnection");
		}
		
		/**
		 * Calls a function to retry connecting with the server
		 */
		private function retryConnection():void 
		{
			MainGameClass.getInstance.communicator.retryConnection();
		}
		
		/**
		 * Removes this popup from screen
		 */
		private function removeServerMessage():void 
		{
			this.parent.removeChild(this);
		}
		
		/**
		 * Sets the header and content of the popup based on the "type" variable
		 * @param	type - the type of message to display
		 */
		public function setMessage(type:String):void
		{			
			switch(type)
			{				
				case "SecurityError":
				{
					header.text = "Błąd bezpieczeństwa";
					content.text = "Nastąpiło naruszenie poufności witryny.";
					
					MovieClip(this.getChildByName("call_removeServerMessage$lockEnabled_false$")).visible = false;
					if (MainGameClass.getInstance.gameClip)
					{
						MainGameClass.getInstance.gameClip.mouseEnabled = false;
						MainGameClass.getInstance.gameClip.mouseChildren = false;
					}
					
					MainGameClass.getInstance.emergencyStopTimer();
					
					break;
				}
				case "ConnectionError":
				{					
					header.text = "Błąd połączenia";
					content.text = "Utracono połączenie z serwerem";
					
					MovieClip(this.getChildByName("call_removeServerMessage$lockEnabled_false$")).visible = false;
					if (MainGameClass.getInstance.gameClip)
					{
						MainGameClass.getInstance.gameClip.mouseEnabled = false;
						MainGameClass.getInstance.gameClip.mouseChildren = false;
					}		
					
					MainGameClass.getInstance.emergencyStopTimer();
					
					break;
				}
				case "InitialConnectionError":
				{
					header.text = "Błąd połączenia";
					content.text = "Nawiązanie połącznia z serwerem nie powiodło się. Klinij \"Połącz ponownie\" aby ponowić próbę połączenia.";
					
					this.gotoAndStop("reconnect");
					break;
				}
				case "JoinRoomError":
				case "LoginError":
				{
					header.text = "Błąd logowania";
					content.text = "Próba logowania nie powiodła się. Spróbuj ponownie.";
					break;
				}
				default:
				{
					header.text = "Błąd";
					content.text = "Wystąpił nieznany wyjątek.";
					
					MovieClip(this.getChildByName("call_removeServerMessage$lockEnabled_false$")).visible = false;
					if (MainGameClass.getInstance.gameClip)
					{
						MainGameClass.getInstance.gameClip.mouseEnabled = false;
						MainGameClass.getInstance.gameClip.mouseChildren = false;
					}					
					
					MainGameClass.getInstance.emergencyStopTimer();
					
					break;
				}
			}
		}
		
	}

}