package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	
	/**
	 * A popup for managing in-game warehouses. Holds a list of warehouses, list of products and other warehouses
	 * @author Andrzej Kaczor
	 */
	public class WarehousePopup extends PopupBase
	{	
		private var scrollableWindow:ScrollableWindow;
		public static var shownType:String;
		
		/**
		 * Constructor. Gets the reference to the scrollable item list.
		 */
		public function WarehousePopup()
		{
			super(false);
			
			scrollableWindow = ScrollableWindow(container.getChildByName("scrollablesContainer"));		
			
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseChildren = false;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseEnabled = false;
			
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseChildren = false;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseEnabled = false;			
			
			GameEvent.dispatcher.addEventListener(GameEvent.UPDATE_POPUP, reloadItemList);
			
			var upgradeButton:MovieClip = MovieClip(container.getChildByName("upgradeClip"));
			
			if (upgradeButton)
			{
				if ((MainGameClass.getInstance.gameMap.selectedPlaceable &&
					MainGameClass.getInstance.gameMap.selectedPlaceable.objectSettings["costLevel" + Warehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent).structureLevel] > UserData.getInstance.money))
				{
					upgradeButton.alpha = 0.3;
					upgradeButton.mouseChildren = false;
					upgradeButton.mouseEnabled = false;
				}
				else if (MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent && MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.structureLevel > 2)
				{
					upgradeButton.gotoAndStop(2);
				}
			}
		}
		
		/**
		 * Called upon removal from display list. Removes listeners.
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.UPDATE_POPUP, reloadItemList);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.ITEM_SELECTED, itemSelectedHandler);
			GameEvent.dispatcher.removeEventListener(GameEvent.ITEM_DESELECTED, itemDeselectedHandler);
		}
		
		/**
		 * Clear and populate the item list again with items provided in the event parameter.
		 * @param	e
		 */
		private function reloadItemList(e:GameEvent):void 
		{	
			scrollableWindow.clearItemList();
			scrollableWindow.populateItemList(UserData.getInstance.getWarehouseProducts(shownType), "warehouse");
			
			if (UserData.getInstance.getWarehouse(shownType))
			{
				var capacity:int = UserData.getInstance.getWarehouse(shownType).capacity;
				var free:int = UserData.getInstance.getWarehouse(shownType).freeSpace;
							
				MovieClip(container.getChildByName("capacityBar")).visible = true;
				
				TextField(MovieClip(container.getChildByName("capacityBar")).getChildByName("capacityText")).text = (capacity - free).toString() + "/" + capacity.toString();
				MovieClip(MovieClip(container.getChildByName("capacityBar")).getChildByName("capacityProgress")).gotoAndStop(Math.round((1 - free/capacity)*100));
			}
			else
			{				
				MovieClip(container.getChildByName("capacityBar")).visible = false;
			}
		}
		
		/**
		 * Locks certain warehouse popup buttons when no item is selected
		 * @param	e
		 */
		private function itemDeselectedHandler(e:GameEvent):void 
		{
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseChildren = false;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseEnabled = false;	
			
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseChildren = false;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseEnabled = false;
		}
		
		/**
		 * Enables certain buttons when an item has been selected
		 * @param	e
		 */
		private function itemSelectedHandler(e:GameEvent):void 
		{
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).alpha = 1;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseChildren = true;
			MovieClip(container.getChildByName("call_sendToMarketplacePopup$lockEnabled_false$")).mouseEnabled = true;
			
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).alpha = 1;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseChildren = true;
			MovieClip(container.getChildByName("call_removeWarehouseItem$lockEnabled_false$")).mouseEnabled = true;
		}
		
		/**
		 * Populates the variable popup fields with data passed in the parmasVector.
		 * @param	paramsVector - a vector of objects containing popup parameters.
		 */
		public function populate(paramsVector:Vector.<Object>):void
		{			
			if (container.getChildByName("upgradeClip") && paramsVector[0])
			{
				var level:int = paramsVector[2].value;
				
				var buildingIcon:MovieClip = MovieClip(new (getDefinitionByName(paramsVector[0].value) as Class)());
				buildingIcon.gotoAndStop(level);
				
				MovieClip(container.getChildByName("icon")).addChild(buildingIcon);
				
				TextField(container["header"]).text = paramsVector[5].value;
			}
			
			shownType = paramsVector[1].value;
			
			if (UserData.getInstance.getWarehouse(shownType))
			{
				var capacity:int = UserData.getInstance.getWarehouse(shownType).capacity;
				var free:int = UserData.getInstance.getWarehouse(shownType).freeSpace;
							
				MovieClip(container.getChildByName("capacityBar")).visible = true;
				
				TextField(MovieClip(container.getChildByName("capacityBar")).getChildByName("capacityText")).text = (capacity - free).toString() + "/" + capacity.toString();
				MovieClip(MovieClip(container.getChildByName("capacityBar")).getChildByName("capacityProgress")).gotoAndStop(Math.round((1 - free/capacity)*100));
			}
			else
			{				
				MovieClip(container.getChildByName("capacityBar")).visible = false;
			}
			
			scrollableWindow.clearItemList();
			scrollableWindow.populateItemList(paramsVector[3].value, "warehouse");
			
			scrollableWindow.activate();
			
			GameEvent.dispatcher.addEventListener(GameEvent.ITEM_SELECTED, itemSelectedHandler);
			GameEvent.dispatcher.addEventListener(GameEvent.ITEM_DESELECTED, itemDeselectedHandler);
		}
				
		/**
		 * Hide the popup
		 * @param	e
		 */
		override public function hide(e:GameEvent = null):void 
		{
			if (e && this.parent.getChildIndex(this) < this.parent.numChildren-1) return;
			
			super.hide(e);
			
			MainGameClass.getInstance.gameMap.unselectObject();
		}
	}

}