package pl.fabrykagier.eduFarma.popups 
{
	import flash.events.MouseEvent;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	
	/**
	 * A Tab object in the warehouse popup used for switching categories.
	 * @author Andrzej Kaczor
	 */
	public class WarehouseTab extends GotoButton
	{
		
		public function WarehouseTab()
		{
			GameEvent.dispatcher.addEventListener(GameEvent.TAB_CHANGE, deactivateTab);
			
			// get tab type from instance name
			if(this.name.split("_")[1].split("$")[0] == WarehousePopup.shownType) this.gotoAndStop("on_on");
		}
		
		/**
		 * called when the object is beign removed from the display list
		 */
		override protected function onRemoved():void 
		{
			GameEvent.dispatcher.removeEventListener(GameEvent.TAB_CHANGE, deactivateTab);
			
			super.onRemoved();
		}
		
		/**
		 * Triggered by an event when one of the other tabs is clicked. Deactivates current tab.
		 * @param	e
		 */
		private function deactivateTab(e:GameEvent):void 
		{
			this.gotoAndStop("off_off");
		}
		
		/**
		 * Tab has been clicked, highlight it and set the content of the warehouse popup to the type associated with the tab.
		 * @param	event
		 */
		override protected function onClickHandler(event:MouseEvent):void 
		{
			super.onClickHandler(event);
			
			var paramsVector:Vector.<Object> = new Vector.<Object>();
			
			var type:String = this.name.split("_")[1].split("$")[0];
			var warehouseName:String;
			
			if (type == "fromObject")
			{
				type = Warehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent).storageType;
			}
			
			// Name
			paramsVector.push(null);
			
			// Type
			paramsVector.push({value:type});
			
			// Free space
			paramsVector.push( {value:UserData.getInstance.warehouseFreeSpace(type).toString()});
			
			//Products
			if (type != "marketplace") paramsVector.push( { value:UserData.getInstance.getWarehouseProducts(type) } );
			else paramsVector.push( { value:UserData.getInstance.getProductsOnMarketplace()} );
						
			WarehousePopup(this.parent.parent).populate(paramsVector);
			
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.TAB_CHANGE));
			
			this.gotoAndStop("on_on");
		}
		
		/**
		 * Mouse is over the tab
		 * @param	event
		 */
		override protected function onButtonOverHandler(event:MouseEvent):void
		{
			this.gotoAndStop("on_" + this.currentLabel.split("_")[1]);
		}
		
		/**
		 * Mouse went off the tab
		 * @param	event
		 */
		override protected function onButtonOutHandler(event:MouseEvent):void 
		{
			this.gotoAndStop("off_" + this.currentLabel.split("_")[1]);			
		}
		
	}

}