package pl.fabrykagier.eduFarma.popups 
{
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * A confirmation popup with yes/no buttons
	 * @author Andrzej Kaczor
	 */
	public class YesNoPopup extends PopupBase
	{
		
		public function YesNoPopup() 
		{
			super(false);
			
			Framework.instance.registerFunction(cancelFunction, "cancel");
			Framework.instance.registerFunction(acceptFunction, "accept");
		}
		
		/**
		 * Sets the header and text of the popup
		 * @param	headerText - title header text
		 * @param	contentText - content text
		 */
		public function populate(headerText:String, contentText:String):void
		{
			TextField(container.getChildByName("header")).text = headerText;
			TextField(container.getChildByName("textContent")).text = contentText;
		}
		
		/**
		 * Dispatches an event after clicking "yes" button
		 */
		private function acceptFunction():void
		{
			GameEvent.dispatcher.dispatchEvent( new GameEvent(GameEvent.YES_NO_RESPONSE, { response:"yes" } ));
			
			hide();
		}
		
		/**
		 * Dispatches an event after clicking "no" button
		 */
		private function cancelFunction():void 
		{
			GameEvent.dispatcher.dispatchEvent( new GameEvent(GameEvent.YES_NO_RESPONSE, { response:"no" } ));
			
			hide();
		}
		
	}

}