package pl.fabrykagier.eduFarma.processess 
{
	import flash.events.EventDispatcher;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	
	/**
	 * Base class of a process object. Contains common process properties.
	 * @author Andrzej Kaczor
	 */
	public class ProcessBase extends EventDispatcher
	{
		protected var _buildingID:int;
		protected var _structure:PlaceableObject;
		protected var _processType:String;
		protected var _progress:int = 0;
		
		/**
		 * Constructor. Pass the ID of the building and a reference to the object representing it.
		 * @param	buildingID - ID of the building
		 * @param	structure - reference to the building object
		 */
		public function ProcessBase(buildingID:int, structure:PlaceableObject) 
		{
			this._structure = structure;
			this._buildingID = buildingID;			
		}
		
		/**
		 * To be overriden - updates the process.
		 */
		public function update():void
		{
			
		}
		
		/**
		 * To be overriden - dispatches and event informing the process creator that the process has finished. 
		 * Reference to this process is passed as a parameter.
		 */
		public function endProcess():void
		{
			this.dispatchEvent(new GameEvent(GameEvent.PROCESS_END, { process:this } ));
		}
		
		/**
		 * Get the building ID
		 */
		public function get buildingID():int { return _buildingID; }
		
		/**
		 * Set the building ID
		 */
		public function set buildingID(value:int):void 
		{
			_buildingID = value;
		}
		
		/**
		 * Get the building object reference
		 */
		public function get structure():PlaceableObject { return _structure; }
		
		/**
		 * Set the building object reference
		 */
		public function set structure(value:PlaceableObject):void 
		{
			_structure = value;
		}
		
		public function get processType():String { return _processType; }
		
		public function get progress():int { return _progress; }
		
	}

}